/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVocabularyFilterRequest extends TranscribeRequest implements
        ToCopyableBuilder<UpdateVocabularyFilterRequest.Builder, UpdateVocabularyFilterRequest> {
    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterName").getter(getter(UpdateVocabularyFilterRequest::vocabularyFilterName))
            .setter(setter(Builder::vocabularyFilterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build())
            .build();

    private static final SdkField<List<String>> WORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Words")
            .getter(getter(UpdateVocabularyFilterRequest::words))
            .setter(setter(Builder::words))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Words").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VOCABULARY_FILTER_FILE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterFileUri").getter(getter(UpdateVocabularyFilterRequest::vocabularyFilterFileUri))
            .setter(setter(Builder::vocabularyFilterFileUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterFileUri").build())
            .build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessRoleArn").getter(getter(UpdateVocabularyFilterRequest::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_FILTER_NAME_FIELD,
            WORDS_FIELD, VOCABULARY_FILTER_FILE_URI_FIELD, DATA_ACCESS_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String vocabularyFilterName;

    private final List<String> words;

    private final String vocabularyFilterFileUri;

    private final String dataAccessRoleArn;

    private UpdateVocabularyFilterRequest(BuilderImpl builder) {
        super(builder);
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.words = builder.words;
        this.vocabularyFilterFileUri = builder.vocabularyFilterFileUri;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
    }

    /**
     * <p>
     * The name of the custom vocabulary filter you want to update. Custom vocabulary filter names are case sensitive.
     * </p>
     * 
     * @return The name of the custom vocabulary filter you want to update. Custom vocabulary filter names are case
     *         sensitive.
     */
    public final String vocabularyFilterName() {
        return vocabularyFilterName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Words property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasWords() {
        return words != null && !(words instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Use this parameter if you want to update your custom vocabulary filter by including all desired terms, as
     * comma-separated values, within your request. The other option for updating your vocabulary filter is to save your
     * entries in a text file and upload them to an Amazon S3 bucket, then specify the location of your file using the
     * <code>VocabularyFilterFileUri</code> parameter.
     * </p>
     * <p>
     * Note that if you include <code>Words</code> in your request, you cannot use <code>VocabularyFilterFileUri</code>;
     * you must choose one or the other.
     * </p>
     * <p>
     * Each language has a character set that contains all allowed characters for that specific language. If you use
     * unsupported characters, your custom vocabulary filter request fails. Refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom Vocabularies</a>
     * to get the character set for your language.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWords} method.
     * </p>
     * 
     * @return Use this parameter if you want to update your custom vocabulary filter by including all desired terms, as
     *         comma-separated values, within your request. The other option for updating your vocabulary filter is to
     *         save your entries in a text file and upload them to an Amazon S3 bucket, then specify the location of
     *         your file using the <code>VocabularyFilterFileUri</code> parameter.</p>
     *         <p>
     *         Note that if you include <code>Words</code> in your request, you cannot use
     *         <code>VocabularyFilterFileUri</code>; you must choose one or the other.
     *         </p>
     *         <p>
     *         Each language has a character set that contains all allowed characters for that specific language. If you
     *         use unsupported characters, your custom vocabulary filter request fails. Refer to <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom
     *         Vocabularies</a> to get the character set for your language.
     */
    public final List<String> words() {
        return words;
    }

    /**
     * <p>
     * The Amazon S3 location of the text file that contains your custom vocabulary filter terms. The URI must be
     * located in the same Amazon Web Services Region as the resource you're calling.
     * </p>
     * <p>
     * Here's an example URI path: <code>s3://DOC-EXAMPLE-BUCKET/my-vocab-filter-file.txt</code>
     * </p>
     * <p>
     * Note that if you include <code>VocabularyFilterFileUri</code> in your request, you cannot use <code>Words</code>;
     * you must choose one or the other.
     * </p>
     * 
     * @return The Amazon S3 location of the text file that contains your custom vocabulary filter terms. The URI must
     *         be located in the same Amazon Web Services Region as the resource you're calling.</p>
     *         <p>
     *         Here's an example URI path: <code>s3://DOC-EXAMPLE-BUCKET/my-vocab-filter-file.txt</code>
     *         </p>
     *         <p>
     *         Note that if you include <code>VocabularyFilterFileUri</code> in your request, you cannot use
     *         <code>Words</code>; you must choose one or the other.
     */
    public final String vocabularyFilterFileUri() {
        return vocabularyFilterFileUri;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains
     * your input files (in this case, your custom vocabulary filter). If the role that you specify doesn’t have the
     * appropriate permissions to access the specified Amazon S3 location, your request fails.
     * </p>
     * <p>
     * IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example:
     * <code>arn:aws:iam::111122223333:role/Admin</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM ARNs</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that
     *         contains your input files (in this case, your custom vocabulary filter). If the role that you specify
     *         doesn’t have the appropriate permissions to access the specified Amazon S3 location, your request
     *         fails.</p>
     *         <p>
     *         IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For
     *         example: <code>arn:aws:iam::111122223333:role/Admin</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM
     *         ARNs</a>.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(hasWords() ? words() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterFileUri());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVocabularyFilterRequest)) {
            return false;
        }
        UpdateVocabularyFilterRequest other = (UpdateVocabularyFilterRequest) obj;
        return Objects.equals(vocabularyFilterName(), other.vocabularyFilterName()) && hasWords() == other.hasWords()
                && Objects.equals(words(), other.words())
                && Objects.equals(vocabularyFilterFileUri(), other.vocabularyFilterFileUri())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateVocabularyFilterRequest").add("VocabularyFilterName", vocabularyFilterName())
                .add("Words", hasWords() ? words() : null).add("VocabularyFilterFileUri", vocabularyFilterFileUri())
                .add("DataAccessRoleArn", dataAccessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VocabularyFilterName":
            return Optional.ofNullable(clazz.cast(vocabularyFilterName()));
        case "Words":
            return Optional.ofNullable(clazz.cast(words()));
        case "VocabularyFilterFileUri":
            return Optional.ofNullable(clazz.cast(vocabularyFilterFileUri()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VocabularyFilterName", VOCABULARY_FILTER_NAME_FIELD);
        map.put("Words", WORDS_FIELD);
        map.put("VocabularyFilterFileUri", VOCABULARY_FILTER_FILE_URI_FIELD);
        map.put("DataAccessRoleArn", DATA_ACCESS_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateVocabularyFilterRequest, T> g) {
        return obj -> g.apply((UpdateVocabularyFilterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateVocabularyFilterRequest> {
        /**
         * <p>
         * The name of the custom vocabulary filter you want to update. Custom vocabulary filter names are case
         * sensitive.
         * </p>
         * 
         * @param vocabularyFilterName
         *        The name of the custom vocabulary filter you want to update. Custom vocabulary filter names are case
         *        sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterName(String vocabularyFilterName);

        /**
         * <p>
         * Use this parameter if you want to update your custom vocabulary filter by including all desired terms, as
         * comma-separated values, within your request. The other option for updating your vocabulary filter is to save
         * your entries in a text file and upload them to an Amazon S3 bucket, then specify the location of your file
         * using the <code>VocabularyFilterFileUri</code> parameter.
         * </p>
         * <p>
         * Note that if you include <code>Words</code> in your request, you cannot use
         * <code>VocabularyFilterFileUri</code>; you must choose one or the other.
         * </p>
         * <p>
         * Each language has a character set that contains all allowed characters for that specific language. If you use
         * unsupported characters, your custom vocabulary filter request fails. Refer to <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom
         * Vocabularies</a> to get the character set for your language.
         * </p>
         * 
         * @param words
         *        Use this parameter if you want to update your custom vocabulary filter by including all desired terms,
         *        as comma-separated values, within your request. The other option for updating your vocabulary filter
         *        is to save your entries in a text file and upload them to an Amazon S3 bucket, then specify the
         *        location of your file using the <code>VocabularyFilterFileUri</code> parameter.</p>
         *        <p>
         *        Note that if you include <code>Words</code> in your request, you cannot use
         *        <code>VocabularyFilterFileUri</code>; you must choose one or the other.
         *        </p>
         *        <p>
         *        Each language has a character set that contains all allowed characters for that specific language. If
         *        you use unsupported characters, your custom vocabulary filter request fails. Refer to <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom
         *        Vocabularies</a> to get the character set for your language.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder words(Collection<String> words);

        /**
         * <p>
         * Use this parameter if you want to update your custom vocabulary filter by including all desired terms, as
         * comma-separated values, within your request. The other option for updating your vocabulary filter is to save
         * your entries in a text file and upload them to an Amazon S3 bucket, then specify the location of your file
         * using the <code>VocabularyFilterFileUri</code> parameter.
         * </p>
         * <p>
         * Note that if you include <code>Words</code> in your request, you cannot use
         * <code>VocabularyFilterFileUri</code>; you must choose one or the other.
         * </p>
         * <p>
         * Each language has a character set that contains all allowed characters for that specific language. If you use
         * unsupported characters, your custom vocabulary filter request fails. Refer to <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom
         * Vocabularies</a> to get the character set for your language.
         * </p>
         * 
         * @param words
         *        Use this parameter if you want to update your custom vocabulary filter by including all desired terms,
         *        as comma-separated values, within your request. The other option for updating your vocabulary filter
         *        is to save your entries in a text file and upload them to an Amazon S3 bucket, then specify the
         *        location of your file using the <code>VocabularyFilterFileUri</code> parameter.</p>
         *        <p>
         *        Note that if you include <code>Words</code> in your request, you cannot use
         *        <code>VocabularyFilterFileUri</code>; you must choose one or the other.
         *        </p>
         *        <p>
         *        Each language has a character set that contains all allowed characters for that specific language. If
         *        you use unsupported characters, your custom vocabulary filter request fails. Refer to <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom
         *        Vocabularies</a> to get the character set for your language.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder words(String... words);

        /**
         * <p>
         * The Amazon S3 location of the text file that contains your custom vocabulary filter terms. The URI must be
         * located in the same Amazon Web Services Region as the resource you're calling.
         * </p>
         * <p>
         * Here's an example URI path: <code>s3://DOC-EXAMPLE-BUCKET/my-vocab-filter-file.txt</code>
         * </p>
         * <p>
         * Note that if you include <code>VocabularyFilterFileUri</code> in your request, you cannot use
         * <code>Words</code>; you must choose one or the other.
         * </p>
         * 
         * @param vocabularyFilterFileUri
         *        The Amazon S3 location of the text file that contains your custom vocabulary filter terms. The URI
         *        must be located in the same Amazon Web Services Region as the resource you're calling.</p>
         *        <p>
         *        Here's an example URI path: <code>s3://DOC-EXAMPLE-BUCKET/my-vocab-filter-file.txt</code>
         *        </p>
         *        <p>
         *        Note that if you include <code>VocabularyFilterFileUri</code> in your request, you cannot use
         *        <code>Words</code>; you must choose one or the other.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterFileUri(String vocabularyFilterFileUri);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that
         * contains your input files (in this case, your custom vocabulary filter). If the role that you specify doesn’t
         * have the appropriate permissions to access the specified Amazon S3 location, your request fails.
         * </p>
         * <p>
         * IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example:
         * <code>arn:aws:iam::111122223333:role/Admin</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM
         * ARNs</a>.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that
         *        contains your input files (in this case, your custom vocabulary filter). If the role that you specify
         *        doesn’t have the appropriate permissions to access the specified Amazon S3 location, your request
         *        fails.</p>
         *        <p>
         *        IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For
         *        example: <code>arn:aws:iam::111122223333:role/Admin</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns"
         *        >IAM ARNs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranscribeRequest.BuilderImpl implements Builder {
        private String vocabularyFilterName;

        private List<String> words = DefaultSdkAutoConstructList.getInstance();

        private String vocabularyFilterFileUri;

        private String dataAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVocabularyFilterRequest model) {
            super(model);
            vocabularyFilterName(model.vocabularyFilterName);
            words(model.words);
            vocabularyFilterFileUri(model.vocabularyFilterFileUri);
            dataAccessRoleArn(model.dataAccessRoleArn);
        }

        public final String getVocabularyFilterName() {
            return vocabularyFilterName;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final Collection<String> getWords() {
            if (words instanceof SdkAutoConstructList) {
                return null;
            }
            return words;
        }

        public final void setWords(Collection<String> words) {
            this.words = WordsCopier.copy(words);
        }

        @Override
        public final Builder words(Collection<String> words) {
            this.words = WordsCopier.copy(words);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder words(String... words) {
            words(Arrays.asList(words));
            return this;
        }

        public final String getVocabularyFilterFileUri() {
            return vocabularyFilterFileUri;
        }

        public final void setVocabularyFilterFileUri(String vocabularyFilterFileUri) {
            this.vocabularyFilterFileUri = vocabularyFilterFileUri;
        }

        @Override
        public final Builder vocabularyFilterFileUri(String vocabularyFilterFileUri) {
            this.vocabularyFilterFileUri = vocabularyFilterFileUri;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVocabularyFilterRequest build() {
            return new UpdateVocabularyFilterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
