/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Makes it possible to control how your Medical Scribe job is processed using a <code>MedicalScribeSettings</code>
 * object. Specify <code>ChannelIdentification</code> if <code>ChannelDefinitions</code> are set. Enabled
 * <code>ShowSpeakerLabels</code> if <code>ChannelIdentification</code> and <code>ChannelDefinitions</code> are not set.
 * One and only one of <code>ChannelIdentification</code> and <code>ShowSpeakerLabels</code> must be set. If
 * <code>ShowSpeakerLabels</code> is set, <code>MaxSpeakerLabels</code> must also be set. Use <code>Settings</code> to
 * specify a vocabulary or vocabulary filter or both using <code>VocabularyName</code>,
 * <code>VocabularyFilterName</code>. <code>VocabularyFilterMethod</code> must be specified if
 * <code>VocabularyFilterName</code> is set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MedicalScribeSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<MedicalScribeSettings.Builder, MedicalScribeSettings> {
    private static final SdkField<Boolean> SHOW_SPEAKER_LABELS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ShowSpeakerLabels").getter(getter(MedicalScribeSettings::showSpeakerLabels))
            .setter(setter(Builder::showSpeakerLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowSpeakerLabels").build()).build();

    private static final SdkField<Integer> MAX_SPEAKER_LABELS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSpeakerLabels").getter(getter(MedicalScribeSettings::maxSpeakerLabels))
            .setter(setter(Builder::maxSpeakerLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSpeakerLabels").build()).build();

    private static final SdkField<Boolean> CHANNEL_IDENTIFICATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ChannelIdentification").getter(getter(MedicalScribeSettings::channelIdentification))
            .setter(setter(Builder::channelIdentification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelIdentification").build())
            .build();

    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyName").getter(getter(MedicalScribeSettings::vocabularyName))
            .setter(setter(Builder::vocabularyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()).build();

    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterName").getter(getter(MedicalScribeSettings::vocabularyFilterName))
            .setter(setter(Builder::vocabularyFilterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build())
            .build();

    private static final SdkField<String> VOCABULARY_FILTER_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterMethod").getter(getter(MedicalScribeSettings::vocabularyFilterMethodAsString))
            .setter(setter(Builder::vocabularyFilterMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterMethod").build())
            .build();

    private static final SdkField<ClinicalNoteGenerationSettings> CLINICAL_NOTE_GENERATION_SETTINGS_FIELD = SdkField
            .<ClinicalNoteGenerationSettings> builder(MarshallingType.SDK_POJO)
            .memberName("ClinicalNoteGenerationSettings")
            .getter(getter(MedicalScribeSettings::clinicalNoteGenerationSettings))
            .setter(setter(Builder::clinicalNoteGenerationSettings))
            .constructor(ClinicalNoteGenerationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClinicalNoteGenerationSettings")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHOW_SPEAKER_LABELS_FIELD,
            MAX_SPEAKER_LABELS_FIELD, CHANNEL_IDENTIFICATION_FIELD, VOCABULARY_NAME_FIELD, VOCABULARY_FILTER_NAME_FIELD,
            VOCABULARY_FILTER_METHOD_FIELD, CLINICAL_NOTE_GENERATION_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean showSpeakerLabels;

    private final Integer maxSpeakerLabels;

    private final Boolean channelIdentification;

    private final String vocabularyName;

    private final String vocabularyFilterName;

    private final String vocabularyFilterMethod;

    private final ClinicalNoteGenerationSettings clinicalNoteGenerationSettings;

    private MedicalScribeSettings(BuilderImpl builder) {
        this.showSpeakerLabels = builder.showSpeakerLabels;
        this.maxSpeakerLabels = builder.maxSpeakerLabels;
        this.channelIdentification = builder.channelIdentification;
        this.vocabularyName = builder.vocabularyName;
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.vocabularyFilterMethod = builder.vocabularyFilterMethod;
        this.clinicalNoteGenerationSettings = builder.clinicalNoteGenerationSettings;
    }

    /**
     * <p>
     * Enables speaker partitioning (diarization) in your Medical Scribe output. Speaker partitioning labels the speech
     * from individual speakers in your media file.
     * </p>
     * <p>
     * If you enable <code>ShowSpeakerLabels</code> in your request, you must also include <code>MaxSpeakerLabels</code>
     * .
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers (diarization)</a>.
     * </p>
     * 
     * @return Enables speaker partitioning (diarization) in your Medical Scribe output. Speaker partitioning labels the
     *         speech from individual speakers in your media file.</p>
     *         <p>
     *         If you enable <code>ShowSpeakerLabels</code> in your request, you must also include
     *         <code>MaxSpeakerLabels</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers
     *         (diarization)</a>.
     */
    public final Boolean showSpeakerLabels() {
        return showSpeakerLabels;
    }

    /**
     * <p>
     * Specify the maximum number of speakers you want to partition in your media.
     * </p>
     * <p>
     * Note that if your media contains more speakers than the specified number, multiple speakers are treated as a
     * single speaker.
     * </p>
     * <p>
     * If you specify the <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code> field to
     * true.
     * </p>
     * 
     * @return Specify the maximum number of speakers you want to partition in your media.</p>
     *         <p>
     *         Note that if your media contains more speakers than the specified number, multiple speakers are treated
     *         as a single speaker.
     *         </p>
     *         <p>
     *         If you specify the <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code>
     *         field to true.
     */
    public final Integer maxSpeakerLabels() {
        return maxSpeakerLabels;
    }

    /**
     * <p>
     * Enables channel identification in multi-channel audio.
     * </p>
     * <p>
     * Channel identification transcribes the audio on each channel independently, then appends the output for each
     * channel into one transcript.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing
     * multi-channel audio</a>.
     * </p>
     * 
     * @return Enables channel identification in multi-channel audio.</p>
     *         <p>
     *         Channel identification transcribes the audio on each channel independently, then appends the output for
     *         each channel into one transcript.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel
     *         audio</a>.
     */
    public final Boolean channelIdentification() {
        return channelIdentification;
    }

    /**
     * <p>
     * The name of the custom vocabulary you want to include in your Medical Scribe request. Custom vocabulary names are
     * case sensitive.
     * </p>
     * 
     * @return The name of the custom vocabulary you want to include in your Medical Scribe request. Custom vocabulary
     *         names are case sensitive.
     */
    public final String vocabularyName() {
        return vocabularyName;
    }

    /**
     * <p>
     * The name of the custom vocabulary filter you want to include in your Medical Scribe request. Custom vocabulary
     * filter names are case sensitive.
     * </p>
     * <p>
     * Note that if you include <code>VocabularyFilterName</code> in your request, you must also include
     * <code>VocabularyFilterMethod</code>.
     * </p>
     * 
     * @return The name of the custom vocabulary filter you want to include in your Medical Scribe request. Custom
     *         vocabulary filter names are case sensitive.</p>
     *         <p>
     *         Note that if you include <code>VocabularyFilterName</code> in your request, you must also include
     *         <code>VocabularyFilterMethod</code>.
     */
    public final String vocabularyFilterName() {
        return vocabularyFilterName;
    }

    /**
     * <p>
     * Specify how you want your custom vocabulary filter applied to your transcript.
     * </p>
     * <p>
     * To replace words with <code>***</code>, choose <code>mask</code>.
     * </p>
     * <p>
     * To delete words, choose <code>remove</code>.
     * </p>
     * <p>
     * To flag words without changing them, choose <code>tag</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vocabularyFilterMethod} will return {@link VocabularyFilterMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #vocabularyFilterMethodAsString}.
     * </p>
     * 
     * @return Specify how you want your custom vocabulary filter applied to your transcript.</p>
     *         <p>
     *         To replace words with <code>***</code>, choose <code>mask</code>.
     *         </p>
     *         <p>
     *         To delete words, choose <code>remove</code>.
     *         </p>
     *         <p>
     *         To flag words without changing them, choose <code>tag</code>.
     * @see VocabularyFilterMethod
     */
    public final VocabularyFilterMethod vocabularyFilterMethod() {
        return VocabularyFilterMethod.fromValue(vocabularyFilterMethod);
    }

    /**
     * <p>
     * Specify how you want your custom vocabulary filter applied to your transcript.
     * </p>
     * <p>
     * To replace words with <code>***</code>, choose <code>mask</code>.
     * </p>
     * <p>
     * To delete words, choose <code>remove</code>.
     * </p>
     * <p>
     * To flag words without changing them, choose <code>tag</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vocabularyFilterMethod} will return {@link VocabularyFilterMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #vocabularyFilterMethodAsString}.
     * </p>
     * 
     * @return Specify how you want your custom vocabulary filter applied to your transcript.</p>
     *         <p>
     *         To replace words with <code>***</code>, choose <code>mask</code>.
     *         </p>
     *         <p>
     *         To delete words, choose <code>remove</code>.
     *         </p>
     *         <p>
     *         To flag words without changing them, choose <code>tag</code>.
     * @see VocabularyFilterMethod
     */
    public final String vocabularyFilterMethodAsString() {
        return vocabularyFilterMethod;
    }

    /**
     * <p>
     * Specify settings for the clinical note generation.
     * </p>
     * 
     * @return Specify settings for the clinical note generation.
     */
    public final ClinicalNoteGenerationSettings clinicalNoteGenerationSettings() {
        return clinicalNoteGenerationSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(showSpeakerLabels());
        hashCode = 31 * hashCode + Objects.hashCode(maxSpeakerLabels());
        hashCode = 31 * hashCode + Objects.hashCode(channelIdentification());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clinicalNoteGenerationSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalScribeSettings)) {
            return false;
        }
        MedicalScribeSettings other = (MedicalScribeSettings) obj;
        return Objects.equals(showSpeakerLabels(), other.showSpeakerLabels())
                && Objects.equals(maxSpeakerLabels(), other.maxSpeakerLabels())
                && Objects.equals(channelIdentification(), other.channelIdentification())
                && Objects.equals(vocabularyName(), other.vocabularyName())
                && Objects.equals(vocabularyFilterName(), other.vocabularyFilterName())
                && Objects.equals(vocabularyFilterMethodAsString(), other.vocabularyFilterMethodAsString())
                && Objects.equals(clinicalNoteGenerationSettings(), other.clinicalNoteGenerationSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MedicalScribeSettings").add("ShowSpeakerLabels", showSpeakerLabels())
                .add("MaxSpeakerLabels", maxSpeakerLabels()).add("ChannelIdentification", channelIdentification())
                .add("VocabularyName", vocabularyName()).add("VocabularyFilterName", vocabularyFilterName())
                .add("VocabularyFilterMethod", vocabularyFilterMethodAsString())
                .add("ClinicalNoteGenerationSettings", clinicalNoteGenerationSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShowSpeakerLabels":
            return Optional.ofNullable(clazz.cast(showSpeakerLabels()));
        case "MaxSpeakerLabels":
            return Optional.ofNullable(clazz.cast(maxSpeakerLabels()));
        case "ChannelIdentification":
            return Optional.ofNullable(clazz.cast(channelIdentification()));
        case "VocabularyName":
            return Optional.ofNullable(clazz.cast(vocabularyName()));
        case "VocabularyFilterName":
            return Optional.ofNullable(clazz.cast(vocabularyFilterName()));
        case "VocabularyFilterMethod":
            return Optional.ofNullable(clazz.cast(vocabularyFilterMethodAsString()));
        case "ClinicalNoteGenerationSettings":
            return Optional.ofNullable(clazz.cast(clinicalNoteGenerationSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ShowSpeakerLabels", SHOW_SPEAKER_LABELS_FIELD);
        map.put("MaxSpeakerLabels", MAX_SPEAKER_LABELS_FIELD);
        map.put("ChannelIdentification", CHANNEL_IDENTIFICATION_FIELD);
        map.put("VocabularyName", VOCABULARY_NAME_FIELD);
        map.put("VocabularyFilterName", VOCABULARY_FILTER_NAME_FIELD);
        map.put("VocabularyFilterMethod", VOCABULARY_FILTER_METHOD_FIELD);
        map.put("ClinicalNoteGenerationSettings", CLINICAL_NOTE_GENERATION_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MedicalScribeSettings, T> g) {
        return obj -> g.apply((MedicalScribeSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MedicalScribeSettings> {
        /**
         * <p>
         * Enables speaker partitioning (diarization) in your Medical Scribe output. Speaker partitioning labels the
         * speech from individual speakers in your media file.
         * </p>
         * <p>
         * If you enable <code>ShowSpeakerLabels</code> in your request, you must also include
         * <code>MaxSpeakerLabels</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers
         * (diarization)</a>.
         * </p>
         * 
         * @param showSpeakerLabels
         *        Enables speaker partitioning (diarization) in your Medical Scribe output. Speaker partitioning labels
         *        the speech from individual speakers in your media file.</p>
         *        <p>
         *        If you enable <code>ShowSpeakerLabels</code> in your request, you must also include
         *        <code>MaxSpeakerLabels</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers
         *        (diarization)</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder showSpeakerLabels(Boolean showSpeakerLabels);

        /**
         * <p>
         * Specify the maximum number of speakers you want to partition in your media.
         * </p>
         * <p>
         * Note that if your media contains more speakers than the specified number, multiple speakers are treated as a
         * single speaker.
         * </p>
         * <p>
         * If you specify the <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code> field
         * to true.
         * </p>
         * 
         * @param maxSpeakerLabels
         *        Specify the maximum number of speakers you want to partition in your media.</p>
         *        <p>
         *        Note that if your media contains more speakers than the specified number, multiple speakers are
         *        treated as a single speaker.
         *        </p>
         *        <p>
         *        If you specify the <code>MaxSpeakerLabels</code> field, you must set the
         *        <code>ShowSpeakerLabels</code> field to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSpeakerLabels(Integer maxSpeakerLabels);

        /**
         * <p>
         * Enables channel identification in multi-channel audio.
         * </p>
         * <p>
         * Channel identification transcribes the audio on each channel independently, then appends the output for each
         * channel into one transcript.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel audio</a>.
         * </p>
         * 
         * @param channelIdentification
         *        Enables channel identification in multi-channel audio.</p>
         *        <p>
         *        Channel identification transcribes the audio on each channel independently, then appends the output
         *        for each channel into one transcript.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel
         *        audio</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelIdentification(Boolean channelIdentification);

        /**
         * <p>
         * The name of the custom vocabulary you want to include in your Medical Scribe request. Custom vocabulary names
         * are case sensitive.
         * </p>
         * 
         * @param vocabularyName
         *        The name of the custom vocabulary you want to include in your Medical Scribe request. Custom
         *        vocabulary names are case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyName(String vocabularyName);

        /**
         * <p>
         * The name of the custom vocabulary filter you want to include in your Medical Scribe request. Custom
         * vocabulary filter names are case sensitive.
         * </p>
         * <p>
         * Note that if you include <code>VocabularyFilterName</code> in your request, you must also include
         * <code>VocabularyFilterMethod</code>.
         * </p>
         * 
         * @param vocabularyFilterName
         *        The name of the custom vocabulary filter you want to include in your Medical Scribe request. Custom
         *        vocabulary filter names are case sensitive.</p>
         *        <p>
         *        Note that if you include <code>VocabularyFilterName</code> in your request, you must also include
         *        <code>VocabularyFilterMethod</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterName(String vocabularyFilterName);

        /**
         * <p>
         * Specify how you want your custom vocabulary filter applied to your transcript.
         * </p>
         * <p>
         * To replace words with <code>***</code>, choose <code>mask</code>.
         * </p>
         * <p>
         * To delete words, choose <code>remove</code>.
         * </p>
         * <p>
         * To flag words without changing them, choose <code>tag</code>.
         * </p>
         * 
         * @param vocabularyFilterMethod
         *        Specify how you want your custom vocabulary filter applied to your transcript.</p>
         *        <p>
         *        To replace words with <code>***</code>, choose <code>mask</code>.
         *        </p>
         *        <p>
         *        To delete words, choose <code>remove</code>.
         *        </p>
         *        <p>
         *        To flag words without changing them, choose <code>tag</code>.
         * @see VocabularyFilterMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyFilterMethod
         */
        Builder vocabularyFilterMethod(String vocabularyFilterMethod);

        /**
         * <p>
         * Specify how you want your custom vocabulary filter applied to your transcript.
         * </p>
         * <p>
         * To replace words with <code>***</code>, choose <code>mask</code>.
         * </p>
         * <p>
         * To delete words, choose <code>remove</code>.
         * </p>
         * <p>
         * To flag words without changing them, choose <code>tag</code>.
         * </p>
         * 
         * @param vocabularyFilterMethod
         *        Specify how you want your custom vocabulary filter applied to your transcript.</p>
         *        <p>
         *        To replace words with <code>***</code>, choose <code>mask</code>.
         *        </p>
         *        <p>
         *        To delete words, choose <code>remove</code>.
         *        </p>
         *        <p>
         *        To flag words without changing them, choose <code>tag</code>.
         * @see VocabularyFilterMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyFilterMethod
         */
        Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod);

        /**
         * <p>
         * Specify settings for the clinical note generation.
         * </p>
         * 
         * @param clinicalNoteGenerationSettings
         *        Specify settings for the clinical note generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clinicalNoteGenerationSettings(ClinicalNoteGenerationSettings clinicalNoteGenerationSettings);

        /**
         * <p>
         * Specify settings for the clinical note generation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClinicalNoteGenerationSettings.Builder}
         * avoiding the need to create one manually via {@link ClinicalNoteGenerationSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClinicalNoteGenerationSettings.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #clinicalNoteGenerationSettings(ClinicalNoteGenerationSettings)}.
         * 
         * @param clinicalNoteGenerationSettings
         *        a consumer that will call methods on {@link ClinicalNoteGenerationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clinicalNoteGenerationSettings(ClinicalNoteGenerationSettings)
         */
        default Builder clinicalNoteGenerationSettings(
                Consumer<ClinicalNoteGenerationSettings.Builder> clinicalNoteGenerationSettings) {
            return clinicalNoteGenerationSettings(ClinicalNoteGenerationSettings.builder()
                    .applyMutation(clinicalNoteGenerationSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean showSpeakerLabels;

        private Integer maxSpeakerLabels;

        private Boolean channelIdentification;

        private String vocabularyName;

        private String vocabularyFilterName;

        private String vocabularyFilterMethod;

        private ClinicalNoteGenerationSettings clinicalNoteGenerationSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalScribeSettings model) {
            showSpeakerLabels(model.showSpeakerLabels);
            maxSpeakerLabels(model.maxSpeakerLabels);
            channelIdentification(model.channelIdentification);
            vocabularyName(model.vocabularyName);
            vocabularyFilterName(model.vocabularyFilterName);
            vocabularyFilterMethod(model.vocabularyFilterMethod);
            clinicalNoteGenerationSettings(model.clinicalNoteGenerationSettings);
        }

        public final Boolean getShowSpeakerLabels() {
            return showSpeakerLabels;
        }

        public final void setShowSpeakerLabels(Boolean showSpeakerLabels) {
            this.showSpeakerLabels = showSpeakerLabels;
        }

        @Override
        public final Builder showSpeakerLabels(Boolean showSpeakerLabels) {
            this.showSpeakerLabels = showSpeakerLabels;
            return this;
        }

        public final Integer getMaxSpeakerLabels() {
            return maxSpeakerLabels;
        }

        public final void setMaxSpeakerLabels(Integer maxSpeakerLabels) {
            this.maxSpeakerLabels = maxSpeakerLabels;
        }

        @Override
        public final Builder maxSpeakerLabels(Integer maxSpeakerLabels) {
            this.maxSpeakerLabels = maxSpeakerLabels;
            return this;
        }

        public final Boolean getChannelIdentification() {
            return channelIdentification;
        }

        public final void setChannelIdentification(Boolean channelIdentification) {
            this.channelIdentification = channelIdentification;
        }

        @Override
        public final Builder channelIdentification(Boolean channelIdentification) {
            this.channelIdentification = channelIdentification;
            return this;
        }

        public final String getVocabularyName() {
            return vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getVocabularyFilterName() {
            return vocabularyFilterName;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final String getVocabularyFilterMethod() {
            return vocabularyFilterMethod;
        }

        public final void setVocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
        }

        @Override
        public final Builder vocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
            return this;
        }

        @Override
        public final Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod) {
            this.vocabularyFilterMethod(vocabularyFilterMethod == null ? null : vocabularyFilterMethod.toString());
            return this;
        }

        public final ClinicalNoteGenerationSettings.Builder getClinicalNoteGenerationSettings() {
            return clinicalNoteGenerationSettings != null ? clinicalNoteGenerationSettings.toBuilder() : null;
        }

        public final void setClinicalNoteGenerationSettings(
                ClinicalNoteGenerationSettings.BuilderImpl clinicalNoteGenerationSettings) {
            this.clinicalNoteGenerationSettings = clinicalNoteGenerationSettings != null ? clinicalNoteGenerationSettings.build()
                    : null;
        }

        @Override
        public final Builder clinicalNoteGenerationSettings(ClinicalNoteGenerationSettings clinicalNoteGenerationSettings) {
            this.clinicalNoteGenerationSettings = clinicalNoteGenerationSettings;
            return this;
        }

        @Override
        public MedicalScribeSettings build() {
            return new MedicalScribeSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
