/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>MedicalScribeContext</code> object that contains contextual information used to generate customized
 * clinical notes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MedicalScribeContext implements SdkPojo, Serializable,
        ToCopyableBuilder<MedicalScribeContext.Builder, MedicalScribeContext> {
    private static final SdkField<MedicalScribePatientContext> PATIENT_CONTEXT_FIELD = SdkField
            .<MedicalScribePatientContext> builder(MarshallingType.SDK_POJO).memberName("PatientContext")
            .getter(getter(MedicalScribeContext::patientContext)).setter(setter(Builder::patientContext))
            .constructor(MedicalScribePatientContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatientContext").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATIENT_CONTEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MedicalScribePatientContext patientContext;

    private MedicalScribeContext(BuilderImpl builder) {
        this.patientContext = builder.patientContext;
    }

    /**
     * <p>
     * Contains patient-specific information.
     * </p>
     * 
     * @return Contains patient-specific information.
     */
    public final MedicalScribePatientContext patientContext() {
        return patientContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(patientContext());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalScribeContext)) {
            return false;
        }
        MedicalScribeContext other = (MedicalScribeContext) obj;
        return Objects.equals(patientContext(), other.patientContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MedicalScribeContext").add("PatientContext", patientContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PatientContext":
            return Optional.ofNullable(clazz.cast(patientContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PatientContext", PATIENT_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MedicalScribeContext, T> g) {
        return obj -> g.apply((MedicalScribeContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MedicalScribeContext> {
        /**
         * <p>
         * Contains patient-specific information.
         * </p>
         * 
         * @param patientContext
         *        Contains patient-specific information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patientContext(MedicalScribePatientContext patientContext);

        /**
         * <p>
         * Contains patient-specific information.
         * </p>
         * This is a convenience method that creates an instance of the {@link MedicalScribePatientContext.Builder}
         * avoiding the need to create one manually via {@link MedicalScribePatientContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MedicalScribePatientContext.Builder#build()} is called
         * immediately and its result is passed to {@link #patientContext(MedicalScribePatientContext)}.
         * 
         * @param patientContext
         *        a consumer that will call methods on {@link MedicalScribePatientContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #patientContext(MedicalScribePatientContext)
         */
        default Builder patientContext(Consumer<MedicalScribePatientContext.Builder> patientContext) {
            return patientContext(MedicalScribePatientContext.builder().applyMutation(patientContext).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MedicalScribePatientContext patientContext;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalScribeContext model) {
            patientContext(model.patientContext);
        }

        public final MedicalScribePatientContext.Builder getPatientContext() {
            return patientContext != null ? patientContext.toBuilder() : null;
        }

        public final void setPatientContext(MedicalScribePatientContext.BuilderImpl patientContext) {
            this.patientContext = patientContext != null ? patientContext.build() : null;
        }

        @Override
        public final Builder patientContext(MedicalScribePatientContext patientContext) {
            this.patientContext = patientContext;
            return this;
        }

        @Override
        public MedicalScribeContext build() {
            return new MedicalScribeContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
