/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides detailed information about a specific Medical Scribe job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MedicalScribeJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<MedicalScribeJobSummary.Builder, MedicalScribeJobSummary> {
    private static final SdkField<String> MEDICAL_SCRIBE_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MedicalScribeJobName").getter(getter(MedicalScribeJobSummary::medicalScribeJobName))
            .setter(setter(Builder::medicalScribeJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedicalScribeJobName").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(MedicalScribeJobSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(MedicalScribeJobSummary::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionTime").getter(getter(MedicalScribeJobSummary::completionTime))
            .setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(MedicalScribeJobSummary::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> MEDICAL_SCRIBE_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MedicalScribeJobStatus").getter(getter(MedicalScribeJobSummary::medicalScribeJobStatusAsString))
            .setter(setter(Builder::medicalScribeJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedicalScribeJobStatus").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(MedicalScribeJobSummary::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDICAL_SCRIBE_JOB_NAME_FIELD,
            CREATION_TIME_FIELD, START_TIME_FIELD, COMPLETION_TIME_FIELD, LANGUAGE_CODE_FIELD, MEDICAL_SCRIBE_JOB_STATUS_FIELD,
            FAILURE_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String medicalScribeJobName;

    private final Instant creationTime;

    private final Instant startTime;

    private final Instant completionTime;

    private final String languageCode;

    private final String medicalScribeJobStatus;

    private final String failureReason;

    private MedicalScribeJobSummary(BuilderImpl builder) {
        this.medicalScribeJobName = builder.medicalScribeJobName;
        this.creationTime = builder.creationTime;
        this.startTime = builder.startTime;
        this.completionTime = builder.completionTime;
        this.languageCode = builder.languageCode;
        this.medicalScribeJobStatus = builder.medicalScribeJobStatus;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The name of the Medical Scribe job. Job names are case sensitive and must be unique within an Amazon Web Services
     * account.
     * </p>
     * 
     * @return The name of the Medical Scribe job. Job names are case sensitive and must be unique within an Amazon Web
     *         Services account.
     */
    public final String medicalScribeJobName() {
        return medicalScribeJobName;
    }

    /**
     * <p>
     * The date and time the specified Medical Scribe job request was made.
     * </p>
     * <p>
     * Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
     * <code>2022-05-04T12:32:58.761000-07:00</code> represents a Medical Scribe job that started processing at 12:32 PM
     * UTC-7 on May 4, 2022.
     * </p>
     * 
     * @return The date and time the specified Medical Scribe job request was made.</p>
     *         <p>
     *         Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
     *         <code>2022-05-04T12:32:58.761000-07:00</code> represents a Medical Scribe job that started processing at
     *         12:32 PM UTC-7 on May 4, 2022.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time your Medical Scribe job began processing.
     * </p>
     * <p>
     * Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
     * <code>2022-05-04T12:32:58.789000-07:00</code> represents a Medical Scribe job that started processing at 12:32 PM
     * UTC-7 on May 4, 2022.
     * </p>
     * 
     * @return The date and time your Medical Scribe job began processing.</p>
     *         <p>
     *         Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
     *         <code>2022-05-04T12:32:58.789000-07:00</code> represents a Medical Scribe job that started processing at
     *         12:32 PM UTC-7 on May 4, 2022.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The date and time the specified Medical Scribe job finished processing.
     * </p>
     * <p>
     * Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
     * <code>2022-05-04T12:32:58.761000-07:00</code> represents a Medical Scribe job that finished processing at 12:32
     * PM UTC-7 on May 4, 2022.
     * </p>
     * 
     * @return The date and time the specified Medical Scribe job finished processing.</p>
     *         <p>
     *         Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
     *         <code>2022-05-04T12:32:58.761000-07:00</code> represents a Medical Scribe job that finished processing at
     *         12:32 PM UTC-7 on May 4, 2022.
     */
    public final Instant completionTime() {
        return completionTime;
    }

    /**
     * <p>
     * The language code used to create your Medical Scribe job. US English (<code>en-US</code>) is the only supported
     * language for Medical Scribe jobs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link MedicalScribeLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code used to create your Medical Scribe job. US English (<code>en-US</code>) is the only
     *         supported language for Medical Scribe jobs.
     * @see MedicalScribeLanguageCode
     */
    public final MedicalScribeLanguageCode languageCode() {
        return MedicalScribeLanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code used to create your Medical Scribe job. US English (<code>en-US</code>) is the only supported
     * language for Medical Scribe jobs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link MedicalScribeLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code used to create your Medical Scribe job. US English (<code>en-US</code>) is the only
     *         supported language for Medical Scribe jobs.
     * @see MedicalScribeLanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * Provides the status of the specified Medical Scribe job.
     * </p>
     * <p>
     * If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location
     * specified in <code>MedicalScribeOutput</code> If the status is <code>FAILED</code>, <code>FailureReason</code>
     * provides details on why your Medical Scribe job failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #medicalScribeJobStatus} will return {@link MedicalScribeJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #medicalScribeJobStatusAsString}.
     * </p>
     * 
     * @return Provides the status of the specified Medical Scribe job.</p>
     *         <p>
     *         If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location
     *         specified in <code>MedicalScribeOutput</code> If the status is <code>FAILED</code>,
     *         <code>FailureReason</code> provides details on why your Medical Scribe job failed.
     * @see MedicalScribeJobStatus
     */
    public final MedicalScribeJobStatus medicalScribeJobStatus() {
        return MedicalScribeJobStatus.fromValue(medicalScribeJobStatus);
    }

    /**
     * <p>
     * Provides the status of the specified Medical Scribe job.
     * </p>
     * <p>
     * If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location
     * specified in <code>MedicalScribeOutput</code> If the status is <code>FAILED</code>, <code>FailureReason</code>
     * provides details on why your Medical Scribe job failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #medicalScribeJobStatus} will return {@link MedicalScribeJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #medicalScribeJobStatusAsString}.
     * </p>
     * 
     * @return Provides the status of the specified Medical Scribe job.</p>
     *         <p>
     *         If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location
     *         specified in <code>MedicalScribeOutput</code> If the status is <code>FAILED</code>,
     *         <code>FailureReason</code> provides details on why your Medical Scribe job failed.
     * @see MedicalScribeJobStatus
     */
    public final String medicalScribeJobStatusAsString() {
        return medicalScribeJobStatus;
    }

    /**
     * <p>
     * If <code>MedicalScribeJobStatus</code> is <code>FAILED</code>, <code>FailureReason</code> contains information
     * about why the transcription job failed. See also: <a
     * href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.
     * </p>
     * 
     * @return If <code>MedicalScribeJobStatus</code> is <code>FAILED</code>, <code>FailureReason</code> contains
     *         information about why the transcription job failed. See also: <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(medicalScribeJobName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(medicalScribeJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalScribeJobSummary)) {
            return false;
        }
        MedicalScribeJobSummary other = (MedicalScribeJobSummary) obj;
        return Objects.equals(medicalScribeJobName(), other.medicalScribeJobName())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(completionTime(), other.completionTime())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(medicalScribeJobStatusAsString(), other.medicalScribeJobStatusAsString())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MedicalScribeJobSummary").add("MedicalScribeJobName", medicalScribeJobName())
                .add("CreationTime", creationTime()).add("StartTime", startTime()).add("CompletionTime", completionTime())
                .add("LanguageCode", languageCodeAsString()).add("MedicalScribeJobStatus", medicalScribeJobStatusAsString())
                .add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MedicalScribeJobName":
            return Optional.ofNullable(clazz.cast(medicalScribeJobName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "CompletionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "MedicalScribeJobStatus":
            return Optional.ofNullable(clazz.cast(medicalScribeJobStatusAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MedicalScribeJobName", MEDICAL_SCRIBE_JOB_NAME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("CompletionTime", COMPLETION_TIME_FIELD);
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        map.put("MedicalScribeJobStatus", MEDICAL_SCRIBE_JOB_STATUS_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MedicalScribeJobSummary, T> g) {
        return obj -> g.apply((MedicalScribeJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MedicalScribeJobSummary> {
        /**
         * <p>
         * The name of the Medical Scribe job. Job names are case sensitive and must be unique within an Amazon Web
         * Services account.
         * </p>
         * 
         * @param medicalScribeJobName
         *        The name of the Medical Scribe job. Job names are case sensitive and must be unique within an Amazon
         *        Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder medicalScribeJobName(String medicalScribeJobName);

        /**
         * <p>
         * The date and time the specified Medical Scribe job request was made.
         * </p>
         * <p>
         * Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
         * <code>2022-05-04T12:32:58.761000-07:00</code> represents a Medical Scribe job that started processing at
         * 12:32 PM UTC-7 on May 4, 2022.
         * </p>
         * 
         * @param creationTime
         *        The date and time the specified Medical Scribe job request was made.</p>
         *        <p>
         *        Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
         *        <code>2022-05-04T12:32:58.761000-07:00</code> represents a Medical Scribe job that started processing
         *        at 12:32 PM UTC-7 on May 4, 2022.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date and time your Medical Scribe job began processing.
         * </p>
         * <p>
         * Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
         * <code>2022-05-04T12:32:58.789000-07:00</code> represents a Medical Scribe job that started processing at
         * 12:32 PM UTC-7 on May 4, 2022.
         * </p>
         * 
         * @param startTime
         *        The date and time your Medical Scribe job began processing.</p>
         *        <p>
         *        Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
         *        <code>2022-05-04T12:32:58.789000-07:00</code> represents a Medical Scribe job that started processing
         *        at 12:32 PM UTC-7 on May 4, 2022.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The date and time the specified Medical Scribe job finished processing.
         * </p>
         * <p>
         * Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
         * <code>2022-05-04T12:32:58.761000-07:00</code> represents a Medical Scribe job that finished processing at
         * 12:32 PM UTC-7 on May 4, 2022.
         * </p>
         * 
         * @param completionTime
         *        The date and time the specified Medical Scribe job finished processing.</p>
         *        <p>
         *        Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
         *        <code>2022-05-04T12:32:58.761000-07:00</code> represents a Medical Scribe job that finished processing
         *        at 12:32 PM UTC-7 on May 4, 2022.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);

        /**
         * <p>
         * The language code used to create your Medical Scribe job. US English (<code>en-US</code>) is the only
         * supported language for Medical Scribe jobs.
         * </p>
         * 
         * @param languageCode
         *        The language code used to create your Medical Scribe job. US English (<code>en-US</code>) is the only
         *        supported language for Medical Scribe jobs.
         * @see MedicalScribeLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeLanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code used to create your Medical Scribe job. US English (<code>en-US</code>) is the only
         * supported language for Medical Scribe jobs.
         * </p>
         * 
         * @param languageCode
         *        The language code used to create your Medical Scribe job. US English (<code>en-US</code>) is the only
         *        supported language for Medical Scribe jobs.
         * @see MedicalScribeLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeLanguageCode
         */
        Builder languageCode(MedicalScribeLanguageCode languageCode);

        /**
         * <p>
         * Provides the status of the specified Medical Scribe job.
         * </p>
         * <p>
         * If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location
         * specified in <code>MedicalScribeOutput</code> If the status is <code>FAILED</code>,
         * <code>FailureReason</code> provides details on why your Medical Scribe job failed.
         * </p>
         * 
         * @param medicalScribeJobStatus
         *        Provides the status of the specified Medical Scribe job.</p>
         *        <p>
         *        If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the
         *        location specified in <code>MedicalScribeOutput</code> If the status is <code>FAILED</code>,
         *        <code>FailureReason</code> provides details on why your Medical Scribe job failed.
         * @see MedicalScribeJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeJobStatus
         */
        Builder medicalScribeJobStatus(String medicalScribeJobStatus);

        /**
         * <p>
         * Provides the status of the specified Medical Scribe job.
         * </p>
         * <p>
         * If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location
         * specified in <code>MedicalScribeOutput</code> If the status is <code>FAILED</code>,
         * <code>FailureReason</code> provides details on why your Medical Scribe job failed.
         * </p>
         * 
         * @param medicalScribeJobStatus
         *        Provides the status of the specified Medical Scribe job.</p>
         *        <p>
         *        If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the
         *        location specified in <code>MedicalScribeOutput</code> If the status is <code>FAILED</code>,
         *        <code>FailureReason</code> provides details on why your Medical Scribe job failed.
         * @see MedicalScribeJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeJobStatus
         */
        Builder medicalScribeJobStatus(MedicalScribeJobStatus medicalScribeJobStatus);

        /**
         * <p>
         * If <code>MedicalScribeJobStatus</code> is <code>FAILED</code>, <code>FailureReason</code> contains
         * information about why the transcription job failed. See also: <a
         * href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.
         * </p>
         * 
         * @param failureReason
         *        If <code>MedicalScribeJobStatus</code> is <code>FAILED</code>, <code>FailureReason</code> contains
         *        information about why the transcription job failed. See also: <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private String medicalScribeJobName;

        private Instant creationTime;

        private Instant startTime;

        private Instant completionTime;

        private String languageCode;

        private String medicalScribeJobStatus;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalScribeJobSummary model) {
            medicalScribeJobName(model.medicalScribeJobName);
            creationTime(model.creationTime);
            startTime(model.startTime);
            completionTime(model.completionTime);
            languageCode(model.languageCode);
            medicalScribeJobStatus(model.medicalScribeJobStatus);
            failureReason(model.failureReason);
        }

        public final String getMedicalScribeJobName() {
            return medicalScribeJobName;
        }

        public final void setMedicalScribeJobName(String medicalScribeJobName) {
            this.medicalScribeJobName = medicalScribeJobName;
        }

        @Override
        public final Builder medicalScribeJobName(String medicalScribeJobName) {
            this.medicalScribeJobName = medicalScribeJobName;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(MedicalScribeLanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getMedicalScribeJobStatus() {
            return medicalScribeJobStatus;
        }

        public final void setMedicalScribeJobStatus(String medicalScribeJobStatus) {
            this.medicalScribeJobStatus = medicalScribeJobStatus;
        }

        @Override
        public final Builder medicalScribeJobStatus(String medicalScribeJobStatus) {
            this.medicalScribeJobStatus = medicalScribeJobStatus;
            return this;
        }

        @Override
        public final Builder medicalScribeJobStatus(MedicalScribeJobStatus medicalScribeJobStatus) {
            this.medicalScribeJobStatus(medicalScribeJobStatus == null ? null : medicalScribeJobStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public MedicalScribeJobSummary build() {
            return new MedicalScribeJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
