/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A time range, in percentage, between two points in your media file.
 * </p>
 * <p>
 * You can use <code>StartPercentage</code> and <code>EndPercentage</code> to search a custom segment. For example,
 * setting <code>StartPercentage</code> to 10 and <code>EndPercentage</code> to 50 only searches for your specified
 * criteria in the audio contained between the 10 percent mark and the 50 percent mark of your media file.
 * </p>
 * <p>
 * You can use also <code>First</code> to search from the start of the media file until the time that you specify. Or
 * use <code>Last</code> to search from the time that you specify until the end of the media file. For example, setting
 * <code>First</code> to 10 only searches for your specified criteria in the audio contained in the first 10 percent of
 * the media file.
 * </p>
 * <p>
 * If you prefer to use milliseconds instead of percentage, see .
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelativeTimeRange implements SdkPojo, Serializable,
        ToCopyableBuilder<RelativeTimeRange.Builder, RelativeTimeRange> {
    private static final SdkField<Integer> START_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartPercentage").getter(getter(RelativeTimeRange::startPercentage))
            .setter(setter(Builder::startPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartPercentage").build()).build();

    private static final SdkField<Integer> END_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndPercentage").getter(getter(RelativeTimeRange::endPercentage)).setter(setter(Builder::endPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndPercentage").build()).build();

    private static final SdkField<Integer> FIRST_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("First")
            .getter(getter(RelativeTimeRange::first)).setter(setter(Builder::first))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("First").build()).build();

    private static final SdkField<Integer> LAST_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Last")
            .getter(getter(RelativeTimeRange::last)).setter(setter(Builder::last))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Last").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_PERCENTAGE_FIELD,
            END_PERCENTAGE_FIELD, FIRST_FIELD, LAST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer startPercentage;

    private final Integer endPercentage;

    private final Integer first;

    private final Integer last;

    private RelativeTimeRange(BuilderImpl builder) {
        this.startPercentage = builder.startPercentage;
        this.endPercentage = builder.endPercentage;
        this.first = builder.first;
        this.last = builder.last;
    }

    /**
     * <p>
     * The time, in percentage, when Amazon Transcribe starts searching for the specified criteria in your media file.
     * If you include <code>StartPercentage</code> in your request, you must also include <code>EndPercentage</code>.
     * </p>
     * 
     * @return The time, in percentage, when Amazon Transcribe starts searching for the specified criteria in your media
     *         file. If you include <code>StartPercentage</code> in your request, you must also include
     *         <code>EndPercentage</code>.
     */
    public final Integer startPercentage() {
        return startPercentage;
    }

    /**
     * <p>
     * The time, in percentage, when Amazon Transcribe stops searching for the specified criteria in your media file. If
     * you include <code>EndPercentage</code> in your request, you must also include <code>StartPercentage</code>.
     * </p>
     * 
     * @return The time, in percentage, when Amazon Transcribe stops searching for the specified criteria in your media
     *         file. If you include <code>EndPercentage</code> in your request, you must also include
     *         <code>StartPercentage</code>.
     */
    public final Integer endPercentage() {
        return endPercentage;
    }

    /**
     * <p>
     * The time, in percentage, from the start of your media file until the specified value. Amazon Transcribe searches
     * for your specified criteria in this time segment.
     * </p>
     * 
     * @return The time, in percentage, from the start of your media file until the specified value. Amazon Transcribe
     *         searches for your specified criteria in this time segment.
     */
    public final Integer first() {
        return first;
    }

    /**
     * <p>
     * The time, in percentage, from the specified value until the end of your media file. Amazon Transcribe searches
     * for your specified criteria in this time segment.
     * </p>
     * 
     * @return The time, in percentage, from the specified value until the end of your media file. Amazon Transcribe
     *         searches for your specified criteria in this time segment.
     */
    public final Integer last() {
        return last;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(endPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(first());
        hashCode = 31 * hashCode + Objects.hashCode(last());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelativeTimeRange)) {
            return false;
        }
        RelativeTimeRange other = (RelativeTimeRange) obj;
        return Objects.equals(startPercentage(), other.startPercentage())
                && Objects.equals(endPercentage(), other.endPercentage()) && Objects.equals(first(), other.first())
                && Objects.equals(last(), other.last());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelativeTimeRange").add("StartPercentage", startPercentage())
                .add("EndPercentage", endPercentage()).add("First", first()).add("Last", last()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartPercentage":
            return Optional.ofNullable(clazz.cast(startPercentage()));
        case "EndPercentage":
            return Optional.ofNullable(clazz.cast(endPercentage()));
        case "First":
            return Optional.ofNullable(clazz.cast(first()));
        case "Last":
            return Optional.ofNullable(clazz.cast(last()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StartPercentage", START_PERCENTAGE_FIELD);
        map.put("EndPercentage", END_PERCENTAGE_FIELD);
        map.put("First", FIRST_FIELD);
        map.put("Last", LAST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RelativeTimeRange, T> g) {
        return obj -> g.apply((RelativeTimeRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelativeTimeRange> {
        /**
         * <p>
         * The time, in percentage, when Amazon Transcribe starts searching for the specified criteria in your media
         * file. If you include <code>StartPercentage</code> in your request, you must also include
         * <code>EndPercentage</code>.
         * </p>
         * 
         * @param startPercentage
         *        The time, in percentage, when Amazon Transcribe starts searching for the specified criteria in your
         *        media file. If you include <code>StartPercentage</code> in your request, you must also include
         *        <code>EndPercentage</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startPercentage(Integer startPercentage);

        /**
         * <p>
         * The time, in percentage, when Amazon Transcribe stops searching for the specified criteria in your media
         * file. If you include <code>EndPercentage</code> in your request, you must also include
         * <code>StartPercentage</code>.
         * </p>
         * 
         * @param endPercentage
         *        The time, in percentage, when Amazon Transcribe stops searching for the specified criteria in your
         *        media file. If you include <code>EndPercentage</code> in your request, you must also include
         *        <code>StartPercentage</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endPercentage(Integer endPercentage);

        /**
         * <p>
         * The time, in percentage, from the start of your media file until the specified value. Amazon Transcribe
         * searches for your specified criteria in this time segment.
         * </p>
         * 
         * @param first
         *        The time, in percentage, from the start of your media file until the specified value. Amazon
         *        Transcribe searches for your specified criteria in this time segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder first(Integer first);

        /**
         * <p>
         * The time, in percentage, from the specified value until the end of your media file. Amazon Transcribe
         * searches for your specified criteria in this time segment.
         * </p>
         * 
         * @param last
         *        The time, in percentage, from the specified value until the end of your media file. Amazon Transcribe
         *        searches for your specified criteria in this time segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder last(Integer last);
    }

    static final class BuilderImpl implements Builder {
        private Integer startPercentage;

        private Integer endPercentage;

        private Integer first;

        private Integer last;

        private BuilderImpl() {
        }

        private BuilderImpl(RelativeTimeRange model) {
            startPercentage(model.startPercentage);
            endPercentage(model.endPercentage);
            first(model.first);
            last(model.last);
        }

        public final Integer getStartPercentage() {
            return startPercentage;
        }

        public final void setStartPercentage(Integer startPercentage) {
            this.startPercentage = startPercentage;
        }

        @Override
        public final Builder startPercentage(Integer startPercentage) {
            this.startPercentage = startPercentage;
            return this;
        }

        public final Integer getEndPercentage() {
            return endPercentage;
        }

        public final void setEndPercentage(Integer endPercentage) {
            this.endPercentage = endPercentage;
        }

        @Override
        public final Builder endPercentage(Integer endPercentage) {
            this.endPercentage = endPercentage;
            return this;
        }

        public final Integer getFirst() {
            return first;
        }

        public final void setFirst(Integer first) {
            this.first = first;
        }

        @Override
        public final Builder first(Integer first) {
            this.first = first;
            return this;
        }

        public final Integer getLast() {
            return last;
        }

        public final void setLast(Integer last) {
            this.last = last;
        }

        @Override
        public final Builder last(Integer last) {
            this.last = last;
            return this;
        }

        @Override
        public RelativeTimeRange build() {
            return new RelativeTimeRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
