/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains <code>GenerateAbstractiveSummary</code>, which is a required parameter if you want to enable Generative call
 * summarization in your Call Analytics request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Summarization implements SdkPojo, Serializable, ToCopyableBuilder<Summarization.Builder, Summarization> {
    private static final SdkField<Boolean> GENERATE_ABSTRACTIVE_SUMMARY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("GenerateAbstractiveSummary")
            .getter(getter(Summarization::generateAbstractiveSummary))
            .setter(setter(Builder::generateAbstractiveSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerateAbstractiveSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(GENERATE_ABSTRACTIVE_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean generateAbstractiveSummary;

    private Summarization(BuilderImpl builder) {
        this.generateAbstractiveSummary = builder.generateAbstractiveSummary;
    }

    /**
     * <p>
     * Enables Generative call summarization in your Call Analytics request
     * </p>
     * <p>
     * Generative call summarization provides a summary of the transcript including important components discussed in
     * the conversation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-enable-summarization.html">Enabling generative call
     * summarization</a>.
     * </p>
     * 
     * @return Enables Generative call summarization in your Call Analytics request</p>
     *         <p>
     *         Generative call summarization provides a summary of the transcript including important components
     *         discussed in the conversation.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-enable-summarization.html">Enabling generative
     *         call summarization</a>.
     */
    public final Boolean generateAbstractiveSummary() {
        return generateAbstractiveSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(generateAbstractiveSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Summarization)) {
            return false;
        }
        Summarization other = (Summarization) obj;
        return Objects.equals(generateAbstractiveSummary(), other.generateAbstractiveSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Summarization").add("GenerateAbstractiveSummary", generateAbstractiveSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GenerateAbstractiveSummary":
            return Optional.ofNullable(clazz.cast(generateAbstractiveSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GenerateAbstractiveSummary", GENERATE_ABSTRACTIVE_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Summarization, T> g) {
        return obj -> g.apply((Summarization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Summarization> {
        /**
         * <p>
         * Enables Generative call summarization in your Call Analytics request
         * </p>
         * <p>
         * Generative call summarization provides a summary of the transcript including important components discussed
         * in the conversation.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-enable-summarization.html">Enabling generative
         * call summarization</a>.
         * </p>
         * 
         * @param generateAbstractiveSummary
         *        Enables Generative call summarization in your Call Analytics request</p>
         *        <p>
         *        Generative call summarization provides a summary of the transcript including important components
         *        discussed in the conversation.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-enable-summarization.html">Enabling
         *        generative call summarization</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generateAbstractiveSummary(Boolean generateAbstractiveSummary);
    }

    static final class BuilderImpl implements Builder {
        private Boolean generateAbstractiveSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(Summarization model) {
            generateAbstractiveSummary(model.generateAbstractiveSummary);
        }

        public final Boolean getGenerateAbstractiveSummary() {
            return generateAbstractiveSummary;
        }

        public final void setGenerateAbstractiveSummary(Boolean generateAbstractiveSummary) {
            this.generateAbstractiveSummary = generateAbstractiveSummary;
        }

        @Override
        public final Builder generateAbstractiveSummary(Boolean generateAbstractiveSummary) {
            this.generateAbstractiveSummary = generateAbstractiveSummary;
            return this;
        }

        @Override
        public Summarization build() {
            return new Summarization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
