/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains <code>ToxicityCategories</code>, which is a required parameter if you want to enable toxicity detection (
 * <code>ToxicityDetection</code>) in your transcription request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ToxicityDetectionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ToxicityDetectionSettings.Builder, ToxicityDetectionSettings> {
    private static final SdkField<List<String>> TOXICITY_CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ToxicityCategories")
            .getter(getter(ToxicityDetectionSettings::toxicityCategoriesAsStrings))
            .setter(setter(Builder::toxicityCategoriesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToxicityCategories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOXICITY_CATEGORIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> toxicityCategories;

    private ToxicityDetectionSettings(BuilderImpl builder) {
        this.toxicityCategories = builder.toxicityCategories;
    }

    /**
     * <p>
     * If you include <code>ToxicityDetection</code> in your transcription request, you must also include
     * <code>ToxicityCategories</code>. The only accepted value for this parameter is <code>ALL</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasToxicityCategories} method.
     * </p>
     * 
     * @return If you include <code>ToxicityDetection</code> in your transcription request, you must also include
     *         <code>ToxicityCategories</code>. The only accepted value for this parameter is <code>ALL</code>.
     */
    public final List<ToxicityCategory> toxicityCategories() {
        return ToxicityCategoriesCopier.copyStringToEnum(toxicityCategories);
    }

    /**
     * For responses, this returns true if the service returned a value for the ToxicityCategories property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasToxicityCategories() {
        return toxicityCategories != null && !(toxicityCategories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If you include <code>ToxicityDetection</code> in your transcription request, you must also include
     * <code>ToxicityCategories</code>. The only accepted value for this parameter is <code>ALL</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasToxicityCategories} method.
     * </p>
     * 
     * @return If you include <code>ToxicityDetection</code> in your transcription request, you must also include
     *         <code>ToxicityCategories</code>. The only accepted value for this parameter is <code>ALL</code>.
     */
    public final List<String> toxicityCategoriesAsStrings() {
        return toxicityCategories;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasToxicityCategories() ? toxicityCategoriesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToxicityDetectionSettings)) {
            return false;
        }
        ToxicityDetectionSettings other = (ToxicityDetectionSettings) obj;
        return hasToxicityCategories() == other.hasToxicityCategories()
                && Objects.equals(toxicityCategoriesAsStrings(), other.toxicityCategoriesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ToxicityDetectionSettings")
                .add("ToxicityCategories", hasToxicityCategories() ? toxicityCategoriesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ToxicityCategories":
            return Optional.ofNullable(clazz.cast(toxicityCategoriesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ToxicityCategories", TOXICITY_CATEGORIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToxicityDetectionSettings, T> g) {
        return obj -> g.apply((ToxicityDetectionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ToxicityDetectionSettings> {
        /**
         * <p>
         * If you include <code>ToxicityDetection</code> in your transcription request, you must also include
         * <code>ToxicityCategories</code>. The only accepted value for this parameter is <code>ALL</code>.
         * </p>
         * 
         * @param toxicityCategories
         *        If you include <code>ToxicityDetection</code> in your transcription request, you must also include
         *        <code>ToxicityCategories</code>. The only accepted value for this parameter is <code>ALL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toxicityCategoriesWithStrings(Collection<String> toxicityCategories);

        /**
         * <p>
         * If you include <code>ToxicityDetection</code> in your transcription request, you must also include
         * <code>ToxicityCategories</code>. The only accepted value for this parameter is <code>ALL</code>.
         * </p>
         * 
         * @param toxicityCategories
         *        If you include <code>ToxicityDetection</code> in your transcription request, you must also include
         *        <code>ToxicityCategories</code>. The only accepted value for this parameter is <code>ALL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toxicityCategoriesWithStrings(String... toxicityCategories);

        /**
         * <p>
         * If you include <code>ToxicityDetection</code> in your transcription request, you must also include
         * <code>ToxicityCategories</code>. The only accepted value for this parameter is <code>ALL</code>.
         * </p>
         * 
         * @param toxicityCategories
         *        If you include <code>ToxicityDetection</code> in your transcription request, you must also include
         *        <code>ToxicityCategories</code>. The only accepted value for this parameter is <code>ALL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toxicityCategories(Collection<ToxicityCategory> toxicityCategories);

        /**
         * <p>
         * If you include <code>ToxicityDetection</code> in your transcription request, you must also include
         * <code>ToxicityCategories</code>. The only accepted value for this parameter is <code>ALL</code>.
         * </p>
         * 
         * @param toxicityCategories
         *        If you include <code>ToxicityDetection</code> in your transcription request, you must also include
         *        <code>ToxicityCategories</code>. The only accepted value for this parameter is <code>ALL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toxicityCategories(ToxicityCategory... toxicityCategories);
    }

    static final class BuilderImpl implements Builder {
        private List<String> toxicityCategories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ToxicityDetectionSettings model) {
            toxicityCategoriesWithStrings(model.toxicityCategories);
        }

        public final Collection<String> getToxicityCategories() {
            if (toxicityCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return toxicityCategories;
        }

        public final void setToxicityCategories(Collection<String> toxicityCategories) {
            this.toxicityCategories = ToxicityCategoriesCopier.copy(toxicityCategories);
        }

        @Override
        public final Builder toxicityCategoriesWithStrings(Collection<String> toxicityCategories) {
            this.toxicityCategories = ToxicityCategoriesCopier.copy(toxicityCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toxicityCategoriesWithStrings(String... toxicityCategories) {
            toxicityCategoriesWithStrings(Arrays.asList(toxicityCategories));
            return this;
        }

        @Override
        public final Builder toxicityCategories(Collection<ToxicityCategory> toxicityCategories) {
            this.toxicityCategories = ToxicityCategoriesCopier.copyEnumToString(toxicityCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toxicityCategories(ToxicityCategory... toxicityCategories) {
            toxicityCategories(Arrays.asList(toxicityCategories));
            return this;
        }

        @Override
        public ToxicityDetectionSettings build() {
            return new ToxicityDetectionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
