/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.transcribe.model.KMSEncryptionContextMapCopier;
import software.amazon.awssdk.services.transcribe.model.Media;
import software.amazon.awssdk.services.transcribe.model.MedicalScribeChannelDefinition;
import software.amazon.awssdk.services.transcribe.model.MedicalScribeChannelDefinitionsCopier;
import software.amazon.awssdk.services.transcribe.model.MedicalScribeContext;
import software.amazon.awssdk.services.transcribe.model.MedicalScribeSettings;
import software.amazon.awssdk.services.transcribe.model.Tag;
import software.amazon.awssdk.services.transcribe.model.TagListCopier;
import software.amazon.awssdk.services.transcribe.model.TranscribeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartMedicalScribeJobRequest
extends TranscribeRequest
implements ToCopyableBuilder<Builder, StartMedicalScribeJobRequest> {
    private static final SdkField<String> MEDICAL_SCRIBE_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MedicalScribeJobName").getter(StartMedicalScribeJobRequest.getter(StartMedicalScribeJobRequest::medicalScribeJobName)).setter(StartMedicalScribeJobRequest.setter(Builder::medicalScribeJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedicalScribeJobName").build()}).build();
    private static final SdkField<Media> MEDIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Media").getter(StartMedicalScribeJobRequest.getter(StartMedicalScribeJobRequest::media)).setter(StartMedicalScribeJobRequest.setter(Builder::media)).constructor(Media::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Media").build()}).build();
    private static final SdkField<String> OUTPUT_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputBucketName").getter(StartMedicalScribeJobRequest.getter(StartMedicalScribeJobRequest::outputBucketName)).setter(StartMedicalScribeJobRequest.setter(Builder::outputBucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputBucketName").build()}).build();
    private static final SdkField<String> OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputEncryptionKMSKeyId").getter(StartMedicalScribeJobRequest.getter(StartMedicalScribeJobRequest::outputEncryptionKMSKeyId)).setter(StartMedicalScribeJobRequest.setter(Builder::outputEncryptionKMSKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputEncryptionKMSKeyId").build()}).build();
    private static final SdkField<Map<String, String>> KMS_ENCRYPTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("KMSEncryptionContext").getter(StartMedicalScribeJobRequest.getter(StartMedicalScribeJobRequest::kmsEncryptionContext)).setter(StartMedicalScribeJobRequest.setter(Builder::kmsEncryptionContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncryptionContext").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataAccessRoleArn").getter(StartMedicalScribeJobRequest.getter(StartMedicalScribeJobRequest::dataAccessRoleArn)).setter(StartMedicalScribeJobRequest.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final SdkField<MedicalScribeSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Settings").getter(StartMedicalScribeJobRequest.getter(StartMedicalScribeJobRequest::settings)).setter(StartMedicalScribeJobRequest.setter(Builder::settings)).constructor(MedicalScribeSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()}).build();
    private static final SdkField<List<MedicalScribeChannelDefinition>> CHANNEL_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChannelDefinitions").getter(StartMedicalScribeJobRequest.getter(StartMedicalScribeJobRequest::channelDefinitions)).setter(StartMedicalScribeJobRequest.setter(Builder::channelDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MedicalScribeChannelDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(StartMedicalScribeJobRequest.getter(StartMedicalScribeJobRequest::tags)).setter(StartMedicalScribeJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MedicalScribeContext> MEDICAL_SCRIBE_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MedicalScribeContext").getter(StartMedicalScribeJobRequest.getter(StartMedicalScribeJobRequest::medicalScribeContext)).setter(StartMedicalScribeJobRequest.setter(Builder::medicalScribeContext)).constructor(MedicalScribeContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedicalScribeContext").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDICAL_SCRIBE_JOB_NAME_FIELD, MEDIA_FIELD, OUTPUT_BUCKET_NAME_FIELD, OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD, KMS_ENCRYPTION_CONTEXT_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, SETTINGS_FIELD, CHANNEL_DEFINITIONS_FIELD, TAGS_FIELD, MEDICAL_SCRIBE_CONTEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartMedicalScribeJobRequest.memberNameToFieldInitializer();
    private final String medicalScribeJobName;
    private final Media media;
    private final String outputBucketName;
    private final String outputEncryptionKMSKeyId;
    private final Map<String, String> kmsEncryptionContext;
    private final String dataAccessRoleArn;
    private final MedicalScribeSettings settings;
    private final List<MedicalScribeChannelDefinition> channelDefinitions;
    private final List<Tag> tags;
    private final MedicalScribeContext medicalScribeContext;

    private StartMedicalScribeJobRequest(BuilderImpl builder) {
        super(builder);
        this.medicalScribeJobName = builder.medicalScribeJobName;
        this.media = builder.media;
        this.outputBucketName = builder.outputBucketName;
        this.outputEncryptionKMSKeyId = builder.outputEncryptionKMSKeyId;
        this.kmsEncryptionContext = builder.kmsEncryptionContext;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.settings = builder.settings;
        this.channelDefinitions = builder.channelDefinitions;
        this.tags = builder.tags;
        this.medicalScribeContext = builder.medicalScribeContext;
    }

    public final String medicalScribeJobName() {
        return this.medicalScribeJobName;
    }

    public final Media media() {
        return this.media;
    }

    public final String outputBucketName() {
        return this.outputBucketName;
    }

    public final String outputEncryptionKMSKeyId() {
        return this.outputEncryptionKMSKeyId;
    }

    public final boolean hasKmsEncryptionContext() {
        return this.kmsEncryptionContext != null && !(this.kmsEncryptionContext instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> kmsEncryptionContext() {
        return this.kmsEncryptionContext;
    }

    public final String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public final MedicalScribeSettings settings() {
        return this.settings;
    }

    public final boolean hasChannelDefinitions() {
        return this.channelDefinitions != null && !(this.channelDefinitions instanceof SdkAutoConstructList);
    }

    public final List<MedicalScribeChannelDefinition> channelDefinitions() {
        return this.channelDefinitions;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final MedicalScribeContext medicalScribeContext() {
        return this.medicalScribeContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.medicalScribeJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.media());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputEncryptionKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKmsEncryptionContext() ? this.kmsEncryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannelDefinitions() ? this.channelDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.medicalScribeContext());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMedicalScribeJobRequest)) {
            return false;
        }
        StartMedicalScribeJobRequest other = (StartMedicalScribeJobRequest)((Object)obj);
        return Objects.equals(this.medicalScribeJobName(), other.medicalScribeJobName()) && Objects.equals(this.media(), other.media()) && Objects.equals(this.outputBucketName(), other.outputBucketName()) && Objects.equals(this.outputEncryptionKMSKeyId(), other.outputEncryptionKMSKeyId()) && this.hasKmsEncryptionContext() == other.hasKmsEncryptionContext() && Objects.equals(this.kmsEncryptionContext(), other.kmsEncryptionContext()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(this.settings(), other.settings()) && this.hasChannelDefinitions() == other.hasChannelDefinitions() && Objects.equals(this.channelDefinitions(), other.channelDefinitions()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.medicalScribeContext(), other.medicalScribeContext());
    }

    public final String toString() {
        return ToString.builder((String)"StartMedicalScribeJobRequest").add("MedicalScribeJobName", (Object)this.medicalScribeJobName()).add("Media", (Object)this.media()).add("OutputBucketName", (Object)this.outputBucketName()).add("OutputEncryptionKMSKeyId", (Object)this.outputEncryptionKMSKeyId()).add("KMSEncryptionContext", this.hasKmsEncryptionContext() ? this.kmsEncryptionContext() : null).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).add("Settings", (Object)this.settings()).add("ChannelDefinitions", this.hasChannelDefinitions() ? this.channelDefinitions() : null).add("Tags", this.hasTags() ? this.tags() : null).add("MedicalScribeContext", (Object)this.medicalScribeContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MedicalScribeJobName": {
                return Optional.ofNullable(clazz.cast(this.medicalScribeJobName()));
            }
            case "Media": {
                return Optional.ofNullable(clazz.cast(this.media()));
            }
            case "OutputBucketName": {
                return Optional.ofNullable(clazz.cast(this.outputBucketName()));
            }
            case "OutputEncryptionKMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.outputEncryptionKMSKeyId()));
            }
            case "KMSEncryptionContext": {
                return Optional.ofNullable(clazz.cast(this.kmsEncryptionContext()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "ChannelDefinitions": {
                return Optional.ofNullable(clazz.cast(this.channelDefinitions()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "MedicalScribeContext": {
                return Optional.ofNullable(clazz.cast(this.medicalScribeContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MedicalScribeJobName", MEDICAL_SCRIBE_JOB_NAME_FIELD);
        map.put("Media", MEDIA_FIELD);
        map.put("OutputBucketName", OUTPUT_BUCKET_NAME_FIELD);
        map.put("OutputEncryptionKMSKeyId", OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD);
        map.put("KMSEncryptionContext", KMS_ENCRYPTION_CONTEXT_FIELD);
        map.put("DataAccessRoleArn", DATA_ACCESS_ROLE_ARN_FIELD);
        map.put("Settings", SETTINGS_FIELD);
        map.put("ChannelDefinitions", CHANNEL_DEFINITIONS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("MedicalScribeContext", MEDICAL_SCRIBE_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartMedicalScribeJobRequest, T> g) {
        return obj -> g.apply((StartMedicalScribeJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeRequest.BuilderImpl
    implements Builder {
        private String medicalScribeJobName;
        private Media media;
        private String outputBucketName;
        private String outputEncryptionKMSKeyId;
        private Map<String, String> kmsEncryptionContext = DefaultSdkAutoConstructMap.getInstance();
        private String dataAccessRoleArn;
        private MedicalScribeSettings settings;
        private List<MedicalScribeChannelDefinition> channelDefinitions = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private MedicalScribeContext medicalScribeContext;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMedicalScribeJobRequest model) {
            super(model);
            this.medicalScribeJobName(model.medicalScribeJobName);
            this.media(model.media);
            this.outputBucketName(model.outputBucketName);
            this.outputEncryptionKMSKeyId(model.outputEncryptionKMSKeyId);
            this.kmsEncryptionContext(model.kmsEncryptionContext);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
            this.settings(model.settings);
            this.channelDefinitions(model.channelDefinitions);
            this.tags(model.tags);
            this.medicalScribeContext(model.medicalScribeContext);
        }

        public final String getMedicalScribeJobName() {
            return this.medicalScribeJobName;
        }

        public final void setMedicalScribeJobName(String medicalScribeJobName) {
            this.medicalScribeJobName = medicalScribeJobName;
        }

        @Override
        public final Builder medicalScribeJobName(String medicalScribeJobName) {
            this.medicalScribeJobName = medicalScribeJobName;
            return this;
        }

        public final Media.Builder getMedia() {
            return this.media != null ? this.media.toBuilder() : null;
        }

        public final void setMedia(Media.BuilderImpl media) {
            this.media = media != null ? media.build() : null;
        }

        @Override
        public final Builder media(Media media) {
            this.media = media;
            return this;
        }

        public final String getOutputBucketName() {
            return this.outputBucketName;
        }

        public final void setOutputBucketName(String outputBucketName) {
            this.outputBucketName = outputBucketName;
        }

        @Override
        public final Builder outputBucketName(String outputBucketName) {
            this.outputBucketName = outputBucketName;
            return this;
        }

        public final String getOutputEncryptionKMSKeyId() {
            return this.outputEncryptionKMSKeyId;
        }

        public final void setOutputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
        }

        @Override
        public final Builder outputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
            return this;
        }

        public final Map<String, String> getKmsEncryptionContext() {
            if (this.kmsEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.kmsEncryptionContext;
        }

        public final void setKmsEncryptionContext(Map<String, String> kmsEncryptionContext) {
            this.kmsEncryptionContext = KMSEncryptionContextMapCopier.copy(kmsEncryptionContext);
        }

        @Override
        public final Builder kmsEncryptionContext(Map<String, String> kmsEncryptionContext) {
            this.kmsEncryptionContext = KMSEncryptionContextMapCopier.copy(kmsEncryptionContext);
            return this;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final MedicalScribeSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        public final void setSettings(MedicalScribeSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(MedicalScribeSettings settings) {
            this.settings = settings;
            return this;
        }

        public final List<MedicalScribeChannelDefinition.Builder> getChannelDefinitions() {
            List<MedicalScribeChannelDefinition.Builder> result = MedicalScribeChannelDefinitionsCopier.copyToBuilder(this.channelDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelDefinitions(Collection<MedicalScribeChannelDefinition.BuilderImpl> channelDefinitions) {
            this.channelDefinitions = MedicalScribeChannelDefinitionsCopier.copyFromBuilder(channelDefinitions);
        }

        @Override
        public final Builder channelDefinitions(Collection<MedicalScribeChannelDefinition> channelDefinitions) {
            this.channelDefinitions = MedicalScribeChannelDefinitionsCopier.copy(channelDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(MedicalScribeChannelDefinition ... channelDefinitions) {
            this.channelDefinitions(Arrays.asList(channelDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(Consumer<MedicalScribeChannelDefinition.Builder> ... channelDefinitions) {
            this.channelDefinitions(Stream.of(channelDefinitions).map(c -> (MedicalScribeChannelDefinition)((MedicalScribeChannelDefinition.Builder)MedicalScribeChannelDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final MedicalScribeContext.Builder getMedicalScribeContext() {
            return this.medicalScribeContext != null ? this.medicalScribeContext.toBuilder() : null;
        }

        public final void setMedicalScribeContext(MedicalScribeContext.BuilderImpl medicalScribeContext) {
            this.medicalScribeContext = medicalScribeContext != null ? medicalScribeContext.build() : null;
        }

        @Override
        public final Builder medicalScribeContext(MedicalScribeContext medicalScribeContext) {
            this.medicalScribeContext = medicalScribeContext;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMedicalScribeJobRequest build() {
            return new StartMedicalScribeJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TranscribeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartMedicalScribeJobRequest> {
        public Builder medicalScribeJobName(String var1);

        public Builder media(Media var1);

        default public Builder media(Consumer<Media.Builder> media) {
            return this.media((Media)((Media.Builder)Media.builder().applyMutation(media)).build());
        }

        public Builder outputBucketName(String var1);

        public Builder outputEncryptionKMSKeyId(String var1);

        public Builder kmsEncryptionContext(Map<String, String> var1);

        public Builder dataAccessRoleArn(String var1);

        public Builder settings(MedicalScribeSettings var1);

        default public Builder settings(Consumer<MedicalScribeSettings.Builder> settings) {
            return this.settings((MedicalScribeSettings)((MedicalScribeSettings.Builder)MedicalScribeSettings.builder().applyMutation(settings)).build());
        }

        public Builder channelDefinitions(Collection<MedicalScribeChannelDefinition> var1);

        public Builder channelDefinitions(MedicalScribeChannelDefinition ... var1);

        public Builder channelDefinitions(Consumer<MedicalScribeChannelDefinition.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder medicalScribeContext(MedicalScribeContext var1);

        default public Builder medicalScribeContext(Consumer<MedicalScribeContext.Builder> medicalScribeContext) {
            return this.medicalScribeContext((MedicalScribeContext)((MedicalScribeContext.Builder)MedicalScribeContext.builder().applyMutation(medicalScribeContext)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

