/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMedicalVocabularyResponse extends TranscribeResponse implements
        ToCopyableBuilder<GetMedicalVocabularyResponse.Builder, GetMedicalVocabularyResponse> {
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyName").getter(getter(GetMedicalVocabularyResponse::vocabularyName))
            .setter(setter(Builder::vocabularyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(GetMedicalVocabularyResponse::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> VOCABULARY_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyState").getter(getter(GetMedicalVocabularyResponse::vocabularyStateAsString))
            .setter(setter(Builder::vocabularyState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyState").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(GetMedicalVocabularyResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(GetMedicalVocabularyResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> DOWNLOAD_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DownloadUri").getter(getter(GetMedicalVocabularyResponse::downloadUri))
            .setter(setter(Builder::downloadUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DownloadUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_NAME_FIELD,
            LANGUAGE_CODE_FIELD, VOCABULARY_STATE_FIELD, LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD, DOWNLOAD_URI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String vocabularyName;

    private final String languageCode;

    private final String vocabularyState;

    private final Instant lastModifiedTime;

    private final String failureReason;

    private final String downloadUri;

    private GetMedicalVocabularyResponse(BuilderImpl builder) {
        super(builder);
        this.vocabularyName = builder.vocabularyName;
        this.languageCode = builder.languageCode;
        this.vocabularyState = builder.vocabularyState;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
        this.downloadUri = builder.downloadUri;
    }

    /**
     * <p>
     * The name of the custom medical vocabulary you requested information about.
     * </p>
     * 
     * @return The name of the custom medical vocabulary you requested information about.
     */
    public final String vocabularyName() {
        return vocabularyName;
    }

    /**
     * <p>
     * The language code you selected for your custom medical vocabulary. US English (<code>en-US</code>) is the only
     * language supported with Amazon Transcribe Medical.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code you selected for your custom medical vocabulary. US English (<code>en-US</code>) is the
     *         only language supported with Amazon Transcribe Medical.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code you selected for your custom medical vocabulary. US English (<code>en-US</code>) is the only
     * language supported with Amazon Transcribe Medical.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code you selected for your custom medical vocabulary. US English (<code>en-US</code>) is the
     *         only language supported with Amazon Transcribe Medical.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The processing state of your custom medical vocabulary. If the state is <code>READY</code>, you can use the
     * custom vocabulary in a <code>StartMedicalTranscriptionJob</code> request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vocabularyState}
     * will return {@link VocabularyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #vocabularyStateAsString}.
     * </p>
     * 
     * @return The processing state of your custom medical vocabulary. If the state is <code>READY</code>, you can use
     *         the custom vocabulary in a <code>StartMedicalTranscriptionJob</code> request.
     * @see VocabularyState
     */
    public final VocabularyState vocabularyState() {
        return VocabularyState.fromValue(vocabularyState);
    }

    /**
     * <p>
     * The processing state of your custom medical vocabulary. If the state is <code>READY</code>, you can use the
     * custom vocabulary in a <code>StartMedicalTranscriptionJob</code> request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vocabularyState}
     * will return {@link VocabularyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #vocabularyStateAsString}.
     * </p>
     * 
     * @return The processing state of your custom medical vocabulary. If the state is <code>READY</code>, you can use
     *         the custom vocabulary in a <code>StartMedicalTranscriptionJob</code> request.
     * @see VocabularyState
     */
    public final String vocabularyStateAsString() {
        return vocabularyState;
    }

    /**
     * <p>
     * The date and time the specified custom medical vocabulary was last modified.
     * </p>
     * <p>
     * Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
     * <code>2022-05-04T12:32:58.761000-07:00</code> represents 12:32 PM UTC-7 on May 4, 2022.
     * </p>
     * 
     * @return The date and time the specified custom medical vocabulary was last modified.</p>
     *         <p>
     *         Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
     *         <code>2022-05-04T12:32:58.761000-07:00</code> represents 12:32 PM UTC-7 on May 4, 2022.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * If <code>VocabularyState</code> is <code>FAILED</code>, <code>FailureReason</code> contains information about why
     * the custom medical vocabulary request failed. See also: <a
     * href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.
     * </p>
     * 
     * @return If <code>VocabularyState</code> is <code>FAILED</code>, <code>FailureReason</code> contains information
     *         about why the custom medical vocabulary request failed. See also: <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The Amazon S3 location where the specified custom medical vocabulary is stored; use this URI to view or download
     * the custom vocabulary.
     * </p>
     * 
     * @return The Amazon S3 location where the specified custom medical vocabulary is stored; use this URI to view or
     *         download the custom vocabulary.
     */
    public final String downloadUri() {
        return downloadUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(downloadUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMedicalVocabularyResponse)) {
            return false;
        }
        GetMedicalVocabularyResponse other = (GetMedicalVocabularyResponse) obj;
        return Objects.equals(vocabularyName(), other.vocabularyName())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(vocabularyStateAsString(), other.vocabularyStateAsString())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(downloadUri(), other.downloadUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMedicalVocabularyResponse").add("VocabularyName", vocabularyName())
                .add("LanguageCode", languageCodeAsString()).add("VocabularyState", vocabularyStateAsString())
                .add("LastModifiedTime", lastModifiedTime()).add("FailureReason", failureReason())
                .add("DownloadUri", downloadUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VocabularyName":
            return Optional.ofNullable(clazz.cast(vocabularyName()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "VocabularyState":
            return Optional.ofNullable(clazz.cast(vocabularyStateAsString()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "DownloadUri":
            return Optional.ofNullable(clazz.cast(downloadUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VocabularyName", VOCABULARY_NAME_FIELD);
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        map.put("VocabularyState", VOCABULARY_STATE_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("DownloadUri", DOWNLOAD_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMedicalVocabularyResponse, T> g) {
        return obj -> g.apply((GetMedicalVocabularyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TranscribeResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMedicalVocabularyResponse> {
        /**
         * <p>
         * The name of the custom medical vocabulary you requested information about.
         * </p>
         * 
         * @param vocabularyName
         *        The name of the custom medical vocabulary you requested information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyName(String vocabularyName);

        /**
         * <p>
         * The language code you selected for your custom medical vocabulary. US English (<code>en-US</code>) is the
         * only language supported with Amazon Transcribe Medical.
         * </p>
         * 
         * @param languageCode
         *        The language code you selected for your custom medical vocabulary. US English (<code>en-US</code>) is
         *        the only language supported with Amazon Transcribe Medical.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code you selected for your custom medical vocabulary. US English (<code>en-US</code>) is the
         * only language supported with Amazon Transcribe Medical.
         * </p>
         * 
         * @param languageCode
         *        The language code you selected for your custom medical vocabulary. US English (<code>en-US</code>) is
         *        the only language supported with Amazon Transcribe Medical.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * The processing state of your custom medical vocabulary. If the state is <code>READY</code>, you can use the
         * custom vocabulary in a <code>StartMedicalTranscriptionJob</code> request.
         * </p>
         * 
         * @param vocabularyState
         *        The processing state of your custom medical vocabulary. If the state is <code>READY</code>, you can
         *        use the custom vocabulary in a <code>StartMedicalTranscriptionJob</code> request.
         * @see VocabularyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyState
         */
        Builder vocabularyState(String vocabularyState);

        /**
         * <p>
         * The processing state of your custom medical vocabulary. If the state is <code>READY</code>, you can use the
         * custom vocabulary in a <code>StartMedicalTranscriptionJob</code> request.
         * </p>
         * 
         * @param vocabularyState
         *        The processing state of your custom medical vocabulary. If the state is <code>READY</code>, you can
         *        use the custom vocabulary in a <code>StartMedicalTranscriptionJob</code> request.
         * @see VocabularyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyState
         */
        Builder vocabularyState(VocabularyState vocabularyState);

        /**
         * <p>
         * The date and time the specified custom medical vocabulary was last modified.
         * </p>
         * <p>
         * Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
         * <code>2022-05-04T12:32:58.761000-07:00</code> represents 12:32 PM UTC-7 on May 4, 2022.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time the specified custom medical vocabulary was last modified.</p>
         *        <p>
         *        Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
         *        <code>2022-05-04T12:32:58.761000-07:00</code> represents 12:32 PM UTC-7 on May 4, 2022.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * If <code>VocabularyState</code> is <code>FAILED</code>, <code>FailureReason</code> contains information about
         * why the custom medical vocabulary request failed. See also: <a
         * href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.
         * </p>
         * 
         * @param failureReason
         *        If <code>VocabularyState</code> is <code>FAILED</code>, <code>FailureReason</code> contains
         *        information about why the custom medical vocabulary request failed. See also: <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The Amazon S3 location where the specified custom medical vocabulary is stored; use this URI to view or
         * download the custom vocabulary.
         * </p>
         * 
         * @param downloadUri
         *        The Amazon S3 location where the specified custom medical vocabulary is stored; use this URI to view
         *        or download the custom vocabulary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downloadUri(String downloadUri);
    }

    static final class BuilderImpl extends TranscribeResponse.BuilderImpl implements Builder {
        private String vocabularyName;

        private String languageCode;

        private String vocabularyState;

        private Instant lastModifiedTime;

        private String failureReason;

        private String downloadUri;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMedicalVocabularyResponse model) {
            super(model);
            vocabularyName(model.vocabularyName);
            languageCode(model.languageCode);
            vocabularyState(model.vocabularyState);
            lastModifiedTime(model.lastModifiedTime);
            failureReason(model.failureReason);
            downloadUri(model.downloadUri);
        }

        public final String getVocabularyName() {
            return vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getVocabularyState() {
            return vocabularyState;
        }

        public final void setVocabularyState(String vocabularyState) {
            this.vocabularyState = vocabularyState;
        }

        @Override
        public final Builder vocabularyState(String vocabularyState) {
            this.vocabularyState = vocabularyState;
            return this;
        }

        @Override
        public final Builder vocabularyState(VocabularyState vocabularyState) {
            this.vocabularyState(vocabularyState == null ? null : vocabularyState.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getDownloadUri() {
            return downloadUri;
        }

        public final void setDownloadUri(String downloadUri) {
            this.downloadUri = downloadUri;
        }

        @Override
        public final Builder downloadUri(String downloadUri) {
            this.downloadUri = downloadUri;
            return this;
        }

        @Override
        public GetMedicalVocabularyResponse build() {
            return new GetMedicalVocabularyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
