/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A rule is a set of criteria that you can specify to flag an attribute in your Call Analytics output. Rules define a
 * Call Analytics category.
 * </p>
 * <p>
 * Rules can include these parameters: , , , and .
 * </p>
 * <p>
 * To learn more about Call Analytics rules and categories, see <a
 * href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html">Creating categories for post-call
 * transcriptions</a> and <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-stream.html">Creating
 * categories for real-time transcriptions</a>.
 * </p>
 * <p>
 * To learn more about Call Analytics, see <a
 * href="https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics.html">Analyzing call center audio with Call
 * Analytics</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Rule implements SdkPojo, Serializable, ToCopyableBuilder<Rule.Builder, Rule> {
    private static final SdkField<NonTalkTimeFilter> NON_TALK_TIME_FILTER_FIELD = SdkField
            .<NonTalkTimeFilter> builder(MarshallingType.SDK_POJO).memberName("NonTalkTimeFilter")
            .getter(getter(Rule::nonTalkTimeFilter)).setter(setter(Builder::nonTalkTimeFilter))
            .constructor(NonTalkTimeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonTalkTimeFilter").build()).build();

    private static final SdkField<InterruptionFilter> INTERRUPTION_FILTER_FIELD = SdkField
            .<InterruptionFilter> builder(MarshallingType.SDK_POJO).memberName("InterruptionFilter")
            .getter(getter(Rule::interruptionFilter)).setter(setter(Builder::interruptionFilter))
            .constructor(InterruptionFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterruptionFilter").build())
            .build();

    private static final SdkField<TranscriptFilter> TRANSCRIPT_FILTER_FIELD = SdkField
            .<TranscriptFilter> builder(MarshallingType.SDK_POJO).memberName("TranscriptFilter")
            .getter(getter(Rule::transcriptFilter)).setter(setter(Builder::transcriptFilter))
            .constructor(TranscriptFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptFilter").build()).build();

    private static final SdkField<SentimentFilter> SENTIMENT_FILTER_FIELD = SdkField
            .<SentimentFilter> builder(MarshallingType.SDK_POJO).memberName("SentimentFilter")
            .getter(getter(Rule::sentimentFilter)).setter(setter(Builder::sentimentFilter)).constructor(SentimentFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SentimentFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NON_TALK_TIME_FILTER_FIELD,
            INTERRUPTION_FILTER_FIELD, TRANSCRIPT_FILTER_FIELD, SENTIMENT_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final NonTalkTimeFilter nonTalkTimeFilter;

    private final InterruptionFilter interruptionFilter;

    private final TranscriptFilter transcriptFilter;

    private final SentimentFilter sentimentFilter;

    private final Type type;

    private Rule(BuilderImpl builder) {
        this.nonTalkTimeFilter = builder.nonTalkTimeFilter;
        this.interruptionFilter = builder.interruptionFilter;
        this.transcriptFilter = builder.transcriptFilter;
        this.sentimentFilter = builder.sentimentFilter;
        this.type = builder.type;
    }

    /**
     * <p>
     * Flag the presence or absence of periods of silence in your Call Analytics transcription output. Refer to for more
     * detail.
     * </p>
     * 
     * @return Flag the presence or absence of periods of silence in your Call Analytics transcription output. Refer to
     *         for more detail.
     */
    public final NonTalkTimeFilter nonTalkTimeFilter() {
        return nonTalkTimeFilter;
    }

    /**
     * <p>
     * Flag the presence or absence of interruptions in your Call Analytics transcription output. Refer to for more
     * detail.
     * </p>
     * 
     * @return Flag the presence or absence of interruptions in your Call Analytics transcription output. Refer to for
     *         more detail.
     */
    public final InterruptionFilter interruptionFilter() {
        return interruptionFilter;
    }

    /**
     * <p>
     * Flag the presence or absence of specific words or phrases in your Call Analytics transcription output. Refer to
     * for more detail.
     * </p>
     * 
     * @return Flag the presence or absence of specific words or phrases in your Call Analytics transcription output.
     *         Refer to for more detail.
     */
    public final TranscriptFilter transcriptFilter() {
        return transcriptFilter;
    }

    /**
     * <p>
     * Flag the presence or absence of specific sentiments in your Call Analytics transcription output. Refer to for
     * more detail.
     * </p>
     * 
     * @return Flag the presence or absence of specific sentiments in your Call Analytics transcription output. Refer to
     *         for more detail.
     */
    public final SentimentFilter sentimentFilter() {
        return sentimentFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nonTalkTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(interruptionFilter());
        hashCode = 31 * hashCode + Objects.hashCode(transcriptFilter());
        hashCode = 31 * hashCode + Objects.hashCode(sentimentFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule) obj;
        return Objects.equals(nonTalkTimeFilter(), other.nonTalkTimeFilter())
                && Objects.equals(interruptionFilter(), other.interruptionFilter())
                && Objects.equals(transcriptFilter(), other.transcriptFilter())
                && Objects.equals(sentimentFilter(), other.sentimentFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Rule").add("NonTalkTimeFilter", nonTalkTimeFilter())
                .add("InterruptionFilter", interruptionFilter()).add("TranscriptFilter", transcriptFilter())
                .add("SentimentFilter", sentimentFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NonTalkTimeFilter":
            return Optional.ofNullable(clazz.cast(nonTalkTimeFilter()));
        case "InterruptionFilter":
            return Optional.ofNullable(clazz.cast(interruptionFilter()));
        case "TranscriptFilter":
            return Optional.ofNullable(clazz.cast(transcriptFilter()));
        case "SentimentFilter":
            return Optional.ofNullable(clazz.cast(sentimentFilter()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #nonTalkTimeFilter()} initialized to the given value.
     *
     * <p>
     * Flag the presence or absence of periods of silence in your Call Analytics transcription output. Refer to for more
     * detail.
     * </p>
     * 
     * @param nonTalkTimeFilter
     *        Flag the presence or absence of periods of silence in your Call Analytics transcription output. Refer to
     *        for more detail.
     */
    public static Rule fromNonTalkTimeFilter(NonTalkTimeFilter nonTalkTimeFilter) {
        return builder().nonTalkTimeFilter(nonTalkTimeFilter).build();
    }

    /**
     * Create an instance of this class with {@link #nonTalkTimeFilter()} initialized to the given value.
     *
     * <p>
     * Flag the presence or absence of periods of silence in your Call Analytics transcription output. Refer to for more
     * detail.
     * </p>
     * 
     * @param nonTalkTimeFilter
     *        Flag the presence or absence of periods of silence in your Call Analytics transcription output. Refer to
     *        for more detail.
     */
    public static Rule fromNonTalkTimeFilter(Consumer<NonTalkTimeFilter.Builder> nonTalkTimeFilter) {
        NonTalkTimeFilter.Builder builder = NonTalkTimeFilter.builder();
        nonTalkTimeFilter.accept(builder);
        return fromNonTalkTimeFilter(builder.build());
    }

    /**
     * Create an instance of this class with {@link #interruptionFilter()} initialized to the given value.
     *
     * <p>
     * Flag the presence or absence of interruptions in your Call Analytics transcription output. Refer to for more
     * detail.
     * </p>
     * 
     * @param interruptionFilter
     *        Flag the presence or absence of interruptions in your Call Analytics transcription output. Refer to for
     *        more detail.
     */
    public static Rule fromInterruptionFilter(InterruptionFilter interruptionFilter) {
        return builder().interruptionFilter(interruptionFilter).build();
    }

    /**
     * Create an instance of this class with {@link #interruptionFilter()} initialized to the given value.
     *
     * <p>
     * Flag the presence or absence of interruptions in your Call Analytics transcription output. Refer to for more
     * detail.
     * </p>
     * 
     * @param interruptionFilter
     *        Flag the presence or absence of interruptions in your Call Analytics transcription output. Refer to for
     *        more detail.
     */
    public static Rule fromInterruptionFilter(Consumer<InterruptionFilter.Builder> interruptionFilter) {
        InterruptionFilter.Builder builder = InterruptionFilter.builder();
        interruptionFilter.accept(builder);
        return fromInterruptionFilter(builder.build());
    }

    /**
     * Create an instance of this class with {@link #transcriptFilter()} initialized to the given value.
     *
     * <p>
     * Flag the presence or absence of specific words or phrases in your Call Analytics transcription output. Refer to
     * for more detail.
     * </p>
     * 
     * @param transcriptFilter
     *        Flag the presence or absence of specific words or phrases in your Call Analytics transcription output.
     *        Refer to for more detail.
     */
    public static Rule fromTranscriptFilter(TranscriptFilter transcriptFilter) {
        return builder().transcriptFilter(transcriptFilter).build();
    }

    /**
     * Create an instance of this class with {@link #transcriptFilter()} initialized to the given value.
     *
     * <p>
     * Flag the presence or absence of specific words or phrases in your Call Analytics transcription output. Refer to
     * for more detail.
     * </p>
     * 
     * @param transcriptFilter
     *        Flag the presence or absence of specific words or phrases in your Call Analytics transcription output.
     *        Refer to for more detail.
     */
    public static Rule fromTranscriptFilter(Consumer<TranscriptFilter.Builder> transcriptFilter) {
        TranscriptFilter.Builder builder = TranscriptFilter.builder();
        transcriptFilter.accept(builder);
        return fromTranscriptFilter(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sentimentFilter()} initialized to the given value.
     *
     * <p>
     * Flag the presence or absence of specific sentiments in your Call Analytics transcription output. Refer to for
     * more detail.
     * </p>
     * 
     * @param sentimentFilter
     *        Flag the presence or absence of specific sentiments in your Call Analytics transcription output. Refer to
     *        for more detail.
     */
    public static Rule fromSentimentFilter(SentimentFilter sentimentFilter) {
        return builder().sentimentFilter(sentimentFilter).build();
    }

    /**
     * Create an instance of this class with {@link #sentimentFilter()} initialized to the given value.
     *
     * <p>
     * Flag the presence or absence of specific sentiments in your Call Analytics transcription output. Refer to for
     * more detail.
     * </p>
     * 
     * @param sentimentFilter
     *        Flag the presence or absence of specific sentiments in your Call Analytics transcription output. Refer to
     *        for more detail.
     */
    public static Rule fromSentimentFilter(Consumer<SentimentFilter.Builder> sentimentFilter) {
        SentimentFilter.Builder builder = SentimentFilter.builder();
        sentimentFilter.accept(builder);
        return fromSentimentFilter(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NonTalkTimeFilter", NON_TALK_TIME_FILTER_FIELD);
        map.put("InterruptionFilter", INTERRUPTION_FILTER_FIELD);
        map.put("TranscriptFilter", TRANSCRIPT_FILTER_FIELD);
        map.put("SentimentFilter", SENTIMENT_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Rule, T> g) {
        return obj -> g.apply((Rule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Rule> {
        /**
         * <p>
         * Flag the presence or absence of periods of silence in your Call Analytics transcription output. Refer to for
         * more detail.
         * </p>
         * 
         * @param nonTalkTimeFilter
         *        Flag the presence or absence of periods of silence in your Call Analytics transcription output. Refer
         *        to for more detail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonTalkTimeFilter(NonTalkTimeFilter nonTalkTimeFilter);

        /**
         * <p>
         * Flag the presence or absence of periods of silence in your Call Analytics transcription output. Refer to for
         * more detail.
         * </p>
         * This is a convenience method that creates an instance of the {@link NonTalkTimeFilter.Builder} avoiding the
         * need to create one manually via {@link NonTalkTimeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NonTalkTimeFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #nonTalkTimeFilter(NonTalkTimeFilter)}.
         * 
         * @param nonTalkTimeFilter
         *        a consumer that will call methods on {@link NonTalkTimeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nonTalkTimeFilter(NonTalkTimeFilter)
         */
        default Builder nonTalkTimeFilter(Consumer<NonTalkTimeFilter.Builder> nonTalkTimeFilter) {
            return nonTalkTimeFilter(NonTalkTimeFilter.builder().applyMutation(nonTalkTimeFilter).build());
        }

        /**
         * <p>
         * Flag the presence or absence of interruptions in your Call Analytics transcription output. Refer to for more
         * detail.
         * </p>
         * 
         * @param interruptionFilter
         *        Flag the presence or absence of interruptions in your Call Analytics transcription output. Refer to
         *        for more detail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interruptionFilter(InterruptionFilter interruptionFilter);

        /**
         * <p>
         * Flag the presence or absence of interruptions in your Call Analytics transcription output. Refer to for more
         * detail.
         * </p>
         * This is a convenience method that creates an instance of the {@link InterruptionFilter.Builder} avoiding the
         * need to create one manually via {@link InterruptionFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InterruptionFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #interruptionFilter(InterruptionFilter)}.
         * 
         * @param interruptionFilter
         *        a consumer that will call methods on {@link InterruptionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interruptionFilter(InterruptionFilter)
         */
        default Builder interruptionFilter(Consumer<InterruptionFilter.Builder> interruptionFilter) {
            return interruptionFilter(InterruptionFilter.builder().applyMutation(interruptionFilter).build());
        }

        /**
         * <p>
         * Flag the presence or absence of specific words or phrases in your Call Analytics transcription output. Refer
         * to for more detail.
         * </p>
         * 
         * @param transcriptFilter
         *        Flag the presence or absence of specific words or phrases in your Call Analytics transcription output.
         *        Refer to for more detail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcriptFilter(TranscriptFilter transcriptFilter);

        /**
         * <p>
         * Flag the presence or absence of specific words or phrases in your Call Analytics transcription output. Refer
         * to for more detail.
         * </p>
         * This is a convenience method that creates an instance of the {@link TranscriptFilter.Builder} avoiding the
         * need to create one manually via {@link TranscriptFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TranscriptFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #transcriptFilter(TranscriptFilter)}.
         * 
         * @param transcriptFilter
         *        a consumer that will call methods on {@link TranscriptFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transcriptFilter(TranscriptFilter)
         */
        default Builder transcriptFilter(Consumer<TranscriptFilter.Builder> transcriptFilter) {
            return transcriptFilter(TranscriptFilter.builder().applyMutation(transcriptFilter).build());
        }

        /**
         * <p>
         * Flag the presence or absence of specific sentiments in your Call Analytics transcription output. Refer to for
         * more detail.
         * </p>
         * 
         * @param sentimentFilter
         *        Flag the presence or absence of specific sentiments in your Call Analytics transcription output. Refer
         *        to for more detail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sentimentFilter(SentimentFilter sentimentFilter);

        /**
         * <p>
         * Flag the presence or absence of specific sentiments in your Call Analytics transcription output. Refer to for
         * more detail.
         * </p>
         * This is a convenience method that creates an instance of the {@link SentimentFilter.Builder} avoiding the
         * need to create one manually via {@link SentimentFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SentimentFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #sentimentFilter(SentimentFilter)}.
         * 
         * @param sentimentFilter
         *        a consumer that will call methods on {@link SentimentFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sentimentFilter(SentimentFilter)
         */
        default Builder sentimentFilter(Consumer<SentimentFilter.Builder> sentimentFilter) {
            return sentimentFilter(SentimentFilter.builder().applyMutation(sentimentFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NonTalkTimeFilter nonTalkTimeFilter;

        private InterruptionFilter interruptionFilter;

        private TranscriptFilter transcriptFilter;

        private SentimentFilter sentimentFilter;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            nonTalkTimeFilter(model.nonTalkTimeFilter);
            interruptionFilter(model.interruptionFilter);
            transcriptFilter(model.transcriptFilter);
            sentimentFilter(model.sentimentFilter);
        }

        public final NonTalkTimeFilter.Builder getNonTalkTimeFilter() {
            return nonTalkTimeFilter != null ? nonTalkTimeFilter.toBuilder() : null;
        }

        public final void setNonTalkTimeFilter(NonTalkTimeFilter.BuilderImpl nonTalkTimeFilter) {
            Object oldValue = this.nonTalkTimeFilter;
            this.nonTalkTimeFilter = nonTalkTimeFilter != null ? nonTalkTimeFilter.build() : null;
            handleUnionValueChange(Type.NON_TALK_TIME_FILTER, oldValue, this.nonTalkTimeFilter);
        }

        @Override
        public final Builder nonTalkTimeFilter(NonTalkTimeFilter nonTalkTimeFilter) {
            Object oldValue = this.nonTalkTimeFilter;
            this.nonTalkTimeFilter = nonTalkTimeFilter;
            handleUnionValueChange(Type.NON_TALK_TIME_FILTER, oldValue, this.nonTalkTimeFilter);
            return this;
        }

        public final InterruptionFilter.Builder getInterruptionFilter() {
            return interruptionFilter != null ? interruptionFilter.toBuilder() : null;
        }

        public final void setInterruptionFilter(InterruptionFilter.BuilderImpl interruptionFilter) {
            Object oldValue = this.interruptionFilter;
            this.interruptionFilter = interruptionFilter != null ? interruptionFilter.build() : null;
            handleUnionValueChange(Type.INTERRUPTION_FILTER, oldValue, this.interruptionFilter);
        }

        @Override
        public final Builder interruptionFilter(InterruptionFilter interruptionFilter) {
            Object oldValue = this.interruptionFilter;
            this.interruptionFilter = interruptionFilter;
            handleUnionValueChange(Type.INTERRUPTION_FILTER, oldValue, this.interruptionFilter);
            return this;
        }

        public final TranscriptFilter.Builder getTranscriptFilter() {
            return transcriptFilter != null ? transcriptFilter.toBuilder() : null;
        }

        public final void setTranscriptFilter(TranscriptFilter.BuilderImpl transcriptFilter) {
            Object oldValue = this.transcriptFilter;
            this.transcriptFilter = transcriptFilter != null ? transcriptFilter.build() : null;
            handleUnionValueChange(Type.TRANSCRIPT_FILTER, oldValue, this.transcriptFilter);
        }

        @Override
        public final Builder transcriptFilter(TranscriptFilter transcriptFilter) {
            Object oldValue = this.transcriptFilter;
            this.transcriptFilter = transcriptFilter;
            handleUnionValueChange(Type.TRANSCRIPT_FILTER, oldValue, this.transcriptFilter);
            return this;
        }

        public final SentimentFilter.Builder getSentimentFilter() {
            return sentimentFilter != null ? sentimentFilter.toBuilder() : null;
        }

        public final void setSentimentFilter(SentimentFilter.BuilderImpl sentimentFilter) {
            Object oldValue = this.sentimentFilter;
            this.sentimentFilter = sentimentFilter != null ? sentimentFilter.build() : null;
            handleUnionValueChange(Type.SENTIMENT_FILTER, oldValue, this.sentimentFilter);
        }

        @Override
        public final Builder sentimentFilter(SentimentFilter sentimentFilter) {
            Object oldValue = this.sentimentFilter;
            this.sentimentFilter = sentimentFilter;
            handleUnionValueChange(Type.SENTIMENT_FILTER, oldValue, this.sentimentFilter);
            return this;
        }

        @Override
        public Rule build() {
            return new Rule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Rule#type()
     */
    public enum Type {
        NON_TALK_TIME_FILTER,

        INTERRUPTION_FILTER,

        TRANSCRIPT_FILTER,

        SENTIMENT_FILTER,

        UNKNOWN_TO_SDK_VERSION
    }
}
