/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a call analytics job, including information about skipped analytics features.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CallAnalyticsJobDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CallAnalyticsJobDetails.Builder, CallAnalyticsJobDetails> {
    private static final SdkField<List<CallAnalyticsSkippedFeature>> SKIPPED_FIELD = SdkField
            .<List<CallAnalyticsSkippedFeature>> builder(MarshallingType.LIST)
            .memberName("Skipped")
            .getter(getter(CallAnalyticsJobDetails::skipped))
            .setter(setter(Builder::skipped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Skipped").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CallAnalyticsSkippedFeature> builder(MarshallingType.SDK_POJO)
                                            .constructor(CallAnalyticsSkippedFeature::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKIPPED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<CallAnalyticsSkippedFeature> skipped;

    private CallAnalyticsJobDetails(BuilderImpl builder) {
        this.skipped = builder.skipped;
    }

    /**
     * For responses, this returns true if the service returned a value for the Skipped property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSkipped() {
        return skipped != null && !(skipped instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information about any skipped analytics features during the analysis of a call analytics job.
     * </p>
     * <p>
     * This array lists all the analytics features that were skipped, along with their corresponding reason code and
     * message.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSkipped} method.
     * </p>
     * 
     * @return Contains information about any skipped analytics features during the analysis of a call analytics
     *         job.</p>
     *         <p>
     *         This array lists all the analytics features that were skipped, along with their corresponding reason code
     *         and message.
     */
    public final List<CallAnalyticsSkippedFeature> skipped() {
        return skipped;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSkipped() ? skipped() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CallAnalyticsJobDetails)) {
            return false;
        }
        CallAnalyticsJobDetails other = (CallAnalyticsJobDetails) obj;
        return hasSkipped() == other.hasSkipped() && Objects.equals(skipped(), other.skipped());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CallAnalyticsJobDetails").add("Skipped", hasSkipped() ? skipped() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Skipped":
            return Optional.ofNullable(clazz.cast(skipped()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Skipped", SKIPPED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CallAnalyticsJobDetails, T> g) {
        return obj -> g.apply((CallAnalyticsJobDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CallAnalyticsJobDetails> {
        /**
         * <p>
         * Contains information about any skipped analytics features during the analysis of a call analytics job.
         * </p>
         * <p>
         * This array lists all the analytics features that were skipped, along with their corresponding reason code and
         * message.
         * </p>
         * 
         * @param skipped
         *        Contains information about any skipped analytics features during the analysis of a call analytics
         *        job.</p>
         *        <p>
         *        This array lists all the analytics features that were skipped, along with their corresponding reason
         *        code and message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipped(Collection<CallAnalyticsSkippedFeature> skipped);

        /**
         * <p>
         * Contains information about any skipped analytics features during the analysis of a call analytics job.
         * </p>
         * <p>
         * This array lists all the analytics features that were skipped, along with their corresponding reason code and
         * message.
         * </p>
         * 
         * @param skipped
         *        Contains information about any skipped analytics features during the analysis of a call analytics
         *        job.</p>
         *        <p>
         *        This array lists all the analytics features that were skipped, along with their corresponding reason
         *        code and message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipped(CallAnalyticsSkippedFeature... skipped);

        /**
         * <p>
         * Contains information about any skipped analytics features during the analysis of a call analytics job.
         * </p>
         * <p>
         * This array lists all the analytics features that were skipped, along with their corresponding reason code and
         * message.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transcribe.model.CallAnalyticsSkippedFeature.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.transcribe.model.CallAnalyticsSkippedFeature#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transcribe.model.CallAnalyticsSkippedFeature.Builder#build()} is
         * called immediately and its result is passed to {@link #skipped(List<CallAnalyticsSkippedFeature>)}.
         * 
         * @param skipped
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transcribe.model.CallAnalyticsSkippedFeature.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #skipped(java.util.Collection<CallAnalyticsSkippedFeature>)
         */
        Builder skipped(Consumer<CallAnalyticsSkippedFeature.Builder>... skipped);
    }

    static final class BuilderImpl implements Builder {
        private List<CallAnalyticsSkippedFeature> skipped = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CallAnalyticsJobDetails model) {
            skipped(model.skipped);
        }

        public final List<CallAnalyticsSkippedFeature.Builder> getSkipped() {
            List<CallAnalyticsSkippedFeature.Builder> result = CallAnalyticsSkippedFeatureListCopier.copyToBuilder(this.skipped);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSkipped(Collection<CallAnalyticsSkippedFeature.BuilderImpl> skipped) {
            this.skipped = CallAnalyticsSkippedFeatureListCopier.copyFromBuilder(skipped);
        }

        @Override
        public final Builder skipped(Collection<CallAnalyticsSkippedFeature> skipped) {
            this.skipped = CallAnalyticsSkippedFeatureListCopier.copy(skipped);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skipped(CallAnalyticsSkippedFeature... skipped) {
            skipped(Arrays.asList(skipped));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skipped(Consumer<CallAnalyticsSkippedFeature.Builder>... skipped) {
            skipped(Stream.of(skipped).map(c -> CallAnalyticsSkippedFeature.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CallAnalyticsJobDetails build() {
            return new CallAnalyticsJobDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
