/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a skipped analytics feature during the analysis of a call analytics job.
 * </p>
 * <p>
 * The <code>Feature</code> field indicates the type of analytics feature that was skipped.
 * </p>
 * <p>
 * The <code>Message</code> field contains additional information or a message explaining why the analytics feature was
 * skipped.
 * </p>
 * <p>
 * The <code>ReasonCode</code> field provides a code indicating the reason why the analytics feature was skipped.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CallAnalyticsSkippedFeature implements SdkPojo, Serializable,
        ToCopyableBuilder<CallAnalyticsSkippedFeature.Builder, CallAnalyticsSkippedFeature> {
    private static final SdkField<String> FEATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Feature")
            .getter(getter(CallAnalyticsSkippedFeature::featureAsString)).setter(setter(Builder::feature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Feature").build()).build();

    private static final SdkField<String> REASON_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReasonCode").getter(getter(CallAnalyticsSkippedFeature::reasonCodeAsString))
            .setter(setter(Builder::reasonCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReasonCode").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(CallAnalyticsSkippedFeature::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_FIELD,
            REASON_CODE_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String feature;

    private final String reasonCode;

    private final String message;

    private CallAnalyticsSkippedFeature(BuilderImpl builder) {
        this.feature = builder.feature;
        this.reasonCode = builder.reasonCode;
        this.message = builder.message;
    }

    /**
     * <p>
     * Indicates the type of analytics feature that was skipped during the analysis of a call analytics job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feature} will
     * return {@link CallAnalyticsFeature#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #featureAsString}.
     * </p>
     * 
     * @return Indicates the type of analytics feature that was skipped during the analysis of a call analytics job.
     * @see CallAnalyticsFeature
     */
    public final CallAnalyticsFeature feature() {
        return CallAnalyticsFeature.fromValue(feature);
    }

    /**
     * <p>
     * Indicates the type of analytics feature that was skipped during the analysis of a call analytics job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feature} will
     * return {@link CallAnalyticsFeature#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #featureAsString}.
     * </p>
     * 
     * @return Indicates the type of analytics feature that was skipped during the analysis of a call analytics job.
     * @see CallAnalyticsFeature
     */
    public final String featureAsString() {
        return feature;
    }

    /**
     * <p>
     * Provides a code indicating the reason why a specific analytics feature was skipped during the analysis of a call
     * analytics job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reasonCode} will
     * return {@link CallAnalyticsSkippedReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonCodeAsString}.
     * </p>
     * 
     * @return Provides a code indicating the reason why a specific analytics feature was skipped during the analysis of
     *         a call analytics job.
     * @see CallAnalyticsSkippedReasonCode
     */
    public final CallAnalyticsSkippedReasonCode reasonCode() {
        return CallAnalyticsSkippedReasonCode.fromValue(reasonCode);
    }

    /**
     * <p>
     * Provides a code indicating the reason why a specific analytics feature was skipped during the analysis of a call
     * analytics job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reasonCode} will
     * return {@link CallAnalyticsSkippedReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonCodeAsString}.
     * </p>
     * 
     * @return Provides a code indicating the reason why a specific analytics feature was skipped during the analysis of
     *         a call analytics job.
     * @see CallAnalyticsSkippedReasonCode
     */
    public final String reasonCodeAsString() {
        return reasonCode;
    }

    /**
     * <p>
     * Contains additional information or a message explaining why a specific analytics feature was skipped during the
     * analysis of a call analytics job.
     * </p>
     * 
     * @return Contains additional information or a message explaining why a specific analytics feature was skipped
     *         during the analysis of a call analytics job.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(featureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reasonCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CallAnalyticsSkippedFeature)) {
            return false;
        }
        CallAnalyticsSkippedFeature other = (CallAnalyticsSkippedFeature) obj;
        return Objects.equals(featureAsString(), other.featureAsString())
                && Objects.equals(reasonCodeAsString(), other.reasonCodeAsString()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CallAnalyticsSkippedFeature").add("Feature", featureAsString())
                .add("ReasonCode", reasonCodeAsString()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Feature":
            return Optional.ofNullable(clazz.cast(featureAsString()));
        case "ReasonCode":
            return Optional.ofNullable(clazz.cast(reasonCodeAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Feature", FEATURE_FIELD);
        map.put("ReasonCode", REASON_CODE_FIELD);
        map.put("Message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CallAnalyticsSkippedFeature, T> g) {
        return obj -> g.apply((CallAnalyticsSkippedFeature) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CallAnalyticsSkippedFeature> {
        /**
         * <p>
         * Indicates the type of analytics feature that was skipped during the analysis of a call analytics job.
         * </p>
         * 
         * @param feature
         *        Indicates the type of analytics feature that was skipped during the analysis of a call analytics job.
         * @see CallAnalyticsFeature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAnalyticsFeature
         */
        Builder feature(String feature);

        /**
         * <p>
         * Indicates the type of analytics feature that was skipped during the analysis of a call analytics job.
         * </p>
         * 
         * @param feature
         *        Indicates the type of analytics feature that was skipped during the analysis of a call analytics job.
         * @see CallAnalyticsFeature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAnalyticsFeature
         */
        Builder feature(CallAnalyticsFeature feature);

        /**
         * <p>
         * Provides a code indicating the reason why a specific analytics feature was skipped during the analysis of a
         * call analytics job.
         * </p>
         * 
         * @param reasonCode
         *        Provides a code indicating the reason why a specific analytics feature was skipped during the analysis
         *        of a call analytics job.
         * @see CallAnalyticsSkippedReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAnalyticsSkippedReasonCode
         */
        Builder reasonCode(String reasonCode);

        /**
         * <p>
         * Provides a code indicating the reason why a specific analytics feature was skipped during the analysis of a
         * call analytics job.
         * </p>
         * 
         * @param reasonCode
         *        Provides a code indicating the reason why a specific analytics feature was skipped during the analysis
         *        of a call analytics job.
         * @see CallAnalyticsSkippedReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAnalyticsSkippedReasonCode
         */
        Builder reasonCode(CallAnalyticsSkippedReasonCode reasonCode);

        /**
         * <p>
         * Contains additional information or a message explaining why a specific analytics feature was skipped during
         * the analysis of a call analytics job.
         * </p>
         * 
         * @param message
         *        Contains additional information or a message explaining why a specific analytics feature was skipped
         *        during the analysis of a call analytics job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String feature;

        private String reasonCode;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(CallAnalyticsSkippedFeature model) {
            feature(model.feature);
            reasonCode(model.reasonCode);
            message(model.message);
        }

        public final String getFeature() {
            return feature;
        }

        public final void setFeature(String feature) {
            this.feature = feature;
        }

        @Override
        public final Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public final Builder feature(CallAnalyticsFeature feature) {
            this.feature(feature == null ? null : feature.toString());
            return this;
        }

        public final String getReasonCode() {
            return reasonCode;
        }

        public final void setReasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
        }

        @Override
        public final Builder reasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        @Override
        public final Builder reasonCode(CallAnalyticsSkippedReasonCode reasonCode) {
            this.reasonCode(reasonCode == null ? null : reasonCode.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public CallAnalyticsSkippedFeature build() {
            return new CallAnalyticsSkippedFeature(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
