/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTranscriptionJobResponse extends TranscribeResponse implements
        ToCopyableBuilder<StartTranscriptionJobResponse.Builder, StartTranscriptionJobResponse> {
    private static final SdkField<TranscriptionJob> TRANSCRIPTION_JOB_FIELD = SdkField
            .<TranscriptionJob> builder(MarshallingType.SDK_POJO).memberName("TranscriptionJob")
            .getter(getter(StartTranscriptionJobResponse::transcriptionJob)).setter(setter(Builder::transcriptionJob))
            .constructor(TranscriptionJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptionJob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPTION_JOB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TranscriptionJob transcriptionJob;

    private StartTranscriptionJobResponse(BuilderImpl builder) {
        super(builder);
        this.transcriptionJob = builder.transcriptionJob;
    }

    /**
     * <p>
     * Provides detailed information about the current transcription job, including job status and, if applicable,
     * failure reason.
     * </p>
     * 
     * @return Provides detailed information about the current transcription job, including job status and, if
     *         applicable, failure reason.
     */
    public final TranscriptionJob transcriptionJob() {
        return transcriptionJob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transcriptionJob());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTranscriptionJobResponse)) {
            return false;
        }
        StartTranscriptionJobResponse other = (StartTranscriptionJobResponse) obj;
        return Objects.equals(transcriptionJob(), other.transcriptionJob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartTranscriptionJobResponse").add("TranscriptionJob", transcriptionJob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TranscriptionJob":
            return Optional.ofNullable(clazz.cast(transcriptionJob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TranscriptionJob", TRANSCRIPTION_JOB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartTranscriptionJobResponse, T> g) {
        return obj -> g.apply((StartTranscriptionJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TranscribeResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartTranscriptionJobResponse> {
        /**
         * <p>
         * Provides detailed information about the current transcription job, including job status and, if applicable,
         * failure reason.
         * </p>
         * 
         * @param transcriptionJob
         *        Provides detailed information about the current transcription job, including job status and, if
         *        applicable, failure reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcriptionJob(TranscriptionJob transcriptionJob);

        /**
         * <p>
         * Provides detailed information about the current transcription job, including job status and, if applicable,
         * failure reason.
         * </p>
         * This is a convenience method that creates an instance of the {@link TranscriptionJob.Builder} avoiding the
         * need to create one manually via {@link TranscriptionJob#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TranscriptionJob.Builder#build()} is called immediately and its
         * result is passed to {@link #transcriptionJob(TranscriptionJob)}.
         * 
         * @param transcriptionJob
         *        a consumer that will call methods on {@link TranscriptionJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transcriptionJob(TranscriptionJob)
         */
        default Builder transcriptionJob(Consumer<TranscriptionJob.Builder> transcriptionJob) {
            return transcriptionJob(TranscriptionJob.builder().applyMutation(transcriptionJob).build());
        }
    }

    static final class BuilderImpl extends TranscribeResponse.BuilderImpl implements Builder {
        private TranscriptionJob transcriptionJob;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTranscriptionJobResponse model) {
            super(model);
            transcriptionJob(model.transcriptionJob);
        }

        public final TranscriptionJob.Builder getTranscriptionJob() {
            return transcriptionJob != null ? transcriptionJob.toBuilder() : null;
        }

        public final void setTranscriptionJob(TranscriptionJob.BuilderImpl transcriptionJob) {
            this.transcriptionJob = transcriptionJob != null ? transcriptionJob.build() : null;
        }

        @Override
        public final Builder transcriptionJob(TranscriptionJob transcriptionJob) {
            this.transcriptionJob = transcriptionJob;
            return this;
        }

        @Override
        public StartTranscriptionJobResponse build() {
            return new StartTranscriptionJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
