/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTranscriptionJobResponse extends TranscribeResponse implements
        ToCopyableBuilder<GetTranscriptionJobResponse.Builder, GetTranscriptionJobResponse> {
    private static final SdkField<TranscriptionJob> TRANSCRIPTION_JOB_FIELD = SdkField
            .<TranscriptionJob> builder(MarshallingType.SDK_POJO).getter(getter(GetTranscriptionJobResponse::transcriptionJob))
            .setter(setter(Builder::transcriptionJob)).constructor(TranscriptionJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptionJob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPTION_JOB_FIELD));

    private final TranscriptionJob transcriptionJob;

    private GetTranscriptionJobResponse(BuilderImpl builder) {
        super(builder);
        this.transcriptionJob = builder.transcriptionJob;
    }

    /**
     * <p>
     * An object that contains the results of the transcription job.
     * </p>
     * 
     * @return An object that contains the results of the transcription job.
     */
    public TranscriptionJob transcriptionJob() {
        return transcriptionJob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transcriptionJob());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTranscriptionJobResponse)) {
            return false;
        }
        GetTranscriptionJobResponse other = (GetTranscriptionJobResponse) obj;
        return Objects.equals(transcriptionJob(), other.transcriptionJob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetTranscriptionJobResponse").add("TranscriptionJob", transcriptionJob()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TranscriptionJob":
            return Optional.ofNullable(clazz.cast(transcriptionJob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTranscriptionJobResponse, T> g) {
        return obj -> g.apply((GetTranscriptionJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTranscriptionJobResponse> {
        /**
         * <p>
         * An object that contains the results of the transcription job.
         * </p>
         * 
         * @param transcriptionJob
         *        An object that contains the results of the transcription job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcriptionJob(TranscriptionJob transcriptionJob);

        /**
         * <p>
         * An object that contains the results of the transcription job.
         * </p>
         * This is a convenience that creates an instance of the {@link TranscriptionJob.Builder} avoiding the need to
         * create one manually via {@link TranscriptionJob#builder()}.
         *
         * When the {@link Consumer} completes, {@link TranscriptionJob.Builder#build()} is called immediately and its
         * result is passed to {@link #transcriptionJob(TranscriptionJob)}.
         * 
         * @param transcriptionJob
         *        a consumer that will call methods on {@link TranscriptionJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transcriptionJob(TranscriptionJob)
         */
        default Builder transcriptionJob(Consumer<TranscriptionJob.Builder> transcriptionJob) {
            return transcriptionJob(TranscriptionJob.builder().applyMutation(transcriptionJob).build());
        }
    }

    static final class BuilderImpl extends TranscribeResponse.BuilderImpl implements Builder {
        private TranscriptionJob transcriptionJob;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTranscriptionJobResponse model) {
            super(model);
            transcriptionJob(model.transcriptionJob);
        }

        public final TranscriptionJob.Builder getTranscriptionJob() {
            return transcriptionJob != null ? transcriptionJob.toBuilder() : null;
        }

        @Override
        public final Builder transcriptionJob(TranscriptionJob transcriptionJob) {
            this.transcriptionJob = transcriptionJob;
            return this;
        }

        public final void setTranscriptionJob(TranscriptionJob.BuilderImpl transcriptionJob) {
            this.transcriptionJob = transcriptionJob != null ? transcriptionJob.build() : null;
        }

        @Override
        public GetTranscriptionJobResponse build() {
            return new GetTranscriptionJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
