/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of information about a transcription job. .
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TranscriptionJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TranscriptionJobSummary.Builder, TranscriptionJobSummary> {
    private static final SdkField<String> TRANSCRIPTION_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TranscriptionJobSummary::transcriptionJobName)).setter(setter(Builder::transcriptionJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptionJobName").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(TranscriptionJobSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(TranscriptionJobSummary::completionTime)).setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TranscriptionJobSummary::languageCodeAsString)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> TRANSCRIPTION_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TranscriptionJobSummary::transcriptionJobStatusAsString))
            .setter(setter(Builder::transcriptionJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptionJobStatus").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TranscriptionJobSummary::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> OUTPUT_LOCATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TranscriptionJobSummary::outputLocationTypeAsString)).setter(setter(Builder::outputLocationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocationType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPTION_JOB_NAME_FIELD,
            CREATION_TIME_FIELD, COMPLETION_TIME_FIELD, LANGUAGE_CODE_FIELD, TRANSCRIPTION_JOB_STATUS_FIELD,
            FAILURE_REASON_FIELD, OUTPUT_LOCATION_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transcriptionJobName;

    private final Instant creationTime;

    private final Instant completionTime;

    private final String languageCode;

    private final String transcriptionJobStatus;

    private final String failureReason;

    private final String outputLocationType;

    private TranscriptionJobSummary(BuilderImpl builder) {
        this.transcriptionJobName = builder.transcriptionJobName;
        this.creationTime = builder.creationTime;
        this.completionTime = builder.completionTime;
        this.languageCode = builder.languageCode;
        this.transcriptionJobStatus = builder.transcriptionJobStatus;
        this.failureReason = builder.failureReason;
        this.outputLocationType = builder.outputLocationType;
    }

    /**
     * <p>
     * The name of the transcription job.
     * </p>
     * 
     * @return The name of the transcription job.
     */
    public String transcriptionJobName() {
        return transcriptionJobName;
    }

    /**
     * <p>
     * A timestamp that shows when the job was created.
     * </p>
     * 
     * @return A timestamp that shows when the job was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * A timestamp that shows when the job was completed.
     * </p>
     * 
     * @return A timestamp that shows when the job was completed.
     */
    public Instant completionTime() {
        return completionTime;
    }

    /**
     * <p>
     * The language code for the input speech.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code for the input speech.
     * @see LanguageCode
     */
    public LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code for the input speech.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code for the input speech.
     * @see LanguageCode
     */
    public String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The status of the transcription job. When the status is <code>COMPLETED</code>, use the
     * <code>GetTranscriptionJob</code> operation to get the results of the transcription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transcriptionJobStatus} will return {@link TranscriptionJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #transcriptionJobStatusAsString}.
     * </p>
     * 
     * @return The status of the transcription job. When the status is <code>COMPLETED</code>, use the
     *         <code>GetTranscriptionJob</code> operation to get the results of the transcription.
     * @see TranscriptionJobStatus
     */
    public TranscriptionJobStatus transcriptionJobStatus() {
        return TranscriptionJobStatus.fromValue(transcriptionJobStatus);
    }

    /**
     * <p>
     * The status of the transcription job. When the status is <code>COMPLETED</code>, use the
     * <code>GetTranscriptionJob</code> operation to get the results of the transcription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transcriptionJobStatus} will return {@link TranscriptionJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #transcriptionJobStatusAsString}.
     * </p>
     * 
     * @return The status of the transcription job. When the status is <code>COMPLETED</code>, use the
     *         <code>GetTranscriptionJob</code> operation to get the results of the transcription.
     * @see TranscriptionJobStatus
     */
    public String transcriptionJobStatusAsString() {
        return transcriptionJobStatus;
    }

    /**
     * <p>
     * If the <code>TranscriptionJobStatus</code> field is <code>FAILED</code>, a description of the error.
     * </p>
     * 
     * @return If the <code>TranscriptionJobStatus</code> field is <code>FAILED</code>, a description of the error.
     */
    public String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * Indicates the location of the output of the transcription job.
     * </p>
     * <p>
     * If the value is <code>CUSTOMER_BUCKET</code> then the location is the S3 bucket specified in the
     * <code>outputBucketName</code> field when the transcription job was started with the
     * <code>StartTranscriptionJob</code> operation.
     * </p>
     * <p>
     * If the value is <code>SERVICE_BUCKET</code> then the output is stored by Amazon Transcribe and can be retrieved
     * using the URI in the <code>GetTranscriptionJob</code> response's <code>TranscriptFileUri</code> field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #outputLocationType} will return {@link OutputLocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #outputLocationTypeAsString}.
     * </p>
     * 
     * @return Indicates the location of the output of the transcription job.</p>
     *         <p>
     *         If the value is <code>CUSTOMER_BUCKET</code> then the location is the S3 bucket specified in the
     *         <code>outputBucketName</code> field when the transcription job was started with the
     *         <code>StartTranscriptionJob</code> operation.
     *         </p>
     *         <p>
     *         If the value is <code>SERVICE_BUCKET</code> then the output is stored by Amazon Transcribe and can be
     *         retrieved using the URI in the <code>GetTranscriptionJob</code> response's <code>TranscriptFileUri</code>
     *         field.
     * @see OutputLocationType
     */
    public OutputLocationType outputLocationType() {
        return OutputLocationType.fromValue(outputLocationType);
    }

    /**
     * <p>
     * Indicates the location of the output of the transcription job.
     * </p>
     * <p>
     * If the value is <code>CUSTOMER_BUCKET</code> then the location is the S3 bucket specified in the
     * <code>outputBucketName</code> field when the transcription job was started with the
     * <code>StartTranscriptionJob</code> operation.
     * </p>
     * <p>
     * If the value is <code>SERVICE_BUCKET</code> then the output is stored by Amazon Transcribe and can be retrieved
     * using the URI in the <code>GetTranscriptionJob</code> response's <code>TranscriptFileUri</code> field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #outputLocationType} will return {@link OutputLocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #outputLocationTypeAsString}.
     * </p>
     * 
     * @return Indicates the location of the output of the transcription job.</p>
     *         <p>
     *         If the value is <code>CUSTOMER_BUCKET</code> then the location is the S3 bucket specified in the
     *         <code>outputBucketName</code> field when the transcription job was started with the
     *         <code>StartTranscriptionJob</code> operation.
     *         </p>
     *         <p>
     *         If the value is <code>SERVICE_BUCKET</code> then the output is stored by Amazon Transcribe and can be
     *         retrieved using the URI in the <code>GetTranscriptionJob</code> response's <code>TranscriptFileUri</code>
     *         field.
     * @see OutputLocationType
     */
    public String outputLocationTypeAsString() {
        return outputLocationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transcriptionJobName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(transcriptionJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(outputLocationTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranscriptionJobSummary)) {
            return false;
        }
        TranscriptionJobSummary other = (TranscriptionJobSummary) obj;
        return Objects.equals(transcriptionJobName(), other.transcriptionJobName())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(completionTime(), other.completionTime())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(transcriptionJobStatusAsString(), other.transcriptionJobStatusAsString())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(outputLocationTypeAsString(), other.outputLocationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TranscriptionJobSummary").add("TranscriptionJobName", transcriptionJobName())
                .add("CreationTime", creationTime()).add("CompletionTime", completionTime())
                .add("LanguageCode", languageCodeAsString()).add("TranscriptionJobStatus", transcriptionJobStatusAsString())
                .add("FailureReason", failureReason()).add("OutputLocationType", outputLocationTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TranscriptionJobName":
            return Optional.ofNullable(clazz.cast(transcriptionJobName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CompletionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "TranscriptionJobStatus":
            return Optional.ofNullable(clazz.cast(transcriptionJobStatusAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "OutputLocationType":
            return Optional.ofNullable(clazz.cast(outputLocationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TranscriptionJobSummary, T> g) {
        return obj -> g.apply((TranscriptionJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TranscriptionJobSummary> {
        /**
         * <p>
         * The name of the transcription job.
         * </p>
         * 
         * @param transcriptionJobName
         *        The name of the transcription job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcriptionJobName(String transcriptionJobName);

        /**
         * <p>
         * A timestamp that shows when the job was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp that shows when the job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * A timestamp that shows when the job was completed.
         * </p>
         * 
         * @param completionTime
         *        A timestamp that shows when the job was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);

        /**
         * <p>
         * The language code for the input speech.
         * </p>
         * 
         * @param languageCode
         *        The language code for the input speech.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code for the input speech.
         * </p>
         * 
         * @param languageCode
         *        The language code for the input speech.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * The status of the transcription job. When the status is <code>COMPLETED</code>, use the
         * <code>GetTranscriptionJob</code> operation to get the results of the transcription.
         * </p>
         * 
         * @param transcriptionJobStatus
         *        The status of the transcription job. When the status is <code>COMPLETED</code>, use the
         *        <code>GetTranscriptionJob</code> operation to get the results of the transcription.
         * @see TranscriptionJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscriptionJobStatus
         */
        Builder transcriptionJobStatus(String transcriptionJobStatus);

        /**
         * <p>
         * The status of the transcription job. When the status is <code>COMPLETED</code>, use the
         * <code>GetTranscriptionJob</code> operation to get the results of the transcription.
         * </p>
         * 
         * @param transcriptionJobStatus
         *        The status of the transcription job. When the status is <code>COMPLETED</code>, use the
         *        <code>GetTranscriptionJob</code> operation to get the results of the transcription.
         * @see TranscriptionJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscriptionJobStatus
         */
        Builder transcriptionJobStatus(TranscriptionJobStatus transcriptionJobStatus);

        /**
         * <p>
         * If the <code>TranscriptionJobStatus</code> field is <code>FAILED</code>, a description of the error.
         * </p>
         * 
         * @param failureReason
         *        If the <code>TranscriptionJobStatus</code> field is <code>FAILED</code>, a description of the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * Indicates the location of the output of the transcription job.
         * </p>
         * <p>
         * If the value is <code>CUSTOMER_BUCKET</code> then the location is the S3 bucket specified in the
         * <code>outputBucketName</code> field when the transcription job was started with the
         * <code>StartTranscriptionJob</code> operation.
         * </p>
         * <p>
         * If the value is <code>SERVICE_BUCKET</code> then the output is stored by Amazon Transcribe and can be
         * retrieved using the URI in the <code>GetTranscriptionJob</code> response's <code>TranscriptFileUri</code>
         * field.
         * </p>
         * 
         * @param outputLocationType
         *        Indicates the location of the output of the transcription job.</p>
         *        <p>
         *        If the value is <code>CUSTOMER_BUCKET</code> then the location is the S3 bucket specified in the
         *        <code>outputBucketName</code> field when the transcription job was started with the
         *        <code>StartTranscriptionJob</code> operation.
         *        </p>
         *        <p>
         *        If the value is <code>SERVICE_BUCKET</code> then the output is stored by Amazon Transcribe and can be
         *        retrieved using the URI in the <code>GetTranscriptionJob</code> response's
         *        <code>TranscriptFileUri</code> field.
         * @see OutputLocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputLocationType
         */
        Builder outputLocationType(String outputLocationType);

        /**
         * <p>
         * Indicates the location of the output of the transcription job.
         * </p>
         * <p>
         * If the value is <code>CUSTOMER_BUCKET</code> then the location is the S3 bucket specified in the
         * <code>outputBucketName</code> field when the transcription job was started with the
         * <code>StartTranscriptionJob</code> operation.
         * </p>
         * <p>
         * If the value is <code>SERVICE_BUCKET</code> then the output is stored by Amazon Transcribe and can be
         * retrieved using the URI in the <code>GetTranscriptionJob</code> response's <code>TranscriptFileUri</code>
         * field.
         * </p>
         * 
         * @param outputLocationType
         *        Indicates the location of the output of the transcription job.</p>
         *        <p>
         *        If the value is <code>CUSTOMER_BUCKET</code> then the location is the S3 bucket specified in the
         *        <code>outputBucketName</code> field when the transcription job was started with the
         *        <code>StartTranscriptionJob</code> operation.
         *        </p>
         *        <p>
         *        If the value is <code>SERVICE_BUCKET</code> then the output is stored by Amazon Transcribe and can be
         *        retrieved using the URI in the <code>GetTranscriptionJob</code> response's
         *        <code>TranscriptFileUri</code> field.
         * @see OutputLocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputLocationType
         */
        Builder outputLocationType(OutputLocationType outputLocationType);
    }

    static final class BuilderImpl implements Builder {
        private String transcriptionJobName;

        private Instant creationTime;

        private Instant completionTime;

        private String languageCode;

        private String transcriptionJobStatus;

        private String failureReason;

        private String outputLocationType;

        private BuilderImpl() {
        }

        private BuilderImpl(TranscriptionJobSummary model) {
            transcriptionJobName(model.transcriptionJobName);
            creationTime(model.creationTime);
            completionTime(model.completionTime);
            languageCode(model.languageCode);
            transcriptionJobStatus(model.transcriptionJobStatus);
            failureReason(model.failureReason);
            outputLocationType(model.outputLocationType);
        }

        public final String getTranscriptionJobName() {
            return transcriptionJobName;
        }

        @Override
        public final Builder transcriptionJobName(String transcriptionJobName) {
            this.transcriptionJobName = transcriptionJobName;
            return this;
        }

        public final void setTranscriptionJobName(String transcriptionJobName) {
            this.transcriptionJobName = transcriptionJobName;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        public final String getLanguageCodeAsString() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getTranscriptionJobStatusAsString() {
            return transcriptionJobStatus;
        }

        @Override
        public final Builder transcriptionJobStatus(String transcriptionJobStatus) {
            this.transcriptionJobStatus = transcriptionJobStatus;
            return this;
        }

        @Override
        public final Builder transcriptionJobStatus(TranscriptionJobStatus transcriptionJobStatus) {
            this.transcriptionJobStatus(transcriptionJobStatus.toString());
            return this;
        }

        public final void setTranscriptionJobStatus(String transcriptionJobStatus) {
            this.transcriptionJobStatus = transcriptionJobStatus;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getOutputLocationTypeAsString() {
            return outputLocationType;
        }

        @Override
        public final Builder outputLocationType(String outputLocationType) {
            this.outputLocationType = outputLocationType;
            return this;
        }

        @Override
        public final Builder outputLocationType(OutputLocationType outputLocationType) {
            this.outputLocationType(outputLocationType.toString());
            return this;
        }

        public final void setOutputLocationType(String outputLocationType) {
            this.outputLocationType = outputLocationType;
        }

        @Override
        public TranscriptionJobSummary build() {
            return new TranscriptionJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
