/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVocabulariesRequest extends TranscribeRequest implements
        ToCopyableBuilder<ListVocabulariesRequest.Builder, ListVocabulariesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListVocabulariesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListVocabulariesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> STATE_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListVocabulariesRequest::stateEqualsAsString)).setter(setter(Builder::stateEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateEquals").build()).build();

    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListVocabulariesRequest::nameContains)).setter(setter(Builder::nameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, STATE_EQUALS_FIELD, NAME_CONTAINS_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final String stateEquals;

    private final String nameContains;

    private ListVocabulariesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.stateEquals = builder.stateEquals;
        this.nameContains = builder.nameContains;
    }

    /**
     * <p>
     * If the result of the previous request to <code>ListVocabularies</code> was truncated, include the
     * <code>NextToken</code> to fetch the next set of jobs.
     * </p>
     * 
     * @return If the result of the previous request to <code>ListVocabularies</code> was truncated, include the
     *         <code>NextToken</code> to fetch the next set of jobs.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of vocabularies to return in the response. If there are fewer results in the list, this
     * response contains only the actual results.
     * </p>
     * 
     * @return The maximum number of vocabularies to return in the response. If there are fewer results in the list,
     *         this response contains only the actual results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * When specified, only returns vocabularies with the <code>VocabularyState</code> field equal to the specified
     * state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateEquals} will
     * return {@link VocabularyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateEqualsAsString}.
     * </p>
     * 
     * @return When specified, only returns vocabularies with the <code>VocabularyState</code> field equal to the
     *         specified state.
     * @see VocabularyState
     */
    public VocabularyState stateEquals() {
        return VocabularyState.fromValue(stateEquals);
    }

    /**
     * <p>
     * When specified, only returns vocabularies with the <code>VocabularyState</code> field equal to the specified
     * state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateEquals} will
     * return {@link VocabularyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateEqualsAsString}.
     * </p>
     * 
     * @return When specified, only returns vocabularies with the <code>VocabularyState</code> field equal to the
     *         specified state.
     * @see VocabularyState
     */
    public String stateEqualsAsString() {
        return stateEquals;
    }

    /**
     * <p>
     * When specified, the vocabularies returned in the list are limited to vocabularies whose name contains the
     * specified string. The search is case-insensitive, <code>ListVocabularies</code> will return both "vocabularyname"
     * and "VocabularyName" in the response list.
     * </p>
     * 
     * @return When specified, the vocabularies returned in the list are limited to vocabularies whose name contains the
     *         specified string. The search is case-insensitive, <code>ListVocabularies</code> will return both
     *         "vocabularyname" and "VocabularyName" in the response list.
     */
    public String nameContains() {
        return nameContains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(stateEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nameContains());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVocabulariesRequest)) {
            return false;
        }
        ListVocabulariesRequest other = (ListVocabulariesRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(stateEqualsAsString(), other.stateEqualsAsString())
                && Objects.equals(nameContains(), other.nameContains());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListVocabulariesRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("StateEquals", stateEqualsAsString()).add("NameContains", nameContains()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "StateEquals":
            return Optional.ofNullable(clazz.cast(stateEqualsAsString()));
        case "NameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVocabulariesRequest, T> g) {
        return obj -> g.apply((ListVocabulariesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListVocabulariesRequest> {
        /**
         * <p>
         * If the result of the previous request to <code>ListVocabularies</code> was truncated, include the
         * <code>NextToken</code> to fetch the next set of jobs.
         * </p>
         * 
         * @param nextToken
         *        If the result of the previous request to <code>ListVocabularies</code> was truncated, include the
         *        <code>NextToken</code> to fetch the next set of jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of vocabularies to return in the response. If there are fewer results in the list, this
         * response contains only the actual results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of vocabularies to return in the response. If there are fewer results in the list,
         *        this response contains only the actual results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * When specified, only returns vocabularies with the <code>VocabularyState</code> field equal to the specified
         * state.
         * </p>
         * 
         * @param stateEquals
         *        When specified, only returns vocabularies with the <code>VocabularyState</code> field equal to the
         *        specified state.
         * @see VocabularyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyState
         */
        Builder stateEquals(String stateEquals);

        /**
         * <p>
         * When specified, only returns vocabularies with the <code>VocabularyState</code> field equal to the specified
         * state.
         * </p>
         * 
         * @param stateEquals
         *        When specified, only returns vocabularies with the <code>VocabularyState</code> field equal to the
         *        specified state.
         * @see VocabularyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyState
         */
        Builder stateEquals(VocabularyState stateEquals);

        /**
         * <p>
         * When specified, the vocabularies returned in the list are limited to vocabularies whose name contains the
         * specified string. The search is case-insensitive, <code>ListVocabularies</code> will return both
         * "vocabularyname" and "VocabularyName" in the response list.
         * </p>
         * 
         * @param nameContains
         *        When specified, the vocabularies returned in the list are limited to vocabularies whose name contains
         *        the specified string. The search is case-insensitive, <code>ListVocabularies</code> will return both
         *        "vocabularyname" and "VocabularyName" in the response list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranscribeRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String stateEquals;

        private String nameContains;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVocabulariesRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            stateEquals(model.stateEquals);
            nameContains(model.nameContains);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getStateEqualsAsString() {
            return stateEquals;
        }

        @Override
        public final Builder stateEquals(String stateEquals) {
            this.stateEquals = stateEquals;
            return this;
        }

        @Override
        public final Builder stateEquals(VocabularyState stateEquals) {
            this.stateEquals(stateEquals == null ? null : stateEquals.toString());
            return this;
        }

        public final void setStateEquals(String stateEquals) {
            this.stateEquals = stateEquals;
        }

        public final String getNameContains() {
            return nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListVocabulariesRequest build() {
            return new ListVocabulariesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
