/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetVocabularyResponse extends TranscribeResponse implements
        ToCopyableBuilder<GetVocabularyResponse.Builder, GetVocabularyResponse> {
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetVocabularyResponse::vocabularyName)).setter(setter(Builder::vocabularyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetVocabularyResponse::languageCodeAsString)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> VOCABULARY_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetVocabularyResponse::vocabularyStateAsString)).setter(setter(Builder::vocabularyState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyState").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetVocabularyResponse::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetVocabularyResponse::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> DOWNLOAD_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetVocabularyResponse::downloadUri)).setter(setter(Builder::downloadUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DownloadUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_NAME_FIELD,
            LANGUAGE_CODE_FIELD, VOCABULARY_STATE_FIELD, LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD, DOWNLOAD_URI_FIELD));

    private final String vocabularyName;

    private final String languageCode;

    private final String vocabularyState;

    private final Instant lastModifiedTime;

    private final String failureReason;

    private final String downloadUri;

    private GetVocabularyResponse(BuilderImpl builder) {
        super(builder);
        this.vocabularyName = builder.vocabularyName;
        this.languageCode = builder.languageCode;
        this.vocabularyState = builder.vocabularyState;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
        this.downloadUri = builder.downloadUri;
    }

    /**
     * <p>
     * The name of the vocabulary to return.
     * </p>
     * 
     * @return The name of the vocabulary to return.
     */
    public String vocabularyName() {
        return vocabularyName;
    }

    /**
     * <p>
     * The language code of the vocabulary entries.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code of the vocabulary entries.
     * @see LanguageCode
     */
    public LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code of the vocabulary entries.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code of the vocabulary entries.
     * @see LanguageCode
     */
    public String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The processing state of the vocabulary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vocabularyState}
     * will return {@link VocabularyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #vocabularyStateAsString}.
     * </p>
     * 
     * @return The processing state of the vocabulary.
     * @see VocabularyState
     */
    public VocabularyState vocabularyState() {
        return VocabularyState.fromValue(vocabularyState);
    }

    /**
     * <p>
     * The processing state of the vocabulary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vocabularyState}
     * will return {@link VocabularyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #vocabularyStateAsString}.
     * </p>
     * 
     * @return The processing state of the vocabulary.
     * @see VocabularyState
     */
    public String vocabularyStateAsString() {
        return vocabularyState;
    }

    /**
     * <p>
     * The date and time that the vocabulary was last modified.
     * </p>
     * 
     * @return The date and time that the vocabulary was last modified.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * If the <code>VocabularyState</code> field is <code>FAILED</code>, this field contains information about why the
     * job failed.
     * </p>
     * 
     * @return If the <code>VocabularyState</code> field is <code>FAILED</code>, this field contains information about
     *         why the job failed.
     */
    public String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The S3 location where the vocabulary is stored. Use this URI to get the contents of the vocabulary. The URI is
     * available for a limited time.
     * </p>
     * 
     * @return The S3 location where the vocabulary is stored. Use this URI to get the contents of the vocabulary. The
     *         URI is available for a limited time.
     */
    public String downloadUri() {
        return downloadUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(downloadUri());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVocabularyResponse)) {
            return false;
        }
        GetVocabularyResponse other = (GetVocabularyResponse) obj;
        return Objects.equals(vocabularyName(), other.vocabularyName())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(vocabularyStateAsString(), other.vocabularyStateAsString())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(downloadUri(), other.downloadUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetVocabularyResponse").add("VocabularyName", vocabularyName())
                .add("LanguageCode", languageCodeAsString()).add("VocabularyState", vocabularyStateAsString())
                .add("LastModifiedTime", lastModifiedTime()).add("FailureReason", failureReason())
                .add("DownloadUri", downloadUri()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VocabularyName":
            return Optional.ofNullable(clazz.cast(vocabularyName()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "VocabularyState":
            return Optional.ofNullable(clazz.cast(vocabularyStateAsString()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "DownloadUri":
            return Optional.ofNullable(clazz.cast(downloadUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetVocabularyResponse, T> g) {
        return obj -> g.apply((GetVocabularyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetVocabularyResponse> {
        /**
         * <p>
         * The name of the vocabulary to return.
         * </p>
         * 
         * @param vocabularyName
         *        The name of the vocabulary to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyName(String vocabularyName);

        /**
         * <p>
         * The language code of the vocabulary entries.
         * </p>
         * 
         * @param languageCode
         *        The language code of the vocabulary entries.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code of the vocabulary entries.
         * </p>
         * 
         * @param languageCode
         *        The language code of the vocabulary entries.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * The processing state of the vocabulary.
         * </p>
         * 
         * @param vocabularyState
         *        The processing state of the vocabulary.
         * @see VocabularyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyState
         */
        Builder vocabularyState(String vocabularyState);

        /**
         * <p>
         * The processing state of the vocabulary.
         * </p>
         * 
         * @param vocabularyState
         *        The processing state of the vocabulary.
         * @see VocabularyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyState
         */
        Builder vocabularyState(VocabularyState vocabularyState);

        /**
         * <p>
         * The date and time that the vocabulary was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time that the vocabulary was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * If the <code>VocabularyState</code> field is <code>FAILED</code>, this field contains information about why
         * the job failed.
         * </p>
         * 
         * @param failureReason
         *        If the <code>VocabularyState</code> field is <code>FAILED</code>, this field contains information
         *        about why the job failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The S3 location where the vocabulary is stored. Use this URI to get the contents of the vocabulary. The URI
         * is available for a limited time.
         * </p>
         * 
         * @param downloadUri
         *        The S3 location where the vocabulary is stored. Use this URI to get the contents of the vocabulary.
         *        The URI is available for a limited time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downloadUri(String downloadUri);
    }

    static final class BuilderImpl extends TranscribeResponse.BuilderImpl implements Builder {
        private String vocabularyName;

        private String languageCode;

        private String vocabularyState;

        private Instant lastModifiedTime;

        private String failureReason;

        private String downloadUri;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVocabularyResponse model) {
            super(model);
            vocabularyName(model.vocabularyName);
            languageCode(model.languageCode);
            vocabularyState(model.vocabularyState);
            lastModifiedTime(model.lastModifiedTime);
            failureReason(model.failureReason);
            downloadUri(model.downloadUri);
        }

        public final String getVocabularyName() {
            return vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        public final String getLanguageCodeAsString() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getVocabularyStateAsString() {
            return vocabularyState;
        }

        @Override
        public final Builder vocabularyState(String vocabularyState) {
            this.vocabularyState = vocabularyState;
            return this;
        }

        @Override
        public final Builder vocabularyState(VocabularyState vocabularyState) {
            this.vocabularyState(vocabularyState == null ? null : vocabularyState.toString());
            return this;
        }

        public final void setVocabularyState(String vocabularyState) {
            this.vocabularyState = vocabularyState;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getDownloadUri() {
            return downloadUri;
        }

        @Override
        public final Builder downloadUri(String downloadUri) {
            this.downloadUri = downloadUri;
            return this;
        }

        public final void setDownloadUri(String downloadUri) {
            this.downloadUri = downloadUri;
        }

        @Override
        public GetVocabularyResponse build() {
            return new GetVocabularyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
