/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.transcribestreaming.model.AudioStream;
import software.amazon.awssdk.services.transcribestreaming.model.StartStreamTranscriptionRequest;
import software.amazon.awssdk.services.transcribestreaming.model.StartStreamTranscriptionResponseHandler;

/**
 * Service client for accessing Amazon Transcribe Streaming Service asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Operations and objects for transcribing streaming speech to text.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface TranscribeStreamingAsyncClient extends SdkClient {
    String SERVICE_NAME = "transcribe";

    /**
     * Create a {@link TranscribeStreamingAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static TranscribeStreamingAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link TranscribeStreamingAsyncClient}.
     */
    static TranscribeStreamingAsyncClientBuilder builder() {
        return new DefaultTranscribeStreamingAsyncClientBuilder();
    }

    /**
     * <p>
     * Starts a bidirectional HTTP2 stream where audio is streamed to Amazon Transcribe and the transcription results
     * are streamed to your application.
     * </p>
     * <p>
     * The following are encoded as HTTP2 headers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * x-amzn-transcribe-language-code
     * </p>
     * </li>
     * <li>
     * <p>
     * x-amzn-transcribe-media-encoding
     * </p>
     * </li>
     * <li>
     * <p>
     * x-amzn-transcribe-sample-rate
     * </p>
     * </li>
     * <li>
     * <p>
     * x-amzn-transcribe-session-id
     * </p>
     * </li>
     * </ul>
     *
     * @param startStreamTranscriptionRequest
     * @return A Java Future containing the result of the StartStreamTranscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException One or more arguments to the <code>StartStreamTranscription</code> operation was
     *         invalid. For example, <code>MediaEncoding</code> was not set to <code>pcm</code> or
     *         <code>LanguageCode</code> was not set to a valid code. Check the parameters and try your request again.</li>
     *         <li>LimitExceededException You have exceeded the maximum number of concurrent transcription streams, are
     *         starting transcription streams too quickly, or the maximum audio length of 4 hours. Wait until a stream
     *         has finished processing, or break your audio stream into smaller chunks and try your request again.</li>
     *         <li>InternalFailureException A problem occurred while processing the audio. Amazon Transcribe terminated
     *         processing. Try your request again.</li>
     *         <li>ConflictException A new stream started with the same session ID. The current stream has been
     *         terminated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeStreamingException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample TranscribeStreamingAsyncClient.StartStreamTranscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/transcribe-streaming-2017-10-26/StartStreamTranscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> startStreamTranscription(StartStreamTranscriptionRequest startStreamTranscriptionRequest,
            Publisher<AudioStream> requestStream, StartStreamTranscriptionResponseHandler asyncResponseHandler) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a bidirectional HTTP2 stream where audio is streamed to Amazon Transcribe and the transcription results
     * are streamed to your application.
     * </p>
     * <p>
     * The following are encoded as HTTP2 headers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * x-amzn-transcribe-language-code
     * </p>
     * </li>
     * <li>
     * <p>
     * x-amzn-transcribe-media-encoding
     * </p>
     * </li>
     * <li>
     * <p>
     * x-amzn-transcribe-sample-rate
     * </p>
     * </li>
     * <li>
     * <p>
     * x-amzn-transcribe-session-id
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartStreamTranscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link StartStreamTranscriptionRequest#builder()}
     * </p>
     *
     * @param startStreamTranscriptionRequest
     *        A {@link Consumer} that will call methods on {@link StartStreamTranscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartStreamTranscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException One or more arguments to the <code>StartStreamTranscription</code> operation was
     *         invalid. For example, <code>MediaEncoding</code> was not set to <code>pcm</code> or
     *         <code>LanguageCode</code> was not set to a valid code. Check the parameters and try your request again.</li>
     *         <li>LimitExceededException You have exceeded the maximum number of concurrent transcription streams, are
     *         starting transcription streams too quickly, or the maximum audio length of 4 hours. Wait until a stream
     *         has finished processing, or break your audio stream into smaller chunks and try your request again.</li>
     *         <li>InternalFailureException A problem occurred while processing the audio. Amazon Transcribe terminated
     *         processing. Try your request again.</li>
     *         <li>ConflictException A new stream started with the same session ID. The current stream has been
     *         terminated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeStreamingException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample TranscribeStreamingAsyncClient.StartStreamTranscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/transcribe-streaming-2017-10-26/StartStreamTranscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> startStreamTranscription(
            Consumer<StartStreamTranscriptionRequest.Builder> startStreamTranscriptionRequest,
            Publisher<AudioStream> requestStream, StartStreamTranscriptionResponseHandler asyncResponseHandler) {
        return startStreamTranscription(StartStreamTranscriptionRequest.builder().applyMutation(startStreamTranscriptionRequest)
                .build(), requestStream, asyncResponseHandler);
    }
}
