/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a wrapper for the audio chunks that you are sending.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioEvent implements SdkPojo, Serializable, ToCopyableBuilder<AudioEvent.Builder, AudioEvent>, AudioStream {
    private static final SdkField<SdkBytes> AUDIO_CHUNK_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(AudioEvent::audioChunk))
            .setter(setter(Builder::audioChunk))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudioChunk").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_CHUNK_FIELD));

    private static final long serialVersionUID = 1L;

    private final SdkBytes audioChunk;

    private AudioEvent(BuilderImpl builder) {
        this.audioChunk = builder.audioChunk;
    }

    /**
     * <p>
     * An audio blob that contains the next part of the audio that you want to transcribe.
     * </p>
     * 
     * @return An audio blob that contains the next part of the audio that you want to transcribe.
     */
    public SdkBytes audioChunk() {
        return audioChunk;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioChunk());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioEvent)) {
            return false;
        }
        AudioEvent other = (AudioEvent) obj;
        return Objects.equals(audioChunk(), other.audioChunk());
    }

    @Override
    public String toString() {
        return ToString.builder("AudioEvent").add("AudioChunk", audioChunk()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioChunk":
            return Optional.ofNullable(clazz.cast(audioChunk()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioEvent, T> g) {
        return obj -> g.apply((AudioEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioEvent> {
        /**
         * <p>
         * An audio blob that contains the next part of the audio that you want to transcribe.
         * </p>
         * 
         * @param audioChunk
         *        An audio blob that contains the next part of the audio that you want to transcribe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioChunk(SdkBytes audioChunk);
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes audioChunk;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioEvent model) {
            audioChunk(model.audioChunk);
        }

        public final ByteBuffer getAudioChunk() {
            return audioChunk == null ? null : audioChunk.asByteBuffer();
        }

        @Override
        public final Builder audioChunk(SdkBytes audioChunk) {
            this.audioChunk = StandardMemberCopier.copy(audioChunk);
            return this;
        }

        public final void setAudioChunk(ByteBuffer audioChunk) {
            audioChunk(audioChunk == null ? null : SdkBytes.fromByteBuffer(audioChunk));
        }

        @Override
        public AudioEvent build() {
            return new AudioEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
