/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of possible transcriptions for the audio.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Alternative implements SdkPojo, Serializable, ToCopyableBuilder<Alternative.Builder, Alternative> {
    private static final SdkField<String> TRANSCRIPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Alternative::transcript)).setter(setter(Builder::transcript))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transcript").build()).build();

    private static final SdkField<List<Item>> ITEMS_FIELD = SdkField
            .<List<Item>> builder(MarshallingType.LIST)
            .getter(getter(Alternative::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Item> builder(MarshallingType.SDK_POJO)
                                            .constructor(Item::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TRANSCRIPT_FIELD, ITEMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transcript;

    private final List<Item> items;

    private Alternative(BuilderImpl builder) {
        this.transcript = builder.transcript;
        this.items = builder.items;
    }

    /**
     * <p>
     * The text that was transcribed from the audio.
     * </p>
     * 
     * @return The text that was transcribed from the audio.
     */
    public String transcript() {
        return transcript;
    }

    /**
     * <p>
     * One or more alternative interpretations of the input audio.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more alternative interpretations of the input audio.
     */
    public List<Item> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transcript());
        hashCode = 31 * hashCode + Objects.hashCode(items());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alternative)) {
            return false;
        }
        Alternative other = (Alternative) obj;
        return Objects.equals(transcript(), other.transcript()) && Objects.equals(items(), other.items());
    }

    @Override
    public String toString() {
        return ToString.builder("Alternative").add("Transcript", transcript()).add("Items", items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Transcript":
            return Optional.ofNullable(clazz.cast(transcript()));
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Alternative, T> g) {
        return obj -> g.apply((Alternative) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Alternative> {
        /**
         * <p>
         * The text that was transcribed from the audio.
         * </p>
         * 
         * @param transcript
         *        The text that was transcribed from the audio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcript(String transcript);

        /**
         * <p>
         * One or more alternative interpretations of the input audio.
         * </p>
         * 
         * @param items
         *        One or more alternative interpretations of the input audio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<Item> items);

        /**
         * <p>
         * One or more alternative interpretations of the input audio.
         * </p>
         * 
         * @param items
         *        One or more alternative interpretations of the input audio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Item... items);

        /**
         * <p>
         * One or more alternative interpretations of the input audio.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Item>.Builder} avoiding the need to create
         * one manually via {@link List<Item>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Item>.Builder#build()} is called immediately and its result
         * is passed to {@link #items(List<Item>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<Item>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<Item>)
         */
        Builder items(Consumer<Item.Builder>... items);
    }

    static final class BuilderImpl implements Builder {
        private String transcript;

        private List<Item> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Alternative model) {
            transcript(model.transcript);
            items(model.items);
        }

        public final String getTranscript() {
            return transcript;
        }

        @Override
        public final Builder transcript(String transcript) {
            this.transcript = transcript;
            return this;
        }

        public final void setTranscript(String transcript) {
            this.transcript = transcript;
        }

        public final Collection<Item.Builder> getItems() {
            return items != null ? items.stream().map(Item::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<Item> items) {
            this.items = ItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Item... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<Item.Builder>... items) {
            items(Stream.of(items).map(c -> Item.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<Item.BuilderImpl> items) {
            this.items = ItemListCopier.copyFromBuilder(items);
        }

        @Override
        public Alternative build() {
            return new Alternative(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
