/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The transcription in a <a>TranscriptEvent</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Transcript implements SdkPojo, Serializable, ToCopyableBuilder<Transcript.Builder, Transcript> {
    private static final SdkField<List<Result>> RESULTS_FIELD = SdkField
            .<List<Result>> builder(MarshallingType.LIST)
            .getter(getter(Transcript::results))
            .setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Result> builder(MarshallingType.SDK_POJO)
                                            .constructor(Result::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Result> results;

    private Transcript(BuilderImpl builder) {
        this.results = builder.results;
    }

    /**
     * <p>
     * <a>Result</a> objects that contain the results of transcribing a portion of the input audio stream. The array can
     * be empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return <a>Result</a> objects that contain the results of transcribing a portion of the input audio stream. The
     *         array can be empty.
     */
    public List<Result> results() {
        return results;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(results());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transcript)) {
            return false;
        }
        Transcript other = (Transcript) obj;
        return Objects.equals(results(), other.results());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Transcript").add("Results", results()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Results":
            return Optional.ofNullable(clazz.cast(results()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Transcript, T> g) {
        return obj -> g.apply((Transcript) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Transcript> {
        /**
         * <p>
         * <a>Result</a> objects that contain the results of transcribing a portion of the input audio stream. The array
         * can be empty.
         * </p>
         * 
         * @param results
         *        <a>Result</a> objects that contain the results of transcribing a portion of the input audio stream.
         *        The array can be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<Result> results);

        /**
         * <p>
         * <a>Result</a> objects that contain the results of transcribing a portion of the input audio stream. The array
         * can be empty.
         * </p>
         * 
         * @param results
         *        <a>Result</a> objects that contain the results of transcribing a portion of the input audio stream.
         *        The array can be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Result... results);

        /**
         * <p>
         * <a>Result</a> objects that contain the results of transcribing a portion of the input audio stream. The array
         * can be empty.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Result>.Builder} avoiding the need to
         * create one manually via {@link List<Result>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Result>.Builder#build()} is called immediately and its
         * result is passed to {@link #results(List<Result>)}.
         * 
         * @param results
         *        a consumer that will call methods on {@link List<Result>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #results(List<Result>)
         */
        Builder results(Consumer<Result.Builder>... results);
    }

    static final class BuilderImpl implements Builder {
        private List<Result> results = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Transcript model) {
            results(model.results);
        }

        public final Collection<Result.Builder> getResults() {
            return results != null ? results.stream().map(Result::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder results(Collection<Result> results) {
            this.results = ResultListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Result... results) {
            results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<Result.Builder>... results) {
            results(Stream.of(results).map(c -> Result.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResults(Collection<Result.BuilderImpl> results) {
            this.results = ResultListCopier.copyFromBuilder(results);
        }

        @Override
        public Transcript build() {
            return new Transcript(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
