/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A word or phrase transcribed from the input audio.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Item implements SdkPojo, Serializable, ToCopyableBuilder<Item.Builder, Item> {
    private static final SdkField<Double> START_TIME_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Item::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Double> END_TIME_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Item::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Item::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Item::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, TYPE_FIELD, CONTENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double startTime;

    private final Double endTime;

    private final String type;

    private final String content;

    private Item(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.type = builder.type;
        this.content = builder.content;
    }

    /**
     * <p>
     * The offset from the beginning of the audio stream to the beginning of the audio that resulted in the item.
     * </p>
     * 
     * @return The offset from the beginning of the audio stream to the beginning of the audio that resulted in the
     *         item.
     */
    public Double startTime() {
        return startTime;
    }

    /**
     * <p>
     * The offset from the beginning of the audio stream to the end of the audio that resulted in the item.
     * </p>
     * 
     * @return The offset from the beginning of the audio stream to the end of the audio that resulted in the item.
     */
    public Double endTime() {
        return endTime;
    }

    /**
     * <p>
     * The type of the item. <code>PRONUNCIATION</code> indicates that the item is a word that was recognized in the
     * input audio. <code>PUNCTUATION</code> indicates that the item was interpreted as a pause in the input audio.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the item. <code>PRONUNCIATION</code> indicates that the item is a word that was recognized in
     *         the input audio. <code>PUNCTUATION</code> indicates that the item was interpreted as a pause in the input
     *         audio.
     * @see ItemType
     */
    public ItemType type() {
        return ItemType.fromValue(type);
    }

    /**
     * <p>
     * The type of the item. <code>PRONUNCIATION</code> indicates that the item is a word that was recognized in the
     * input audio. <code>PUNCTUATION</code> indicates that the item was interpreted as a pause in the input audio.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the item. <code>PRONUNCIATION</code> indicates that the item is a word that was recognized in
     *         the input audio. <code>PUNCTUATION</code> indicates that the item was interpreted as a pause in the input
     *         audio.
     * @see ItemType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The word or punctuation that was recognized in the input audio.
     * </p>
     * 
     * @return The word or punctuation that was recognized in the input audio.
     */
    public String content() {
        return content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Item)) {
            return false;
        }
        Item other = (Item) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(content(), other.content());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Item").add("StartTime", startTime()).add("EndTime", endTime()).add("Type", typeAsString())
                .add("Content", content()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Item, T> g) {
        return obj -> g.apply((Item) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Item> {
        /**
         * <p>
         * The offset from the beginning of the audio stream to the beginning of the audio that resulted in the item.
         * </p>
         * 
         * @param startTime
         *        The offset from the beginning of the audio stream to the beginning of the audio that resulted in the
         *        item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Double startTime);

        /**
         * <p>
         * The offset from the beginning of the audio stream to the end of the audio that resulted in the item.
         * </p>
         * 
         * @param endTime
         *        The offset from the beginning of the audio stream to the end of the audio that resulted in the item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Double endTime);

        /**
         * <p>
         * The type of the item. <code>PRONUNCIATION</code> indicates that the item is a word that was recognized in the
         * input audio. <code>PUNCTUATION</code> indicates that the item was interpreted as a pause in the input audio.
         * </p>
         * 
         * @param type
         *        The type of the item. <code>PRONUNCIATION</code> indicates that the item is a word that was recognized
         *        in the input audio. <code>PUNCTUATION</code> indicates that the item was interpreted as a pause in the
         *        input audio.
         * @see ItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ItemType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the item. <code>PRONUNCIATION</code> indicates that the item is a word that was recognized in the
         * input audio. <code>PUNCTUATION</code> indicates that the item was interpreted as a pause in the input audio.
         * </p>
         * 
         * @param type
         *        The type of the item. <code>PRONUNCIATION</code> indicates that the item is a word that was recognized
         *        in the input audio. <code>PUNCTUATION</code> indicates that the item was interpreted as a pause in the
         *        input audio.
         * @see ItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ItemType
         */
        Builder type(ItemType type);

        /**
         * <p>
         * The word or punctuation that was recognized in the input audio.
         * </p>
         * 
         * @param content
         *        The word or punctuation that was recognized in the input audio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);
    }

    static final class BuilderImpl implements Builder {
        private Double startTime;

        private Double endTime;

        private String type;

        private String content;

        private BuilderImpl() {
        }

        private BuilderImpl(Item model) {
            startTime(model.startTime);
            endTime(model.endTime);
            type(model.type);
            content(model.content);
        }

        public final Double getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Double startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Double startTime) {
            this.startTime = startTime;
        }

        public final Double getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Double endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Double endTime) {
            this.endTime = endTime;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ItemType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getContent() {
            return content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public Item build() {
            return new Item(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
