/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartStreamTranscriptionRequest extends TranscribeStreamingRequest implements
        ToCopyableBuilder<StartStreamTranscriptionRequest.Builder, StartStreamTranscriptionRequest> {
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode")
            .getter(getter(StartStreamTranscriptionRequest::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-language-code")
                    .build()).build();

    private static final SdkField<Integer> MEDIA_SAMPLE_RATE_HERTZ_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MediaSampleRateHertz")
            .getter(getter(StartStreamTranscriptionRequest::mediaSampleRateHertz))
            .setter(setter(Builder::mediaSampleRateHertz))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-sample-rate")
                    .build()).build();

    private static final SdkField<String> MEDIA_ENCODING_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MediaEncoding")
            .getter(getter(StartStreamTranscriptionRequest::mediaEncodingAsString))
            .setter(setter(Builder::mediaEncoding))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-media-encoding")
                    .build()).build();

    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VocabularyName")
            .getter(getter(StartStreamTranscriptionRequest::vocabularyName))
            .setter(setter(Builder::vocabularyName))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-vocabulary-name")
                    .build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SessionId")
            .getter(getter(StartStreamTranscriptionRequest::sessionId))
            .setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-session-id")
                    .build()).build();

    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterName")
            .getter(getter(StartStreamTranscriptionRequest::vocabularyFilterName))
            .setter(setter(Builder::vocabularyFilterName))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-vocabulary-filter-name").build()).build();

    private static final SdkField<String> VOCABULARY_FILTER_METHOD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterMethod")
            .getter(getter(StartStreamTranscriptionRequest::vocabularyFilterMethodAsString))
            .setter(setter(Builder::vocabularyFilterMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-vocabulary-filter-method").build()).build();

    private static final SdkField<Boolean> SHOW_SPEAKER_LABEL_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ShowSpeakerLabel")
            .getter(getter(StartStreamTranscriptionRequest::showSpeakerLabel))
            .setter(setter(Builder::showSpeakerLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-show-speaker-label").build()).build();

    private static final SdkField<Boolean> ENABLE_CHANNEL_IDENTIFICATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableChannelIdentification")
            .getter(getter(StartStreamTranscriptionRequest::enableChannelIdentification))
            .setter(setter(Builder::enableChannelIdentification))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-enable-channel-identification").build()).build();

    private static final SdkField<Integer> NUMBER_OF_CHANNELS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfChannels")
            .getter(getter(StartStreamTranscriptionRequest::numberOfChannels))
            .setter(setter(Builder::numberOfChannels))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-number-of-channels").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_CODE_FIELD,
            MEDIA_SAMPLE_RATE_HERTZ_FIELD, MEDIA_ENCODING_FIELD, VOCABULARY_NAME_FIELD, SESSION_ID_FIELD,
            VOCABULARY_FILTER_NAME_FIELD, VOCABULARY_FILTER_METHOD_FIELD, SHOW_SPEAKER_LABEL_FIELD,
            ENABLE_CHANNEL_IDENTIFICATION_FIELD, NUMBER_OF_CHANNELS_FIELD));

    private final String languageCode;

    private final Integer mediaSampleRateHertz;

    private final String mediaEncoding;

    private final String vocabularyName;

    private final String sessionId;

    private final String vocabularyFilterName;

    private final String vocabularyFilterMethod;

    private final Boolean showSpeakerLabel;

    private final Boolean enableChannelIdentification;

    private final Integer numberOfChannels;

    private StartStreamTranscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.languageCode = builder.languageCode;
        this.mediaSampleRateHertz = builder.mediaSampleRateHertz;
        this.mediaEncoding = builder.mediaEncoding;
        this.vocabularyName = builder.vocabularyName;
        this.sessionId = builder.sessionId;
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.vocabularyFilterMethod = builder.vocabularyFilterMethod;
        this.showSpeakerLabel = builder.showSpeakerLabel;
        this.enableChannelIdentification = builder.enableChannelIdentification;
        this.numberOfChannels = builder.numberOfChannels;
    }

    /**
     * <p>
     * Indicates the source language used in the input audio stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Indicates the source language used in the input audio stream.
     * @see LanguageCode
     */
    public LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * Indicates the source language used in the input audio stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Indicates the source language used in the input audio stream.
     * @see LanguageCode
     */
    public String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The sample rate, in Hertz, of the input audio. We suggest that you use 8000 Hz for low quality audio and 16000 Hz
     * for high quality audio.
     * </p>
     * 
     * @return The sample rate, in Hertz, of the input audio. We suggest that you use 8000 Hz for low quality audio and
     *         16000 Hz for high quality audio.
     */
    public Integer mediaSampleRateHertz() {
        return mediaSampleRateHertz;
    }

    /**
     * <p>
     * The encoding used for the input audio. <code>pcm</code> is the only valid value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaEncoding}
     * will return {@link MediaEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mediaEncodingAsString}.
     * </p>
     * 
     * @return The encoding used for the input audio. <code>pcm</code> is the only valid value.
     * @see MediaEncoding
     */
    public MediaEncoding mediaEncoding() {
        return MediaEncoding.fromValue(mediaEncoding);
    }

    /**
     * <p>
     * The encoding used for the input audio. <code>pcm</code> is the only valid value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaEncoding}
     * will return {@link MediaEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mediaEncodingAsString}.
     * </p>
     * 
     * @return The encoding used for the input audio. <code>pcm</code> is the only valid value.
     * @see MediaEncoding
     */
    public String mediaEncodingAsString() {
        return mediaEncoding;
    }

    /**
     * <p>
     * The name of the vocabulary to use when processing the transcription job.
     * </p>
     * 
     * @return The name of the vocabulary to use when processing the transcription job.
     */
    public String vocabularyName() {
        return vocabularyName;
    }

    /**
     * <p>
     * A identifier for the transcription session. Use this parameter when you want to retry a session. If you don't
     * provide a session ID, Amazon Transcribe will generate one for you and return it in the response.
     * </p>
     * 
     * @return A identifier for the transcription session. Use this parameter when you want to retry a session. If you
     *         don't provide a session ID, Amazon Transcribe will generate one for you and return it in the response.
     */
    public String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The name of the vocabulary filter you've created that is unique to your AWS account. Provide the name in this
     * field to successfully use it in a stream.
     * </p>
     * 
     * @return The name of the vocabulary filter you've created that is unique to your AWS account. Provide the name in
     *         this field to successfully use it in a stream.
     */
    public String vocabularyFilterName() {
        return vocabularyFilterName;
    }

    /**
     * <p>
     * The manner in which you use your vocabulary filter to filter words in your transcript. <code>Remove</code>
     * removes filtered words from your transcription results. <code>Mask</code> masks those words with a
     * <code>***</code> in your transcription results. <code>Tag</code> keeps the filtered words in your transcription
     * results and tags them. The tag appears as <code>VocabularyFilterMatch</code> equal to <code>True</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vocabularyFilterMethod} will return {@link VocabularyFilterMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #vocabularyFilterMethodAsString}.
     * </p>
     * 
     * @return The manner in which you use your vocabulary filter to filter words in your transcript.
     *         <code>Remove</code> removes filtered words from your transcription results. <code>Mask</code> masks those
     *         words with a <code>***</code> in your transcription results. <code>Tag</code> keeps the filtered words in
     *         your transcription results and tags them. The tag appears as <code>VocabularyFilterMatch</code> equal to
     *         <code>True</code>
     * @see VocabularyFilterMethod
     */
    public VocabularyFilterMethod vocabularyFilterMethod() {
        return VocabularyFilterMethod.fromValue(vocabularyFilterMethod);
    }

    /**
     * <p>
     * The manner in which you use your vocabulary filter to filter words in your transcript. <code>Remove</code>
     * removes filtered words from your transcription results. <code>Mask</code> masks those words with a
     * <code>***</code> in your transcription results. <code>Tag</code> keeps the filtered words in your transcription
     * results and tags them. The tag appears as <code>VocabularyFilterMatch</code> equal to <code>True</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vocabularyFilterMethod} will return {@link VocabularyFilterMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #vocabularyFilterMethodAsString}.
     * </p>
     * 
     * @return The manner in which you use your vocabulary filter to filter words in your transcript.
     *         <code>Remove</code> removes filtered words from your transcription results. <code>Mask</code> masks those
     *         words with a <code>***</code> in your transcription results. <code>Tag</code> keeps the filtered words in
     *         your transcription results and tags them. The tag appears as <code>VocabularyFilterMatch</code> equal to
     *         <code>True</code>
     * @see VocabularyFilterMethod
     */
    public String vocabularyFilterMethodAsString() {
        return vocabularyFilterMethod;
    }

    /**
     * <p>
     * When <code>true</code>, enables speaker identification in your real-time stream.
     * </p>
     * 
     * @return When <code>true</code>, enables speaker identification in your real-time stream.
     */
    public Boolean showSpeakerLabel() {
        return showSpeakerLabel;
    }

    /**
     * <p>
     * When <code>true</code>, instructs Amazon Transcribe to process each audio channel separately and then merge the
     * transcription output of each channel into a single transcription.
     * </p>
     * <p>
     * Amazon Transcribe also produces a transcription of each item. An item includes the start time, end time, and any
     * alternative transcriptions.
     * </p>
     * <p>
     * You can't set both <code>ShowSpeakerLabel</code> and <code>EnableChannelIdentification</code> in the same
     * request. If you set both, your request returns a <code>BadRequestException</code>.
     * </p>
     * 
     * @return When <code>true</code>, instructs Amazon Transcribe to process each audio channel separately and then
     *         merge the transcription output of each channel into a single transcription.</p>
     *         <p>
     *         Amazon Transcribe also produces a transcription of each item. An item includes the start time, end time,
     *         and any alternative transcriptions.
     *         </p>
     *         <p>
     *         You can't set both <code>ShowSpeakerLabel</code> and <code>EnableChannelIdentification</code> in the same
     *         request. If you set both, your request returns a <code>BadRequestException</code>.
     */
    public Boolean enableChannelIdentification() {
        return enableChannelIdentification;
    }

    /**
     * <p>
     * The number of channels that are in your audio stream.
     * </p>
     * 
     * @return The number of channels that are in your audio stream.
     */
    public Integer numberOfChannels() {
        return numberOfChannels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mediaSampleRateHertz());
        hashCode = 31 * hashCode + Objects.hashCode(mediaEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(showSpeakerLabel());
        hashCode = 31 * hashCode + Objects.hashCode(enableChannelIdentification());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfChannels());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartStreamTranscriptionRequest)) {
            return false;
        }
        StartStreamTranscriptionRequest other = (StartStreamTranscriptionRequest) obj;
        return Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(mediaSampleRateHertz(), other.mediaSampleRateHertz())
                && Objects.equals(mediaEncodingAsString(), other.mediaEncodingAsString())
                && Objects.equals(vocabularyName(), other.vocabularyName()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(vocabularyFilterName(), other.vocabularyFilterName())
                && Objects.equals(vocabularyFilterMethodAsString(), other.vocabularyFilterMethodAsString())
                && Objects.equals(showSpeakerLabel(), other.showSpeakerLabel())
                && Objects.equals(enableChannelIdentification(), other.enableChannelIdentification())
                && Objects.equals(numberOfChannels(), other.numberOfChannels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartStreamTranscriptionRequest").add("LanguageCode", languageCodeAsString())
                .add("MediaSampleRateHertz", mediaSampleRateHertz()).add("MediaEncoding", mediaEncodingAsString())
                .add("VocabularyName", vocabularyName()).add("SessionId", sessionId())
                .add("VocabularyFilterName", vocabularyFilterName())
                .add("VocabularyFilterMethod", vocabularyFilterMethodAsString()).add("ShowSpeakerLabel", showSpeakerLabel())
                .add("EnableChannelIdentification", enableChannelIdentification()).add("NumberOfChannels", numberOfChannels())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "MediaSampleRateHertz":
            return Optional.ofNullable(clazz.cast(mediaSampleRateHertz()));
        case "MediaEncoding":
            return Optional.ofNullable(clazz.cast(mediaEncodingAsString()));
        case "VocabularyName":
            return Optional.ofNullable(clazz.cast(vocabularyName()));
        case "SessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "VocabularyFilterName":
            return Optional.ofNullable(clazz.cast(vocabularyFilterName()));
        case "VocabularyFilterMethod":
            return Optional.ofNullable(clazz.cast(vocabularyFilterMethodAsString()));
        case "ShowSpeakerLabel":
            return Optional.ofNullable(clazz.cast(showSpeakerLabel()));
        case "EnableChannelIdentification":
            return Optional.ofNullable(clazz.cast(enableChannelIdentification()));
        case "NumberOfChannels":
            return Optional.ofNullable(clazz.cast(numberOfChannels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartStreamTranscriptionRequest, T> g) {
        return obj -> g.apply((StartStreamTranscriptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeStreamingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartStreamTranscriptionRequest> {
        /**
         * <p>
         * Indicates the source language used in the input audio stream.
         * </p>
         * 
         * @param languageCode
         *        Indicates the source language used in the input audio stream.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * Indicates the source language used in the input audio stream.
         * </p>
         * 
         * @param languageCode
         *        Indicates the source language used in the input audio stream.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * The sample rate, in Hertz, of the input audio. We suggest that you use 8000 Hz for low quality audio and
         * 16000 Hz for high quality audio.
         * </p>
         * 
         * @param mediaSampleRateHertz
         *        The sample rate, in Hertz, of the input audio. We suggest that you use 8000 Hz for low quality audio
         *        and 16000 Hz for high quality audio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaSampleRateHertz(Integer mediaSampleRateHertz);

        /**
         * <p>
         * The encoding used for the input audio. <code>pcm</code> is the only valid value.
         * </p>
         * 
         * @param mediaEncoding
         *        The encoding used for the input audio. <code>pcm</code> is the only valid value.
         * @see MediaEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaEncoding
         */
        Builder mediaEncoding(String mediaEncoding);

        /**
         * <p>
         * The encoding used for the input audio. <code>pcm</code> is the only valid value.
         * </p>
         * 
         * @param mediaEncoding
         *        The encoding used for the input audio. <code>pcm</code> is the only valid value.
         * @see MediaEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaEncoding
         */
        Builder mediaEncoding(MediaEncoding mediaEncoding);

        /**
         * <p>
         * The name of the vocabulary to use when processing the transcription job.
         * </p>
         * 
         * @param vocabularyName
         *        The name of the vocabulary to use when processing the transcription job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyName(String vocabularyName);

        /**
         * <p>
         * A identifier for the transcription session. Use this parameter when you want to retry a session. If you don't
         * provide a session ID, Amazon Transcribe will generate one for you and return it in the response.
         * </p>
         * 
         * @param sessionId
         *        A identifier for the transcription session. Use this parameter when you want to retry a session. If
         *        you don't provide a session ID, Amazon Transcribe will generate one for you and return it in the
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The name of the vocabulary filter you've created that is unique to your AWS account. Provide the name in this
         * field to successfully use it in a stream.
         * </p>
         * 
         * @param vocabularyFilterName
         *        The name of the vocabulary filter you've created that is unique to your AWS account. Provide the name
         *        in this field to successfully use it in a stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterName(String vocabularyFilterName);

        /**
         * <p>
         * The manner in which you use your vocabulary filter to filter words in your transcript. <code>Remove</code>
         * removes filtered words from your transcription results. <code>Mask</code> masks those words with a
         * <code>***</code> in your transcription results. <code>Tag</code> keeps the filtered words in your
         * transcription results and tags them. The tag appears as <code>VocabularyFilterMatch</code> equal to
         * <code>True</code>
         * </p>
         * 
         * @param vocabularyFilterMethod
         *        The manner in which you use your vocabulary filter to filter words in your transcript.
         *        <code>Remove</code> removes filtered words from your transcription results. <code>Mask</code> masks
         *        those words with a <code>***</code> in your transcription results. <code>Tag</code> keeps the filtered
         *        words in your transcription results and tags them. The tag appears as
         *        <code>VocabularyFilterMatch</code> equal to <code>True</code>
         * @see VocabularyFilterMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyFilterMethod
         */
        Builder vocabularyFilterMethod(String vocabularyFilterMethod);

        /**
         * <p>
         * The manner in which you use your vocabulary filter to filter words in your transcript. <code>Remove</code>
         * removes filtered words from your transcription results. <code>Mask</code> masks those words with a
         * <code>***</code> in your transcription results. <code>Tag</code> keeps the filtered words in your
         * transcription results and tags them. The tag appears as <code>VocabularyFilterMatch</code> equal to
         * <code>True</code>
         * </p>
         * 
         * @param vocabularyFilterMethod
         *        The manner in which you use your vocabulary filter to filter words in your transcript.
         *        <code>Remove</code> removes filtered words from your transcription results. <code>Mask</code> masks
         *        those words with a <code>***</code> in your transcription results. <code>Tag</code> keeps the filtered
         *        words in your transcription results and tags them. The tag appears as
         *        <code>VocabularyFilterMatch</code> equal to <code>True</code>
         * @see VocabularyFilterMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyFilterMethod
         */
        Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod);

        /**
         * <p>
         * When <code>true</code>, enables speaker identification in your real-time stream.
         * </p>
         * 
         * @param showSpeakerLabel
         *        When <code>true</code>, enables speaker identification in your real-time stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder showSpeakerLabel(Boolean showSpeakerLabel);

        /**
         * <p>
         * When <code>true</code>, instructs Amazon Transcribe to process each audio channel separately and then merge
         * the transcription output of each channel into a single transcription.
         * </p>
         * <p>
         * Amazon Transcribe also produces a transcription of each item. An item includes the start time, end time, and
         * any alternative transcriptions.
         * </p>
         * <p>
         * You can't set both <code>ShowSpeakerLabel</code> and <code>EnableChannelIdentification</code> in the same
         * request. If you set both, your request returns a <code>BadRequestException</code>.
         * </p>
         * 
         * @param enableChannelIdentification
         *        When <code>true</code>, instructs Amazon Transcribe to process each audio channel separately and then
         *        merge the transcription output of each channel into a single transcription.</p>
         *        <p>
         *        Amazon Transcribe also produces a transcription of each item. An item includes the start time, end
         *        time, and any alternative transcriptions.
         *        </p>
         *        <p>
         *        You can't set both <code>ShowSpeakerLabel</code> and <code>EnableChannelIdentification</code> in the
         *        same request. If you set both, your request returns a <code>BadRequestException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableChannelIdentification(Boolean enableChannelIdentification);

        /**
         * <p>
         * The number of channels that are in your audio stream.
         * </p>
         * 
         * @param numberOfChannels
         *        The number of channels that are in your audio stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfChannels(Integer numberOfChannels);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranscribeStreamingRequest.BuilderImpl implements Builder {
        private String languageCode;

        private Integer mediaSampleRateHertz;

        private String mediaEncoding;

        private String vocabularyName;

        private String sessionId;

        private String vocabularyFilterName;

        private String vocabularyFilterMethod;

        private Boolean showSpeakerLabel;

        private Boolean enableChannelIdentification;

        private Integer numberOfChannels;

        private BuilderImpl() {
        }

        private BuilderImpl(StartStreamTranscriptionRequest model) {
            super(model);
            languageCode(model.languageCode);
            mediaSampleRateHertz(model.mediaSampleRateHertz);
            mediaEncoding(model.mediaEncoding);
            vocabularyName(model.vocabularyName);
            sessionId(model.sessionId);
            vocabularyFilterName(model.vocabularyFilterName);
            vocabularyFilterMethod(model.vocabularyFilterMethod);
            showSpeakerLabel(model.showSpeakerLabel);
            enableChannelIdentification(model.enableChannelIdentification);
            numberOfChannels(model.numberOfChannels);
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final Integer getMediaSampleRateHertz() {
            return mediaSampleRateHertz;
        }

        @Override
        public final Builder mediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
            return this;
        }

        public final void setMediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
        }

        public final String getMediaEncoding() {
            return mediaEncoding;
        }

        @Override
        public final Builder mediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
            return this;
        }

        @Override
        public final Builder mediaEncoding(MediaEncoding mediaEncoding) {
            this.mediaEncoding(mediaEncoding == null ? null : mediaEncoding.toString());
            return this;
        }

        public final void setMediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
        }

        public final String getVocabularyName() {
            return vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        public final String getSessionId() {
            return sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public final String getVocabularyFilterName() {
            return vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        public final String getVocabularyFilterMethod() {
            return vocabularyFilterMethod;
        }

        @Override
        public final Builder vocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
            return this;
        }

        @Override
        public final Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod) {
            this.vocabularyFilterMethod(vocabularyFilterMethod == null ? null : vocabularyFilterMethod.toString());
            return this;
        }

        public final void setVocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
        }

        public final Boolean getShowSpeakerLabel() {
            return showSpeakerLabel;
        }

        @Override
        public final Builder showSpeakerLabel(Boolean showSpeakerLabel) {
            this.showSpeakerLabel = showSpeakerLabel;
            return this;
        }

        public final void setShowSpeakerLabel(Boolean showSpeakerLabel) {
            this.showSpeakerLabel = showSpeakerLabel;
        }

        public final Boolean getEnableChannelIdentification() {
            return enableChannelIdentification;
        }

        @Override
        public final Builder enableChannelIdentification(Boolean enableChannelIdentification) {
            this.enableChannelIdentification = enableChannelIdentification;
            return this;
        }

        public final void setEnableChannelIdentification(Boolean enableChannelIdentification) {
            this.enableChannelIdentification = enableChannelIdentification;
        }

        public final Integer getNumberOfChannels() {
            return numberOfChannels;
        }

        @Override
        public final Builder numberOfChannels(Integer numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
            return this;
        }

        public final void setNumberOfChannels(Integer numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartStreamTranscriptionRequest build() {
            return new StartStreamTranscriptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
