/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The results of transcribing a portion of the input audio stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MedicalResult implements SdkPojo, Serializable, ToCopyableBuilder<MedicalResult.Builder, MedicalResult> {
    private static final SdkField<String> RESULT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultId").getter(getter(MedicalResult::resultId)).setter(setter(Builder::resultId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultId").build()).build();

    private static final SdkField<Double> START_TIME_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("StartTime").getter(getter(MedicalResult::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Double> END_TIME_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("EndTime").getter(getter(MedicalResult::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Boolean> IS_PARTIAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsPartial").getter(getter(MedicalResult::isPartial)).setter(setter(Builder::isPartial))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPartial").build()).build();

    private static final SdkField<List<MedicalAlternative>> ALTERNATIVES_FIELD = SdkField
            .<List<MedicalAlternative>> builder(MarshallingType.LIST)
            .memberName("Alternatives")
            .getter(getter(MedicalResult::alternatives))
            .setter(setter(Builder::alternatives))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alternatives").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MedicalAlternative> builder(MarshallingType.SDK_POJO)
                                            .constructor(MedicalAlternative::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelId").getter(getter(MedicalResult::channelId)).setter(setter(Builder::channelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_ID_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, IS_PARTIAL_FIELD, ALTERNATIVES_FIELD, CHANNEL_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resultId;

    private final Double startTime;

    private final Double endTime;

    private final Boolean isPartial;

    private final List<MedicalAlternative> alternatives;

    private final String channelId;

    private MedicalResult(BuilderImpl builder) {
        this.resultId = builder.resultId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.isPartial = builder.isPartial;
        this.alternatives = builder.alternatives;
        this.channelId = builder.channelId;
    }

    /**
     * <p>
     * A unique identifier for the result.
     * </p>
     * 
     * @return A unique identifier for the result.
     */
    public String resultId() {
        return resultId;
    }

    /**
     * <p>
     * The time, in seconds, from the beginning of the audio stream to the beginning of the result.
     * </p>
     * 
     * @return The time, in seconds, from the beginning of the audio stream to the beginning of the result.
     */
    public Double startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time, in seconds, from the beginning of the audio stream to the end of the result.
     * </p>
     * 
     * @return The time, in seconds, from the beginning of the audio stream to the end of the result.
     */
    public Double endTime() {
        return endTime;
    }

    /**
     * <p>
     * Amazon Transcribe Medical divides the incoming audio stream into segments at natural points in the audio.
     * Transcription results are returned based on these segments.
     * </p>
     * <p>
     * The <code>IsPartial</code> field is <code>true</code> to indicate that Amazon Transcribe Medical has additional
     * transcription data to send. The <code>IsPartial</code> field is <code>false</code> to indicate that this is the
     * last transcription result for the segment.
     * </p>
     * 
     * @return Amazon Transcribe Medical divides the incoming audio stream into segments at natural points in the audio.
     *         Transcription results are returned based on these segments.</p>
     *         <p>
     *         The <code>IsPartial</code> field is <code>true</code> to indicate that Amazon Transcribe Medical has
     *         additional transcription data to send. The <code>IsPartial</code> field is <code>false</code> to indicate
     *         that this is the last transcription result for the segment.
     */
    public Boolean isPartial() {
        return isPartial;
    }

    /**
     * Returns true if the Alternatives property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAlternatives() {
        return alternatives != null && !(alternatives instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of possible transcriptions of the audio. Each alternative typically contains one <code>Item</code> that
     * contains the result of the transcription.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAlternatives()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of possible transcriptions of the audio. Each alternative typically contains one <code>Item</code>
     *         that contains the result of the transcription.
     */
    public List<MedicalAlternative> alternatives() {
        return alternatives;
    }

    /**
     * <p>
     * When channel identification is enabled, Amazon Transcribe Medical transcribes the speech from each audio channel
     * separately.
     * </p>
     * <p>
     * You can use <code>ChannelId</code> to retrieve the transcription results for a single channel in your audio
     * stream.
     * </p>
     * 
     * @return When channel identification is enabled, Amazon Transcribe Medical transcribes the speech from each audio
     *         channel separately.</p>
     *         <p>
     *         You can use <code>ChannelId</code> to retrieve the transcription results for a single channel in your
     *         audio stream.
     */
    public String channelId() {
        return channelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resultId());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(isPartial());
        hashCode = 31 * hashCode + Objects.hashCode(hasAlternatives() ? alternatives() : null);
        hashCode = 31 * hashCode + Objects.hashCode(channelId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalResult)) {
            return false;
        }
        MedicalResult other = (MedicalResult) obj;
        return Objects.equals(resultId(), other.resultId()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(isPartial(), other.isPartial())
                && hasAlternatives() == other.hasAlternatives() && Objects.equals(alternatives(), other.alternatives())
                && Objects.equals(channelId(), other.channelId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MedicalResult").add("ResultId", resultId()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("IsPartial", isPartial())
                .add("Alternatives", hasAlternatives() ? alternatives() : null).add("ChannelId", channelId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResultId":
            return Optional.ofNullable(clazz.cast(resultId()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "IsPartial":
            return Optional.ofNullable(clazz.cast(isPartial()));
        case "Alternatives":
            return Optional.ofNullable(clazz.cast(alternatives()));
        case "ChannelId":
            return Optional.ofNullable(clazz.cast(channelId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MedicalResult, T> g) {
        return obj -> g.apply((MedicalResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MedicalResult> {
        /**
         * <p>
         * A unique identifier for the result.
         * </p>
         * 
         * @param resultId
         *        A unique identifier for the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultId(String resultId);

        /**
         * <p>
         * The time, in seconds, from the beginning of the audio stream to the beginning of the result.
         * </p>
         * 
         * @param startTime
         *        The time, in seconds, from the beginning of the audio stream to the beginning of the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Double startTime);

        /**
         * <p>
         * The time, in seconds, from the beginning of the audio stream to the end of the result.
         * </p>
         * 
         * @param endTime
         *        The time, in seconds, from the beginning of the audio stream to the end of the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Double endTime);

        /**
         * <p>
         * Amazon Transcribe Medical divides the incoming audio stream into segments at natural points in the audio.
         * Transcription results are returned based on these segments.
         * </p>
         * <p>
         * The <code>IsPartial</code> field is <code>true</code> to indicate that Amazon Transcribe Medical has
         * additional transcription data to send. The <code>IsPartial</code> field is <code>false</code> to indicate
         * that this is the last transcription result for the segment.
         * </p>
         * 
         * @param isPartial
         *        Amazon Transcribe Medical divides the incoming audio stream into segments at natural points in the
         *        audio. Transcription results are returned based on these segments.</p>
         *        <p>
         *        The <code>IsPartial</code> field is <code>true</code> to indicate that Amazon Transcribe Medical has
         *        additional transcription data to send. The <code>IsPartial</code> field is <code>false</code> to
         *        indicate that this is the last transcription result for the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPartial(Boolean isPartial);

        /**
         * <p>
         * A list of possible transcriptions of the audio. Each alternative typically contains one <code>Item</code>
         * that contains the result of the transcription.
         * </p>
         * 
         * @param alternatives
         *        A list of possible transcriptions of the audio. Each alternative typically contains one
         *        <code>Item</code> that contains the result of the transcription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alternatives(Collection<MedicalAlternative> alternatives);

        /**
         * <p>
         * A list of possible transcriptions of the audio. Each alternative typically contains one <code>Item</code>
         * that contains the result of the transcription.
         * </p>
         * 
         * @param alternatives
         *        A list of possible transcriptions of the audio. Each alternative typically contains one
         *        <code>Item</code> that contains the result of the transcription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alternatives(MedicalAlternative... alternatives);

        /**
         * <p>
         * A list of possible transcriptions of the audio. Each alternative typically contains one <code>Item</code>
         * that contains the result of the transcription.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MedicalAlternative>.Builder} avoiding the
         * need to create one manually via {@link List<MedicalAlternative>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MedicalAlternative>.Builder#build()} is called immediately
         * and its result is passed to {@link #alternatives(List<MedicalAlternative>)}.
         * 
         * @param alternatives
         *        a consumer that will call methods on {@link List<MedicalAlternative>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alternatives(List<MedicalAlternative>)
         */
        Builder alternatives(Consumer<MedicalAlternative.Builder>... alternatives);

        /**
         * <p>
         * When channel identification is enabled, Amazon Transcribe Medical transcribes the speech from each audio
         * channel separately.
         * </p>
         * <p>
         * You can use <code>ChannelId</code> to retrieve the transcription results for a single channel in your audio
         * stream.
         * </p>
         * 
         * @param channelId
         *        When channel identification is enabled, Amazon Transcribe Medical transcribes the speech from each
         *        audio channel separately.</p>
         *        <p>
         *        You can use <code>ChannelId</code> to retrieve the transcription results for a single channel in your
         *        audio stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelId(String channelId);
    }

    static final class BuilderImpl implements Builder {
        private String resultId;

        private Double startTime;

        private Double endTime;

        private Boolean isPartial;

        private List<MedicalAlternative> alternatives = DefaultSdkAutoConstructList.getInstance();

        private String channelId;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalResult model) {
            resultId(model.resultId);
            startTime(model.startTime);
            endTime(model.endTime);
            isPartial(model.isPartial);
            alternatives(model.alternatives);
            channelId(model.channelId);
        }

        public final String getResultId() {
            return resultId;
        }

        @Override
        public final Builder resultId(String resultId) {
            this.resultId = resultId;
            return this;
        }

        public final void setResultId(String resultId) {
            this.resultId = resultId;
        }

        public final Double getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Double startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Double startTime) {
            this.startTime = startTime;
        }

        public final Double getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Double endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Double endTime) {
            this.endTime = endTime;
        }

        public final Boolean getIsPartial() {
            return isPartial;
        }

        @Override
        public final Builder isPartial(Boolean isPartial) {
            this.isPartial = isPartial;
            return this;
        }

        public final void setIsPartial(Boolean isPartial) {
            this.isPartial = isPartial;
        }

        public final Collection<MedicalAlternative.Builder> getAlternatives() {
            if (alternatives instanceof SdkAutoConstructList) {
                return null;
            }
            return alternatives != null ? alternatives.stream().map(MedicalAlternative::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder alternatives(Collection<MedicalAlternative> alternatives) {
            this.alternatives = MedicalAlternativeListCopier.copy(alternatives);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternatives(MedicalAlternative... alternatives) {
            alternatives(Arrays.asList(alternatives));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternatives(Consumer<MedicalAlternative.Builder>... alternatives) {
            alternatives(Stream.of(alternatives).map(c -> MedicalAlternative.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAlternatives(Collection<MedicalAlternative.BuilderImpl> alternatives) {
            this.alternatives = MedicalAlternativeListCopier.copyFromBuilder(alternatives);
        }

        public final String getChannelId() {
            return channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public MedicalResult build() {
            return new MedicalResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
