/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The medical transcript in a <a>MedicalTranscriptEvent</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MedicalTranscript implements SdkPojo, Serializable,
        ToCopyableBuilder<MedicalTranscript.Builder, MedicalTranscript> {
    private static final SdkField<List<MedicalResult>> RESULTS_FIELD = SdkField
            .<List<MedicalResult>> builder(MarshallingType.LIST)
            .memberName("Results")
            .getter(getter(MedicalTranscript::results))
            .setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MedicalResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(MedicalResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<MedicalResult> results;

    private MedicalTranscript(BuilderImpl builder) {
        this.results = builder.results;
    }

    /**
     * Returns true if the Results property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResults() {
        return results != null && !(results instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * <a>MedicalResult</a> objects that contain the results of transcribing a portion of the input audio stream. The
     * array can be empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResults()} to see if a value was sent in this field.
     * </p>
     * 
     * @return <a>MedicalResult</a> objects that contain the results of transcribing a portion of the input audio
     *         stream. The array can be empty.
     */
    public List<MedicalResult> results() {
        return results;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasResults() ? results() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalTranscript)) {
            return false;
        }
        MedicalTranscript other = (MedicalTranscript) obj;
        return hasResults() == other.hasResults() && Objects.equals(results(), other.results());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MedicalTranscript").add("Results", hasResults() ? results() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Results":
            return Optional.ofNullable(clazz.cast(results()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MedicalTranscript, T> g) {
        return obj -> g.apply((MedicalTranscript) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MedicalTranscript> {
        /**
         * <p>
         * <a>MedicalResult</a> objects that contain the results of transcribing a portion of the input audio stream.
         * The array can be empty.
         * </p>
         * 
         * @param results
         *        <a>MedicalResult</a> objects that contain the results of transcribing a portion of the input audio
         *        stream. The array can be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<MedicalResult> results);

        /**
         * <p>
         * <a>MedicalResult</a> objects that contain the results of transcribing a portion of the input audio stream.
         * The array can be empty.
         * </p>
         * 
         * @param results
         *        <a>MedicalResult</a> objects that contain the results of transcribing a portion of the input audio
         *        stream. The array can be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(MedicalResult... results);

        /**
         * <p>
         * <a>MedicalResult</a> objects that contain the results of transcribing a portion of the input audio stream.
         * The array can be empty.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MedicalResult>.Builder} avoiding the need
         * to create one manually via {@link List<MedicalResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MedicalResult>.Builder#build()} is called immediately and
         * its result is passed to {@link #results(List<MedicalResult>)}.
         * 
         * @param results
         *        a consumer that will call methods on {@link List<MedicalResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #results(List<MedicalResult>)
         */
        Builder results(Consumer<MedicalResult.Builder>... results);
    }

    static final class BuilderImpl implements Builder {
        private List<MedicalResult> results = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalTranscript model) {
            results(model.results);
        }

        public final Collection<MedicalResult.Builder> getResults() {
            if (results instanceof SdkAutoConstructList) {
                return null;
            }
            return results != null ? results.stream().map(MedicalResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder results(Collection<MedicalResult> results) {
            this.results = MedicalResultListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(MedicalResult... results) {
            results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<MedicalResult.Builder>... results) {
            results(Stream.of(results).map(c -> MedicalResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResults(Collection<MedicalResult.BuilderImpl> results) {
            this.results = MedicalResultListCopier.copyFromBuilder(results);
        }

        @Override
        public MedicalTranscript build() {
            return new MedicalTranscript(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
