/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of possible transcriptions for the audio.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Alternative implements SdkPojo, Serializable, ToCopyableBuilder<Alternative.Builder, Alternative> {
    private static final SdkField<String> TRANSCRIPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Transcript").getter(getter(Alternative::transcript)).setter(setter(Builder::transcript))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transcript").build()).build();

    private static final SdkField<List<Item>> ITEMS_FIELD = SdkField
            .<List<Item>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(Alternative::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Item> builder(MarshallingType.SDK_POJO)
                                            .constructor(Item::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Entity>> ENTITIES_FIELD = SdkField
            .<List<Entity>> builder(MarshallingType.LIST)
            .memberName("Entities")
            .getter(getter(Alternative::entities))
            .setter(setter(Builder::entities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Entity> builder(MarshallingType.SDK_POJO)
                                            .constructor(Entity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPT_FIELD, ITEMS_FIELD,
            ENTITIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transcript;

    private final List<Item> items;

    private final List<Entity> entities;

    private Alternative(BuilderImpl builder) {
        this.transcript = builder.transcript;
        this.items = builder.items;
        this.entities = builder.entities;
    }

    /**
     * <p>
     * The text that was transcribed from the audio.
     * </p>
     * 
     * @return The text that was transcribed from the audio.
     */
    public final String transcript() {
        return transcript;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more alternative interpretations of the input audio.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return One or more alternative interpretations of the input audio.
     */
    public final List<Item> items() {
        return items;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntities() {
        return entities != null && !(entities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the entities identified as personally identifiable information (PII) in the transcription output.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntities} method.
     * </p>
     * 
     * @return Contains the entities identified as personally identifiable information (PII) in the transcription
     *         output.
     */
    public final List<Entity> entities() {
        return entities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transcript());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEntities() ? entities() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alternative)) {
            return false;
        }
        Alternative other = (Alternative) obj;
        return Objects.equals(transcript(), other.transcript()) && hasItems() == other.hasItems()
                && Objects.equals(items(), other.items()) && hasEntities() == other.hasEntities()
                && Objects.equals(entities(), other.entities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Alternative").add("Transcript", transcript()).add("Items", hasItems() ? items() : null)
                .add("Entities", hasEntities() ? entities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Transcript":
            return Optional.ofNullable(clazz.cast(transcript()));
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        case "Entities":
            return Optional.ofNullable(clazz.cast(entities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Alternative, T> g) {
        return obj -> g.apply((Alternative) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Alternative> {
        /**
         * <p>
         * The text that was transcribed from the audio.
         * </p>
         * 
         * @param transcript
         *        The text that was transcribed from the audio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcript(String transcript);

        /**
         * <p>
         * One or more alternative interpretations of the input audio.
         * </p>
         * 
         * @param items
         *        One or more alternative interpretations of the input audio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<Item> items);

        /**
         * <p>
         * One or more alternative interpretations of the input audio.
         * </p>
         * 
         * @param items
         *        One or more alternative interpretations of the input audio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Item... items);

        /**
         * <p>
         * One or more alternative interpretations of the input audio.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Item>.Builder} avoiding the need to
         * create one manually via {@link List<Item>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Item>.Builder#build()} is called immediately and its result
         * is passed to {@link #items(List<Item>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<Item>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<Item>)
         */
        Builder items(Consumer<Item.Builder>... items);

        /**
         * <p>
         * Contains the entities identified as personally identifiable information (PII) in the transcription output.
         * </p>
         * 
         * @param entities
         *        Contains the entities identified as personally identifiable information (PII) in the transcription
         *        output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(Collection<Entity> entities);

        /**
         * <p>
         * Contains the entities identified as personally identifiable information (PII) in the transcription output.
         * </p>
         * 
         * @param entities
         *        Contains the entities identified as personally identifiable information (PII) in the transcription
         *        output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(Entity... entities);

        /**
         * <p>
         * Contains the entities identified as personally identifiable information (PII) in the transcription output.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Entity>.Builder} avoiding the need
         * to create one manually via {@link List<Entity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Entity>.Builder#build()} is called immediately and its
         * result is passed to {@link #entities(List<Entity>)}.
         * 
         * @param entities
         *        a consumer that will call methods on {@link List<Entity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entities(List<Entity>)
         */
        Builder entities(Consumer<Entity.Builder>... entities);
    }

    static final class BuilderImpl implements Builder {
        private String transcript;

        private List<Item> items = DefaultSdkAutoConstructList.getInstance();

        private List<Entity> entities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Alternative model) {
            transcript(model.transcript);
            items(model.items);
            entities(model.entities);
        }

        public final String getTranscript() {
            return transcript;
        }

        public final void setTranscript(String transcript) {
            this.transcript = transcript;
        }

        @Override
        @Transient
        public final Builder transcript(String transcript) {
            this.transcript = transcript;
            return this;
        }

        public final List<Item.Builder> getItems() {
            List<Item.Builder> result = ItemListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<Item.BuilderImpl> items) {
            this.items = ItemListCopier.copyFromBuilder(items);
        }

        @Override
        @Transient
        public final Builder items(Collection<Item> items) {
            this.items = ItemListCopier.copy(items);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder items(Item... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder items(Consumer<Item.Builder>... items) {
            items(Stream.of(items).map(c -> Item.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Entity.Builder> getEntities() {
            List<Entity.Builder> result = EntityListCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<Entity.BuilderImpl> entities) {
            this.entities = EntityListCopier.copyFromBuilder(entities);
        }

        @Override
        @Transient
        public final Builder entities(Collection<Entity> entities) {
            this.entities = EntityListCopier.copy(entities);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entities(Entity... entities) {
            entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entities(Consumer<Entity.Builder>... entities) {
            entities(Stream.of(entities).map(c -> Entity.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Alternative build() {
            return new Alternative(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
