/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a set of transcription results from the server to the client. It contains one or more segments of the
 * transcription.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TranscriptEvent implements SdkPojo, Serializable, ToCopyableBuilder<TranscriptEvent.Builder, TranscriptEvent>,
        TranscriptResultStream {
    private static final SdkField<Transcript> TRANSCRIPT_FIELD = SdkField.<Transcript> builder(MarshallingType.SDK_POJO)
            .memberName("Transcript").getter(getter(TranscriptEvent::transcript)).setter(setter(Builder::transcript))
            .constructor(Transcript::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transcript").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Transcript transcript;

    protected TranscriptEvent(BuilderImpl builder) {
        this.transcript = builder.transcript;
    }

    /**
     * <p>
     * The transcription of the audio stream. The transcription is composed of all of the items in the results list.
     * </p>
     * 
     * @return The transcription of the audio stream. The transcription is composed of all of the items in the results
     *         list.
     */
    public final Transcript transcript() {
        return transcript;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transcript());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranscriptEvent)) {
            return false;
        }
        TranscriptEvent other = (TranscriptEvent) obj;
        return Objects.equals(transcript(), other.transcript());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TranscriptEvent").add("Transcript", transcript()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Transcript":
            return Optional.ofNullable(clazz.cast(transcript()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final TranscriptEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TranscriptEvent, T> g) {
        return obj -> g.apply((TranscriptEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Override
    public TranscriptResultStream.EventType sdkEventType() {
        return TranscriptResultStream.EventType.TRANSCRIPT_EVENT;
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link TranscriptEvent}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(StartStreamTranscriptionResponseHandler.Visitor visitor) {
        visitor.visit(this);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TranscriptEvent> {
        /**
         * <p>
         * The transcription of the audio stream. The transcription is composed of all of the items in the results list.
         * </p>
         * 
         * @param transcript
         *        The transcription of the audio stream. The transcription is composed of all of the items in the
         *        results list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcript(Transcript transcript);

        /**
         * <p>
         * The transcription of the audio stream. The transcription is composed of all of the items in the results list.
         * </p>
         * This is a convenience method that creates an instance of the {@link Transcript.Builder} avoiding the need to
         * create one manually via {@link Transcript#builder()}.
         *
         * When the {@link Consumer} completes, {@link Transcript.Builder#build()} is called immediately and its result
         * is passed to {@link #transcript(Transcript)}.
         * 
         * @param transcript
         *        a consumer that will call methods on {@link Transcript.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transcript(Transcript)
         */
        default Builder transcript(Consumer<Transcript.Builder> transcript) {
            return transcript(Transcript.builder().applyMutation(transcript).build());
        }
    }

    protected static class BuilderImpl implements Builder {
        private Transcript transcript;

        protected BuilderImpl() {
        }

        protected BuilderImpl(TranscriptEvent model) {
            transcript(model.transcript);
        }

        public final Transcript.Builder getTranscript() {
            return transcript != null ? transcript.toBuilder() : null;
        }

        public final void setTranscript(Transcript.BuilderImpl transcript) {
            this.transcript = transcript != null ? transcript.build() : null;
        }

        @Override
        public final Builder transcript(Transcript transcript) {
            this.transcript = transcript;
            return this;
        }

        @Override
        public TranscriptEvent build() {
            return new TranscriptEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
