/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMedicalStreamTranscriptionResponse extends TranscribeStreamingResponse implements
        ToCopyableBuilder<StartMedicalStreamTranscriptionResponse.Builder, StartMedicalStreamTranscriptionResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(StartMedicalStreamTranscriptionResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-request-id").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode")
            .getter(getter(StartMedicalStreamTranscriptionResponse::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-language-code")
                    .build()).build();

    private static final SdkField<Integer> MEDIA_SAMPLE_RATE_HERTZ_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MediaSampleRateHertz")
            .getter(getter(StartMedicalStreamTranscriptionResponse::mediaSampleRateHertz))
            .setter(setter(Builder::mediaSampleRateHertz))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-sample-rate")
                    .build()).build();

    private static final SdkField<String> MEDIA_ENCODING_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MediaEncoding")
            .getter(getter(StartMedicalStreamTranscriptionResponse::mediaEncodingAsString))
            .setter(setter(Builder::mediaEncoding))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-media-encoding")
                    .build()).build();

    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VocabularyName")
            .getter(getter(StartMedicalStreamTranscriptionResponse::vocabularyName))
            .setter(setter(Builder::vocabularyName))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-vocabulary-name")
                    .build()).build();

    private static final SdkField<String> SPECIALTY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Specialty")
            .getter(getter(StartMedicalStreamTranscriptionResponse::specialtyAsString))
            .setter(setter(Builder::specialty))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-specialty").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(StartMedicalStreamTranscriptionResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-type").build())
            .build();

    private static final SdkField<Boolean> SHOW_SPEAKER_LABEL_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ShowSpeakerLabel")
            .getter(getter(StartMedicalStreamTranscriptionResponse::showSpeakerLabel))
            .setter(setter(Builder::showSpeakerLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-show-speaker-label").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SessionId")
            .getter(getter(StartMedicalStreamTranscriptionResponse::sessionId))
            .setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-session-id")
                    .build()).build();

    private static final SdkField<Boolean> ENABLE_CHANNEL_IDENTIFICATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableChannelIdentification")
            .getter(getter(StartMedicalStreamTranscriptionResponse::enableChannelIdentification))
            .setter(setter(Builder::enableChannelIdentification))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-enable-channel-identification").build()).build();

    private static final SdkField<Integer> NUMBER_OF_CHANNELS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfChannels")
            .getter(getter(StartMedicalStreamTranscriptionResponse::numberOfChannels))
            .setter(setter(Builder::numberOfChannels))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-number-of-channels").build()).build();

    private static final SdkField<String> CONTENT_IDENTIFICATION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ContentIdentificationType")
            .getter(getter(StartMedicalStreamTranscriptionResponse::contentIdentificationTypeAsString))
            .setter(setter(Builder::contentIdentificationType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-content-identification-type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            LANGUAGE_CODE_FIELD, MEDIA_SAMPLE_RATE_HERTZ_FIELD, MEDIA_ENCODING_FIELD, VOCABULARY_NAME_FIELD, SPECIALTY_FIELD,
            TYPE_FIELD, SHOW_SPEAKER_LABEL_FIELD, SESSION_ID_FIELD, ENABLE_CHANNEL_IDENTIFICATION_FIELD,
            NUMBER_OF_CHANNELS_FIELD, CONTENT_IDENTIFICATION_TYPE_FIELD));

    private final String requestId;

    private final String languageCode;

    private final Integer mediaSampleRateHertz;

    private final String mediaEncoding;

    private final String vocabularyName;

    private final String specialty;

    private final String type;

    private final Boolean showSpeakerLabel;

    private final String sessionId;

    private final Boolean enableChannelIdentification;

    private final Integer numberOfChannels;

    private final String contentIdentificationType;

    private StartMedicalStreamTranscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.requestId = builder.requestId;
        this.languageCode = builder.languageCode;
        this.mediaSampleRateHertz = builder.mediaSampleRateHertz;
        this.mediaEncoding = builder.mediaEncoding;
        this.vocabularyName = builder.vocabularyName;
        this.specialty = builder.specialty;
        this.type = builder.type;
        this.showSpeakerLabel = builder.showSpeakerLabel;
        this.sessionId = builder.sessionId;
        this.enableChannelIdentification = builder.enableChannelIdentification;
        this.numberOfChannels = builder.numberOfChannels;
        this.contentIdentificationType = builder.contentIdentificationType;
    }

    /**
     * <p>
     * An identifier for the streaming transcription.
     * </p>
     * 
     * @return An identifier for the streaming transcription.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The language code for the response transcript. For Amazon Transcribe Medical, this is US English (en-US).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code for the response transcript. For Amazon Transcribe Medical, this is US English (en-US).
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code for the response transcript. For Amazon Transcribe Medical, this is US English (en-US).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code for the response transcript. For Amazon Transcribe Medical, this is US English (en-US).
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The sample rate of the input audio in Hertz. Valid value: 16000 Hz.
     * </p>
     * 
     * @return The sample rate of the input audio in Hertz. Valid value: 16000 Hz.
     */
    public final Integer mediaSampleRateHertz() {
        return mediaSampleRateHertz;
    }

    /**
     * <p>
     * The encoding used for the input audio stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaEncoding}
     * will return {@link MediaEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mediaEncodingAsString}.
     * </p>
     * 
     * @return The encoding used for the input audio stream.
     * @see MediaEncoding
     */
    public final MediaEncoding mediaEncoding() {
        return MediaEncoding.fromValue(mediaEncoding);
    }

    /**
     * <p>
     * The encoding used for the input audio stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaEncoding}
     * will return {@link MediaEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mediaEncodingAsString}.
     * </p>
     * 
     * @return The encoding used for the input audio stream.
     * @see MediaEncoding
     */
    public final String mediaEncodingAsString() {
        return mediaEncoding;
    }

    /**
     * <p>
     * The name of the vocabulary used when processing the stream.
     * </p>
     * 
     * @return The name of the vocabulary used when processing the stream.
     */
    public final String vocabularyName() {
        return vocabularyName;
    }

    /**
     * <p>
     * The specialty in the medical domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #specialty} will
     * return {@link Specialty#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #specialtyAsString}.
     * </p>
     * 
     * @return The specialty in the medical domain.
     * @see Specialty
     */
    public final Specialty specialty() {
        return Specialty.fromValue(specialty);
    }

    /**
     * <p>
     * The specialty in the medical domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #specialty} will
     * return {@link Specialty#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #specialtyAsString}.
     * </p>
     * 
     * @return The specialty in the medical domain.
     * @see Specialty
     */
    public final String specialtyAsString() {
        return specialty;
    }

    /**
     * <p>
     * The type of audio that was transcribed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of audio that was transcribed.
     * @see Type
     */
    public final Type type() {
        return Type.fromValue(type);
    }

    /**
     * <p>
     * The type of audio that was transcribed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of audio that was transcribed.
     * @see Type
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Shows whether speaker identification was enabled in the stream.
     * </p>
     * 
     * @return Shows whether speaker identification was enabled in the stream.
     */
    public final Boolean showSpeakerLabel() {
        return showSpeakerLabel;
    }

    /**
     * <p>
     * Optional. An identifier for the transcription session. If you don't provide a session ID, Amazon Transcribe
     * generates one for you and returns it in the response.
     * </p>
     * 
     * @return Optional. An identifier for the transcription session. If you don't provide a session ID, Amazon
     *         Transcribe generates one for you and returns it in the response.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * Shows whether channel identification has been enabled in the stream.
     * </p>
     * 
     * @return Shows whether channel identification has been enabled in the stream.
     */
    public final Boolean enableChannelIdentification() {
        return enableChannelIdentification;
    }

    /**
     * <p>
     * The number of channels identified in the stream.
     * </p>
     * 
     * @return The number of channels identified in the stream.
     */
    public final Integer numberOfChannels() {
        return numberOfChannels;
    }

    /**
     * <p>
     * If the value is <code>PHI</code>, indicates that you've configured your stream to identify personal health
     * information.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentIdentificationType} will return {@link MedicalContentIdentificationType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #contentIdentificationTypeAsString}.
     * </p>
     * 
     * @return If the value is <code>PHI</code>, indicates that you've configured your stream to identify personal
     *         health information.
     * @see MedicalContentIdentificationType
     */
    public final MedicalContentIdentificationType contentIdentificationType() {
        return MedicalContentIdentificationType.fromValue(contentIdentificationType);
    }

    /**
     * <p>
     * If the value is <code>PHI</code>, indicates that you've configured your stream to identify personal health
     * information.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentIdentificationType} will return {@link MedicalContentIdentificationType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #contentIdentificationTypeAsString}.
     * </p>
     * 
     * @return If the value is <code>PHI</code>, indicates that you've configured your stream to identify personal
     *         health information.
     * @see MedicalContentIdentificationType
     */
    public final String contentIdentificationTypeAsString() {
        return contentIdentificationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mediaSampleRateHertz());
        hashCode = 31 * hashCode + Objects.hashCode(mediaEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(specialtyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(showSpeakerLabel());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(enableChannelIdentification());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfChannels());
        hashCode = 31 * hashCode + Objects.hashCode(contentIdentificationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMedicalStreamTranscriptionResponse)) {
            return false;
        }
        StartMedicalStreamTranscriptionResponse other = (StartMedicalStreamTranscriptionResponse) obj;
        return Objects.equals(requestId(), other.requestId())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(mediaSampleRateHertz(), other.mediaSampleRateHertz())
                && Objects.equals(mediaEncodingAsString(), other.mediaEncodingAsString())
                && Objects.equals(vocabularyName(), other.vocabularyName())
                && Objects.equals(specialtyAsString(), other.specialtyAsString())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(showSpeakerLabel(), other.showSpeakerLabel()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(enableChannelIdentification(), other.enableChannelIdentification())
                && Objects.equals(numberOfChannels(), other.numberOfChannels())
                && Objects.equals(contentIdentificationTypeAsString(), other.contentIdentificationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMedicalStreamTranscriptionResponse").add("RequestId", requestId())
                .add("LanguageCode", languageCodeAsString()).add("MediaSampleRateHertz", mediaSampleRateHertz())
                .add("MediaEncoding", mediaEncodingAsString()).add("VocabularyName", vocabularyName())
                .add("Specialty", specialtyAsString()).add("Type", typeAsString()).add("ShowSpeakerLabel", showSpeakerLabel())
                .add("SessionId", sessionId()).add("EnableChannelIdentification", enableChannelIdentification())
                .add("NumberOfChannels", numberOfChannels())
                .add("ContentIdentificationType", contentIdentificationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "MediaSampleRateHertz":
            return Optional.ofNullable(clazz.cast(mediaSampleRateHertz()));
        case "MediaEncoding":
            return Optional.ofNullable(clazz.cast(mediaEncodingAsString()));
        case "VocabularyName":
            return Optional.ofNullable(clazz.cast(vocabularyName()));
        case "Specialty":
            return Optional.ofNullable(clazz.cast(specialtyAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ShowSpeakerLabel":
            return Optional.ofNullable(clazz.cast(showSpeakerLabel()));
        case "SessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "EnableChannelIdentification":
            return Optional.ofNullable(clazz.cast(enableChannelIdentification()));
        case "NumberOfChannels":
            return Optional.ofNullable(clazz.cast(numberOfChannels()));
        case "ContentIdentificationType":
            return Optional.ofNullable(clazz.cast(contentIdentificationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMedicalStreamTranscriptionResponse, T> g) {
        return obj -> g.apply((StartMedicalStreamTranscriptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeStreamingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartMedicalStreamTranscriptionResponse> {
        /**
         * <p>
         * An identifier for the streaming transcription.
         * </p>
         * 
         * @param requestId
         *        An identifier for the streaming transcription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The language code for the response transcript. For Amazon Transcribe Medical, this is US English (en-US).
         * </p>
         * 
         * @param languageCode
         *        The language code for the response transcript. For Amazon Transcribe Medical, this is US English
         *        (en-US).
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code for the response transcript. For Amazon Transcribe Medical, this is US English (en-US).
         * </p>
         * 
         * @param languageCode
         *        The language code for the response transcript. For Amazon Transcribe Medical, this is US English
         *        (en-US).
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * The sample rate of the input audio in Hertz. Valid value: 16000 Hz.
         * </p>
         * 
         * @param mediaSampleRateHertz
         *        The sample rate of the input audio in Hertz. Valid value: 16000 Hz.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaSampleRateHertz(Integer mediaSampleRateHertz);

        /**
         * <p>
         * The encoding used for the input audio stream.
         * </p>
         * 
         * @param mediaEncoding
         *        The encoding used for the input audio stream.
         * @see MediaEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaEncoding
         */
        Builder mediaEncoding(String mediaEncoding);

        /**
         * <p>
         * The encoding used for the input audio stream.
         * </p>
         * 
         * @param mediaEncoding
         *        The encoding used for the input audio stream.
         * @see MediaEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaEncoding
         */
        Builder mediaEncoding(MediaEncoding mediaEncoding);

        /**
         * <p>
         * The name of the vocabulary used when processing the stream.
         * </p>
         * 
         * @param vocabularyName
         *        The name of the vocabulary used when processing the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyName(String vocabularyName);

        /**
         * <p>
         * The specialty in the medical domain.
         * </p>
         * 
         * @param specialty
         *        The specialty in the medical domain.
         * @see Specialty
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Specialty
         */
        Builder specialty(String specialty);

        /**
         * <p>
         * The specialty in the medical domain.
         * </p>
         * 
         * @param specialty
         *        The specialty in the medical domain.
         * @see Specialty
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Specialty
         */
        Builder specialty(Specialty specialty);

        /**
         * <p>
         * The type of audio that was transcribed.
         * </p>
         * 
         * @param type
         *        The type of audio that was transcribed.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * <p>
         * The type of audio that was transcribed.
         * </p>
         * 
         * @param type
         *        The type of audio that was transcribed.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);

        /**
         * <p>
         * Shows whether speaker identification was enabled in the stream.
         * </p>
         * 
         * @param showSpeakerLabel
         *        Shows whether speaker identification was enabled in the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder showSpeakerLabel(Boolean showSpeakerLabel);

        /**
         * <p>
         * Optional. An identifier for the transcription session. If you don't provide a session ID, Amazon Transcribe
         * generates one for you and returns it in the response.
         * </p>
         * 
         * @param sessionId
         *        Optional. An identifier for the transcription session. If you don't provide a session ID, Amazon
         *        Transcribe generates one for you and returns it in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * Shows whether channel identification has been enabled in the stream.
         * </p>
         * 
         * @param enableChannelIdentification
         *        Shows whether channel identification has been enabled in the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableChannelIdentification(Boolean enableChannelIdentification);

        /**
         * <p>
         * The number of channels identified in the stream.
         * </p>
         * 
         * @param numberOfChannels
         *        The number of channels identified in the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfChannels(Integer numberOfChannels);

        /**
         * <p>
         * If the value is <code>PHI</code>, indicates that you've configured your stream to identify personal health
         * information.
         * </p>
         * 
         * @param contentIdentificationType
         *        If the value is <code>PHI</code>, indicates that you've configured your stream to identify personal
         *        health information.
         * @see MedicalContentIdentificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalContentIdentificationType
         */
        Builder contentIdentificationType(String contentIdentificationType);

        /**
         * <p>
         * If the value is <code>PHI</code>, indicates that you've configured your stream to identify personal health
         * information.
         * </p>
         * 
         * @param contentIdentificationType
         *        If the value is <code>PHI</code>, indicates that you've configured your stream to identify personal
         *        health information.
         * @see MedicalContentIdentificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalContentIdentificationType
         */
        Builder contentIdentificationType(MedicalContentIdentificationType contentIdentificationType);
    }

    static final class BuilderImpl extends TranscribeStreamingResponse.BuilderImpl implements Builder {
        private String requestId;

        private String languageCode;

        private Integer mediaSampleRateHertz;

        private String mediaEncoding;

        private String vocabularyName;

        private String specialty;

        private String type;

        private Boolean showSpeakerLabel;

        private String sessionId;

        private Boolean enableChannelIdentification;

        private Integer numberOfChannels;

        private String contentIdentificationType;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMedicalStreamTranscriptionResponse model) {
            super(model);
            requestId(model.requestId);
            languageCode(model.languageCode);
            mediaSampleRateHertz(model.mediaSampleRateHertz);
            mediaEncoding(model.mediaEncoding);
            vocabularyName(model.vocabularyName);
            specialty(model.specialty);
            type(model.type);
            showSpeakerLabel(model.showSpeakerLabel);
            sessionId(model.sessionId);
            enableChannelIdentification(model.enableChannelIdentification);
            numberOfChannels(model.numberOfChannels);
            contentIdentificationType(model.contentIdentificationType);
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        @Transient
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        @Transient
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        @Transient
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Integer getMediaSampleRateHertz() {
            return mediaSampleRateHertz;
        }

        public final void setMediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
        }

        @Override
        @Transient
        public final Builder mediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
            return this;
        }

        public final String getMediaEncoding() {
            return mediaEncoding;
        }

        public final void setMediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
        }

        @Override
        @Transient
        public final Builder mediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
            return this;
        }

        @Override
        @Transient
        public final Builder mediaEncoding(MediaEncoding mediaEncoding) {
            this.mediaEncoding(mediaEncoding == null ? null : mediaEncoding.toString());
            return this;
        }

        public final String getVocabularyName() {
            return vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        @Transient
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getSpecialty() {
            return specialty;
        }

        public final void setSpecialty(String specialty) {
            this.specialty = specialty;
        }

        @Override
        @Transient
        public final Builder specialty(String specialty) {
            this.specialty = specialty;
            return this;
        }

        @Override
        @Transient
        public final Builder specialty(Specialty specialty) {
            this.specialty(specialty == null ? null : specialty.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Boolean getShowSpeakerLabel() {
            return showSpeakerLabel;
        }

        public final void setShowSpeakerLabel(Boolean showSpeakerLabel) {
            this.showSpeakerLabel = showSpeakerLabel;
        }

        @Override
        @Transient
        public final Builder showSpeakerLabel(Boolean showSpeakerLabel) {
            this.showSpeakerLabel = showSpeakerLabel;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        @Transient
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Boolean getEnableChannelIdentification() {
            return enableChannelIdentification;
        }

        public final void setEnableChannelIdentification(Boolean enableChannelIdentification) {
            this.enableChannelIdentification = enableChannelIdentification;
        }

        @Override
        @Transient
        public final Builder enableChannelIdentification(Boolean enableChannelIdentification) {
            this.enableChannelIdentification = enableChannelIdentification;
            return this;
        }

        public final Integer getNumberOfChannels() {
            return numberOfChannels;
        }

        public final void setNumberOfChannels(Integer numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
        }

        @Override
        @Transient
        public final Builder numberOfChannels(Integer numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
            return this;
        }

        public final String getContentIdentificationType() {
            return contentIdentificationType;
        }

        public final void setContentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
        }

        @Override
        @Transient
        public final Builder contentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
            return this;
        }

        @Override
        @Transient
        public final Builder contentIdentificationType(MedicalContentIdentificationType contentIdentificationType) {
            this.contentIdentificationType(contentIdentificationType == null ? null : contentIdentificationType.toString());
            return this;
        }

        @Override
        public StartMedicalStreamTranscriptionResponse build() {
            return new StartMedicalStreamTranscriptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
