/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartStreamTranscriptionResponse extends TranscribeStreamingResponse implements
        ToCopyableBuilder<StartStreamTranscriptionResponse.Builder, StartStreamTranscriptionResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(StartStreamTranscriptionResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-request-id").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode")
            .getter(getter(StartStreamTranscriptionResponse::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-language-code")
                    .build()).build();

    private static final SdkField<Integer> MEDIA_SAMPLE_RATE_HERTZ_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MediaSampleRateHertz")
            .getter(getter(StartStreamTranscriptionResponse::mediaSampleRateHertz))
            .setter(setter(Builder::mediaSampleRateHertz))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-sample-rate")
                    .build()).build();

    private static final SdkField<String> MEDIA_ENCODING_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MediaEncoding")
            .getter(getter(StartStreamTranscriptionResponse::mediaEncodingAsString))
            .setter(setter(Builder::mediaEncoding))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-media-encoding")
                    .build()).build();

    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VocabularyName")
            .getter(getter(StartStreamTranscriptionResponse::vocabularyName))
            .setter(setter(Builder::vocabularyName))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-vocabulary-name")
                    .build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SessionId")
            .getter(getter(StartStreamTranscriptionResponse::sessionId))
            .setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-session-id")
                    .build()).build();

    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterName")
            .getter(getter(StartStreamTranscriptionResponse::vocabularyFilterName))
            .setter(setter(Builder::vocabularyFilterName))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-vocabulary-filter-name").build()).build();

    private static final SdkField<String> VOCABULARY_FILTER_METHOD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterMethod")
            .getter(getter(StartStreamTranscriptionResponse::vocabularyFilterMethodAsString))
            .setter(setter(Builder::vocabularyFilterMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-vocabulary-filter-method").build()).build();

    private static final SdkField<Boolean> SHOW_SPEAKER_LABEL_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ShowSpeakerLabel")
            .getter(getter(StartStreamTranscriptionResponse::showSpeakerLabel))
            .setter(setter(Builder::showSpeakerLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-show-speaker-label").build()).build();

    private static final SdkField<Boolean> ENABLE_CHANNEL_IDENTIFICATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableChannelIdentification")
            .getter(getter(StartStreamTranscriptionResponse::enableChannelIdentification))
            .setter(setter(Builder::enableChannelIdentification))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-enable-channel-identification").build()).build();

    private static final SdkField<Integer> NUMBER_OF_CHANNELS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfChannels")
            .getter(getter(StartStreamTranscriptionResponse::numberOfChannels))
            .setter(setter(Builder::numberOfChannels))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-number-of-channels").build()).build();

    private static final SdkField<Boolean> ENABLE_PARTIAL_RESULTS_STABILIZATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnablePartialResultsStabilization")
            .getter(getter(StartStreamTranscriptionResponse::enablePartialResultsStabilization))
            .setter(setter(Builder::enablePartialResultsStabilization))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-enable-partial-results-stabilization").build()).build();

    private static final SdkField<String> PARTIAL_RESULTS_STABILITY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PartialResultsStability")
            .getter(getter(StartStreamTranscriptionResponse::partialResultsStabilityAsString))
            .setter(setter(Builder::partialResultsStability))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-partial-results-stability").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            LANGUAGE_CODE_FIELD, MEDIA_SAMPLE_RATE_HERTZ_FIELD, MEDIA_ENCODING_FIELD, VOCABULARY_NAME_FIELD, SESSION_ID_FIELD,
            VOCABULARY_FILTER_NAME_FIELD, VOCABULARY_FILTER_METHOD_FIELD, SHOW_SPEAKER_LABEL_FIELD,
            ENABLE_CHANNEL_IDENTIFICATION_FIELD, NUMBER_OF_CHANNELS_FIELD, ENABLE_PARTIAL_RESULTS_STABILIZATION_FIELD,
            PARTIAL_RESULTS_STABILITY_FIELD));

    private final String requestId;

    private final String languageCode;

    private final Integer mediaSampleRateHertz;

    private final String mediaEncoding;

    private final String vocabularyName;

    private final String sessionId;

    private final String vocabularyFilterName;

    private final String vocabularyFilterMethod;

    private final Boolean showSpeakerLabel;

    private final Boolean enableChannelIdentification;

    private final Integer numberOfChannels;

    private final Boolean enablePartialResultsStabilization;

    private final String partialResultsStability;

    private StartStreamTranscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.requestId = builder.requestId;
        this.languageCode = builder.languageCode;
        this.mediaSampleRateHertz = builder.mediaSampleRateHertz;
        this.mediaEncoding = builder.mediaEncoding;
        this.vocabularyName = builder.vocabularyName;
        this.sessionId = builder.sessionId;
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.vocabularyFilterMethod = builder.vocabularyFilterMethod;
        this.showSpeakerLabel = builder.showSpeakerLabel;
        this.enableChannelIdentification = builder.enableChannelIdentification;
        this.numberOfChannels = builder.numberOfChannels;
        this.enablePartialResultsStabilization = builder.enablePartialResultsStabilization;
        this.partialResultsStability = builder.partialResultsStability;
    }

    /**
     * <p>
     * An identifier for the streaming transcription.
     * </p>
     * 
     * @return An identifier for the streaming transcription.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The language code for the input audio stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code for the input audio stream.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code for the input audio stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code for the input audio stream.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The sample rate for the input audio stream. Use 8000 Hz for low quality audio and 16000 Hz for high quality
     * audio.
     * </p>
     * 
     * @return The sample rate for the input audio stream. Use 8000 Hz for low quality audio and 16000 Hz for high
     *         quality audio.
     */
    public final Integer mediaSampleRateHertz() {
        return mediaSampleRateHertz;
    }

    /**
     * <p>
     * The encoding used for the input audio stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaEncoding}
     * will return {@link MediaEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mediaEncodingAsString}.
     * </p>
     * 
     * @return The encoding used for the input audio stream.
     * @see MediaEncoding
     */
    public final MediaEncoding mediaEncoding() {
        return MediaEncoding.fromValue(mediaEncoding);
    }

    /**
     * <p>
     * The encoding used for the input audio stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaEncoding}
     * will return {@link MediaEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mediaEncodingAsString}.
     * </p>
     * 
     * @return The encoding used for the input audio stream.
     * @see MediaEncoding
     */
    public final String mediaEncodingAsString() {
        return mediaEncoding;
    }

    /**
     * <p>
     * The name of the vocabulary used when processing the stream.
     * </p>
     * 
     * @return The name of the vocabulary used when processing the stream.
     */
    public final String vocabularyName() {
        return vocabularyName;
    }

    /**
     * <p>
     * An identifier for a specific transcription session.
     * </p>
     * 
     * @return An identifier for a specific transcription session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The name of the vocabulary filter used in your real-time stream.
     * </p>
     * 
     * @return The name of the vocabulary filter used in your real-time stream.
     */
    public final String vocabularyFilterName() {
        return vocabularyFilterName;
    }

    /**
     * <p>
     * The vocabulary filtering method used in the real-time stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vocabularyFilterMethod} will return {@link VocabularyFilterMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #vocabularyFilterMethodAsString}.
     * </p>
     * 
     * @return The vocabulary filtering method used in the real-time stream.
     * @see VocabularyFilterMethod
     */
    public final VocabularyFilterMethod vocabularyFilterMethod() {
        return VocabularyFilterMethod.fromValue(vocabularyFilterMethod);
    }

    /**
     * <p>
     * The vocabulary filtering method used in the real-time stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vocabularyFilterMethod} will return {@link VocabularyFilterMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #vocabularyFilterMethodAsString}.
     * </p>
     * 
     * @return The vocabulary filtering method used in the real-time stream.
     * @see VocabularyFilterMethod
     */
    public final String vocabularyFilterMethodAsString() {
        return vocabularyFilterMethod;
    }

    /**
     * <p>
     * Shows whether speaker identification was enabled in the stream.
     * </p>
     * 
     * @return Shows whether speaker identification was enabled in the stream.
     */
    public final Boolean showSpeakerLabel() {
        return showSpeakerLabel;
    }

    /**
     * <p>
     * Shows whether channel identification has been enabled in the stream.
     * </p>
     * 
     * @return Shows whether channel identification has been enabled in the stream.
     */
    public final Boolean enableChannelIdentification() {
        return enableChannelIdentification;
    }

    /**
     * <p>
     * The number of channels identified in the stream.
     * </p>
     * 
     * @return The number of channels identified in the stream.
     */
    public final Integer numberOfChannels() {
        return numberOfChannels;
    }

    /**
     * <p>
     * Shows whether partial results stabilization has been enabled in the stream.
     * </p>
     * 
     * @return Shows whether partial results stabilization has been enabled in the stream.
     */
    public final Boolean enablePartialResultsStabilization() {
        return enablePartialResultsStabilization;
    }

    /**
     * <p>
     * If partial results stabilization has been enabled in the stream, shows the stability level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #partialResultsStability} will return {@link PartialResultsStability#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #partialResultsStabilityAsString}.
     * </p>
     * 
     * @return If partial results stabilization has been enabled in the stream, shows the stability level.
     * @see PartialResultsStability
     */
    public final PartialResultsStability partialResultsStability() {
        return PartialResultsStability.fromValue(partialResultsStability);
    }

    /**
     * <p>
     * If partial results stabilization has been enabled in the stream, shows the stability level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #partialResultsStability} will return {@link PartialResultsStability#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #partialResultsStabilityAsString}.
     * </p>
     * 
     * @return If partial results stabilization has been enabled in the stream, shows the stability level.
     * @see PartialResultsStability
     */
    public final String partialResultsStabilityAsString() {
        return partialResultsStability;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mediaSampleRateHertz());
        hashCode = 31 * hashCode + Objects.hashCode(mediaEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(showSpeakerLabel());
        hashCode = 31 * hashCode + Objects.hashCode(enableChannelIdentification());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfChannels());
        hashCode = 31 * hashCode + Objects.hashCode(enablePartialResultsStabilization());
        hashCode = 31 * hashCode + Objects.hashCode(partialResultsStabilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartStreamTranscriptionResponse)) {
            return false;
        }
        StartStreamTranscriptionResponse other = (StartStreamTranscriptionResponse) obj;
        return Objects.equals(requestId(), other.requestId())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(mediaSampleRateHertz(), other.mediaSampleRateHertz())
                && Objects.equals(mediaEncodingAsString(), other.mediaEncodingAsString())
                && Objects.equals(vocabularyName(), other.vocabularyName()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(vocabularyFilterName(), other.vocabularyFilterName())
                && Objects.equals(vocabularyFilterMethodAsString(), other.vocabularyFilterMethodAsString())
                && Objects.equals(showSpeakerLabel(), other.showSpeakerLabel())
                && Objects.equals(enableChannelIdentification(), other.enableChannelIdentification())
                && Objects.equals(numberOfChannels(), other.numberOfChannels())
                && Objects.equals(enablePartialResultsStabilization(), other.enablePartialResultsStabilization())
                && Objects.equals(partialResultsStabilityAsString(), other.partialResultsStabilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartStreamTranscriptionResponse").add("RequestId", requestId())
                .add("LanguageCode", languageCodeAsString()).add("MediaSampleRateHertz", mediaSampleRateHertz())
                .add("MediaEncoding", mediaEncodingAsString()).add("VocabularyName", vocabularyName())
                .add("SessionId", sessionId()).add("VocabularyFilterName", vocabularyFilterName())
                .add("VocabularyFilterMethod", vocabularyFilterMethodAsString()).add("ShowSpeakerLabel", showSpeakerLabel())
                .add("EnableChannelIdentification", enableChannelIdentification()).add("NumberOfChannels", numberOfChannels())
                .add("EnablePartialResultsStabilization", enablePartialResultsStabilization())
                .add("PartialResultsStability", partialResultsStabilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "MediaSampleRateHertz":
            return Optional.ofNullable(clazz.cast(mediaSampleRateHertz()));
        case "MediaEncoding":
            return Optional.ofNullable(clazz.cast(mediaEncodingAsString()));
        case "VocabularyName":
            return Optional.ofNullable(clazz.cast(vocabularyName()));
        case "SessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "VocabularyFilterName":
            return Optional.ofNullable(clazz.cast(vocabularyFilterName()));
        case "VocabularyFilterMethod":
            return Optional.ofNullable(clazz.cast(vocabularyFilterMethodAsString()));
        case "ShowSpeakerLabel":
            return Optional.ofNullable(clazz.cast(showSpeakerLabel()));
        case "EnableChannelIdentification":
            return Optional.ofNullable(clazz.cast(enableChannelIdentification()));
        case "NumberOfChannels":
            return Optional.ofNullable(clazz.cast(numberOfChannels()));
        case "EnablePartialResultsStabilization":
            return Optional.ofNullable(clazz.cast(enablePartialResultsStabilization()));
        case "PartialResultsStability":
            return Optional.ofNullable(clazz.cast(partialResultsStabilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartStreamTranscriptionResponse, T> g) {
        return obj -> g.apply((StartStreamTranscriptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeStreamingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartStreamTranscriptionResponse> {
        /**
         * <p>
         * An identifier for the streaming transcription.
         * </p>
         * 
         * @param requestId
         *        An identifier for the streaming transcription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The language code for the input audio stream.
         * </p>
         * 
         * @param languageCode
         *        The language code for the input audio stream.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code for the input audio stream.
         * </p>
         * 
         * @param languageCode
         *        The language code for the input audio stream.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * The sample rate for the input audio stream. Use 8000 Hz for low quality audio and 16000 Hz for high quality
         * audio.
         * </p>
         * 
         * @param mediaSampleRateHertz
         *        The sample rate for the input audio stream. Use 8000 Hz for low quality audio and 16000 Hz for high
         *        quality audio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaSampleRateHertz(Integer mediaSampleRateHertz);

        /**
         * <p>
         * The encoding used for the input audio stream.
         * </p>
         * 
         * @param mediaEncoding
         *        The encoding used for the input audio stream.
         * @see MediaEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaEncoding
         */
        Builder mediaEncoding(String mediaEncoding);

        /**
         * <p>
         * The encoding used for the input audio stream.
         * </p>
         * 
         * @param mediaEncoding
         *        The encoding used for the input audio stream.
         * @see MediaEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaEncoding
         */
        Builder mediaEncoding(MediaEncoding mediaEncoding);

        /**
         * <p>
         * The name of the vocabulary used when processing the stream.
         * </p>
         * 
         * @param vocabularyName
         *        The name of the vocabulary used when processing the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyName(String vocabularyName);

        /**
         * <p>
         * An identifier for a specific transcription session.
         * </p>
         * 
         * @param sessionId
         *        An identifier for a specific transcription session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The name of the vocabulary filter used in your real-time stream.
         * </p>
         * 
         * @param vocabularyFilterName
         *        The name of the vocabulary filter used in your real-time stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterName(String vocabularyFilterName);

        /**
         * <p>
         * The vocabulary filtering method used in the real-time stream.
         * </p>
         * 
         * @param vocabularyFilterMethod
         *        The vocabulary filtering method used in the real-time stream.
         * @see VocabularyFilterMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyFilterMethod
         */
        Builder vocabularyFilterMethod(String vocabularyFilterMethod);

        /**
         * <p>
         * The vocabulary filtering method used in the real-time stream.
         * </p>
         * 
         * @param vocabularyFilterMethod
         *        The vocabulary filtering method used in the real-time stream.
         * @see VocabularyFilterMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyFilterMethod
         */
        Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod);

        /**
         * <p>
         * Shows whether speaker identification was enabled in the stream.
         * </p>
         * 
         * @param showSpeakerLabel
         *        Shows whether speaker identification was enabled in the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder showSpeakerLabel(Boolean showSpeakerLabel);

        /**
         * <p>
         * Shows whether channel identification has been enabled in the stream.
         * </p>
         * 
         * @param enableChannelIdentification
         *        Shows whether channel identification has been enabled in the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableChannelIdentification(Boolean enableChannelIdentification);

        /**
         * <p>
         * The number of channels identified in the stream.
         * </p>
         * 
         * @param numberOfChannels
         *        The number of channels identified in the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfChannels(Integer numberOfChannels);

        /**
         * <p>
         * Shows whether partial results stabilization has been enabled in the stream.
         * </p>
         * 
         * @param enablePartialResultsStabilization
         *        Shows whether partial results stabilization has been enabled in the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePartialResultsStabilization(Boolean enablePartialResultsStabilization);

        /**
         * <p>
         * If partial results stabilization has been enabled in the stream, shows the stability level.
         * </p>
         * 
         * @param partialResultsStability
         *        If partial results stabilization has been enabled in the stream, shows the stability level.
         * @see PartialResultsStability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartialResultsStability
         */
        Builder partialResultsStability(String partialResultsStability);

        /**
         * <p>
         * If partial results stabilization has been enabled in the stream, shows the stability level.
         * </p>
         * 
         * @param partialResultsStability
         *        If partial results stabilization has been enabled in the stream, shows the stability level.
         * @see PartialResultsStability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartialResultsStability
         */
        Builder partialResultsStability(PartialResultsStability partialResultsStability);
    }

    static final class BuilderImpl extends TranscribeStreamingResponse.BuilderImpl implements Builder {
        private String requestId;

        private String languageCode;

        private Integer mediaSampleRateHertz;

        private String mediaEncoding;

        private String vocabularyName;

        private String sessionId;

        private String vocabularyFilterName;

        private String vocabularyFilterMethod;

        private Boolean showSpeakerLabel;

        private Boolean enableChannelIdentification;

        private Integer numberOfChannels;

        private Boolean enablePartialResultsStabilization;

        private String partialResultsStability;

        private BuilderImpl() {
        }

        private BuilderImpl(StartStreamTranscriptionResponse model) {
            super(model);
            requestId(model.requestId);
            languageCode(model.languageCode);
            mediaSampleRateHertz(model.mediaSampleRateHertz);
            mediaEncoding(model.mediaEncoding);
            vocabularyName(model.vocabularyName);
            sessionId(model.sessionId);
            vocabularyFilterName(model.vocabularyFilterName);
            vocabularyFilterMethod(model.vocabularyFilterMethod);
            showSpeakerLabel(model.showSpeakerLabel);
            enableChannelIdentification(model.enableChannelIdentification);
            numberOfChannels(model.numberOfChannels);
            enablePartialResultsStabilization(model.enablePartialResultsStabilization);
            partialResultsStability(model.partialResultsStability);
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        @Transient
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        @Transient
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        @Transient
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Integer getMediaSampleRateHertz() {
            return mediaSampleRateHertz;
        }

        public final void setMediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
        }

        @Override
        @Transient
        public final Builder mediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
            return this;
        }

        public final String getMediaEncoding() {
            return mediaEncoding;
        }

        public final void setMediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
        }

        @Override
        @Transient
        public final Builder mediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
            return this;
        }

        @Override
        @Transient
        public final Builder mediaEncoding(MediaEncoding mediaEncoding) {
            this.mediaEncoding(mediaEncoding == null ? null : mediaEncoding.toString());
            return this;
        }

        public final String getVocabularyName() {
            return vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        @Transient
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        @Transient
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getVocabularyFilterName() {
            return vocabularyFilterName;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        @Override
        @Transient
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final String getVocabularyFilterMethod() {
            return vocabularyFilterMethod;
        }

        public final void setVocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
        }

        @Override
        @Transient
        public final Builder vocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
            return this;
        }

        @Override
        @Transient
        public final Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod) {
            this.vocabularyFilterMethod(vocabularyFilterMethod == null ? null : vocabularyFilterMethod.toString());
            return this;
        }

        public final Boolean getShowSpeakerLabel() {
            return showSpeakerLabel;
        }

        public final void setShowSpeakerLabel(Boolean showSpeakerLabel) {
            this.showSpeakerLabel = showSpeakerLabel;
        }

        @Override
        @Transient
        public final Builder showSpeakerLabel(Boolean showSpeakerLabel) {
            this.showSpeakerLabel = showSpeakerLabel;
            return this;
        }

        public final Boolean getEnableChannelIdentification() {
            return enableChannelIdentification;
        }

        public final void setEnableChannelIdentification(Boolean enableChannelIdentification) {
            this.enableChannelIdentification = enableChannelIdentification;
        }

        @Override
        @Transient
        public final Builder enableChannelIdentification(Boolean enableChannelIdentification) {
            this.enableChannelIdentification = enableChannelIdentification;
            return this;
        }

        public final Integer getNumberOfChannels() {
            return numberOfChannels;
        }

        public final void setNumberOfChannels(Integer numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
        }

        @Override
        @Transient
        public final Builder numberOfChannels(Integer numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
            return this;
        }

        public final Boolean getEnablePartialResultsStabilization() {
            return enablePartialResultsStabilization;
        }

        public final void setEnablePartialResultsStabilization(Boolean enablePartialResultsStabilization) {
            this.enablePartialResultsStabilization = enablePartialResultsStabilization;
        }

        @Override
        @Transient
        public final Builder enablePartialResultsStabilization(Boolean enablePartialResultsStabilization) {
            this.enablePartialResultsStabilization = enablePartialResultsStabilization;
            return this;
        }

        public final String getPartialResultsStability() {
            return partialResultsStability;
        }

        public final void setPartialResultsStability(String partialResultsStability) {
            this.partialResultsStability = partialResultsStability;
        }

        @Override
        @Transient
        public final Builder partialResultsStability(String partialResultsStability) {
            this.partialResultsStability = partialResultsStability;
            return this;
        }

        @Override
        @Transient
        public final Builder partialResultsStability(PartialResultsStability partialResultsStability) {
            this.partialResultsStability(partialResultsStability == null ? null : partialResultsStability.toString());
            return this;
        }

        @Override
        public StartStreamTranscriptionResponse build() {
            return new StartStreamTranscriptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
