/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The medical entity identified as personal health information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MedicalEntity implements SdkPojo, Serializable, ToCopyableBuilder<MedicalEntity.Builder, MedicalEntity> {
    private static final SdkField<Double> START_TIME_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("StartTime").getter(getter(MedicalEntity::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Double> END_TIME_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("EndTime").getter(getter(MedicalEntity::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(MedicalEntity::category)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(MedicalEntity::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<Double> CONFIDENCE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Confidence").getter(getter(MedicalEntity::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, CATEGORY_FIELD, CONTENT_FIELD, CONFIDENCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double startTime;

    private final Double endTime;

    private final String category;

    private final String content;

    private final Double confidence;

    private MedicalEntity(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.category = builder.category;
        this.content = builder.content;
        this.confidence = builder.confidence;
    }

    /**
     * <p>
     * The start time of the speech that was identified as a medical entity.
     * </p>
     * 
     * @return The start time of the speech that was identified as a medical entity.
     */
    public final Double startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time of the speech that was identified as a medical entity.
     * </p>
     * 
     * @return The end time of the speech that was identified as a medical entity.
     */
    public final Double endTime() {
        return endTime;
    }

    /**
     * <p>
     * The type of personal health information of the medical entity.
     * </p>
     * 
     * @return The type of personal health information of the medical entity.
     */
    public final String category() {
        return category;
    }

    /**
     * <p>
     * The word or words in the transcription output that have been identified as a medical entity.
     * </p>
     * 
     * @return The word or words in the transcription output that have been identified as a medical entity.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * A value between zero and one that Amazon Transcribe Medical assigned to the personal health information that it
     * identified in the source audio. Larger values indicate that Amazon Transcribe Medical has higher confidence in
     * the personal health information that it identified.
     * </p>
     * 
     * @return A value between zero and one that Amazon Transcribe Medical assigned to the personal health information
     *         that it identified in the source audio. Larger values indicate that Amazon Transcribe Medical has higher
     *         confidence in the personal health information that it identified.
     */
    public final Double confidence() {
        return confidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalEntity)) {
            return false;
        }
        MedicalEntity other = (MedicalEntity) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(category(), other.category()) && Objects.equals(content(), other.content())
                && Objects.equals(confidence(), other.confidence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MedicalEntity").add("StartTime", startTime()).add("EndTime", endTime())
                .add("Category", category()).add("Content", content()).add("Confidence", confidence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MedicalEntity, T> g) {
        return obj -> g.apply((MedicalEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MedicalEntity> {
        /**
         * <p>
         * The start time of the speech that was identified as a medical entity.
         * </p>
         * 
         * @param startTime
         *        The start time of the speech that was identified as a medical entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Double startTime);

        /**
         * <p>
         * The end time of the speech that was identified as a medical entity.
         * </p>
         * 
         * @param endTime
         *        The end time of the speech that was identified as a medical entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Double endTime);

        /**
         * <p>
         * The type of personal health information of the medical entity.
         * </p>
         * 
         * @param category
         *        The type of personal health information of the medical entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);

        /**
         * <p>
         * The word or words in the transcription output that have been identified as a medical entity.
         * </p>
         * 
         * @param content
         *        The word or words in the transcription output that have been identified as a medical entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * A value between zero and one that Amazon Transcribe Medical assigned to the personal health information that
         * it identified in the source audio. Larger values indicate that Amazon Transcribe Medical has higher
         * confidence in the personal health information that it identified.
         * </p>
         * 
         * @param confidence
         *        A value between zero and one that Amazon Transcribe Medical assigned to the personal health
         *        information that it identified in the source audio. Larger values indicate that Amazon Transcribe
         *        Medical has higher confidence in the personal health information that it identified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Double confidence);
    }

    static final class BuilderImpl implements Builder {
        private Double startTime;

        private Double endTime;

        private String category;

        private String content;

        private Double confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalEntity model) {
            startTime(model.startTime);
            endTime(model.endTime);
            category(model.category);
            content(model.content);
            confidence(model.confidence);
        }

        public final Double getStartTime() {
            return startTime;
        }

        public final void setStartTime(Double startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Double startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Double getEndTime() {
            return endTime;
        }

        public final void setEndTime(Double endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Double endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        @Transient
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        @Transient
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final Double getConfidence() {
            return confidence;
        }

        public final void setConfidence(Double confidence) {
            this.confidence = confidence;
        }

        @Override
        @Transient
        public final Builder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        public MedicalEntity build() {
            return new MedicalEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
