/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.beans.Transient;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a wrapper for the audio chunks that you are sending.
 * </p>
 * <p>
 * For information on audio encoding in Amazon Transcribe, see <a
 * href="https://docs.aws.amazon.com/transcribe/latest/dg/input.html">Speech input</a>. For information on audio
 * encoding formats in Amazon Transcribe Medical, see <a
 * href="https://docs.aws.amazon.com/transcribe/latest/dg/input-med.html">Speech input</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AudioEvent implements SdkPojo, Serializable, ToCopyableBuilder<AudioEvent.Builder, AudioEvent>, AudioStream {
    private static final SdkField<SdkBytes> AUDIO_CHUNK_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("AudioChunk")
            .getter(getter(AudioEvent::audioChunk))
            .setter(setter(Builder::audioChunk))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudioChunk").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_CHUNK_FIELD));

    private static final long serialVersionUID = 1L;

    private final SdkBytes audioChunk;

    protected AudioEvent(BuilderImpl builder) {
        this.audioChunk = builder.audioChunk;
    }

    /**
     * <p>
     * An audio blob that contains the next part of the audio that you want to transcribe. The maximum audio chunk size
     * is 32 KB.
     * </p>
     * 
     * @return An audio blob that contains the next part of the audio that you want to transcribe. The maximum audio
     *         chunk size is 32 KB.
     */
    public final SdkBytes audioChunk() {
        return audioChunk;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioChunk());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioEvent)) {
            return false;
        }
        AudioEvent other = (AudioEvent) obj;
        return Objects.equals(audioChunk(), other.audioChunk());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioEvent").add("AudioChunk", audioChunk()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioChunk":
            return Optional.ofNullable(clazz.cast(audioChunk()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final AudioEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioEvent, T> g) {
        return obj -> g.apply((AudioEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Override
    public AudioStream.EventType sdkEventType() {
        return AudioStream.EventType.AUDIO_EVENT;
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioEvent> {
        /**
         * <p>
         * An audio blob that contains the next part of the audio that you want to transcribe. The maximum audio chunk
         * size is 32 KB.
         * </p>
         * 
         * @param audioChunk
         *        An audio blob that contains the next part of the audio that you want to transcribe. The maximum audio
         *        chunk size is 32 KB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioChunk(SdkBytes audioChunk);
    }

    protected static class BuilderImpl implements Builder {
        private SdkBytes audioChunk;

        protected BuilderImpl() {
        }

        protected BuilderImpl(AudioEvent model) {
            audioChunk(model.audioChunk);
        }

        public final ByteBuffer getAudioChunk() {
            return audioChunk == null ? null : audioChunk.asByteBuffer();
        }

        public final void setAudioChunk(ByteBuffer audioChunk) {
            audioChunk(audioChunk == null ? null : SdkBytes.fromByteBuffer(audioChunk));
        }

        @Override
        @Transient
        public final Builder audioChunk(SdkBytes audioChunk) {
            this.audioChunk = audioChunk;
            return this;
        }

        @Override
        public AudioEvent build() {
            return new AudioEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
