/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A word, phrase, or punctuation mark in your Call Analytics transcription output, along with various associated
 * attributes, such as confidence score, type, and start and end times.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CallAnalyticsItem implements SdkPojo, Serializable,
        ToCopyableBuilder<CallAnalyticsItem.Builder, CallAnalyticsItem> {
    private static final SdkField<Long> BEGIN_OFFSET_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BeginOffsetMillis").getter(getter(CallAnalyticsItem::beginOffsetMillis))
            .setter(setter(Builder::beginOffsetMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffsetMillis").build()).build();

    private static final SdkField<Long> END_OFFSET_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("EndOffsetMillis").getter(getter(CallAnalyticsItem::endOffsetMillis))
            .setter(setter(Builder::endOffsetMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffsetMillis").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CallAnalyticsItem::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(CallAnalyticsItem::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<Double> CONFIDENCE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Confidence").getter(getter(CallAnalyticsItem::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final SdkField<Boolean> VOCABULARY_FILTER_MATCH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("VocabularyFilterMatch").getter(getter(CallAnalyticsItem::vocabularyFilterMatch))
            .setter(setter(Builder::vocabularyFilterMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterMatch").build())
            .build();

    private static final SdkField<Boolean> STABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Stable").getter(getter(CallAnalyticsItem::stable)).setter(setter(Builder::stable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEGIN_OFFSET_MILLIS_FIELD,
            END_OFFSET_MILLIS_FIELD, TYPE_FIELD, CONTENT_FIELD, CONFIDENCE_FIELD, VOCABULARY_FILTER_MATCH_FIELD, STABLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long beginOffsetMillis;

    private final Long endOffsetMillis;

    private final String type;

    private final String content;

    private final Double confidence;

    private final Boolean vocabularyFilterMatch;

    private final Boolean stable;

    private CallAnalyticsItem(BuilderImpl builder) {
        this.beginOffsetMillis = builder.beginOffsetMillis;
        this.endOffsetMillis = builder.endOffsetMillis;
        this.type = builder.type;
        this.content = builder.content;
        this.confidence = builder.confidence;
        this.vocabularyFilterMatch = builder.vocabularyFilterMatch;
        this.stable = builder.stable;
    }

    /**
     * <p>
     * The time, in milliseconds, from the beginning of the audio stream to the start of the identified item.
     * </p>
     * 
     * @return The time, in milliseconds, from the beginning of the audio stream to the start of the identified item.
     */
    public final Long beginOffsetMillis() {
        return beginOffsetMillis;
    }

    /**
     * <p>
     * The time, in milliseconds, from the beginning of the audio stream to the end of the identified item.
     * </p>
     * 
     * @return The time, in milliseconds, from the beginning of the audio stream to the end of the identified item.
     */
    public final Long endOffsetMillis() {
        return endOffsetMillis;
    }

    /**
     * <p>
     * The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and <code>PUNCTUATION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and
     *         <code>PUNCTUATION</code>.
     * @see ItemType
     */
    public final ItemType type() {
        return ItemType.fromValue(type);
    }

    /**
     * <p>
     * The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and <code>PUNCTUATION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and
     *         <code>PUNCTUATION</code>.
     * @see ItemType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The word or punctuation that was transcribed.
     * </p>
     * 
     * @return The word or punctuation that was transcribed.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The confidence score associated with a word or phrase in your transcript.
     * </p>
     * <p>
     * Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified
     * item correctly matches the item spoken in your media.
     * </p>
     * 
     * @return The confidence score associated with a word or phrase in your transcript.</p>
     *         <p>
     *         Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the
     *         identified item correctly matches the item spoken in your media.
     */
    public final Double confidence() {
        return confidence;
    }

    /**
     * <p>
     * Indicates whether the specified item matches a word in the vocabulary filter included in your Call Analytics
     * request. If <code>true</code>, there is a vocabulary filter match.
     * </p>
     * 
     * @return Indicates whether the specified item matches a word in the vocabulary filter included in your Call
     *         Analytics request. If <code>true</code>, there is a vocabulary filter match.
     */
    public final Boolean vocabularyFilterMatch() {
        return vocabularyFilterMatch;
    }

    /**
     * <p>
     * If partial result stabilization is enabled, <code>Stable</code> indicates whether the specified item is stable (
     * <code>true</code>) or if it may change when the segment is complete (<code>false</code>).
     * </p>
     * 
     * @return If partial result stabilization is enabled, <code>Stable</code> indicates whether the specified item is
     *         stable (<code>true</code>) or if it may change when the segment is complete (<code>false</code>).
     */
    public final Boolean stable() {
        return stable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(beginOffsetMillis());
        hashCode = 31 * hashCode + Objects.hashCode(endOffsetMillis());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterMatch());
        hashCode = 31 * hashCode + Objects.hashCode(stable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CallAnalyticsItem)) {
            return false;
        }
        CallAnalyticsItem other = (CallAnalyticsItem) obj;
        return Objects.equals(beginOffsetMillis(), other.beginOffsetMillis())
                && Objects.equals(endOffsetMillis(), other.endOffsetMillis())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(content(), other.content())
                && Objects.equals(confidence(), other.confidence())
                && Objects.equals(vocabularyFilterMatch(), other.vocabularyFilterMatch())
                && Objects.equals(stable(), other.stable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CallAnalyticsItem").add("BeginOffsetMillis", beginOffsetMillis())
                .add("EndOffsetMillis", endOffsetMillis()).add("Type", typeAsString()).add("Content", content())
                .add("Confidence", confidence()).add("VocabularyFilterMatch", vocabularyFilterMatch()).add("Stable", stable())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BeginOffsetMillis":
            return Optional.ofNullable(clazz.cast(beginOffsetMillis()));
        case "EndOffsetMillis":
            return Optional.ofNullable(clazz.cast(endOffsetMillis()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "VocabularyFilterMatch":
            return Optional.ofNullable(clazz.cast(vocabularyFilterMatch()));
        case "Stable":
            return Optional.ofNullable(clazz.cast(stable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CallAnalyticsItem, T> g) {
        return obj -> g.apply((CallAnalyticsItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CallAnalyticsItem> {
        /**
         * <p>
         * The time, in milliseconds, from the beginning of the audio stream to the start of the identified item.
         * </p>
         * 
         * @param beginOffsetMillis
         *        The time, in milliseconds, from the beginning of the audio stream to the start of the identified item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginOffsetMillis(Long beginOffsetMillis);

        /**
         * <p>
         * The time, in milliseconds, from the beginning of the audio stream to the end of the identified item.
         * </p>
         * 
         * @param endOffsetMillis
         *        The time, in milliseconds, from the beginning of the audio stream to the end of the identified item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOffsetMillis(Long endOffsetMillis);

        /**
         * <p>
         * The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and
         * <code>PUNCTUATION</code>.
         * </p>
         * 
         * @param type
         *        The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and
         *        <code>PUNCTUATION</code>.
         * @see ItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ItemType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and
         * <code>PUNCTUATION</code>.
         * </p>
         * 
         * @param type
         *        The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and
         *        <code>PUNCTUATION</code>.
         * @see ItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ItemType
         */
        Builder type(ItemType type);

        /**
         * <p>
         * The word or punctuation that was transcribed.
         * </p>
         * 
         * @param content
         *        The word or punctuation that was transcribed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The confidence score associated with a word or phrase in your transcript.
         * </p>
         * <p>
         * Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the
         * identified item correctly matches the item spoken in your media.
         * </p>
         * 
         * @param confidence
         *        The confidence score associated with a word or phrase in your transcript.</p>
         *        <p>
         *        Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the
         *        identified item correctly matches the item spoken in your media.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Double confidence);

        /**
         * <p>
         * Indicates whether the specified item matches a word in the vocabulary filter included in your Call Analytics
         * request. If <code>true</code>, there is a vocabulary filter match.
         * </p>
         * 
         * @param vocabularyFilterMatch
         *        Indicates whether the specified item matches a word in the vocabulary filter included in your Call
         *        Analytics request. If <code>true</code>, there is a vocabulary filter match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterMatch(Boolean vocabularyFilterMatch);

        /**
         * <p>
         * If partial result stabilization is enabled, <code>Stable</code> indicates whether the specified item is
         * stable (<code>true</code>) or if it may change when the segment is complete (<code>false</code>).
         * </p>
         * 
         * @param stable
         *        If partial result stabilization is enabled, <code>Stable</code> indicates whether the specified item
         *        is stable (<code>true</code>) or if it may change when the segment is complete (<code>false</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stable(Boolean stable);
    }

    static final class BuilderImpl implements Builder {
        private Long beginOffsetMillis;

        private Long endOffsetMillis;

        private String type;

        private String content;

        private Double confidence;

        private Boolean vocabularyFilterMatch;

        private Boolean stable;

        private BuilderImpl() {
        }

        private BuilderImpl(CallAnalyticsItem model) {
            beginOffsetMillis(model.beginOffsetMillis);
            endOffsetMillis(model.endOffsetMillis);
            type(model.type);
            content(model.content);
            confidence(model.confidence);
            vocabularyFilterMatch(model.vocabularyFilterMatch);
            stable(model.stable);
        }

        public final Long getBeginOffsetMillis() {
            return beginOffsetMillis;
        }

        public final void setBeginOffsetMillis(Long beginOffsetMillis) {
            this.beginOffsetMillis = beginOffsetMillis;
        }

        @Override
        public final Builder beginOffsetMillis(Long beginOffsetMillis) {
            this.beginOffsetMillis = beginOffsetMillis;
            return this;
        }

        public final Long getEndOffsetMillis() {
            return endOffsetMillis;
        }

        public final void setEndOffsetMillis(Long endOffsetMillis) {
            this.endOffsetMillis = endOffsetMillis;
        }

        @Override
        public final Builder endOffsetMillis(Long endOffsetMillis) {
            this.endOffsetMillis = endOffsetMillis;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ItemType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final Double getConfidence() {
            return confidence;
        }

        public final void setConfidence(Double confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        public final Boolean getVocabularyFilterMatch() {
            return vocabularyFilterMatch;
        }

        public final void setVocabularyFilterMatch(Boolean vocabularyFilterMatch) {
            this.vocabularyFilterMatch = vocabularyFilterMatch;
        }

        @Override
        public final Builder vocabularyFilterMatch(Boolean vocabularyFilterMatch) {
            this.vocabularyFilterMatch = vocabularyFilterMatch;
            return this;
        }

        public final Boolean getStable() {
            return stable;
        }

        public final void setStable(Boolean stable) {
            this.stable = stable;
        }

        @Override
        public final Builder stable(Boolean stable) {
            this.stable = stable;
            return this;
        }

        @Override
        public CallAnalyticsItem build() {
            return new CallAnalyticsItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
