/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartStreamTranscriptionRequest extends TranscribeStreamingRequest implements
        ToCopyableBuilder<StartStreamTranscriptionRequest.Builder, StartStreamTranscriptionRequest> {
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode")
            .getter(getter(StartStreamTranscriptionRequest::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-language-code")
                    .build()).build();

    private static final SdkField<Integer> MEDIA_SAMPLE_RATE_HERTZ_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MediaSampleRateHertz")
            .getter(getter(StartStreamTranscriptionRequest::mediaSampleRateHertz))
            .setter(setter(Builder::mediaSampleRateHertz))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-sample-rate")
                    .build()).build();

    private static final SdkField<String> MEDIA_ENCODING_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MediaEncoding")
            .getter(getter(StartStreamTranscriptionRequest::mediaEncodingAsString))
            .setter(setter(Builder::mediaEncoding))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-media-encoding")
                    .build()).build();

    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VocabularyName")
            .getter(getter(StartStreamTranscriptionRequest::vocabularyName))
            .setter(setter(Builder::vocabularyName))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-vocabulary-name")
                    .build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SessionId")
            .getter(getter(StartStreamTranscriptionRequest::sessionId))
            .setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-session-id")
                    .build()).build();

    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterName")
            .getter(getter(StartStreamTranscriptionRequest::vocabularyFilterName))
            .setter(setter(Builder::vocabularyFilterName))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-vocabulary-filter-name").build()).build();

    private static final SdkField<String> VOCABULARY_FILTER_METHOD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterMethod")
            .getter(getter(StartStreamTranscriptionRequest::vocabularyFilterMethodAsString))
            .setter(setter(Builder::vocabularyFilterMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-vocabulary-filter-method").build()).build();

    private static final SdkField<Boolean> SHOW_SPEAKER_LABEL_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ShowSpeakerLabel")
            .getter(getter(StartStreamTranscriptionRequest::showSpeakerLabel))
            .setter(setter(Builder::showSpeakerLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-show-speaker-label").build()).build();

    private static final SdkField<Boolean> ENABLE_CHANNEL_IDENTIFICATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableChannelIdentification")
            .getter(getter(StartStreamTranscriptionRequest::enableChannelIdentification))
            .setter(setter(Builder::enableChannelIdentification))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-enable-channel-identification").build()).build();

    private static final SdkField<Integer> NUMBER_OF_CHANNELS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfChannels")
            .getter(getter(StartStreamTranscriptionRequest::numberOfChannels))
            .setter(setter(Builder::numberOfChannels))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-number-of-channels").build()).build();

    private static final SdkField<Boolean> ENABLE_PARTIAL_RESULTS_STABILIZATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnablePartialResultsStabilization")
            .getter(getter(StartStreamTranscriptionRequest::enablePartialResultsStabilization))
            .setter(setter(Builder::enablePartialResultsStabilization))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-enable-partial-results-stabilization").build()).build();

    private static final SdkField<String> PARTIAL_RESULTS_STABILITY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PartialResultsStability")
            .getter(getter(StartStreamTranscriptionRequest::partialResultsStabilityAsString))
            .setter(setter(Builder::partialResultsStability))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-partial-results-stability").build()).build();

    private static final SdkField<String> CONTENT_IDENTIFICATION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ContentIdentificationType")
            .getter(getter(StartStreamTranscriptionRequest::contentIdentificationTypeAsString))
            .setter(setter(Builder::contentIdentificationType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-content-identification-type").build()).build();

    private static final SdkField<String> CONTENT_REDACTION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ContentRedactionType")
            .getter(getter(StartStreamTranscriptionRequest::contentRedactionTypeAsString))
            .setter(setter(Builder::contentRedactionType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-content-redaction-type").build()).build();

    private static final SdkField<String> PII_ENTITY_TYPES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PiiEntityTypes")
            .getter(getter(StartStreamTranscriptionRequest::piiEntityTypes))
            .setter(setter(Builder::piiEntityTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-pii-entity-types")
                    .build()).build();

    private static final SdkField<String> LANGUAGE_MODEL_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LanguageModelName")
            .getter(getter(StartStreamTranscriptionRequest::languageModelName))
            .setter(setter(Builder::languageModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-language-model-name").build()).build();

    private static final SdkField<Boolean> IDENTIFY_LANGUAGE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IdentifyLanguage")
            .getter(getter(StartStreamTranscriptionRequest::identifyLanguage))
            .setter(setter(Builder::identifyLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-identify-language")
                    .build()).build();

    private static final SdkField<String> LANGUAGE_OPTIONS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LanguageOptions")
            .getter(getter(StartStreamTranscriptionRequest::languageOptions))
            .setter(setter(Builder::languageOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-language-options")
                    .build()).build();

    private static final SdkField<String> PREFERRED_LANGUAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredLanguage")
            .getter(getter(StartStreamTranscriptionRequest::preferredLanguageAsString))
            .setter(setter(Builder::preferredLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-preferred-language").build()).build();

    private static final SdkField<Boolean> IDENTIFY_MULTIPLE_LANGUAGES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IdentifyMultipleLanguages")
            .getter(getter(StartStreamTranscriptionRequest::identifyMultipleLanguages))
            .setter(setter(Builder::identifyMultipleLanguages))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-identify-multiple-languages").build()).build();

    private static final SdkField<String> VOCABULARY_NAMES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VocabularyNames")
            .getter(getter(StartStreamTranscriptionRequest::vocabularyNames))
            .setter(setter(Builder::vocabularyNames))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-vocabulary-names")
                    .build()).build();

    private static final SdkField<String> VOCABULARY_FILTER_NAMES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterNames")
            .getter(getter(StartStreamTranscriptionRequest::vocabularyFilterNames))
            .setter(setter(Builder::vocabularyFilterNames))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-vocabulary-filter-names").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_CODE_FIELD,
            MEDIA_SAMPLE_RATE_HERTZ_FIELD, MEDIA_ENCODING_FIELD, VOCABULARY_NAME_FIELD, SESSION_ID_FIELD,
            VOCABULARY_FILTER_NAME_FIELD, VOCABULARY_FILTER_METHOD_FIELD, SHOW_SPEAKER_LABEL_FIELD,
            ENABLE_CHANNEL_IDENTIFICATION_FIELD, NUMBER_OF_CHANNELS_FIELD, ENABLE_PARTIAL_RESULTS_STABILIZATION_FIELD,
            PARTIAL_RESULTS_STABILITY_FIELD, CONTENT_IDENTIFICATION_TYPE_FIELD, CONTENT_REDACTION_TYPE_FIELD,
            PII_ENTITY_TYPES_FIELD, LANGUAGE_MODEL_NAME_FIELD, IDENTIFY_LANGUAGE_FIELD, LANGUAGE_OPTIONS_FIELD,
            PREFERRED_LANGUAGE_FIELD, IDENTIFY_MULTIPLE_LANGUAGES_FIELD, VOCABULARY_NAMES_FIELD, VOCABULARY_FILTER_NAMES_FIELD));

    private final String languageCode;

    private final Integer mediaSampleRateHertz;

    private final String mediaEncoding;

    private final String vocabularyName;

    private final String sessionId;

    private final String vocabularyFilterName;

    private final String vocabularyFilterMethod;

    private final Boolean showSpeakerLabel;

    private final Boolean enableChannelIdentification;

    private final Integer numberOfChannels;

    private final Boolean enablePartialResultsStabilization;

    private final String partialResultsStability;

    private final String contentIdentificationType;

    private final String contentRedactionType;

    private final String piiEntityTypes;

    private final String languageModelName;

    private final Boolean identifyLanguage;

    private final String languageOptions;

    private final String preferredLanguage;

    private final Boolean identifyMultipleLanguages;

    private final String vocabularyNames;

    private final String vocabularyFilterNames;

    private StartStreamTranscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.languageCode = builder.languageCode;
        this.mediaSampleRateHertz = builder.mediaSampleRateHertz;
        this.mediaEncoding = builder.mediaEncoding;
        this.vocabularyName = builder.vocabularyName;
        this.sessionId = builder.sessionId;
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.vocabularyFilterMethod = builder.vocabularyFilterMethod;
        this.showSpeakerLabel = builder.showSpeakerLabel;
        this.enableChannelIdentification = builder.enableChannelIdentification;
        this.numberOfChannels = builder.numberOfChannels;
        this.enablePartialResultsStabilization = builder.enablePartialResultsStabilization;
        this.partialResultsStability = builder.partialResultsStability;
        this.contentIdentificationType = builder.contentIdentificationType;
        this.contentRedactionType = builder.contentRedactionType;
        this.piiEntityTypes = builder.piiEntityTypes;
        this.languageModelName = builder.languageModelName;
        this.identifyLanguage = builder.identifyLanguage;
        this.languageOptions = builder.languageOptions;
        this.preferredLanguage = builder.preferredLanguage;
        this.identifyMultipleLanguages = builder.identifyMultipleLanguages;
        this.vocabularyNames = builder.vocabularyNames;
        this.vocabularyFilterNames = builder.vocabularyFilterNames;
    }

    /**
     * <p>
     * Specify the language code that represents the language spoken in your audio.
     * </p>
     * <p>
     * If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to enable
     * automatic language identification.
     * </p>
     * <p>
     * For a list of languages supported with Amazon Transcribe streaming, refer to the <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Specify the language code that represents the language spoken in your audio.</p>
     *         <p>
     *         If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to
     *         enable automatic language identification.
     *         </p>
     *         <p>
     *         For a list of languages supported with Amazon Transcribe streaming, refer to the <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a>
     *         table.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * Specify the language code that represents the language spoken in your audio.
     * </p>
     * <p>
     * If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to enable
     * automatic language identification.
     * </p>
     * <p>
     * For a list of languages supported with Amazon Transcribe streaming, refer to the <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Specify the language code that represents the language spoken in your audio.</p>
     *         <p>
     *         If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to
     *         enable automatic language identification.
     *         </p>
     *         <p>
     *         For a list of languages supported with Amazon Transcribe streaming, refer to the <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a>
     *         table.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The sample rate of the input audio (in hertz). Low-quality audio, such as telephone audio, is typically around
     * 8,000 Hz. High-quality audio typically ranges from 16,000 Hz to 48,000 Hz. Note that the sample rate you specify
     * must match that of your audio.
     * </p>
     * 
     * @return The sample rate of the input audio (in hertz). Low-quality audio, such as telephone audio, is typically
     *         around 8,000 Hz. High-quality audio typically ranges from 16,000 Hz to 48,000 Hz. Note that the sample
     *         rate you specify must match that of your audio.
     */
    public final Integer mediaSampleRateHertz() {
        return mediaSampleRateHertz;
    }

    /**
     * <p>
     * Specify the encoding of your input audio. Supported formats are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * FLAC
     * </p>
     * </li>
     * <li>
     * <p>
     * OPUS-encoded audio in an Ogg container
     * </p>
     * </li>
     * <li>
     * <p>
     * PCM (only signed 16-bit little-endian audio formats, which does not include WAV)
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaEncoding}
     * will return {@link MediaEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mediaEncodingAsString}.
     * </p>
     * 
     * @return Specify the encoding of your input audio. Supported formats are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         FLAC
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPUS-encoded audio in an Ogg container
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PCM (only signed 16-bit little-endian audio formats, which does not include WAV)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a>.
     * @see MediaEncoding
     */
    public final MediaEncoding mediaEncoding() {
        return MediaEncoding.fromValue(mediaEncoding);
    }

    /**
     * <p>
     * Specify the encoding of your input audio. Supported formats are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * FLAC
     * </p>
     * </li>
     * <li>
     * <p>
     * OPUS-encoded audio in an Ogg container
     * </p>
     * </li>
     * <li>
     * <p>
     * PCM (only signed 16-bit little-endian audio formats, which does not include WAV)
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaEncoding}
     * will return {@link MediaEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mediaEncodingAsString}.
     * </p>
     * 
     * @return Specify the encoding of your input audio. Supported formats are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         FLAC
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPUS-encoded audio in an Ogg container
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PCM (only signed 16-bit little-endian audio formats, which does not include WAV)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a>.
     * @see MediaEncoding
     */
    public final String mediaEncodingAsString() {
        return mediaEncoding;
    }

    /**
     * <p>
     * Specify the name of the custom vocabulary that you want to use when processing your transcription. Note that
     * vocabulary names are case sensitive.
     * </p>
     * <p>
     * If the language of the specified custom vocabulary doesn't match the language identified in your media, the
     * custom vocabulary is not applied to your transcription.
     * </p>
     * <important>
     * <p>
     * This parameter is <b>not</b> intended for use with the <code>IdentifyLanguage</code> parameter. If you're
     * including <code>IdentifyLanguage</code> in your request and want to use one or more custom vocabularies with your
     * transcription, use the <code>VocabularyNames</code> parameter instead.
     * </p>
     * </important>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.
     * </p>
     * 
     * @return Specify the name of the custom vocabulary that you want to use when processing your transcription. Note
     *         that vocabulary names are case sensitive.</p>
     *         <p>
     *         If the language of the specified custom vocabulary doesn't match the language identified in your media,
     *         the custom vocabulary is not applied to your transcription.
     *         </p>
     *         <important>
     *         <p>
     *         This parameter is <b>not</b> intended for use with the <code>IdentifyLanguage</code> parameter. If you're
     *         including <code>IdentifyLanguage</code> in your request and want to use one or more custom vocabularies
     *         with your transcription, use the <code>VocabularyNames</code> parameter instead.
     *         </p>
     *         </important>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.
     */
    public final String vocabularyName() {
        return vocabularyName;
    }

    /**
     * <p>
     * Specify a name for your transcription session. If you don't include this parameter in your request, Amazon
     * Transcribe generates an ID and returns it in the response.
     * </p>
     * <p>
     * You can use a session ID to retry a streaming session.
     * </p>
     * 
     * @return Specify a name for your transcription session. If you don't include this parameter in your request,
     *         Amazon Transcribe generates an ID and returns it in the response.</p>
     *         <p>
     *         You can use a session ID to retry a streaming session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * Specify the name of the custom vocabulary filter that you want to use when processing your transcription. Note
     * that vocabulary filter names are case sensitive.
     * </p>
     * <p>
     * If the language of the specified custom vocabulary filter doesn't match the language identified in your media,
     * the vocabulary filter is not applied to your transcription.
     * </p>
     * <important>
     * <p>
     * This parameter is <b>not</b> intended for use with the <code>IdentifyLanguage</code> parameter. If you're
     * including <code>IdentifyLanguage</code> in your request and want to use one or more vocabulary filters with your
     * transcription, use the <code>VocabularyFilterNames</code> parameter instead.
     * </p>
     * </important>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary filtering with
     * unwanted words</a>.
     * </p>
     * 
     * @return Specify the name of the custom vocabulary filter that you want to use when processing your transcription.
     *         Note that vocabulary filter names are case sensitive.</p>
     *         <p>
     *         If the language of the specified custom vocabulary filter doesn't match the language identified in your
     *         media, the vocabulary filter is not applied to your transcription.
     *         </p>
     *         <important>
     *         <p>
     *         This parameter is <b>not</b> intended for use with the <code>IdentifyLanguage</code> parameter. If you're
     *         including <code>IdentifyLanguage</code> in your request and want to use one or more vocabulary filters
     *         with your transcription, use the <code>VocabularyFilterNames</code> parameter instead.
     *         </p>
     *         </important>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary
     *         filtering with unwanted words</a>.
     */
    public final String vocabularyFilterName() {
        return vocabularyFilterName;
    }

    /**
     * <p>
     * Specify how you want your vocabulary filter applied to your transcript.
     * </p>
     * <p>
     * To replace words with <code>***</code>, choose <code>mask</code>.
     * </p>
     * <p>
     * To delete words, choose <code>remove</code>.
     * </p>
     * <p>
     * To flag words without changing them, choose <code>tag</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vocabularyFilterMethod} will return {@link VocabularyFilterMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #vocabularyFilterMethodAsString}.
     * </p>
     * 
     * @return Specify how you want your vocabulary filter applied to your transcript.</p>
     *         <p>
     *         To replace words with <code>***</code>, choose <code>mask</code>.
     *         </p>
     *         <p>
     *         To delete words, choose <code>remove</code>.
     *         </p>
     *         <p>
     *         To flag words without changing them, choose <code>tag</code>.
     * @see VocabularyFilterMethod
     */
    public final VocabularyFilterMethod vocabularyFilterMethod() {
        return VocabularyFilterMethod.fromValue(vocabularyFilterMethod);
    }

    /**
     * <p>
     * Specify how you want your vocabulary filter applied to your transcript.
     * </p>
     * <p>
     * To replace words with <code>***</code>, choose <code>mask</code>.
     * </p>
     * <p>
     * To delete words, choose <code>remove</code>.
     * </p>
     * <p>
     * To flag words without changing them, choose <code>tag</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vocabularyFilterMethod} will return {@link VocabularyFilterMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #vocabularyFilterMethodAsString}.
     * </p>
     * 
     * @return Specify how you want your vocabulary filter applied to your transcript.</p>
     *         <p>
     *         To replace words with <code>***</code>, choose <code>mask</code>.
     *         </p>
     *         <p>
     *         To delete words, choose <code>remove</code>.
     *         </p>
     *         <p>
     *         To flag words without changing them, choose <code>tag</code>.
     * @see VocabularyFilterMethod
     */
    public final String vocabularyFilterMethodAsString() {
        return vocabularyFilterMethod;
    }

    /**
     * <p>
     * Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the speech
     * from individual speakers in your media file.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers (diarization)</a>.
     * </p>
     * 
     * @return Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the
     *         speech from individual speakers in your media file.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers
     *         (diarization)</a>.
     */
    public final Boolean showSpeakerLabel() {
        return showSpeakerLabel;
    }

    /**
     * <p>
     * Enables channel identification in multi-channel audio.
     * </p>
     * <p>
     * Channel identification transcribes the audio on each channel independently, then appends the output for each
     * channel into one transcript.
     * </p>
     * <p>
     * If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a
     * continuous manner and your transcript is not separated by channel.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing
     * multi-channel audio</a>.
     * </p>
     * 
     * @return Enables channel identification in multi-channel audio.</p>
     *         <p>
     *         Channel identification transcribes the audio on each channel independently, then appends the output for
     *         each channel into one transcript.
     *         </p>
     *         <p>
     *         If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a
     *         continuous manner and your transcript is not separated by channel.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel
     *         audio</a>.
     */
    public final Boolean enableChannelIdentification() {
        return enableChannelIdentification;
    }

    /**
     * <p>
     * Specify the number of channels in your audio stream. Up to two channels are supported.
     * </p>
     * 
     * @return Specify the number of channels in your audio stream. Up to two channels are supported.
     */
    public final Integer numberOfChannels() {
        return numberOfChannels;
    }

    /**
     * <p>
     * Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency in
     * your output, but may impact accuracy. For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
     * >Partial-result stabilization</a>.
     * </p>
     * 
     * @return Enables partial result stabilization for your transcription. Partial result stabilization can reduce
     *         latency in your output, but may impact accuracy. For more information, see <a href=
     *         "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
     *         >Partial-result stabilization</a>.
     */
    public final Boolean enablePartialResultsStabilization() {
        return enablePartialResultsStabilization;
    }

    /**
     * <p>
     * Specify the level of stability to use when you enable partial results stabilization (
     * <code>EnablePartialResultsStabilization</code>).
     * </p>
     * <p>
     * Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
     * >Partial-result stabilization</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #partialResultsStability} will return {@link PartialResultsStability#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #partialResultsStabilityAsString}.
     * </p>
     * 
     * @return Specify the level of stability to use when you enable partial results stabilization (
     *         <code>EnablePartialResultsStabilization</code>).</p>
     *         <p>
     *         Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower
     *         accuracy.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
     *         >Partial-result stabilization</a>.
     * @see PartialResultsStability
     */
    public final PartialResultsStability partialResultsStability() {
        return PartialResultsStability.fromValue(partialResultsStability);
    }

    /**
     * <p>
     * Specify the level of stability to use when you enable partial results stabilization (
     * <code>EnablePartialResultsStabilization</code>).
     * </p>
     * <p>
     * Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
     * >Partial-result stabilization</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #partialResultsStability} will return {@link PartialResultsStability#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #partialResultsStabilityAsString}.
     * </p>
     * 
     * @return Specify the level of stability to use when you enable partial results stabilization (
     *         <code>EnablePartialResultsStabilization</code>).</p>
     *         <p>
     *         Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower
     *         accuracy.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
     *         >Partial-result stabilization</a>.
     * @see PartialResultsStability
     */
    public final String partialResultsStabilityAsString() {
        return partialResultsStability;
    }

    /**
     * <p>
     * Labels all personally identifiable information (PII) identified in your transcript.
     * </p>
     * <p>
     * Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is flagged
     * upon complete transcription of an audio segment.
     * </p>
     * <p>
     * You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same request.
     * If you set both, your request returns a <code>BadRequestException</code>.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting
     * or identifying personally identifiable information</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentIdentificationType} will return {@link ContentIdentificationType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contentIdentificationTypeAsString}.
     * </p>
     * 
     * @return Labels all personally identifiable information (PII) identified in your transcript.</p>
     *         <p>
     *         Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is
     *         flagged upon complete transcription of an audio segment.
     *         </p>
     *         <p>
     *         You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same
     *         request. If you set both, your request returns a <code>BadRequestException</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
     *         personally identifiable information</a>.
     * @see ContentIdentificationType
     */
    public final ContentIdentificationType contentIdentificationType() {
        return ContentIdentificationType.fromValue(contentIdentificationType);
    }

    /**
     * <p>
     * Labels all personally identifiable information (PII) identified in your transcript.
     * </p>
     * <p>
     * Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is flagged
     * upon complete transcription of an audio segment.
     * </p>
     * <p>
     * You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same request.
     * If you set both, your request returns a <code>BadRequestException</code>.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting
     * or identifying personally identifiable information</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentIdentificationType} will return {@link ContentIdentificationType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contentIdentificationTypeAsString}.
     * </p>
     * 
     * @return Labels all personally identifiable information (PII) identified in your transcript.</p>
     *         <p>
     *         Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is
     *         flagged upon complete transcription of an audio segment.
     *         </p>
     *         <p>
     *         You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same
     *         request. If you set both, your request returns a <code>BadRequestException</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
     *         personally identifiable information</a>.
     * @see ContentIdentificationType
     */
    public final String contentIdentificationTypeAsString() {
        return contentIdentificationType;
    }

    /**
     * <p>
     * Redacts all personally identifiable information (PII) identified in your transcript.
     * </p>
     * <p>
     * Content redaction is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is redacted
     * upon complete transcription of an audio segment.
     * </p>
     * <p>
     * You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same request.
     * If you set both, your request returns a <code>BadRequestException</code>.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting
     * or identifying personally identifiable information</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentRedactionType} will return {@link ContentRedactionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #contentRedactionTypeAsString}.
     * </p>
     * 
     * @return Redacts all personally identifiable information (PII) identified in your transcript.</p>
     *         <p>
     *         Content redaction is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is
     *         redacted upon complete transcription of an audio segment.
     *         </p>
     *         <p>
     *         You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same
     *         request. If you set both, your request returns a <code>BadRequestException</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
     *         personally identifiable information</a>.
     * @see ContentRedactionType
     */
    public final ContentRedactionType contentRedactionType() {
        return ContentRedactionType.fromValue(contentRedactionType);
    }

    /**
     * <p>
     * Redacts all personally identifiable information (PII) identified in your transcript.
     * </p>
     * <p>
     * Content redaction is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is redacted
     * upon complete transcription of an audio segment.
     * </p>
     * <p>
     * You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same request.
     * If you set both, your request returns a <code>BadRequestException</code>.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting
     * or identifying personally identifiable information</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentRedactionType} will return {@link ContentRedactionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #contentRedactionTypeAsString}.
     * </p>
     * 
     * @return Redacts all personally identifiable information (PII) identified in your transcript.</p>
     *         <p>
     *         Content redaction is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is
     *         redacted upon complete transcription of an audio segment.
     *         </p>
     *         <p>
     *         You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same
     *         request. If you set both, your request returns a <code>BadRequestException</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
     *         personally identifiable information</a>.
     * @see ContentRedactionType
     */
    public final String contentRedactionTypeAsString() {
        return contentRedactionType;
    }

    /**
     * <p>
     * Specify which types of personally identifiable information (PII) you want to redact in your transcript. You can
     * include as many types as you'd like, or you can select <code>ALL</code>.
     * </p>
     * <p>
     * To include <code>PiiEntityTypes</code> in your request, you must also include either
     * <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.
     * </p>
     * <p>
     * Values must be comma-separated and can include: <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING</code>,
     * <code>CREDIT_DEBIT_NUMBER</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>,
     * <code>PIN</code>, <code>EMAIL</code>, <code>ADDRESS</code>, <code>NAME</code>, <code>PHONE</code>,
     * <code>SSN</code>, or <code>ALL</code>.
     * </p>
     * 
     * @return Specify which types of personally identifiable information (PII) you want to redact in your transcript.
     *         You can include as many types as you'd like, or you can select <code>ALL</code>.</p>
     *         <p>
     *         To include <code>PiiEntityTypes</code> in your request, you must also include either
     *         <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.
     *         </p>
     *         <p>
     *         Values must be comma-separated and can include: <code>BANK_ACCOUNT_NUMBER</code>,
     *         <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_NUMBER</code>, <code>CREDIT_DEBIT_CVV</code>,
     *         <code>CREDIT_DEBIT_EXPIRY</code>, <code>PIN</code>, <code>EMAIL</code>, <code>ADDRESS</code>,
     *         <code>NAME</code>, <code>PHONE</code>, <code>SSN</code>, or <code>ALL</code>.
     */
    public final String piiEntityTypes() {
        return piiEntityTypes;
    }

    /**
     * <p>
     * Specify the name of the custom language model that you want to use when processing your transcription. Note that
     * language model names are case sensitive.
     * </p>
     * <p>
     * The language of the specified language model must match the language code you specify in your transcription
     * request. If the languages don't match, the custom language model isn't applied. There are no errors or warnings
     * associated with a language mismatch.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language models</a>.
     * </p>
     * 
     * @return Specify the name of the custom language model that you want to use when processing your transcription.
     *         Note that language model names are case sensitive.</p>
     *         <p>
     *         The language of the specified language model must match the language code you specify in your
     *         transcription request. If the languages don't match, the custom language model isn't applied. There are
     *         no errors or warnings associated with a language mismatch.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language
     *         models</a>.
     */
    public final String languageModelName() {
        return languageModelName;
    }

    /**
     * <p>
     * Enables automatic language identification for your transcription.
     * </p>
     * <p>
     * If you include <code>IdentifyLanguage</code>, you can optionally include a list of language codes, using
     * <code>LanguageOptions</code>, that you think may be present in your audio stream. Including language options can
     * improve transcription accuracy.
     * </p>
     * <p>
     * You can also include a preferred language using <code>PreferredLanguage</code>. Adding a preferred language can
     * help Amazon Transcribe identify the language faster than if you omit this parameter.
     * </p>
     * <p>
     * If you have multi-channel audio that contains different languages on each channel, and you've enabled channel
     * identification, automatic language identification identifies the dominant language on each audio channel.
     * </p>
     * <p>
     * Note that you must include either <code>LanguageCode</code> or <code>IdentifyLanguage</code> or
     * <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters, your
     * transcription job fails.
     * </p>
     * <p>
     * Streaming language identification can't be combined with custom language models or redaction.
     * </p>
     * 
     * @return Enables automatic language identification for your transcription.</p>
     *         <p>
     *         If you include <code>IdentifyLanguage</code>, you can optionally include a list of language codes, using
     *         <code>LanguageOptions</code>, that you think may be present in your audio stream. Including language
     *         options can improve transcription accuracy.
     *         </p>
     *         <p>
     *         You can also include a preferred language using <code>PreferredLanguage</code>. Adding a preferred
     *         language can help Amazon Transcribe identify the language faster than if you omit this parameter.
     *         </p>
     *         <p>
     *         If you have multi-channel audio that contains different languages on each channel, and you've enabled
     *         channel identification, automatic language identification identifies the dominant language on each audio
     *         channel.
     *         </p>
     *         <p>
     *         Note that you must include either <code>LanguageCode</code> or <code>IdentifyLanguage</code> or
     *         <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters,
     *         your transcription job fails.
     *         </p>
     *         <p>
     *         Streaming language identification can't be combined with custom language models or redaction.
     */
    public final Boolean identifyLanguage() {
        return identifyLanguage;
    }

    /**
     * <p>
     * Specify two or more language codes that represent the languages you think may be present in your media; including
     * more than five is not recommended. If you're unsure what languages are present, do not include this parameter.
     * </p>
     * <p>
     * Including language options can improve the accuracy of language identification.
     * </p>
     * <p>
     * If you include <code>LanguageOptions</code> in your request, you must also include <code>IdentifyLanguage</code>.
     * </p>
     * <p>
     * For a list of languages supported with Amazon Transcribe streaming, refer to the <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.
     * </p>
     * <important>
     * <p>
     * You can only include one language dialect per language per stream. For example, you cannot include
     * <code>en-US</code> and <code>en-AU</code> in the same request.
     * </p>
     * </important>
     * 
     * @return Specify two or more language codes that represent the languages you think may be present in your media;
     *         including more than five is not recommended. If you're unsure what languages are present, do not include
     *         this parameter.</p>
     *         <p>
     *         Including language options can improve the accuracy of language identification.
     *         </p>
     *         <p>
     *         If you include <code>LanguageOptions</code> in your request, you must also include
     *         <code>IdentifyLanguage</code>.
     *         </p>
     *         <p>
     *         For a list of languages supported with Amazon Transcribe streaming, refer to the <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a>
     *         table.
     *         </p>
     *         <important>
     *         <p>
     *         You can only include one language dialect per language per stream. For example, you cannot include
     *         <code>en-US</code> and <code>en-AU</code> in the same request.
     *         </p>
     */
    public final String languageOptions() {
        return languageOptions;
    }

    /**
     * <p>
     * Specify a preferred language from the subset of languages codes you specified in <code>LanguageOptions</code>.
     * </p>
     * <p>
     * You can only use this parameter if you've included <code>IdentifyLanguage</code> and <code>LanguageOptions</code>
     * in your request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #preferredLanguage}
     * will return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #preferredLanguageAsString}.
     * </p>
     * 
     * @return Specify a preferred language from the subset of languages codes you specified in
     *         <code>LanguageOptions</code>.</p>
     *         <p>
     *         You can only use this parameter if you've included <code>IdentifyLanguage</code> and
     *         <code>LanguageOptions</code> in your request.
     * @see LanguageCode
     */
    public final LanguageCode preferredLanguage() {
        return LanguageCode.fromValue(preferredLanguage);
    }

    /**
     * <p>
     * Specify a preferred language from the subset of languages codes you specified in <code>LanguageOptions</code>.
     * </p>
     * <p>
     * You can only use this parameter if you've included <code>IdentifyLanguage</code> and <code>LanguageOptions</code>
     * in your request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #preferredLanguage}
     * will return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #preferredLanguageAsString}.
     * </p>
     * 
     * @return Specify a preferred language from the subset of languages codes you specified in
     *         <code>LanguageOptions</code>.</p>
     *         <p>
     *         You can only use this parameter if you've included <code>IdentifyLanguage</code> and
     *         <code>LanguageOptions</code> in your request.
     * @see LanguageCode
     */
    public final String preferredLanguageAsString() {
        return preferredLanguage;
    }

    /**
     * <p>
     * Enables automatic multi-language identification in your transcription job request. Use this parameter if your
     * stream contains more than one language. If your stream contains only one language, use IdentifyLanguage instead.
     * </p>
     * <p>
     * If you include <code>IdentifyMultipleLanguages</code>, you can optionally include a list of language codes, using
     * <code>LanguageOptions</code>, that you think may be present in your stream. Including
     * <code>LanguageOptions</code> restricts <code>IdentifyMultipleLanguages</code> to only the language options that
     * you specify, which can improve transcription accuracy.
     * </p>
     * <p>
     * If you want to apply a custom vocabulary or a custom vocabulary filter to your automatic multiple language
     * identification request, include <code>VocabularyNames</code> or <code>VocabularyFilterNames</code>.
     * </p>
     * <p>
     * Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or
     * <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters, your
     * transcription job fails.
     * </p>
     * 
     * @return Enables automatic multi-language identification in your transcription job request. Use this parameter if
     *         your stream contains more than one language. If your stream contains only one language, use
     *         IdentifyLanguage instead.</p>
     *         <p>
     *         If you include <code>IdentifyMultipleLanguages</code>, you can optionally include a list of language
     *         codes, using <code>LanguageOptions</code>, that you think may be present in your stream. Including
     *         <code>LanguageOptions</code> restricts <code>IdentifyMultipleLanguages</code> to only the language
     *         options that you specify, which can improve transcription accuracy.
     *         </p>
     *         <p>
     *         If you want to apply a custom vocabulary or a custom vocabulary filter to your automatic multiple
     *         language identification request, include <code>VocabularyNames</code> or
     *         <code>VocabularyFilterNames</code>.
     *         </p>
     *         <p>
     *         Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or
     *         <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters,
     *         your transcription job fails.
     */
    public final Boolean identifyMultipleLanguages() {
        return identifyMultipleLanguages;
    }

    /**
     * <p>
     * Specify the names of the custom vocabularies that you want to use when processing your transcription. Note that
     * vocabulary names are case sensitive.
     * </p>
     * <p>
     * If none of the languages of the specified custom vocabularies match the language identified in your media, your
     * job fails.
     * </p>
     * <important>
     * <p>
     * This parameter is only intended for use <b>with</b> the <code>IdentifyLanguage</code> parameter. If you're
     * <b>not</b> including <code>IdentifyLanguage</code> in your request and want to use a custom vocabulary with your
     * transcription, use the <code>VocabularyName</code> parameter instead.
     * </p>
     * </important>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.
     * </p>
     * 
     * @return Specify the names of the custom vocabularies that you want to use when processing your transcription.
     *         Note that vocabulary names are case sensitive.</p>
     *         <p>
     *         If none of the languages of the specified custom vocabularies match the language identified in your
     *         media, your job fails.
     *         </p>
     *         <important>
     *         <p>
     *         This parameter is only intended for use <b>with</b> the <code>IdentifyLanguage</code> parameter. If
     *         you're <b>not</b> including <code>IdentifyLanguage</code> in your request and want to use a custom
     *         vocabulary with your transcription, use the <code>VocabularyName</code> parameter instead.
     *         </p>
     *         </important>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.
     */
    public final String vocabularyNames() {
        return vocabularyNames;
    }

    /**
     * <p>
     * Specify the names of the custom vocabulary filters that you want to use when processing your transcription. Note
     * that vocabulary filter names are case sensitive.
     * </p>
     * <p>
     * If none of the languages of the specified custom vocabulary filters match the language identified in your media,
     * your job fails.
     * </p>
     * <important>
     * <p>
     * This parameter is only intended for use <b>with</b> the <code>IdentifyLanguage</code> parameter. If you're
     * <b>not</b> including <code>IdentifyLanguage</code> in your request and want to use a custom vocabulary filter
     * with your transcription, use the <code>VocabularyFilterName</code> parameter instead.
     * </p>
     * </important>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary filtering with
     * unwanted words</a>.
     * </p>
     * 
     * @return Specify the names of the custom vocabulary filters that you want to use when processing your
     *         transcription. Note that vocabulary filter names are case sensitive.</p>
     *         <p>
     *         If none of the languages of the specified custom vocabulary filters match the language identified in your
     *         media, your job fails.
     *         </p>
     *         <important>
     *         <p>
     *         This parameter is only intended for use <b>with</b> the <code>IdentifyLanguage</code> parameter. If
     *         you're <b>not</b> including <code>IdentifyLanguage</code> in your request and want to use a custom
     *         vocabulary filter with your transcription, use the <code>VocabularyFilterName</code> parameter instead.
     *         </p>
     *         </important>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary
     *         filtering with unwanted words</a>.
     */
    public final String vocabularyFilterNames() {
        return vocabularyFilterNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mediaSampleRateHertz());
        hashCode = 31 * hashCode + Objects.hashCode(mediaEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(showSpeakerLabel());
        hashCode = 31 * hashCode + Objects.hashCode(enableChannelIdentification());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfChannels());
        hashCode = 31 * hashCode + Objects.hashCode(enablePartialResultsStabilization());
        hashCode = 31 * hashCode + Objects.hashCode(partialResultsStabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentIdentificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentRedactionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(piiEntityTypes());
        hashCode = 31 * hashCode + Objects.hashCode(languageModelName());
        hashCode = 31 * hashCode + Objects.hashCode(identifyLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(languageOptions());
        hashCode = 31 * hashCode + Objects.hashCode(preferredLanguageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identifyMultipleLanguages());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyNames());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterNames());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartStreamTranscriptionRequest)) {
            return false;
        }
        StartStreamTranscriptionRequest other = (StartStreamTranscriptionRequest) obj;
        return Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(mediaSampleRateHertz(), other.mediaSampleRateHertz())
                && Objects.equals(mediaEncodingAsString(), other.mediaEncodingAsString())
                && Objects.equals(vocabularyName(), other.vocabularyName()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(vocabularyFilterName(), other.vocabularyFilterName())
                && Objects.equals(vocabularyFilterMethodAsString(), other.vocabularyFilterMethodAsString())
                && Objects.equals(showSpeakerLabel(), other.showSpeakerLabel())
                && Objects.equals(enableChannelIdentification(), other.enableChannelIdentification())
                && Objects.equals(numberOfChannels(), other.numberOfChannels())
                && Objects.equals(enablePartialResultsStabilization(), other.enablePartialResultsStabilization())
                && Objects.equals(partialResultsStabilityAsString(), other.partialResultsStabilityAsString())
                && Objects.equals(contentIdentificationTypeAsString(), other.contentIdentificationTypeAsString())
                && Objects.equals(contentRedactionTypeAsString(), other.contentRedactionTypeAsString())
                && Objects.equals(piiEntityTypes(), other.piiEntityTypes())
                && Objects.equals(languageModelName(), other.languageModelName())
                && Objects.equals(identifyLanguage(), other.identifyLanguage())
                && Objects.equals(languageOptions(), other.languageOptions())
                && Objects.equals(preferredLanguageAsString(), other.preferredLanguageAsString())
                && Objects.equals(identifyMultipleLanguages(), other.identifyMultipleLanguages())
                && Objects.equals(vocabularyNames(), other.vocabularyNames())
                && Objects.equals(vocabularyFilterNames(), other.vocabularyFilterNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartStreamTranscriptionRequest").add("LanguageCode", languageCodeAsString())
                .add("MediaSampleRateHertz", mediaSampleRateHertz()).add("MediaEncoding", mediaEncodingAsString())
                .add("VocabularyName", vocabularyName()).add("SessionId", sessionId())
                .add("VocabularyFilterName", vocabularyFilterName())
                .add("VocabularyFilterMethod", vocabularyFilterMethodAsString()).add("ShowSpeakerLabel", showSpeakerLabel())
                .add("EnableChannelIdentification", enableChannelIdentification()).add("NumberOfChannels", numberOfChannels())
                .add("EnablePartialResultsStabilization", enablePartialResultsStabilization())
                .add("PartialResultsStability", partialResultsStabilityAsString())
                .add("ContentIdentificationType", contentIdentificationTypeAsString())
                .add("ContentRedactionType", contentRedactionTypeAsString()).add("PiiEntityTypes", piiEntityTypes())
                .add("LanguageModelName", languageModelName()).add("IdentifyLanguage", identifyLanguage())
                .add("LanguageOptions", languageOptions()).add("PreferredLanguage", preferredLanguageAsString())
                .add("IdentifyMultipleLanguages", identifyMultipleLanguages()).add("VocabularyNames", vocabularyNames())
                .add("VocabularyFilterNames", vocabularyFilterNames()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "MediaSampleRateHertz":
            return Optional.ofNullable(clazz.cast(mediaSampleRateHertz()));
        case "MediaEncoding":
            return Optional.ofNullable(clazz.cast(mediaEncodingAsString()));
        case "VocabularyName":
            return Optional.ofNullable(clazz.cast(vocabularyName()));
        case "SessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "VocabularyFilterName":
            return Optional.ofNullable(clazz.cast(vocabularyFilterName()));
        case "VocabularyFilterMethod":
            return Optional.ofNullable(clazz.cast(vocabularyFilterMethodAsString()));
        case "ShowSpeakerLabel":
            return Optional.ofNullable(clazz.cast(showSpeakerLabel()));
        case "EnableChannelIdentification":
            return Optional.ofNullable(clazz.cast(enableChannelIdentification()));
        case "NumberOfChannels":
            return Optional.ofNullable(clazz.cast(numberOfChannels()));
        case "EnablePartialResultsStabilization":
            return Optional.ofNullable(clazz.cast(enablePartialResultsStabilization()));
        case "PartialResultsStability":
            return Optional.ofNullable(clazz.cast(partialResultsStabilityAsString()));
        case "ContentIdentificationType":
            return Optional.ofNullable(clazz.cast(contentIdentificationTypeAsString()));
        case "ContentRedactionType":
            return Optional.ofNullable(clazz.cast(contentRedactionTypeAsString()));
        case "PiiEntityTypes":
            return Optional.ofNullable(clazz.cast(piiEntityTypes()));
        case "LanguageModelName":
            return Optional.ofNullable(clazz.cast(languageModelName()));
        case "IdentifyLanguage":
            return Optional.ofNullable(clazz.cast(identifyLanguage()));
        case "LanguageOptions":
            return Optional.ofNullable(clazz.cast(languageOptions()));
        case "PreferredLanguage":
            return Optional.ofNullable(clazz.cast(preferredLanguageAsString()));
        case "IdentifyMultipleLanguages":
            return Optional.ofNullable(clazz.cast(identifyMultipleLanguages()));
        case "VocabularyNames":
            return Optional.ofNullable(clazz.cast(vocabularyNames()));
        case "VocabularyFilterNames":
            return Optional.ofNullable(clazz.cast(vocabularyFilterNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartStreamTranscriptionRequest, T> g) {
        return obj -> g.apply((StartStreamTranscriptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeStreamingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartStreamTranscriptionRequest> {
        /**
         * <p>
         * Specify the language code that represents the language spoken in your audio.
         * </p>
         * <p>
         * If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to enable
         * automatic language identification.
         * </p>
         * <p>
         * For a list of languages supported with Amazon Transcribe streaming, refer to the <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a>
         * table.
         * </p>
         * 
         * @param languageCode
         *        Specify the language code that represents the language spoken in your audio.</p>
         *        <p>
         *        If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to
         *        enable automatic language identification.
         *        </p>
         *        <p>
         *        For a list of languages supported with Amazon Transcribe streaming, refer to the <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported
         *        languages</a> table.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * Specify the language code that represents the language spoken in your audio.
         * </p>
         * <p>
         * If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to enable
         * automatic language identification.
         * </p>
         * <p>
         * For a list of languages supported with Amazon Transcribe streaming, refer to the <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a>
         * table.
         * </p>
         * 
         * @param languageCode
         *        Specify the language code that represents the language spoken in your audio.</p>
         *        <p>
         *        If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to
         *        enable automatic language identification.
         *        </p>
         *        <p>
         *        For a list of languages supported with Amazon Transcribe streaming, refer to the <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported
         *        languages</a> table.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * The sample rate of the input audio (in hertz). Low-quality audio, such as telephone audio, is typically
         * around 8,000 Hz. High-quality audio typically ranges from 16,000 Hz to 48,000 Hz. Note that the sample rate
         * you specify must match that of your audio.
         * </p>
         * 
         * @param mediaSampleRateHertz
         *        The sample rate of the input audio (in hertz). Low-quality audio, such as telephone audio, is
         *        typically around 8,000 Hz. High-quality audio typically ranges from 16,000 Hz to 48,000 Hz. Note that
         *        the sample rate you specify must match that of your audio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaSampleRateHertz(Integer mediaSampleRateHertz);

        /**
         * <p>
         * Specify the encoding of your input audio. Supported formats are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * FLAC
         * </p>
         * </li>
         * <li>
         * <p>
         * OPUS-encoded audio in an Ogg container
         * </p>
         * </li>
         * <li>
         * <p>
         * PCM (only signed 16-bit little-endian audio formats, which does not include WAV)
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a>.
         * </p>
         * 
         * @param mediaEncoding
         *        Specify the encoding of your input audio. Supported formats are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        FLAC
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPUS-encoded audio in an Ogg container
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PCM (only signed 16-bit little-endian audio formats, which does not include WAV)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media
         *        formats</a>.
         * @see MediaEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaEncoding
         */
        Builder mediaEncoding(String mediaEncoding);

        /**
         * <p>
         * Specify the encoding of your input audio. Supported formats are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * FLAC
         * </p>
         * </li>
         * <li>
         * <p>
         * OPUS-encoded audio in an Ogg container
         * </p>
         * </li>
         * <li>
         * <p>
         * PCM (only signed 16-bit little-endian audio formats, which does not include WAV)
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a>.
         * </p>
         * 
         * @param mediaEncoding
         *        Specify the encoding of your input audio. Supported formats are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        FLAC
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPUS-encoded audio in an Ogg container
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PCM (only signed 16-bit little-endian audio formats, which does not include WAV)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media
         *        formats</a>.
         * @see MediaEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaEncoding
         */
        Builder mediaEncoding(MediaEncoding mediaEncoding);

        /**
         * <p>
         * Specify the name of the custom vocabulary that you want to use when processing your transcription. Note that
         * vocabulary names are case sensitive.
         * </p>
         * <p>
         * If the language of the specified custom vocabulary doesn't match the language identified in your media, the
         * custom vocabulary is not applied to your transcription.
         * </p>
         * <important>
         * <p>
         * This parameter is <b>not</b> intended for use with the <code>IdentifyLanguage</code> parameter. If you're
         * including <code>IdentifyLanguage</code> in your request and want to use one or more custom vocabularies with
         * your transcription, use the <code>VocabularyNames</code> parameter instead.
         * </p>
         * </important>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.
         * </p>
         * 
         * @param vocabularyName
         *        Specify the name of the custom vocabulary that you want to use when processing your transcription.
         *        Note that vocabulary names are case sensitive.</p>
         *        <p>
         *        If the language of the specified custom vocabulary doesn't match the language identified in your
         *        media, the custom vocabulary is not applied to your transcription.
         *        </p>
         *        <important>
         *        <p>
         *        This parameter is <b>not</b> intended for use with the <code>IdentifyLanguage</code> parameter. If
         *        you're including <code>IdentifyLanguage</code> in your request and want to use one or more custom
         *        vocabularies with your transcription, use the <code>VocabularyNames</code> parameter instead.
         *        </p>
         *        </important>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom
         *        vocabularies</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyName(String vocabularyName);

        /**
         * <p>
         * Specify a name for your transcription session. If you don't include this parameter in your request, Amazon
         * Transcribe generates an ID and returns it in the response.
         * </p>
         * <p>
         * You can use a session ID to retry a streaming session.
         * </p>
         * 
         * @param sessionId
         *        Specify a name for your transcription session. If you don't include this parameter in your request,
         *        Amazon Transcribe generates an ID and returns it in the response.</p>
         *        <p>
         *        You can use a session ID to retry a streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * Specify the name of the custom vocabulary filter that you want to use when processing your transcription.
         * Note that vocabulary filter names are case sensitive.
         * </p>
         * <p>
         * If the language of the specified custom vocabulary filter doesn't match the language identified in your
         * media, the vocabulary filter is not applied to your transcription.
         * </p>
         * <important>
         * <p>
         * This parameter is <b>not</b> intended for use with the <code>IdentifyLanguage</code> parameter. If you're
         * including <code>IdentifyLanguage</code> in your request and want to use one or more vocabulary filters with
         * your transcription, use the <code>VocabularyFilterNames</code> parameter instead.
         * </p>
         * </important>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary filtering
         * with unwanted words</a>.
         * </p>
         * 
         * @param vocabularyFilterName
         *        Specify the name of the custom vocabulary filter that you want to use when processing your
         *        transcription. Note that vocabulary filter names are case sensitive.</p>
         *        <p>
         *        If the language of the specified custom vocabulary filter doesn't match the language identified in
         *        your media, the vocabulary filter is not applied to your transcription.
         *        </p>
         *        <important>
         *        <p>
         *        This parameter is <b>not</b> intended for use with the <code>IdentifyLanguage</code> parameter. If
         *        you're including <code>IdentifyLanguage</code> in your request and want to use one or more vocabulary
         *        filters with your transcription, use the <code>VocabularyFilterNames</code> parameter instead.
         *        </p>
         *        </important>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary
         *        filtering with unwanted words</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterName(String vocabularyFilterName);

        /**
         * <p>
         * Specify how you want your vocabulary filter applied to your transcript.
         * </p>
         * <p>
         * To replace words with <code>***</code>, choose <code>mask</code>.
         * </p>
         * <p>
         * To delete words, choose <code>remove</code>.
         * </p>
         * <p>
         * To flag words without changing them, choose <code>tag</code>.
         * </p>
         * 
         * @param vocabularyFilterMethod
         *        Specify how you want your vocabulary filter applied to your transcript.</p>
         *        <p>
         *        To replace words with <code>***</code>, choose <code>mask</code>.
         *        </p>
         *        <p>
         *        To delete words, choose <code>remove</code>.
         *        </p>
         *        <p>
         *        To flag words without changing them, choose <code>tag</code>.
         * @see VocabularyFilterMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyFilterMethod
         */
        Builder vocabularyFilterMethod(String vocabularyFilterMethod);

        /**
         * <p>
         * Specify how you want your vocabulary filter applied to your transcript.
         * </p>
         * <p>
         * To replace words with <code>***</code>, choose <code>mask</code>.
         * </p>
         * <p>
         * To delete words, choose <code>remove</code>.
         * </p>
         * <p>
         * To flag words without changing them, choose <code>tag</code>.
         * </p>
         * 
         * @param vocabularyFilterMethod
         *        Specify how you want your vocabulary filter applied to your transcript.</p>
         *        <p>
         *        To replace words with <code>***</code>, choose <code>mask</code>.
         *        </p>
         *        <p>
         *        To delete words, choose <code>remove</code>.
         *        </p>
         *        <p>
         *        To flag words without changing them, choose <code>tag</code>.
         * @see VocabularyFilterMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyFilterMethod
         */
        Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod);

        /**
         * <p>
         * Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the
         * speech from individual speakers in your media file.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers
         * (diarization)</a>.
         * </p>
         * 
         * @param showSpeakerLabel
         *        Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels
         *        the speech from individual speakers in your media file.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers
         *        (diarization)</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder showSpeakerLabel(Boolean showSpeakerLabel);

        /**
         * <p>
         * Enables channel identification in multi-channel audio.
         * </p>
         * <p>
         * Channel identification transcribes the audio on each channel independently, then appends the output for each
         * channel into one transcript.
         * </p>
         * <p>
         * If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a
         * continuous manner and your transcript is not separated by channel.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel audio</a>.
         * </p>
         * 
         * @param enableChannelIdentification
         *        Enables channel identification in multi-channel audio.</p>
         *        <p>
         *        Channel identification transcribes the audio on each channel independently, then appends the output
         *        for each channel into one transcript.
         *        </p>
         *        <p>
         *        If you have multi-channel audio and do not enable channel identification, your audio is transcribed in
         *        a continuous manner and your transcript is not separated by channel.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel
         *        audio</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableChannelIdentification(Boolean enableChannelIdentification);

        /**
         * <p>
         * Specify the number of channels in your audio stream. Up to two channels are supported.
         * </p>
         * 
         * @param numberOfChannels
         *        Specify the number of channels in your audio stream. Up to two channels are supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfChannels(Integer numberOfChannels);

        /**
         * <p>
         * Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency
         * in your output, but may impact accuracy. For more information, see <a href=
         * "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
         * >Partial-result stabilization</a>.
         * </p>
         * 
         * @param enablePartialResultsStabilization
         *        Enables partial result stabilization for your transcription. Partial result stabilization can reduce
         *        latency in your output, but may impact accuracy. For more information, see <a href=
         *        "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
         *        >Partial-result stabilization</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePartialResultsStabilization(Boolean enablePartialResultsStabilization);

        /**
         * <p>
         * Specify the level of stability to use when you enable partial results stabilization (
         * <code>EnablePartialResultsStabilization</code>).
         * </p>
         * <p>
         * Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower
         * accuracy.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
         * >Partial-result stabilization</a>.
         * </p>
         * 
         * @param partialResultsStability
         *        Specify the level of stability to use when you enable partial results stabilization (
         *        <code>EnablePartialResultsStabilization</code>).</p>
         *        <p>
         *        Low stability provides the highest accuracy. High stability transcribes faster, but with slightly
         *        lower accuracy.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
         *        >Partial-result stabilization</a>.
         * @see PartialResultsStability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartialResultsStability
         */
        Builder partialResultsStability(String partialResultsStability);

        /**
         * <p>
         * Specify the level of stability to use when you enable partial results stabilization (
         * <code>EnablePartialResultsStabilization</code>).
         * </p>
         * <p>
         * Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower
         * accuracy.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
         * >Partial-result stabilization</a>.
         * </p>
         * 
         * @param partialResultsStability
         *        Specify the level of stability to use when you enable partial results stabilization (
         *        <code>EnablePartialResultsStabilization</code>).</p>
         *        <p>
         *        Low stability provides the highest accuracy. High stability transcribes faster, but with slightly
         *        lower accuracy.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization"
         *        >Partial-result stabilization</a>.
         * @see PartialResultsStability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartialResultsStability
         */
        Builder partialResultsStability(PartialResultsStability partialResultsStability);

        /**
         * <p>
         * Labels all personally identifiable information (PII) identified in your transcript.
         * </p>
         * <p>
         * Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is
         * flagged upon complete transcription of an audio segment.
         * </p>
         * <p>
         * You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same
         * request. If you set both, your request returns a <code>BadRequestException</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
         * personally identifiable information</a>.
         * </p>
         * 
         * @param contentIdentificationType
         *        Labels all personally identifiable information (PII) identified in your transcript.</p>
         *        <p>
         *        Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code>
         *        is flagged upon complete transcription of an audio segment.
         *        </p>
         *        <p>
         *        You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same
         *        request. If you set both, your request returns a <code>BadRequestException</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
         *        personally identifiable information</a>.
         * @see ContentIdentificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentIdentificationType
         */
        Builder contentIdentificationType(String contentIdentificationType);

        /**
         * <p>
         * Labels all personally identifiable information (PII) identified in your transcript.
         * </p>
         * <p>
         * Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is
         * flagged upon complete transcription of an audio segment.
         * </p>
         * <p>
         * You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same
         * request. If you set both, your request returns a <code>BadRequestException</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
         * personally identifiable information</a>.
         * </p>
         * 
         * @param contentIdentificationType
         *        Labels all personally identifiable information (PII) identified in your transcript.</p>
         *        <p>
         *        Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code>
         *        is flagged upon complete transcription of an audio segment.
         *        </p>
         *        <p>
         *        You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same
         *        request. If you set both, your request returns a <code>BadRequestException</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
         *        personally identifiable information</a>.
         * @see ContentIdentificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentIdentificationType
         */
        Builder contentIdentificationType(ContentIdentificationType contentIdentificationType);

        /**
         * <p>
         * Redacts all personally identifiable information (PII) identified in your transcript.
         * </p>
         * <p>
         * Content redaction is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is redacted
         * upon complete transcription of an audio segment.
         * </p>
         * <p>
         * You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same
         * request. If you set both, your request returns a <code>BadRequestException</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
         * personally identifiable information</a>.
         * </p>
         * 
         * @param contentRedactionType
         *        Redacts all personally identifiable information (PII) identified in your transcript.</p>
         *        <p>
         *        Content redaction is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is
         *        redacted upon complete transcription of an audio segment.
         *        </p>
         *        <p>
         *        You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same
         *        request. If you set both, your request returns a <code>BadRequestException</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
         *        personally identifiable information</a>.
         * @see ContentRedactionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentRedactionType
         */
        Builder contentRedactionType(String contentRedactionType);

        /**
         * <p>
         * Redacts all personally identifiable information (PII) identified in your transcript.
         * </p>
         * <p>
         * Content redaction is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is redacted
         * upon complete transcription of an audio segment.
         * </p>
         * <p>
         * You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same
         * request. If you set both, your request returns a <code>BadRequestException</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
         * personally identifiable information</a>.
         * </p>
         * 
         * @param contentRedactionType
         *        Redacts all personally identifiable information (PII) identified in your transcript.</p>
         *        <p>
         *        Content redaction is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is
         *        redacted upon complete transcription of an audio segment.
         *        </p>
         *        <p>
         *        You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same
         *        request. If you set both, your request returns a <code>BadRequestException</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying
         *        personally identifiable information</a>.
         * @see ContentRedactionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentRedactionType
         */
        Builder contentRedactionType(ContentRedactionType contentRedactionType);

        /**
         * <p>
         * Specify which types of personally identifiable information (PII) you want to redact in your transcript. You
         * can include as many types as you'd like, or you can select <code>ALL</code>.
         * </p>
         * <p>
         * To include <code>PiiEntityTypes</code> in your request, you must also include either
         * <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.
         * </p>
         * <p>
         * Values must be comma-separated and can include: <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING</code>,
         * <code>CREDIT_DEBIT_NUMBER</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>,
         * <code>PIN</code>, <code>EMAIL</code>, <code>ADDRESS</code>, <code>NAME</code>, <code>PHONE</code>,
         * <code>SSN</code>, or <code>ALL</code>.
         * </p>
         * 
         * @param piiEntityTypes
         *        Specify which types of personally identifiable information (PII) you want to redact in your
         *        transcript. You can include as many types as you'd like, or you can select <code>ALL</code>.</p>
         *        <p>
         *        To include <code>PiiEntityTypes</code> in your request, you must also include either
         *        <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.
         *        </p>
         *        <p>
         *        Values must be comma-separated and can include: <code>BANK_ACCOUNT_NUMBER</code>,
         *        <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_NUMBER</code>, <code>CREDIT_DEBIT_CVV</code>,
         *        <code>CREDIT_DEBIT_EXPIRY</code>, <code>PIN</code>, <code>EMAIL</code>, <code>ADDRESS</code>,
         *        <code>NAME</code>, <code>PHONE</code>, <code>SSN</code>, or <code>ALL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder piiEntityTypes(String piiEntityTypes);

        /**
         * <p>
         * Specify the name of the custom language model that you want to use when processing your transcription. Note
         * that language model names are case sensitive.
         * </p>
         * <p>
         * The language of the specified language model must match the language code you specify in your transcription
         * request. If the languages don't match, the custom language model isn't applied. There are no errors or
         * warnings associated with a language mismatch.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language
         * models</a>.
         * </p>
         * 
         * @param languageModelName
         *        Specify the name of the custom language model that you want to use when processing your transcription.
         *        Note that language model names are case sensitive.</p>
         *        <p>
         *        The language of the specified language model must match the language code you specify in your
         *        transcription request. If the languages don't match, the custom language model isn't applied. There
         *        are no errors or warnings associated with a language mismatch.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language
         *        models</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageModelName(String languageModelName);

        /**
         * <p>
         * Enables automatic language identification for your transcription.
         * </p>
         * <p>
         * If you include <code>IdentifyLanguage</code>, you can optionally include a list of language codes, using
         * <code>LanguageOptions</code>, that you think may be present in your audio stream. Including language options
         * can improve transcription accuracy.
         * </p>
         * <p>
         * You can also include a preferred language using <code>PreferredLanguage</code>. Adding a preferred language
         * can help Amazon Transcribe identify the language faster than if you omit this parameter.
         * </p>
         * <p>
         * If you have multi-channel audio that contains different languages on each channel, and you've enabled channel
         * identification, automatic language identification identifies the dominant language on each audio channel.
         * </p>
         * <p>
         * Note that you must include either <code>LanguageCode</code> or <code>IdentifyLanguage</code> or
         * <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters,
         * your transcription job fails.
         * </p>
         * <p>
         * Streaming language identification can't be combined with custom language models or redaction.
         * </p>
         * 
         * @param identifyLanguage
         *        Enables automatic language identification for your transcription.</p>
         *        <p>
         *        If you include <code>IdentifyLanguage</code>, you can optionally include a list of language codes,
         *        using <code>LanguageOptions</code>, that you think may be present in your audio stream. Including
         *        language options can improve transcription accuracy.
         *        </p>
         *        <p>
         *        You can also include a preferred language using <code>PreferredLanguage</code>. Adding a preferred
         *        language can help Amazon Transcribe identify the language faster than if you omit this parameter.
         *        </p>
         *        <p>
         *        If you have multi-channel audio that contains different languages on each channel, and you've enabled
         *        channel identification, automatic language identification identifies the dominant language on each
         *        audio channel.
         *        </p>
         *        <p>
         *        Note that you must include either <code>LanguageCode</code> or <code>IdentifyLanguage</code> or
         *        <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these
         *        parameters, your transcription job fails.
         *        </p>
         *        <p>
         *        Streaming language identification can't be combined with custom language models or redaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifyLanguage(Boolean identifyLanguage);

        /**
         * <p>
         * Specify two or more language codes that represent the languages you think may be present in your media;
         * including more than five is not recommended. If you're unsure what languages are present, do not include this
         * parameter.
         * </p>
         * <p>
         * Including language options can improve the accuracy of language identification.
         * </p>
         * <p>
         * If you include <code>LanguageOptions</code> in your request, you must also include
         * <code>IdentifyLanguage</code>.
         * </p>
         * <p>
         * For a list of languages supported with Amazon Transcribe streaming, refer to the <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a>
         * table.
         * </p>
         * <important>
         * <p>
         * You can only include one language dialect per language per stream. For example, you cannot include
         * <code>en-US</code> and <code>en-AU</code> in the same request.
         * </p>
         * </important>
         * 
         * @param languageOptions
         *        Specify two or more language codes that represent the languages you think may be present in your
         *        media; including more than five is not recommended. If you're unsure what languages are present, do
         *        not include this parameter.</p>
         *        <p>
         *        Including language options can improve the accuracy of language identification.
         *        </p>
         *        <p>
         *        If you include <code>LanguageOptions</code> in your request, you must also include
         *        <code>IdentifyLanguage</code>.
         *        </p>
         *        <p>
         *        For a list of languages supported with Amazon Transcribe streaming, refer to the <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported
         *        languages</a> table.
         *        </p>
         *        <important>
         *        <p>
         *        You can only include one language dialect per language per stream. For example, you cannot include
         *        <code>en-US</code> and <code>en-AU</code> in the same request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageOptions(String languageOptions);

        /**
         * <p>
         * Specify a preferred language from the subset of languages codes you specified in <code>LanguageOptions</code>
         * .
         * </p>
         * <p>
         * You can only use this parameter if you've included <code>IdentifyLanguage</code> and
         * <code>LanguageOptions</code> in your request.
         * </p>
         * 
         * @param preferredLanguage
         *        Specify a preferred language from the subset of languages codes you specified in
         *        <code>LanguageOptions</code>.</p>
         *        <p>
         *        You can only use this parameter if you've included <code>IdentifyLanguage</code> and
         *        <code>LanguageOptions</code> in your request.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder preferredLanguage(String preferredLanguage);

        /**
         * <p>
         * Specify a preferred language from the subset of languages codes you specified in <code>LanguageOptions</code>
         * .
         * </p>
         * <p>
         * You can only use this parameter if you've included <code>IdentifyLanguage</code> and
         * <code>LanguageOptions</code> in your request.
         * </p>
         * 
         * @param preferredLanguage
         *        Specify a preferred language from the subset of languages codes you specified in
         *        <code>LanguageOptions</code>.</p>
         *        <p>
         *        You can only use this parameter if you've included <code>IdentifyLanguage</code> and
         *        <code>LanguageOptions</code> in your request.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder preferredLanguage(LanguageCode preferredLanguage);

        /**
         * <p>
         * Enables automatic multi-language identification in your transcription job request. Use this parameter if your
         * stream contains more than one language. If your stream contains only one language, use IdentifyLanguage
         * instead.
         * </p>
         * <p>
         * If you include <code>IdentifyMultipleLanguages</code>, you can optionally include a list of language codes,
         * using <code>LanguageOptions</code>, that you think may be present in your stream. Including
         * <code>LanguageOptions</code> restricts <code>IdentifyMultipleLanguages</code> to only the language options
         * that you specify, which can improve transcription accuracy.
         * </p>
         * <p>
         * If you want to apply a custom vocabulary or a custom vocabulary filter to your automatic multiple language
         * identification request, include <code>VocabularyNames</code> or <code>VocabularyFilterNames</code>.
         * </p>
         * <p>
         * Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or
         * <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters,
         * your transcription job fails.
         * </p>
         * 
         * @param identifyMultipleLanguages
         *        Enables automatic multi-language identification in your transcription job request. Use this parameter
         *        if your stream contains more than one language. If your stream contains only one language, use
         *        IdentifyLanguage instead.</p>
         *        <p>
         *        If you include <code>IdentifyMultipleLanguages</code>, you can optionally include a list of language
         *        codes, using <code>LanguageOptions</code>, that you think may be present in your stream. Including
         *        <code>LanguageOptions</code> restricts <code>IdentifyMultipleLanguages</code> to only the language
         *        options that you specify, which can improve transcription accuracy.
         *        </p>
         *        <p>
         *        If you want to apply a custom vocabulary or a custom vocabulary filter to your automatic multiple
         *        language identification request, include <code>VocabularyNames</code> or
         *        <code>VocabularyFilterNames</code>.
         *        </p>
         *        <p>
         *        Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or
         *        <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these
         *        parameters, your transcription job fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifyMultipleLanguages(Boolean identifyMultipleLanguages);

        /**
         * <p>
         * Specify the names of the custom vocabularies that you want to use when processing your transcription. Note
         * that vocabulary names are case sensitive.
         * </p>
         * <p>
         * If none of the languages of the specified custom vocabularies match the language identified in your media,
         * your job fails.
         * </p>
         * <important>
         * <p>
         * This parameter is only intended for use <b>with</b> the <code>IdentifyLanguage</code> parameter. If you're
         * <b>not</b> including <code>IdentifyLanguage</code> in your request and want to use a custom vocabulary with
         * your transcription, use the <code>VocabularyName</code> parameter instead.
         * </p>
         * </important>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.
         * </p>
         * 
         * @param vocabularyNames
         *        Specify the names of the custom vocabularies that you want to use when processing your transcription.
         *        Note that vocabulary names are case sensitive.</p>
         *        <p>
         *        If none of the languages of the specified custom vocabularies match the language identified in your
         *        media, your job fails.
         *        </p>
         *        <important>
         *        <p>
         *        This parameter is only intended for use <b>with</b> the <code>IdentifyLanguage</code> parameter. If
         *        you're <b>not</b> including <code>IdentifyLanguage</code> in your request and want to use a custom
         *        vocabulary with your transcription, use the <code>VocabularyName</code> parameter instead.
         *        </p>
         *        </important>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom
         *        vocabularies</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyNames(String vocabularyNames);

        /**
         * <p>
         * Specify the names of the custom vocabulary filters that you want to use when processing your transcription.
         * Note that vocabulary filter names are case sensitive.
         * </p>
         * <p>
         * If none of the languages of the specified custom vocabulary filters match the language identified in your
         * media, your job fails.
         * </p>
         * <important>
         * <p>
         * This parameter is only intended for use <b>with</b> the <code>IdentifyLanguage</code> parameter. If you're
         * <b>not</b> including <code>IdentifyLanguage</code> in your request and want to use a custom vocabulary filter
         * with your transcription, use the <code>VocabularyFilterName</code> parameter instead.
         * </p>
         * </important>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary filtering
         * with unwanted words</a>.
         * </p>
         * 
         * @param vocabularyFilterNames
         *        Specify the names of the custom vocabulary filters that you want to use when processing your
         *        transcription. Note that vocabulary filter names are case sensitive.</p>
         *        <p>
         *        If none of the languages of the specified custom vocabulary filters match the language identified in
         *        your media, your job fails.
         *        </p>
         *        <important>
         *        <p>
         *        This parameter is only intended for use <b>with</b> the <code>IdentifyLanguage</code> parameter. If
         *        you're <b>not</b> including <code>IdentifyLanguage</code> in your request and want to use a custom
         *        vocabulary filter with your transcription, use the <code>VocabularyFilterName</code> parameter
         *        instead.
         *        </p>
         *        </important>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary
         *        filtering with unwanted words</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterNames(String vocabularyFilterNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranscribeStreamingRequest.BuilderImpl implements Builder {
        private String languageCode;

        private Integer mediaSampleRateHertz;

        private String mediaEncoding;

        private String vocabularyName;

        private String sessionId;

        private String vocabularyFilterName;

        private String vocabularyFilterMethod;

        private Boolean showSpeakerLabel;

        private Boolean enableChannelIdentification;

        private Integer numberOfChannels;

        private Boolean enablePartialResultsStabilization;

        private String partialResultsStability;

        private String contentIdentificationType;

        private String contentRedactionType;

        private String piiEntityTypes;

        private String languageModelName;

        private Boolean identifyLanguage;

        private String languageOptions;

        private String preferredLanguage;

        private Boolean identifyMultipleLanguages;

        private String vocabularyNames;

        private String vocabularyFilterNames;

        private BuilderImpl() {
        }

        private BuilderImpl(StartStreamTranscriptionRequest model) {
            super(model);
            languageCode(model.languageCode);
            mediaSampleRateHertz(model.mediaSampleRateHertz);
            mediaEncoding(model.mediaEncoding);
            vocabularyName(model.vocabularyName);
            sessionId(model.sessionId);
            vocabularyFilterName(model.vocabularyFilterName);
            vocabularyFilterMethod(model.vocabularyFilterMethod);
            showSpeakerLabel(model.showSpeakerLabel);
            enableChannelIdentification(model.enableChannelIdentification);
            numberOfChannels(model.numberOfChannels);
            enablePartialResultsStabilization(model.enablePartialResultsStabilization);
            partialResultsStability(model.partialResultsStability);
            contentIdentificationType(model.contentIdentificationType);
            contentRedactionType(model.contentRedactionType);
            piiEntityTypes(model.piiEntityTypes);
            languageModelName(model.languageModelName);
            identifyLanguage(model.identifyLanguage);
            languageOptions(model.languageOptions);
            preferredLanguage(model.preferredLanguage);
            identifyMultipleLanguages(model.identifyMultipleLanguages);
            vocabularyNames(model.vocabularyNames);
            vocabularyFilterNames(model.vocabularyFilterNames);
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Integer getMediaSampleRateHertz() {
            return mediaSampleRateHertz;
        }

        public final void setMediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
        }

        @Override
        public final Builder mediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
            return this;
        }

        public final String getMediaEncoding() {
            return mediaEncoding;
        }

        public final void setMediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
        }

        @Override
        public final Builder mediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
            return this;
        }

        @Override
        public final Builder mediaEncoding(MediaEncoding mediaEncoding) {
            this.mediaEncoding(mediaEncoding == null ? null : mediaEncoding.toString());
            return this;
        }

        public final String getVocabularyName() {
            return vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getVocabularyFilterName() {
            return vocabularyFilterName;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final String getVocabularyFilterMethod() {
            return vocabularyFilterMethod;
        }

        public final void setVocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
        }

        @Override
        public final Builder vocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
            return this;
        }

        @Override
        public final Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod) {
            this.vocabularyFilterMethod(vocabularyFilterMethod == null ? null : vocabularyFilterMethod.toString());
            return this;
        }

        public final Boolean getShowSpeakerLabel() {
            return showSpeakerLabel;
        }

        public final void setShowSpeakerLabel(Boolean showSpeakerLabel) {
            this.showSpeakerLabel = showSpeakerLabel;
        }

        @Override
        public final Builder showSpeakerLabel(Boolean showSpeakerLabel) {
            this.showSpeakerLabel = showSpeakerLabel;
            return this;
        }

        public final Boolean getEnableChannelIdentification() {
            return enableChannelIdentification;
        }

        public final void setEnableChannelIdentification(Boolean enableChannelIdentification) {
            this.enableChannelIdentification = enableChannelIdentification;
        }

        @Override
        public final Builder enableChannelIdentification(Boolean enableChannelIdentification) {
            this.enableChannelIdentification = enableChannelIdentification;
            return this;
        }

        public final Integer getNumberOfChannels() {
            return numberOfChannels;
        }

        public final void setNumberOfChannels(Integer numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
        }

        @Override
        public final Builder numberOfChannels(Integer numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
            return this;
        }

        public final Boolean getEnablePartialResultsStabilization() {
            return enablePartialResultsStabilization;
        }

        public final void setEnablePartialResultsStabilization(Boolean enablePartialResultsStabilization) {
            this.enablePartialResultsStabilization = enablePartialResultsStabilization;
        }

        @Override
        public final Builder enablePartialResultsStabilization(Boolean enablePartialResultsStabilization) {
            this.enablePartialResultsStabilization = enablePartialResultsStabilization;
            return this;
        }

        public final String getPartialResultsStability() {
            return partialResultsStability;
        }

        public final void setPartialResultsStability(String partialResultsStability) {
            this.partialResultsStability = partialResultsStability;
        }

        @Override
        public final Builder partialResultsStability(String partialResultsStability) {
            this.partialResultsStability = partialResultsStability;
            return this;
        }

        @Override
        public final Builder partialResultsStability(PartialResultsStability partialResultsStability) {
            this.partialResultsStability(partialResultsStability == null ? null : partialResultsStability.toString());
            return this;
        }

        public final String getContentIdentificationType() {
            return contentIdentificationType;
        }

        public final void setContentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
        }

        @Override
        public final Builder contentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
            return this;
        }

        @Override
        public final Builder contentIdentificationType(ContentIdentificationType contentIdentificationType) {
            this.contentIdentificationType(contentIdentificationType == null ? null : contentIdentificationType.toString());
            return this;
        }

        public final String getContentRedactionType() {
            return contentRedactionType;
        }

        public final void setContentRedactionType(String contentRedactionType) {
            this.contentRedactionType = contentRedactionType;
        }

        @Override
        public final Builder contentRedactionType(String contentRedactionType) {
            this.contentRedactionType = contentRedactionType;
            return this;
        }

        @Override
        public final Builder contentRedactionType(ContentRedactionType contentRedactionType) {
            this.contentRedactionType(contentRedactionType == null ? null : contentRedactionType.toString());
            return this;
        }

        public final String getPiiEntityTypes() {
            return piiEntityTypes;
        }

        public final void setPiiEntityTypes(String piiEntityTypes) {
            this.piiEntityTypes = piiEntityTypes;
        }

        @Override
        public final Builder piiEntityTypes(String piiEntityTypes) {
            this.piiEntityTypes = piiEntityTypes;
            return this;
        }

        public final String getLanguageModelName() {
            return languageModelName;
        }

        public final void setLanguageModelName(String languageModelName) {
            this.languageModelName = languageModelName;
        }

        @Override
        public final Builder languageModelName(String languageModelName) {
            this.languageModelName = languageModelName;
            return this;
        }

        public final Boolean getIdentifyLanguage() {
            return identifyLanguage;
        }

        public final void setIdentifyLanguage(Boolean identifyLanguage) {
            this.identifyLanguage = identifyLanguage;
        }

        @Override
        public final Builder identifyLanguage(Boolean identifyLanguage) {
            this.identifyLanguage = identifyLanguage;
            return this;
        }

        public final String getLanguageOptions() {
            return languageOptions;
        }

        public final void setLanguageOptions(String languageOptions) {
            this.languageOptions = languageOptions;
        }

        @Override
        public final Builder languageOptions(String languageOptions) {
            this.languageOptions = languageOptions;
            return this;
        }

        public final String getPreferredLanguage() {
            return preferredLanguage;
        }

        public final void setPreferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
        }

        @Override
        public final Builder preferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
            return this;
        }

        @Override
        public final Builder preferredLanguage(LanguageCode preferredLanguage) {
            this.preferredLanguage(preferredLanguage == null ? null : preferredLanguage.toString());
            return this;
        }

        public final Boolean getIdentifyMultipleLanguages() {
            return identifyMultipleLanguages;
        }

        public final void setIdentifyMultipleLanguages(Boolean identifyMultipleLanguages) {
            this.identifyMultipleLanguages = identifyMultipleLanguages;
        }

        @Override
        public final Builder identifyMultipleLanguages(Boolean identifyMultipleLanguages) {
            this.identifyMultipleLanguages = identifyMultipleLanguages;
            return this;
        }

        public final String getVocabularyNames() {
            return vocabularyNames;
        }

        public final void setVocabularyNames(String vocabularyNames) {
            this.vocabularyNames = vocabularyNames;
        }

        @Override
        public final Builder vocabularyNames(String vocabularyNames) {
            this.vocabularyNames = vocabularyNames;
            return this;
        }

        public final String getVocabularyFilterNames() {
            return vocabularyFilterNames;
        }

        public final void setVocabularyFilterNames(String vocabularyFilterNames) {
            this.vocabularyFilterNames = vocabularyFilterNames;
        }

        @Override
        public final Builder vocabularyFilterNames(String vocabularyFilterNames) {
            this.vocabularyFilterNames = vocabularyFilterNames;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartStreamTranscriptionRequest build() {
            return new StartStreamTranscriptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
