/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains set of transcription results from one or more audio segments, along with additional information about the
 * parameters included in your request. For example, channel definitions, partial result stabilization, sentiment, and
 * issue detection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UtteranceEvent implements SdkPojo, Serializable, ToCopyableBuilder<UtteranceEvent.Builder, UtteranceEvent>,
        CallAnalyticsTranscriptResultStream {
    private static final SdkField<String> UTTERANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UtteranceId").getter(getter(UtteranceEvent::utteranceId)).setter(setter(Builder::utteranceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UtteranceId").build()).build();

    private static final SdkField<Boolean> IS_PARTIAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsPartial").getter(getter(UtteranceEvent::isPartial)).setter(setter(Builder::isPartial))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPartial").build()).build();

    private static final SdkField<String> PARTICIPANT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantRole").getter(getter(UtteranceEvent::participantRoleAsString))
            .setter(setter(Builder::participantRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantRole").build()).build();

    private static final SdkField<Long> BEGIN_OFFSET_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BeginOffsetMillis").getter(getter(UtteranceEvent::beginOffsetMillis))
            .setter(setter(Builder::beginOffsetMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffsetMillis").build()).build();

    private static final SdkField<Long> END_OFFSET_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("EndOffsetMillis").getter(getter(UtteranceEvent::endOffsetMillis))
            .setter(setter(Builder::endOffsetMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffsetMillis").build()).build();

    private static final SdkField<String> TRANSCRIPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Transcript").getter(getter(UtteranceEvent::transcript)).setter(setter(Builder::transcript))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transcript").build()).build();

    private static final SdkField<List<CallAnalyticsItem>> ITEMS_FIELD = SdkField
            .<List<CallAnalyticsItem>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(UtteranceEvent::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CallAnalyticsItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(CallAnalyticsItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CallAnalyticsEntity>> ENTITIES_FIELD = SdkField
            .<List<CallAnalyticsEntity>> builder(MarshallingType.LIST)
            .memberName("Entities")
            .getter(getter(UtteranceEvent::entities))
            .setter(setter(Builder::entities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CallAnalyticsEntity> builder(MarshallingType.SDK_POJO)
                                            .constructor(CallAnalyticsEntity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SENTIMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Sentiment").getter(getter(UtteranceEvent::sentimentAsString)).setter(setter(Builder::sentiment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sentiment").build()).build();

    private static final SdkField<List<IssueDetected>> ISSUES_DETECTED_FIELD = SdkField
            .<List<IssueDetected>> builder(MarshallingType.LIST)
            .memberName("IssuesDetected")
            .getter(getter(UtteranceEvent::issuesDetected))
            .setter(setter(Builder::issuesDetected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuesDetected").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IssueDetected> builder(MarshallingType.SDK_POJO)
                                            .constructor(IssueDetected::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UTTERANCE_ID_FIELD,
            IS_PARTIAL_FIELD, PARTICIPANT_ROLE_FIELD, BEGIN_OFFSET_MILLIS_FIELD, END_OFFSET_MILLIS_FIELD, TRANSCRIPT_FIELD,
            ITEMS_FIELD, ENTITIES_FIELD, SENTIMENT_FIELD, ISSUES_DETECTED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String utteranceId;

    private final Boolean isPartial;

    private final String participantRole;

    private final Long beginOffsetMillis;

    private final Long endOffsetMillis;

    private final String transcript;

    private final List<CallAnalyticsItem> items;

    private final List<CallAnalyticsEntity> entities;

    private final String sentiment;

    private final List<IssueDetected> issuesDetected;

    protected UtteranceEvent(BuilderImpl builder) {
        this.utteranceId = builder.utteranceId;
        this.isPartial = builder.isPartial;
        this.participantRole = builder.participantRole;
        this.beginOffsetMillis = builder.beginOffsetMillis;
        this.endOffsetMillis = builder.endOffsetMillis;
        this.transcript = builder.transcript;
        this.items = builder.items;
        this.entities = builder.entities;
        this.sentiment = builder.sentiment;
        this.issuesDetected = builder.issuesDetected;
    }

    /**
     * <p>
     * The unique identifier that is associated with the specified <code>UtteranceEvent</code>.
     * </p>
     * 
     * @return The unique identifier that is associated with the specified <code>UtteranceEvent</code>.
     */
    public final String utteranceId() {
        return utteranceId;
    }

    /**
     * <p>
     * Indicates whether the segment in the <code>UtteranceEvent</code> is complete (<code>FALSE</code>) or partial (
     * <code>TRUE</code>).
     * </p>
     * 
     * @return Indicates whether the segment in the <code>UtteranceEvent</code> is complete (<code>FALSE</code>) or
     *         partial (<code>TRUE</code>).
     */
    public final Boolean isPartial() {
        return isPartial;
    }

    /**
     * <p>
     * Provides the role of the speaker for each audio channel, either <code>CUSTOMER</code> or <code>AGENT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantRole}
     * will return {@link ParticipantRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantRoleAsString}.
     * </p>
     * 
     * @return Provides the role of the speaker for each audio channel, either <code>CUSTOMER</code> or
     *         <code>AGENT</code>.
     * @see ParticipantRole
     */
    public final ParticipantRole participantRole() {
        return ParticipantRole.fromValue(participantRole);
    }

    /**
     * <p>
     * Provides the role of the speaker for each audio channel, either <code>CUSTOMER</code> or <code>AGENT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantRole}
     * will return {@link ParticipantRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantRoleAsString}.
     * </p>
     * 
     * @return Provides the role of the speaker for each audio channel, either <code>CUSTOMER</code> or
     *         <code>AGENT</code>.
     * @see ParticipantRole
     */
    public final String participantRoleAsString() {
        return participantRole;
    }

    /**
     * <p>
     * The time, in milliseconds, from the beginning of the audio stream to the start of the <code>UtteranceEvent</code>
     * .
     * </p>
     * 
     * @return The time, in milliseconds, from the beginning of the audio stream to the start of the
     *         <code>UtteranceEvent</code>.
     */
    public final Long beginOffsetMillis() {
        return beginOffsetMillis;
    }

    /**
     * <p>
     * The time, in milliseconds, from the beginning of the audio stream to the start of the <code>UtteranceEvent</code>
     * .
     * </p>
     * 
     * @return The time, in milliseconds, from the beginning of the audio stream to the start of the
     *         <code>UtteranceEvent</code>.
     */
    public final Long endOffsetMillis() {
        return endOffsetMillis;
    }

    /**
     * <p>
     * Contains transcribed text.
     * </p>
     * 
     * @return Contains transcribed text.
     */
    public final String transcript() {
        return transcript;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains words, phrases, or punctuation marks that are associated with the specified <code>UtteranceEvent</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return Contains words, phrases, or punctuation marks that are associated with the specified
     *         <code>UtteranceEvent</code>.
     */
    public final List<CallAnalyticsItem> items() {
        return items;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntities() {
        return entities != null && !(entities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains entities identified as personally identifiable information (PII) in your transcription output.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntities} method.
     * </p>
     * 
     * @return Contains entities identified as personally identifiable information (PII) in your transcription output.
     */
    public final List<CallAnalyticsEntity> entities() {
        return entities;
    }

    /**
     * <p>
     * Provides the sentiment that was detected in the specified segment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sentiment} will
     * return {@link Sentiment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sentimentAsString}.
     * </p>
     * 
     * @return Provides the sentiment that was detected in the specified segment.
     * @see Sentiment
     */
    public final Sentiment sentiment() {
        return Sentiment.fromValue(sentiment);
    }

    /**
     * <p>
     * Provides the sentiment that was detected in the specified segment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sentiment} will
     * return {@link Sentiment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sentimentAsString}.
     * </p>
     * 
     * @return Provides the sentiment that was detected in the specified segment.
     * @see Sentiment
     */
    public final String sentimentAsString() {
        return sentiment;
    }

    /**
     * For responses, this returns true if the service returned a value for the IssuesDetected property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIssuesDetected() {
        return issuesDetected != null && !(issuesDetected instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides the issue that was detected in the specified segment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIssuesDetected} method.
     * </p>
     * 
     * @return Provides the issue that was detected in the specified segment.
     */
    public final List<IssueDetected> issuesDetected() {
        return issuesDetected;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(utteranceId());
        hashCode = 31 * hashCode + Objects.hashCode(isPartial());
        hashCode = 31 * hashCode + Objects.hashCode(participantRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(beginOffsetMillis());
        hashCode = 31 * hashCode + Objects.hashCode(endOffsetMillis());
        hashCode = 31 * hashCode + Objects.hashCode(transcript());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEntities() ? entities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sentimentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasIssuesDetected() ? issuesDetected() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UtteranceEvent)) {
            return false;
        }
        UtteranceEvent other = (UtteranceEvent) obj;
        return Objects.equals(utteranceId(), other.utteranceId()) && Objects.equals(isPartial(), other.isPartial())
                && Objects.equals(participantRoleAsString(), other.participantRoleAsString())
                && Objects.equals(beginOffsetMillis(), other.beginOffsetMillis())
                && Objects.equals(endOffsetMillis(), other.endOffsetMillis()) && Objects.equals(transcript(), other.transcript())
                && hasItems() == other.hasItems() && Objects.equals(items(), other.items())
                && hasEntities() == other.hasEntities() && Objects.equals(entities(), other.entities())
                && Objects.equals(sentimentAsString(), other.sentimentAsString())
                && hasIssuesDetected() == other.hasIssuesDetected() && Objects.equals(issuesDetected(), other.issuesDetected());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UtteranceEvent").add("UtteranceId", utteranceId()).add("IsPartial", isPartial())
                .add("ParticipantRole", participantRoleAsString()).add("BeginOffsetMillis", beginOffsetMillis())
                .add("EndOffsetMillis", endOffsetMillis()).add("Transcript", transcript())
                .add("Items", hasItems() ? items() : null).add("Entities", hasEntities() ? entities() : null)
                .add("Sentiment", sentimentAsString()).add("IssuesDetected", hasIssuesDetected() ? issuesDetected() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UtteranceId":
            return Optional.ofNullable(clazz.cast(utteranceId()));
        case "IsPartial":
            return Optional.ofNullable(clazz.cast(isPartial()));
        case "ParticipantRole":
            return Optional.ofNullable(clazz.cast(participantRoleAsString()));
        case "BeginOffsetMillis":
            return Optional.ofNullable(clazz.cast(beginOffsetMillis()));
        case "EndOffsetMillis":
            return Optional.ofNullable(clazz.cast(endOffsetMillis()));
        case "Transcript":
            return Optional.ofNullable(clazz.cast(transcript()));
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        case "Entities":
            return Optional.ofNullable(clazz.cast(entities()));
        case "Sentiment":
            return Optional.ofNullable(clazz.cast(sentimentAsString()));
        case "IssuesDetected":
            return Optional.ofNullable(clazz.cast(issuesDetected()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final UtteranceEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UtteranceId", UTTERANCE_ID_FIELD);
        map.put("IsPartial", IS_PARTIAL_FIELD);
        map.put("ParticipantRole", PARTICIPANT_ROLE_FIELD);
        map.put("BeginOffsetMillis", BEGIN_OFFSET_MILLIS_FIELD);
        map.put("EndOffsetMillis", END_OFFSET_MILLIS_FIELD);
        map.put("Transcript", TRANSCRIPT_FIELD);
        map.put("Items", ITEMS_FIELD);
        map.put("Entities", ENTITIES_FIELD);
        map.put("Sentiment", SENTIMENT_FIELD);
        map.put("IssuesDetected", ISSUES_DETECTED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UtteranceEvent, T> g) {
        return obj -> g.apply((UtteranceEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link UtteranceEvent}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(StartCallAnalyticsStreamTranscriptionResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UtteranceEvent> {
        /**
         * <p>
         * The unique identifier that is associated with the specified <code>UtteranceEvent</code>.
         * </p>
         * 
         * @param utteranceId
         *        The unique identifier that is associated with the specified <code>UtteranceEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utteranceId(String utteranceId);

        /**
         * <p>
         * Indicates whether the segment in the <code>UtteranceEvent</code> is complete (<code>FALSE</code>) or partial
         * (<code>TRUE</code>).
         * </p>
         * 
         * @param isPartial
         *        Indicates whether the segment in the <code>UtteranceEvent</code> is complete (<code>FALSE</code>) or
         *        partial (<code>TRUE</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPartial(Boolean isPartial);

        /**
         * <p>
         * Provides the role of the speaker for each audio channel, either <code>CUSTOMER</code> or <code>AGENT</code>.
         * </p>
         * 
         * @param participantRole
         *        Provides the role of the speaker for each audio channel, either <code>CUSTOMER</code> or
         *        <code>AGENT</code>.
         * @see ParticipantRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRole
         */
        Builder participantRole(String participantRole);

        /**
         * <p>
         * Provides the role of the speaker for each audio channel, either <code>CUSTOMER</code> or <code>AGENT</code>.
         * </p>
         * 
         * @param participantRole
         *        Provides the role of the speaker for each audio channel, either <code>CUSTOMER</code> or
         *        <code>AGENT</code>.
         * @see ParticipantRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRole
         */
        Builder participantRole(ParticipantRole participantRole);

        /**
         * <p>
         * The time, in milliseconds, from the beginning of the audio stream to the start of the
         * <code>UtteranceEvent</code>.
         * </p>
         * 
         * @param beginOffsetMillis
         *        The time, in milliseconds, from the beginning of the audio stream to the start of the
         *        <code>UtteranceEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginOffsetMillis(Long beginOffsetMillis);

        /**
         * <p>
         * The time, in milliseconds, from the beginning of the audio stream to the start of the
         * <code>UtteranceEvent</code>.
         * </p>
         * 
         * @param endOffsetMillis
         *        The time, in milliseconds, from the beginning of the audio stream to the start of the
         *        <code>UtteranceEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOffsetMillis(Long endOffsetMillis);

        /**
         * <p>
         * Contains transcribed text.
         * </p>
         * 
         * @param transcript
         *        Contains transcribed text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcript(String transcript);

        /**
         * <p>
         * Contains words, phrases, or punctuation marks that are associated with the specified
         * <code>UtteranceEvent</code>.
         * </p>
         * 
         * @param items
         *        Contains words, phrases, or punctuation marks that are associated with the specified
         *        <code>UtteranceEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<CallAnalyticsItem> items);

        /**
         * <p>
         * Contains words, phrases, or punctuation marks that are associated with the specified
         * <code>UtteranceEvent</code>.
         * </p>
         * 
         * @param items
         *        Contains words, phrases, or punctuation marks that are associated with the specified
         *        <code>UtteranceEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(CallAnalyticsItem... items);

        /**
         * <p>
         * Contains words, phrases, or punctuation marks that are associated with the specified
         * <code>UtteranceEvent</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transcribestreaming.model.CallAnalyticsItem.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.transcribestreaming.model.CallAnalyticsItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transcribestreaming.model.CallAnalyticsItem.Builder#build()} is called
         * immediately and its result is passed to {@link #items(List<CallAnalyticsItem>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transcribestreaming.model.CallAnalyticsItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<CallAnalyticsItem>)
         */
        Builder items(Consumer<CallAnalyticsItem.Builder>... items);

        /**
         * <p>
         * Contains entities identified as personally identifiable information (PII) in your transcription output.
         * </p>
         * 
         * @param entities
         *        Contains entities identified as personally identifiable information (PII) in your transcription
         *        output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(Collection<CallAnalyticsEntity> entities);

        /**
         * <p>
         * Contains entities identified as personally identifiable information (PII) in your transcription output.
         * </p>
         * 
         * @param entities
         *        Contains entities identified as personally identifiable information (PII) in your transcription
         *        output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(CallAnalyticsEntity... entities);

        /**
         * <p>
         * Contains entities identified as personally identifiable information (PII) in your transcription output.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transcribestreaming.model.CallAnalyticsEntity.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.transcribestreaming.model.CallAnalyticsEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transcribestreaming.model.CallAnalyticsEntity.Builder#build()} is
         * called immediately and its result is passed to {@link #entities(List<CallAnalyticsEntity>)}.
         * 
         * @param entities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transcribestreaming.model.CallAnalyticsEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entities(java.util.Collection<CallAnalyticsEntity>)
         */
        Builder entities(Consumer<CallAnalyticsEntity.Builder>... entities);

        /**
         * <p>
         * Provides the sentiment that was detected in the specified segment.
         * </p>
         * 
         * @param sentiment
         *        Provides the sentiment that was detected in the specified segment.
         * @see Sentiment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Sentiment
         */
        Builder sentiment(String sentiment);

        /**
         * <p>
         * Provides the sentiment that was detected in the specified segment.
         * </p>
         * 
         * @param sentiment
         *        Provides the sentiment that was detected in the specified segment.
         * @see Sentiment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Sentiment
         */
        Builder sentiment(Sentiment sentiment);

        /**
         * <p>
         * Provides the issue that was detected in the specified segment.
         * </p>
         * 
         * @param issuesDetected
         *        Provides the issue that was detected in the specified segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuesDetected(Collection<IssueDetected> issuesDetected);

        /**
         * <p>
         * Provides the issue that was detected in the specified segment.
         * </p>
         * 
         * @param issuesDetected
         *        Provides the issue that was detected in the specified segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuesDetected(IssueDetected... issuesDetected);

        /**
         * <p>
         * Provides the issue that was detected in the specified segment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transcribestreaming.model.IssueDetected.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.transcribestreaming.model.IssueDetected#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transcribestreaming.model.IssueDetected.Builder#build()} is called
         * immediately and its result is passed to {@link #issuesDetected(List<IssueDetected>)}.
         * 
         * @param issuesDetected
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transcribestreaming.model.IssueDetected.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #issuesDetected(java.util.Collection<IssueDetected>)
         */
        Builder issuesDetected(Consumer<IssueDetected.Builder>... issuesDetected);
    }

    protected static class BuilderImpl implements Builder {
        private String utteranceId;

        private Boolean isPartial;

        private String participantRole;

        private Long beginOffsetMillis;

        private Long endOffsetMillis;

        private String transcript;

        private List<CallAnalyticsItem> items = DefaultSdkAutoConstructList.getInstance();

        private List<CallAnalyticsEntity> entities = DefaultSdkAutoConstructList.getInstance();

        private String sentiment;

        private List<IssueDetected> issuesDetected = DefaultSdkAutoConstructList.getInstance();

        protected BuilderImpl() {
        }

        protected BuilderImpl(UtteranceEvent model) {
            utteranceId(model.utteranceId);
            isPartial(model.isPartial);
            participantRole(model.participantRole);
            beginOffsetMillis(model.beginOffsetMillis);
            endOffsetMillis(model.endOffsetMillis);
            transcript(model.transcript);
            items(model.items);
            entities(model.entities);
            sentiment(model.sentiment);
            issuesDetected(model.issuesDetected);
        }

        public final String getUtteranceId() {
            return utteranceId;
        }

        public final void setUtteranceId(String utteranceId) {
            this.utteranceId = utteranceId;
        }

        @Override
        public final Builder utteranceId(String utteranceId) {
            this.utteranceId = utteranceId;
            return this;
        }

        public final Boolean getIsPartial() {
            return isPartial;
        }

        public final void setIsPartial(Boolean isPartial) {
            this.isPartial = isPartial;
        }

        @Override
        public final Builder isPartial(Boolean isPartial) {
            this.isPartial = isPartial;
            return this;
        }

        public final String getParticipantRole() {
            return participantRole;
        }

        public final void setParticipantRole(String participantRole) {
            this.participantRole = participantRole;
        }

        @Override
        public final Builder participantRole(String participantRole) {
            this.participantRole = participantRole;
            return this;
        }

        @Override
        public final Builder participantRole(ParticipantRole participantRole) {
            this.participantRole(participantRole == null ? null : participantRole.toString());
            return this;
        }

        public final Long getBeginOffsetMillis() {
            return beginOffsetMillis;
        }

        public final void setBeginOffsetMillis(Long beginOffsetMillis) {
            this.beginOffsetMillis = beginOffsetMillis;
        }

        @Override
        public final Builder beginOffsetMillis(Long beginOffsetMillis) {
            this.beginOffsetMillis = beginOffsetMillis;
            return this;
        }

        public final Long getEndOffsetMillis() {
            return endOffsetMillis;
        }

        public final void setEndOffsetMillis(Long endOffsetMillis) {
            this.endOffsetMillis = endOffsetMillis;
        }

        @Override
        public final Builder endOffsetMillis(Long endOffsetMillis) {
            this.endOffsetMillis = endOffsetMillis;
            return this;
        }

        public final String getTranscript() {
            return transcript;
        }

        public final void setTranscript(String transcript) {
            this.transcript = transcript;
        }

        @Override
        public final Builder transcript(String transcript) {
            this.transcript = transcript;
            return this;
        }

        public final List<CallAnalyticsItem.Builder> getItems() {
            List<CallAnalyticsItem.Builder> result = CallAnalyticsItemListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<CallAnalyticsItem.BuilderImpl> items) {
            this.items = CallAnalyticsItemListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<CallAnalyticsItem> items) {
            this.items = CallAnalyticsItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(CallAnalyticsItem... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<CallAnalyticsItem.Builder>... items) {
            items(Stream.of(items).map(c -> CallAnalyticsItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CallAnalyticsEntity.Builder> getEntities() {
            List<CallAnalyticsEntity.Builder> result = CallAnalyticsEntityListCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<CallAnalyticsEntity.BuilderImpl> entities) {
            this.entities = CallAnalyticsEntityListCopier.copyFromBuilder(entities);
        }

        @Override
        public final Builder entities(Collection<CallAnalyticsEntity> entities) {
            this.entities = CallAnalyticsEntityListCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(CallAnalyticsEntity... entities) {
            entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<CallAnalyticsEntity.Builder>... entities) {
            entities(Stream.of(entities).map(c -> CallAnalyticsEntity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSentiment() {
            return sentiment;
        }

        public final void setSentiment(String sentiment) {
            this.sentiment = sentiment;
        }

        @Override
        public final Builder sentiment(String sentiment) {
            this.sentiment = sentiment;
            return this;
        }

        @Override
        public final Builder sentiment(Sentiment sentiment) {
            this.sentiment(sentiment == null ? null : sentiment.toString());
            return this;
        }

        public final List<IssueDetected.Builder> getIssuesDetected() {
            List<IssueDetected.Builder> result = IssuesDetectedCopier.copyToBuilder(this.issuesDetected);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIssuesDetected(Collection<IssueDetected.BuilderImpl> issuesDetected) {
            this.issuesDetected = IssuesDetectedCopier.copyFromBuilder(issuesDetected);
        }

        @Override
        public final Builder issuesDetected(Collection<IssueDetected> issuesDetected) {
            this.issuesDetected = IssuesDetectedCopier.copy(issuesDetected);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issuesDetected(IssueDetected... issuesDetected) {
            issuesDetected(Arrays.asList(issuesDetected));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issuesDetected(Consumer<IssueDetected.Builder>... issuesDetected) {
            issuesDetected(Stream.of(issuesDetected).map(c -> IssueDetected.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public UtteranceEvent build() {
            return new UtteranceEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
