/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A wrapper for your audio chunks
 * </p>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/event-stream.html">Event stream
 * encoding</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MedicalScribeAudioEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<MedicalScribeAudioEvent.Builder, MedicalScribeAudioEvent>, MedicalScribeInputStream {
    private static final SdkField<SdkBytes> AUDIO_CHUNK_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("AudioChunk")
            .getter(getter(MedicalScribeAudioEvent::audioChunk))
            .setter(setter(Builder::audioChunk))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudioChunk").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_CHUNK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SdkBytes audioChunk;

    protected MedicalScribeAudioEvent(BuilderImpl builder) {
        this.audioChunk = builder.audioChunk;
    }

    /**
     * <p>
     * An audio blob containing the next segment of audio from your application, with a maximum duration of 1 second.
     * The maximum size in bytes varies based on audio properties.
     * </p>
     * <p>
     * Find recommended size in <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#best-practices">Transcribing streaming best
     * practices</a>.
     * </p>
     * <p>
     * Size calculation: <code>Duration (s) * Sample Rate (Hz) * Number of Channels * 2 (Bytes per Sample)</code>
     * </p>
     * <p>
     * For example, a 1-second chunk of 16 kHz, 2-channel, 16-bit audio would be
     * <code>1 * 16000 * 2 * 2 = 64000 bytes</code>.
     * </p>
     * <p>
     * For 8 kHz, 1-channel, 16-bit audio, a 1-second chunk would be <code>1 * 8000 * 1 * 2 = 16000 bytes</code>.
     * </p>
     * 
     * @return An audio blob containing the next segment of audio from your application, with a maximum duration of 1
     *         second. The maximum size in bytes varies based on audio properties. </p>
     *         <p>
     *         Find recommended size in <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#best-practices">Transcribing
     *         streaming best practices</a>.
     *         </p>
     *         <p>
     *         Size calculation:
     *         <code>Duration (s) * Sample Rate (Hz) * Number of Channels * 2 (Bytes per Sample)</code>
     *         </p>
     *         <p>
     *         For example, a 1-second chunk of 16 kHz, 2-channel, 16-bit audio would be
     *         <code>1 * 16000 * 2 * 2 = 64000 bytes</code>.
     *         </p>
     *         <p>
     *         For 8 kHz, 1-channel, 16-bit audio, a 1-second chunk would be <code>1 * 8000 * 1 * 2 = 16000 bytes</code>.
     */
    public final SdkBytes audioChunk() {
        return audioChunk;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioChunk());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalScribeAudioEvent)) {
            return false;
        }
        MedicalScribeAudioEvent other = (MedicalScribeAudioEvent) obj;
        return Objects.equals(audioChunk(), other.audioChunk());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MedicalScribeAudioEvent").add("AudioChunk", audioChunk()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioChunk":
            return Optional.ofNullable(clazz.cast(audioChunk()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final MedicalScribeAudioEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AudioChunk", AUDIO_CHUNK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MedicalScribeAudioEvent, T> g) {
        return obj -> g.apply((MedicalScribeAudioEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MedicalScribeAudioEvent> {
        /**
         * <p>
         * An audio blob containing the next segment of audio from your application, with a maximum duration of 1
         * second. The maximum size in bytes varies based on audio properties.
         * </p>
         * <p>
         * Find recommended size in <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#best-practices">Transcribing streaming
         * best practices</a>.
         * </p>
         * <p>
         * Size calculation: <code>Duration (s) * Sample Rate (Hz) * Number of Channels * 2 (Bytes per Sample)</code>
         * </p>
         * <p>
         * For example, a 1-second chunk of 16 kHz, 2-channel, 16-bit audio would be
         * <code>1 * 16000 * 2 * 2 = 64000 bytes</code>.
         * </p>
         * <p>
         * For 8 kHz, 1-channel, 16-bit audio, a 1-second chunk would be <code>1 * 8000 * 1 * 2 = 16000 bytes</code>.
         * </p>
         * 
         * @param audioChunk
         *        An audio blob containing the next segment of audio from your application, with a maximum duration of 1
         *        second. The maximum size in bytes varies based on audio properties. </p>
         *        <p>
         *        Find recommended size in <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#best-practices">Transcribing
         *        streaming best practices</a>.
         *        </p>
         *        <p>
         *        Size calculation:
         *        <code>Duration (s) * Sample Rate (Hz) * Number of Channels * 2 (Bytes per Sample)</code>
         *        </p>
         *        <p>
         *        For example, a 1-second chunk of 16 kHz, 2-channel, 16-bit audio would be
         *        <code>1 * 16000 * 2 * 2 = 64000 bytes</code>.
         *        </p>
         *        <p>
         *        For 8 kHz, 1-channel, 16-bit audio, a 1-second chunk would be
         *        <code>1 * 8000 * 1 * 2 = 16000 bytes</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioChunk(SdkBytes audioChunk);
    }

    protected static class BuilderImpl implements Builder {
        private SdkBytes audioChunk;

        protected BuilderImpl() {
        }

        protected BuilderImpl(MedicalScribeAudioEvent model) {
            audioChunk(model.audioChunk);
        }

        public final ByteBuffer getAudioChunk() {
            return audioChunk == null ? null : audioChunk.asByteBuffer();
        }

        public final void setAudioChunk(ByteBuffer audioChunk) {
            audioChunk(audioChunk == null ? null : SdkBytes.fromByteBuffer(audioChunk));
        }

        @Override
        public final Builder audioChunk(SdkBytes audioChunk) {
            this.audioChunk = audioChunk;
            return this;
        }

        @Override
        public MedicalScribeAudioEvent build() {
            return new MedicalScribeAudioEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
