/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribestreaming.model.AudioStream;
import software.amazon.awssdk.services.transcribestreaming.model.ChannelDefinition;
import software.amazon.awssdk.services.transcribestreaming.model.ChannelDefinitionsCopier;
import software.amazon.awssdk.services.transcribestreaming.model.PostCallAnalyticsSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConfigurationEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationEvent>,
AudioStream {
    private static final SdkField<List<ChannelDefinition>> CHANNEL_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChannelDefinitions").getter(ConfigurationEvent.getter(ConfigurationEvent::channelDefinitions)).setter(ConfigurationEvent.setter(Builder::channelDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChannelDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<PostCallAnalyticsSettings> POST_CALL_ANALYTICS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PostCallAnalyticsSettings").getter(ConfigurationEvent.getter(ConfigurationEvent::postCallAnalyticsSettings)).setter(ConfigurationEvent.setter(Builder::postCallAnalyticsSettings)).constructor(PostCallAnalyticsSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostCallAnalyticsSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_DEFINITIONS_FIELD, POST_CALL_ANALYTICS_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigurationEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ChannelDefinition> channelDefinitions;
    private final PostCallAnalyticsSettings postCallAnalyticsSettings;

    protected ConfigurationEvent(BuilderImpl builder) {
        this.channelDefinitions = builder.channelDefinitions;
        this.postCallAnalyticsSettings = builder.postCallAnalyticsSettings;
    }

    public final boolean hasChannelDefinitions() {
        return this.channelDefinitions != null && !(this.channelDefinitions instanceof SdkAutoConstructList);
    }

    public final List<ChannelDefinition> channelDefinitions() {
        return this.channelDefinitions;
    }

    public final PostCallAnalyticsSettings postCallAnalyticsSettings() {
        return this.postCallAnalyticsSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannelDefinitions() ? this.channelDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.postCallAnalyticsSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationEvent)) {
            return false;
        }
        ConfigurationEvent other = (ConfigurationEvent)obj;
        return this.hasChannelDefinitions() == other.hasChannelDefinitions() && Objects.equals(this.channelDefinitions(), other.channelDefinitions()) && Objects.equals(this.postCallAnalyticsSettings(), other.postCallAnalyticsSettings());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationEvent").add("ChannelDefinitions", this.hasChannelDefinitions() ? this.channelDefinitions() : null).add("PostCallAnalyticsSettings", (Object)this.postCallAnalyticsSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelDefinitions": {
                return Optional.ofNullable(clazz.cast(this.channelDefinitions()));
            }
            case "PostCallAnalyticsSettings": {
                return Optional.ofNullable(clazz.cast(this.postCallAnalyticsSettings()));
            }
        }
        return Optional.empty();
    }

    public final ConfigurationEvent copy(Consumer<? super Builder> modifier) {
        return (ConfigurationEvent)super.copy(modifier);
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ChannelDefinitions", CHANNEL_DEFINITIONS_FIELD);
        map.put("PostCallAnalyticsSettings", POST_CALL_ANALYTICS_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationEvent, T> g) {
        return obj -> g.apply((ConfigurationEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    protected static class BuilderImpl
    implements Builder {
        private List<ChannelDefinition> channelDefinitions = DefaultSdkAutoConstructList.getInstance();
        private PostCallAnalyticsSettings postCallAnalyticsSettings;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ConfigurationEvent model) {
            this.channelDefinitions(model.channelDefinitions);
            this.postCallAnalyticsSettings(model.postCallAnalyticsSettings);
        }

        public final List<ChannelDefinition.Builder> getChannelDefinitions() {
            List<ChannelDefinition.Builder> result = ChannelDefinitionsCopier.copyToBuilder(this.channelDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelDefinitions(Collection<ChannelDefinition.BuilderImpl> channelDefinitions) {
            this.channelDefinitions = ChannelDefinitionsCopier.copyFromBuilder(channelDefinitions);
        }

        @Override
        public final Builder channelDefinitions(Collection<ChannelDefinition> channelDefinitions) {
            this.channelDefinitions = ChannelDefinitionsCopier.copy(channelDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(ChannelDefinition ... channelDefinitions) {
            this.channelDefinitions(Arrays.asList(channelDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(Consumer<ChannelDefinition.Builder> ... channelDefinitions) {
            this.channelDefinitions(Stream.of(channelDefinitions).map(c -> (ChannelDefinition)((ChannelDefinition.Builder)ChannelDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final PostCallAnalyticsSettings.Builder getPostCallAnalyticsSettings() {
            return this.postCallAnalyticsSettings != null ? this.postCallAnalyticsSettings.toBuilder() : null;
        }

        public final void setPostCallAnalyticsSettings(PostCallAnalyticsSettings.BuilderImpl postCallAnalyticsSettings) {
            this.postCallAnalyticsSettings = postCallAnalyticsSettings != null ? postCallAnalyticsSettings.build() : null;
        }

        @Override
        public final Builder postCallAnalyticsSettings(PostCallAnalyticsSettings postCallAnalyticsSettings) {
            this.postCallAnalyticsSettings = postCallAnalyticsSettings;
            return this;
        }

        public ConfigurationEvent build() {
            return new ConfigurationEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationEvent> {
        public Builder channelDefinitions(Collection<ChannelDefinition> var1);

        public Builder channelDefinitions(ChannelDefinition ... var1);

        public Builder channelDefinitions(Consumer<ChannelDefinition.Builder> ... var1);

        public Builder postCallAnalyticsSettings(PostCallAnalyticsSettings var1);

        default public Builder postCallAnalyticsSettings(Consumer<PostCallAnalyticsSettings.Builder> postCallAnalyticsSettings) {
            return this.postCallAnalyticsSettings((PostCallAnalyticsSettings)((PostCallAnalyticsSettings.Builder)PostCallAnalyticsSettings.builder().applyMutation(postCallAnalyticsSettings)).build());
        }
    }
}

