/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum LanguageCode {
    EN_US("en-US"),

    EN_GB("en-GB"),

    ES_US("es-US"),

    FR_CA("fr-CA"),

    FR_FR("fr-FR"),

    EN_AU("en-AU"),

    IT_IT("it-IT"),

    DE_DE("de-DE"),

    PT_BR("pt-BR"),

    JA_JP("ja-JP"),

    KO_KR("ko-KR"),

    ZH_CN("zh-CN"),

    TH_TH("th-TH"),

    ES_ES("es-ES"),

    AR_SA("ar-SA"),

    PT_PT("pt-PT"),

    CA_ES("ca-ES"),

    AR_AE("ar-AE"),

    HI_IN("hi-IN"),

    ZH_HK("zh-HK"),

    NL_NL("nl-NL"),

    NO_NO("no-NO"),

    SV_SE("sv-SE"),

    PL_PL("pl-PL"),

    FI_FI("fi-FI"),

    ZH_TW("zh-TW"),

    EN_IN("en-IN"),

    EN_IE("en-IE"),

    EN_NZ("en-NZ"),

    EN_AB("en-AB"),

    EN_ZA("en-ZA"),

    EN_WL("en-WL"),

    DE_CH("de-CH"),

    AF_ZA("af-ZA"),

    EU_ES("eu-ES"),

    HR_HR("hr-HR"),

    CS_CZ("cs-CZ"),

    DA_DK("da-DK"),

    FA_IR("fa-IR"),

    GL_ES("gl-ES"),

    EL_GR("el-GR"),

    HE_IL("he-IL"),

    ID_ID("id-ID"),

    LV_LV("lv-LV"),

    MS_MY("ms-MY"),

    RO_RO("ro-RO"),

    RU_RU("ru-RU"),

    SR_RS("sr-RS"),

    SK_SK("sk-SK"),

    SO_SO("so-SO"),

    TL_PH("tl-PH"),

    UK_UA("uk-UA"),

    VI_VN("vi-VN"),

    ZU_ZA("zu-ZA"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LanguageCode> VALUE_MAP = EnumUtils.uniqueIndex(LanguageCode.class, LanguageCode::toString);

    private final String value;

    private LanguageCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return LanguageCode corresponding to the value
     */
    public static LanguageCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link LanguageCode}s
     */
    public static Set<LanguageCode> knownValues() {
        Set<LanguageCode> knownValues = EnumSet.allOf(LanguageCode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
