/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a set of transcription results, along with additional information of the segment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MedicalScribeTranscriptSegment implements SdkPojo, Serializable,
        ToCopyableBuilder<MedicalScribeTranscriptSegment.Builder, MedicalScribeTranscriptSegment> {
    private static final SdkField<String> SEGMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentId").getter(getter(MedicalScribeTranscriptSegment::segmentId)).setter(setter(Builder::segmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentId").build()).build();

    private static final SdkField<Double> BEGIN_AUDIO_TIME_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("BeginAudioTime").getter(getter(MedicalScribeTranscriptSegment::beginAudioTime))
            .setter(setter(Builder::beginAudioTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginAudioTime").build()).build();

    private static final SdkField<Double> END_AUDIO_TIME_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("EndAudioTime").getter(getter(MedicalScribeTranscriptSegment::endAudioTime))
            .setter(setter(Builder::endAudioTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndAudioTime").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(MedicalScribeTranscriptSegment::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<List<MedicalScribeTranscriptItem>> ITEMS_FIELD = SdkField
            .<List<MedicalScribeTranscriptItem>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(MedicalScribeTranscriptSegment::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MedicalScribeTranscriptItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(MedicalScribeTranscriptItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_PARTIAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsPartial").getter(getter(MedicalScribeTranscriptSegment::isPartial)).setter(setter(Builder::isPartial))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPartial").build()).build();

    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelId").getter(getter(MedicalScribeTranscriptSegment::channelId)).setter(setter(Builder::channelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEGMENT_ID_FIELD,
            BEGIN_AUDIO_TIME_FIELD, END_AUDIO_TIME_FIELD, CONTENT_FIELD, ITEMS_FIELD, IS_PARTIAL_FIELD, CHANNEL_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String segmentId;

    private final Double beginAudioTime;

    private final Double endAudioTime;

    private final String content;

    private final List<MedicalScribeTranscriptItem> items;

    private final Boolean isPartial;

    private final String channelId;

    private MedicalScribeTranscriptSegment(BuilderImpl builder) {
        this.segmentId = builder.segmentId;
        this.beginAudioTime = builder.beginAudioTime;
        this.endAudioTime = builder.endAudioTime;
        this.content = builder.content;
        this.items = builder.items;
        this.isPartial = builder.isPartial;
        this.channelId = builder.channelId;
    }

    /**
     * <p>
     * The identifier of the segment.
     * </p>
     * 
     * @return The identifier of the segment.
     */
    public final String segmentId() {
        return segmentId;
    }

    /**
     * <p>
     * The start time, in milliseconds, of the segment.
     * </p>
     * 
     * @return The start time, in milliseconds, of the segment.
     */
    public final Double beginAudioTime() {
        return beginAudioTime;
    }

    /**
     * <p>
     * The end time, in milliseconds, of the segment.
     * </p>
     * 
     * @return The end time, in milliseconds, of the segment.
     */
    public final Double endAudioTime() {
        return endAudioTime;
    }

    /**
     * <p>
     * Contains transcribed text of the segment.
     * </p>
     * 
     * @return Contains transcribed text of the segment.
     */
    public final String content() {
        return content;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains words, phrases, or punctuation marks in your segment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return Contains words, phrases, or punctuation marks in your segment.
     */
    public final List<MedicalScribeTranscriptItem> items() {
        return items;
    }

    /**
     * <p>
     * Indicates if the segment is complete.
     * </p>
     * <p>
     * If <code>IsPartial</code> is <code>true</code>, the segment is not complete. If <code>IsPartial</code> is
     * <code>false</code>, the segment is complete.
     * </p>
     * 
     * @return Indicates if the segment is complete.</p>
     *         <p>
     *         If <code>IsPartial</code> is <code>true</code>, the segment is not complete. If <code>IsPartial</code> is
     *         <code>false</code>, the segment is complete.
     */
    public final Boolean isPartial() {
        return isPartial;
    }

    /**
     * <p>
     * Indicates which audio channel is associated with the <code>MedicalScribeTranscriptSegment</code>.
     * </p>
     * <p>
     * If <code>MedicalScribeChannelDefinition</code> is not provided in the
     * <code>MedicalScribeConfigurationEvent</code>, then this field will not be included.
     * </p>
     * 
     * @return Indicates which audio channel is associated with the <code>MedicalScribeTranscriptSegment</code>. </p>
     *         <p>
     *         If <code>MedicalScribeChannelDefinition</code> is not provided in the
     *         <code>MedicalScribeConfigurationEvent</code>, then this field will not be included.
     */
    public final String channelId() {
        return channelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(segmentId());
        hashCode = 31 * hashCode + Objects.hashCode(beginAudioTime());
        hashCode = 31 * hashCode + Objects.hashCode(endAudioTime());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isPartial());
        hashCode = 31 * hashCode + Objects.hashCode(channelId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalScribeTranscriptSegment)) {
            return false;
        }
        MedicalScribeTranscriptSegment other = (MedicalScribeTranscriptSegment) obj;
        return Objects.equals(segmentId(), other.segmentId()) && Objects.equals(beginAudioTime(), other.beginAudioTime())
                && Objects.equals(endAudioTime(), other.endAudioTime()) && Objects.equals(content(), other.content())
                && hasItems() == other.hasItems() && Objects.equals(items(), other.items())
                && Objects.equals(isPartial(), other.isPartial()) && Objects.equals(channelId(), other.channelId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MedicalScribeTranscriptSegment").add("SegmentId", segmentId())
                .add("BeginAudioTime", beginAudioTime()).add("EndAudioTime", endAudioTime()).add("Content", content())
                .add("Items", hasItems() ? items() : null).add("IsPartial", isPartial()).add("ChannelId", channelId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SegmentId":
            return Optional.ofNullable(clazz.cast(segmentId()));
        case "BeginAudioTime":
            return Optional.ofNullable(clazz.cast(beginAudioTime()));
        case "EndAudioTime":
            return Optional.ofNullable(clazz.cast(endAudioTime()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        case "IsPartial":
            return Optional.ofNullable(clazz.cast(isPartial()));
        case "ChannelId":
            return Optional.ofNullable(clazz.cast(channelId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SegmentId", SEGMENT_ID_FIELD);
        map.put("BeginAudioTime", BEGIN_AUDIO_TIME_FIELD);
        map.put("EndAudioTime", END_AUDIO_TIME_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("Items", ITEMS_FIELD);
        map.put("IsPartial", IS_PARTIAL_FIELD);
        map.put("ChannelId", CHANNEL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MedicalScribeTranscriptSegment, T> g) {
        return obj -> g.apply((MedicalScribeTranscriptSegment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MedicalScribeTranscriptSegment> {
        /**
         * <p>
         * The identifier of the segment.
         * </p>
         * 
         * @param segmentId
         *        The identifier of the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentId(String segmentId);

        /**
         * <p>
         * The start time, in milliseconds, of the segment.
         * </p>
         * 
         * @param beginAudioTime
         *        The start time, in milliseconds, of the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginAudioTime(Double beginAudioTime);

        /**
         * <p>
         * The end time, in milliseconds, of the segment.
         * </p>
         * 
         * @param endAudioTime
         *        The end time, in milliseconds, of the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endAudioTime(Double endAudioTime);

        /**
         * <p>
         * Contains transcribed text of the segment.
         * </p>
         * 
         * @param content
         *        Contains transcribed text of the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * Contains words, phrases, or punctuation marks in your segment.
         * </p>
         * 
         * @param items
         *        Contains words, phrases, or punctuation marks in your segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<MedicalScribeTranscriptItem> items);

        /**
         * <p>
         * Contains words, phrases, or punctuation marks in your segment.
         * </p>
         * 
         * @param items
         *        Contains words, phrases, or punctuation marks in your segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(MedicalScribeTranscriptItem... items);

        /**
         * <p>
         * Contains words, phrases, or punctuation marks in your segment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeTranscriptItem.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeTranscriptItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeTranscriptItem.Builder#build()}
         * is called immediately and its result is passed to {@link #items(List<MedicalScribeTranscriptItem>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeTranscriptItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<MedicalScribeTranscriptItem>)
         */
        Builder items(Consumer<MedicalScribeTranscriptItem.Builder>... items);

        /**
         * <p>
         * Indicates if the segment is complete.
         * </p>
         * <p>
         * If <code>IsPartial</code> is <code>true</code>, the segment is not complete. If <code>IsPartial</code> is
         * <code>false</code>, the segment is complete.
         * </p>
         * 
         * @param isPartial
         *        Indicates if the segment is complete.</p>
         *        <p>
         *        If <code>IsPartial</code> is <code>true</code>, the segment is not complete. If <code>IsPartial</code>
         *        is <code>false</code>, the segment is complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPartial(Boolean isPartial);

        /**
         * <p>
         * Indicates which audio channel is associated with the <code>MedicalScribeTranscriptSegment</code>.
         * </p>
         * <p>
         * If <code>MedicalScribeChannelDefinition</code> is not provided in the
         * <code>MedicalScribeConfigurationEvent</code>, then this field will not be included.
         * </p>
         * 
         * @param channelId
         *        Indicates which audio channel is associated with the <code>MedicalScribeTranscriptSegment</code>. </p>
         *        <p>
         *        If <code>MedicalScribeChannelDefinition</code> is not provided in the
         *        <code>MedicalScribeConfigurationEvent</code>, then this field will not be included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelId(String channelId);
    }

    static final class BuilderImpl implements Builder {
        private String segmentId;

        private Double beginAudioTime;

        private Double endAudioTime;

        private String content;

        private List<MedicalScribeTranscriptItem> items = DefaultSdkAutoConstructList.getInstance();

        private Boolean isPartial;

        private String channelId;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalScribeTranscriptSegment model) {
            segmentId(model.segmentId);
            beginAudioTime(model.beginAudioTime);
            endAudioTime(model.endAudioTime);
            content(model.content);
            items(model.items);
            isPartial(model.isPartial);
            channelId(model.channelId);
        }

        public final String getSegmentId() {
            return segmentId;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final Double getBeginAudioTime() {
            return beginAudioTime;
        }

        public final void setBeginAudioTime(Double beginAudioTime) {
            this.beginAudioTime = beginAudioTime;
        }

        @Override
        public final Builder beginAudioTime(Double beginAudioTime) {
            this.beginAudioTime = beginAudioTime;
            return this;
        }

        public final Double getEndAudioTime() {
            return endAudioTime;
        }

        public final void setEndAudioTime(Double endAudioTime) {
            this.endAudioTime = endAudioTime;
        }

        @Override
        public final Builder endAudioTime(Double endAudioTime) {
            this.endAudioTime = endAudioTime;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final List<MedicalScribeTranscriptItem.Builder> getItems() {
            List<MedicalScribeTranscriptItem.Builder> result = MedicalScribeTranscriptItemListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<MedicalScribeTranscriptItem.BuilderImpl> items) {
            this.items = MedicalScribeTranscriptItemListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<MedicalScribeTranscriptItem> items) {
            this.items = MedicalScribeTranscriptItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(MedicalScribeTranscriptItem... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<MedicalScribeTranscriptItem.Builder>... items) {
            items(Stream.of(items).map(c -> MedicalScribeTranscriptItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsPartial() {
            return isPartial;
        }

        public final void setIsPartial(Boolean isPartial) {
            this.isPartial = isPartial;
        }

        @Override
        public final Builder isPartial(Boolean isPartial) {
            this.isPartial = isPartial;
            return this;
        }

        public final String getChannelId() {
            return channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        @Override
        public MedicalScribeTranscriptSegment build() {
            return new MedicalScribeTranscriptSegment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
