/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the timestamp range (start time through end time) of a matched category.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimestampRange implements SdkPojo, Serializable, ToCopyableBuilder<TimestampRange.Builder, TimestampRange> {
    private static final SdkField<Long> BEGIN_OFFSET_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BeginOffsetMillis").getter(getter(TimestampRange::beginOffsetMillis))
            .setter(setter(Builder::beginOffsetMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffsetMillis").build()).build();

    private static final SdkField<Long> END_OFFSET_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("EndOffsetMillis").getter(getter(TimestampRange::endOffsetMillis))
            .setter(setter(Builder::endOffsetMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffsetMillis").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEGIN_OFFSET_MILLIS_FIELD,
            END_OFFSET_MILLIS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long beginOffsetMillis;

    private final Long endOffsetMillis;

    private TimestampRange(BuilderImpl builder) {
        this.beginOffsetMillis = builder.beginOffsetMillis;
        this.endOffsetMillis = builder.endOffsetMillis;
    }

    /**
     * <p>
     * The time, in milliseconds, from the beginning of the audio stream to the start of the category match.
     * </p>
     * 
     * @return The time, in milliseconds, from the beginning of the audio stream to the start of the category match.
     */
    public final Long beginOffsetMillis() {
        return beginOffsetMillis;
    }

    /**
     * <p>
     * The time, in milliseconds, from the beginning of the audio stream to the end of the category match.
     * </p>
     * 
     * @return The time, in milliseconds, from the beginning of the audio stream to the end of the category match.
     */
    public final Long endOffsetMillis() {
        return endOffsetMillis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(beginOffsetMillis());
        hashCode = 31 * hashCode + Objects.hashCode(endOffsetMillis());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimestampRange)) {
            return false;
        }
        TimestampRange other = (TimestampRange) obj;
        return Objects.equals(beginOffsetMillis(), other.beginOffsetMillis())
                && Objects.equals(endOffsetMillis(), other.endOffsetMillis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimestampRange").add("BeginOffsetMillis", beginOffsetMillis())
                .add("EndOffsetMillis", endOffsetMillis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BeginOffsetMillis":
            return Optional.ofNullable(clazz.cast(beginOffsetMillis()));
        case "EndOffsetMillis":
            return Optional.ofNullable(clazz.cast(endOffsetMillis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BeginOffsetMillis", BEGIN_OFFSET_MILLIS_FIELD);
        map.put("EndOffsetMillis", END_OFFSET_MILLIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimestampRange, T> g) {
        return obj -> g.apply((TimestampRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimestampRange> {
        /**
         * <p>
         * The time, in milliseconds, from the beginning of the audio stream to the start of the category match.
         * </p>
         * 
         * @param beginOffsetMillis
         *        The time, in milliseconds, from the beginning of the audio stream to the start of the category match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginOffsetMillis(Long beginOffsetMillis);

        /**
         * <p>
         * The time, in milliseconds, from the beginning of the audio stream to the end of the category match.
         * </p>
         * 
         * @param endOffsetMillis
         *        The time, in milliseconds, from the beginning of the audio stream to the end of the category match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOffsetMillis(Long endOffsetMillis);
    }

    static final class BuilderImpl implements Builder {
        private Long beginOffsetMillis;

        private Long endOffsetMillis;

        private BuilderImpl() {
        }

        private BuilderImpl(TimestampRange model) {
            beginOffsetMillis(model.beginOffsetMillis);
            endOffsetMillis(model.endOffsetMillis);
        }

        public final Long getBeginOffsetMillis() {
            return beginOffsetMillis;
        }

        public final void setBeginOffsetMillis(Long beginOffsetMillis) {
            this.beginOffsetMillis = beginOffsetMillis;
        }

        @Override
        public final Builder beginOffsetMillis(Long beginOffsetMillis) {
            this.beginOffsetMillis = beginOffsetMillis;
            return this;
        }

        public final Long getEndOffsetMillis() {
            return endOffsetMillis;
        }

        public final void setEndOffsetMillis(Long endOffsetMillis) {
            this.endOffsetMillis = endOffsetMillis;
        }

        @Override
        public final Builder endOffsetMillis(Long endOffsetMillis) {
            this.endOffsetMillis = endOffsetMillis;
            return this;
        }

        @Override
        public TimestampRange build() {
            return new TimestampRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
