/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of possible alternative transcriptions for the input audio. Each alternative may contain one or more of
 * <code>Items</code>, <code>Entities</code>, or <code>Transcript</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MedicalAlternative implements SdkPojo, Serializable,
        ToCopyableBuilder<MedicalAlternative.Builder, MedicalAlternative> {
    private static final SdkField<String> TRANSCRIPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Transcript").getter(getter(MedicalAlternative::transcript)).setter(setter(Builder::transcript))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transcript").build()).build();

    private static final SdkField<List<MedicalItem>> ITEMS_FIELD = SdkField
            .<List<MedicalItem>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(MedicalAlternative::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MedicalItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(MedicalItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MedicalEntity>> ENTITIES_FIELD = SdkField
            .<List<MedicalEntity>> builder(MarshallingType.LIST)
            .memberName("Entities")
            .getter(getter(MedicalAlternative::entities))
            .setter(setter(Builder::entities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MedicalEntity> builder(MarshallingType.SDK_POJO)
                                            .constructor(MedicalEntity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPT_FIELD, ITEMS_FIELD,
            ENTITIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String transcript;

    private final List<MedicalItem> items;

    private final List<MedicalEntity> entities;

    private MedicalAlternative(BuilderImpl builder) {
        this.transcript = builder.transcript;
        this.items = builder.items;
        this.entities = builder.entities;
    }

    /**
     * <p>
     * Contains transcribed text.
     * </p>
     * 
     * @return Contains transcribed text.
     */
    public final String transcript() {
        return transcript;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains words, phrases, or punctuation marks in your transcription output.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return Contains words, phrases, or punctuation marks in your transcription output.
     */
    public final List<MedicalItem> items() {
        return items;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntities() {
        return entities != null && !(entities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains entities identified as personal health information (PHI) in your transcription output.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntities} method.
     * </p>
     * 
     * @return Contains entities identified as personal health information (PHI) in your transcription output.
     */
    public final List<MedicalEntity> entities() {
        return entities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transcript());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEntities() ? entities() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalAlternative)) {
            return false;
        }
        MedicalAlternative other = (MedicalAlternative) obj;
        return Objects.equals(transcript(), other.transcript()) && hasItems() == other.hasItems()
                && Objects.equals(items(), other.items()) && hasEntities() == other.hasEntities()
                && Objects.equals(entities(), other.entities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MedicalAlternative").add("Transcript", transcript()).add("Items", hasItems() ? items() : null)
                .add("Entities", hasEntities() ? entities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Transcript":
            return Optional.ofNullable(clazz.cast(transcript()));
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        case "Entities":
            return Optional.ofNullable(clazz.cast(entities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Transcript", TRANSCRIPT_FIELD);
        map.put("Items", ITEMS_FIELD);
        map.put("Entities", ENTITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MedicalAlternative, T> g) {
        return obj -> g.apply((MedicalAlternative) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MedicalAlternative> {
        /**
         * <p>
         * Contains transcribed text.
         * </p>
         * 
         * @param transcript
         *        Contains transcribed text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcript(String transcript);

        /**
         * <p>
         * Contains words, phrases, or punctuation marks in your transcription output.
         * </p>
         * 
         * @param items
         *        Contains words, phrases, or punctuation marks in your transcription output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<MedicalItem> items);

        /**
         * <p>
         * Contains words, phrases, or punctuation marks in your transcription output.
         * </p>
         * 
         * @param items
         *        Contains words, phrases, or punctuation marks in your transcription output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(MedicalItem... items);

        /**
         * <p>
         * Contains words, phrases, or punctuation marks in your transcription output.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transcribestreaming.model.MedicalItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.transcribestreaming.model.MedicalItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transcribestreaming.model.MedicalItem.Builder#build()} is called
         * immediately and its result is passed to {@link #items(List<MedicalItem>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transcribestreaming.model.MedicalItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<MedicalItem>)
         */
        Builder items(Consumer<MedicalItem.Builder>... items);

        /**
         * <p>
         * Contains entities identified as personal health information (PHI) in your transcription output.
         * </p>
         * 
         * @param entities
         *        Contains entities identified as personal health information (PHI) in your transcription output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(Collection<MedicalEntity> entities);

        /**
         * <p>
         * Contains entities identified as personal health information (PHI) in your transcription output.
         * </p>
         * 
         * @param entities
         *        Contains entities identified as personal health information (PHI) in your transcription output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(MedicalEntity... entities);

        /**
         * <p>
         * Contains entities identified as personal health information (PHI) in your transcription output.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transcribestreaming.model.MedicalEntity.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.transcribestreaming.model.MedicalEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transcribestreaming.model.MedicalEntity.Builder#build()} is called
         * immediately and its result is passed to {@link #entities(List<MedicalEntity>)}.
         * 
         * @param entities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transcribestreaming.model.MedicalEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entities(java.util.Collection<MedicalEntity>)
         */
        Builder entities(Consumer<MedicalEntity.Builder>... entities);
    }

    static final class BuilderImpl implements Builder {
        private String transcript;

        private List<MedicalItem> items = DefaultSdkAutoConstructList.getInstance();

        private List<MedicalEntity> entities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalAlternative model) {
            transcript(model.transcript);
            items(model.items);
            entities(model.entities);
        }

        public final String getTranscript() {
            return transcript;
        }

        public final void setTranscript(String transcript) {
            this.transcript = transcript;
        }

        @Override
        public final Builder transcript(String transcript) {
            this.transcript = transcript;
            return this;
        }

        public final List<MedicalItem.Builder> getItems() {
            List<MedicalItem.Builder> result = MedicalItemListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<MedicalItem.BuilderImpl> items) {
            this.items = MedicalItemListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<MedicalItem> items) {
            this.items = MedicalItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(MedicalItem... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<MedicalItem.Builder>... items) {
            items(Stream.of(items).map(c -> MedicalItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MedicalEntity.Builder> getEntities() {
            List<MedicalEntity.Builder> result = MedicalEntityListCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<MedicalEntity.BuilderImpl> entities) {
            this.entities = MedicalEntityListCopier.copyFromBuilder(entities);
        }

        @Override
        public final Builder entities(Collection<MedicalEntity> entities) {
            this.entities = MedicalEntityListCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(MedicalEntity... entities) {
            entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<MedicalEntity.Builder>... entities) {
            entities(Stream.of(entities).map(c -> MedicalEntity.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public MedicalAlternative build() {
            return new MedicalAlternative(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
