/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMedicalScribeStreamResponse extends TranscribeStreamingResponse implements
        ToCopyableBuilder<StartMedicalScribeStreamResponse.Builder, StartMedicalScribeStreamResponse> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SessionId")
            .getter(getter(StartMedicalScribeStreamResponse::sessionId))
            .setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-session-id")
                    .build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(StartMedicalScribeStreamResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-request-id").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode")
            .getter(getter(StartMedicalScribeStreamResponse::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-language-code")
                    .build()).build();

    private static final SdkField<Integer> MEDIA_SAMPLE_RATE_HERTZ_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MediaSampleRateHertz")
            .getter(getter(StartMedicalScribeStreamResponse::mediaSampleRateHertz))
            .setter(setter(Builder::mediaSampleRateHertz))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-sample-rate")
                    .build()).build();

    private static final SdkField<String> MEDIA_ENCODING_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MediaEncoding")
            .getter(getter(StartMedicalScribeStreamResponse::mediaEncodingAsString))
            .setter(setter(Builder::mediaEncoding))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-media-encoding")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD,
            REQUEST_ID_FIELD, LANGUAGE_CODE_FIELD, MEDIA_SAMPLE_RATE_HERTZ_FIELD, MEDIA_ENCODING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sessionId;

    private final String requestId;

    private final String languageCode;

    private final Integer mediaSampleRateHertz;

    private final String mediaEncoding;

    private StartMedicalScribeStreamResponse(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.requestId = builder.requestId;
        this.languageCode = builder.languageCode;
        this.mediaSampleRateHertz = builder.mediaSampleRateHertz;
        this.mediaEncoding = builder.mediaEncoding;
    }

    /**
     * <p>
     * The identifier (in UUID format) for your streaming session.
     * </p>
     * <p>
     * If you already started streaming, this is same ID as the one you specified in your initial
     * <code>StartMedicalScribeStreamRequest</code>.
     * </p>
     * 
     * @return The identifier (in UUID format) for your streaming session.</p>
     *         <p>
     *         If you already started streaming, this is same ID as the one you specified in your initial
     *         <code>StartMedicalScribeStreamRequest</code>.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The unique identifier for your streaming request.
     * </p>
     * 
     * @return The unique identifier for your streaming request.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The Language Code that you specified in your request. Same as provided in the
     * <code>StartMedicalScribeStreamRequest</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link MedicalScribeLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The Language Code that you specified in your request. Same as provided in the
     *         <code>StartMedicalScribeStreamRequest</code>.
     * @see MedicalScribeLanguageCode
     */
    public final MedicalScribeLanguageCode languageCode() {
        return MedicalScribeLanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The Language Code that you specified in your request. Same as provided in the
     * <code>StartMedicalScribeStreamRequest</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link MedicalScribeLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The Language Code that you specified in your request. Same as provided in the
     *         <code>StartMedicalScribeStreamRequest</code>.
     * @see MedicalScribeLanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The sample rate (in hertz) that you specified in your request. Same as provided in the
     * <code>StartMedicalScribeStreamRequest</code>
     * </p>
     * 
     * @return The sample rate (in hertz) that you specified in your request. Same as provided in the
     *         <code>StartMedicalScribeStreamRequest</code>
     */
    public final Integer mediaSampleRateHertz() {
        return mediaSampleRateHertz;
    }

    /**
     * <p>
     * The Media Encoding you specified in your request. Same as provided in the
     * <code>StartMedicalScribeStreamRequest</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaEncoding}
     * will return {@link MedicalScribeMediaEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #mediaEncodingAsString}.
     * </p>
     * 
     * @return The Media Encoding you specified in your request. Same as provided in the
     *         <code>StartMedicalScribeStreamRequest</code>
     * @see MedicalScribeMediaEncoding
     */
    public final MedicalScribeMediaEncoding mediaEncoding() {
        return MedicalScribeMediaEncoding.fromValue(mediaEncoding);
    }

    /**
     * <p>
     * The Media Encoding you specified in your request. Same as provided in the
     * <code>StartMedicalScribeStreamRequest</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaEncoding}
     * will return {@link MedicalScribeMediaEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #mediaEncodingAsString}.
     * </p>
     * 
     * @return The Media Encoding you specified in your request. Same as provided in the
     *         <code>StartMedicalScribeStreamRequest</code>
     * @see MedicalScribeMediaEncoding
     */
    public final String mediaEncodingAsString() {
        return mediaEncoding;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mediaSampleRateHertz());
        hashCode = 31 * hashCode + Objects.hashCode(mediaEncodingAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMedicalScribeStreamResponse)) {
            return false;
        }
        StartMedicalScribeStreamResponse other = (StartMedicalScribeStreamResponse) obj;
        return Objects.equals(sessionId(), other.sessionId()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(mediaSampleRateHertz(), other.mediaSampleRateHertz())
                && Objects.equals(mediaEncodingAsString(), other.mediaEncodingAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMedicalScribeStreamResponse").add("SessionId", sessionId()).add("RequestId", requestId())
                .add("LanguageCode", languageCodeAsString()).add("MediaSampleRateHertz", mediaSampleRateHertz())
                .add("MediaEncoding", mediaEncodingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "MediaSampleRateHertz":
            return Optional.ofNullable(clazz.cast(mediaSampleRateHertz()));
        case "MediaEncoding":
            return Optional.ofNullable(clazz.cast(mediaEncodingAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("x-amzn-transcribe-session-id", SESSION_ID_FIELD);
        map.put("x-amzn-request-id", REQUEST_ID_FIELD);
        map.put("x-amzn-transcribe-language-code", LANGUAGE_CODE_FIELD);
        map.put("x-amzn-transcribe-sample-rate", MEDIA_SAMPLE_RATE_HERTZ_FIELD);
        map.put("x-amzn-transcribe-media-encoding", MEDIA_ENCODING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartMedicalScribeStreamResponse, T> g) {
        return obj -> g.apply((StartMedicalScribeStreamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeStreamingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartMedicalScribeStreamResponse> {
        /**
         * <p>
         * The identifier (in UUID format) for your streaming session.
         * </p>
         * <p>
         * If you already started streaming, this is same ID as the one you specified in your initial
         * <code>StartMedicalScribeStreamRequest</code>.
         * </p>
         * 
         * @param sessionId
         *        The identifier (in UUID format) for your streaming session.</p>
         *        <p>
         *        If you already started streaming, this is same ID as the one you specified in your initial
         *        <code>StartMedicalScribeStreamRequest</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The unique identifier for your streaming request.
         * </p>
         * 
         * @param requestId
         *        The unique identifier for your streaming request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The Language Code that you specified in your request. Same as provided in the
         * <code>StartMedicalScribeStreamRequest</code>.
         * </p>
         * 
         * @param languageCode
         *        The Language Code that you specified in your request. Same as provided in the
         *        <code>StartMedicalScribeStreamRequest</code>.
         * @see MedicalScribeLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeLanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The Language Code that you specified in your request. Same as provided in the
         * <code>StartMedicalScribeStreamRequest</code>.
         * </p>
         * 
         * @param languageCode
         *        The Language Code that you specified in your request. Same as provided in the
         *        <code>StartMedicalScribeStreamRequest</code>.
         * @see MedicalScribeLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeLanguageCode
         */
        Builder languageCode(MedicalScribeLanguageCode languageCode);

        /**
         * <p>
         * The sample rate (in hertz) that you specified in your request. Same as provided in the
         * <code>StartMedicalScribeStreamRequest</code>
         * </p>
         * 
         * @param mediaSampleRateHertz
         *        The sample rate (in hertz) that you specified in your request. Same as provided in the
         *        <code>StartMedicalScribeStreamRequest</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaSampleRateHertz(Integer mediaSampleRateHertz);

        /**
         * <p>
         * The Media Encoding you specified in your request. Same as provided in the
         * <code>StartMedicalScribeStreamRequest</code>
         * </p>
         * 
         * @param mediaEncoding
         *        The Media Encoding you specified in your request. Same as provided in the
         *        <code>StartMedicalScribeStreamRequest</code>
         * @see MedicalScribeMediaEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeMediaEncoding
         */
        Builder mediaEncoding(String mediaEncoding);

        /**
         * <p>
         * The Media Encoding you specified in your request. Same as provided in the
         * <code>StartMedicalScribeStreamRequest</code>
         * </p>
         * 
         * @param mediaEncoding
         *        The Media Encoding you specified in your request. Same as provided in the
         *        <code>StartMedicalScribeStreamRequest</code>
         * @see MedicalScribeMediaEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeMediaEncoding
         */
        Builder mediaEncoding(MedicalScribeMediaEncoding mediaEncoding);
    }

    static final class BuilderImpl extends TranscribeStreamingResponse.BuilderImpl implements Builder {
        private String sessionId;

        private String requestId;

        private String languageCode;

        private Integer mediaSampleRateHertz;

        private String mediaEncoding;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMedicalScribeStreamResponse model) {
            super(model);
            sessionId(model.sessionId);
            requestId(model.requestId);
            languageCode(model.languageCode);
            mediaSampleRateHertz(model.mediaSampleRateHertz);
            mediaEncoding(model.mediaEncoding);
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(MedicalScribeLanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Integer getMediaSampleRateHertz() {
            return mediaSampleRateHertz;
        }

        public final void setMediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
        }

        @Override
        public final Builder mediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
            return this;
        }

        public final String getMediaEncoding() {
            return mediaEncoding;
        }

        public final void setMediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
        }

        @Override
        public final Builder mediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
            return this;
        }

        @Override
        public final Builder mediaEncoding(MedicalScribeMediaEncoding mediaEncoding) {
            this.mediaEncoding(mediaEncoding == null ? null : mediaEncoding.toString());
            return this;
        }

        @Override
        public StartMedicalScribeStreamResponse build() {
            return new StartMedicalScribeStreamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
