/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output configuration for aggregated transcript and clinical note generation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClinicalNoteGenerationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ClinicalNoteGenerationSettings.Builder, ClinicalNoteGenerationSettings> {
    private static final SdkField<String> OUTPUT_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputBucketName").getter(getter(ClinicalNoteGenerationSettings::outputBucketName))
            .setter(setter(Builder::outputBucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputBucketName").build()).build();

    private static final SdkField<String> NOTE_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NoteTemplate").getter(getter(ClinicalNoteGenerationSettings::noteTemplateAsString))
            .setter(setter(Builder::noteTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoteTemplate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_BUCKET_NAME_FIELD,
            NOTE_TEMPLATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String outputBucketName;

    private final String noteTemplate;

    private ClinicalNoteGenerationSettings(BuilderImpl builder) {
        this.outputBucketName = builder.outputBucketName;
        this.noteTemplate = builder.noteTemplate;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket where you want the output of Amazon Web Services HealthScribe post-stream
     * analytics stored. Don't include the <code>S3://</code> prefix of the specified bucket.
     * </p>
     * <p>
     * HealthScribe outputs transcript and clinical note files under the prefix:
     * <code>S3://$output-bucket-name/healthscribe-streaming/session-id/post-stream-analytics/clinical-notes</code>
     * </p>
     * <p>
     * The role <code>ResourceAccessRoleArn</code> specified in the <code>MedicalScribeConfigurationEvent</code> must
     * have permission to use the specified location. You can change Amazon S3 permissions using the <a
     * href="https://console.aws.amazon.com/s3"> Amazon Web Services Management Console </a>. See also <a href=
     * "https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user"
     * >Permissions Required for IAM User Roles </a> .
     * </p>
     * 
     * @return The name of the Amazon S3 bucket where you want the output of Amazon Web Services HealthScribe
     *         post-stream analytics stored. Don't include the <code>S3://</code> prefix of the specified bucket. </p>
     *         <p>
     *         HealthScribe outputs transcript and clinical note files under the prefix:
     *         <code>S3://$output-bucket-name/healthscribe-streaming/session-id/post-stream-analytics/clinical-notes</code>
     *         </p>
     *         <p>
     *         The role <code>ResourceAccessRoleArn</code> specified in the <code>MedicalScribeConfigurationEvent</code>
     *         must have permission to use the specified location. You can change Amazon S3 permissions using the <a
     *         href="https://console.aws.amazon.com/s3"> Amazon Web Services Management Console </a>. See also <a href=
     *         "https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user"
     *         >Permissions Required for IAM User Roles </a> .
     */
    public final String outputBucketName() {
        return outputBucketName;
    }

    /**
     * <p>
     * Specify one of the following templates to use for the clinical note summary. The default is
     * <code>HISTORY_AND_PHYSICAL</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * HISTORY_AND_PHYSICAL: Provides summaries for key sections of the clinical documentation. Sections include Chief
     * Complaint, History of Present Illness, Review of Systems, Past Medical History, Assessment, and Plan.
     * </p>
     * </li>
     * <li>
     * <p>
     * GIRPP: Provides summaries based on the patients progress toward goals. Sections include Goal, Intervention,
     * Response, Progress, and Plan.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #noteTemplate} will
     * return {@link MedicalScribeNoteTemplate#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #noteTemplateAsString}.
     * </p>
     * 
     * @return Specify one of the following templates to use for the clinical note summary. The default is
     *         <code>HISTORY_AND_PHYSICAL</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         HISTORY_AND_PHYSICAL: Provides summaries for key sections of the clinical documentation. Sections include
     *         Chief Complaint, History of Present Illness, Review of Systems, Past Medical History, Assessment, and
     *         Plan.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GIRPP: Provides summaries based on the patients progress toward goals. Sections include Goal,
     *         Intervention, Response, Progress, and Plan.
     *         </p>
     *         </li>
     * @see MedicalScribeNoteTemplate
     */
    public final MedicalScribeNoteTemplate noteTemplate() {
        return MedicalScribeNoteTemplate.fromValue(noteTemplate);
    }

    /**
     * <p>
     * Specify one of the following templates to use for the clinical note summary. The default is
     * <code>HISTORY_AND_PHYSICAL</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * HISTORY_AND_PHYSICAL: Provides summaries for key sections of the clinical documentation. Sections include Chief
     * Complaint, History of Present Illness, Review of Systems, Past Medical History, Assessment, and Plan.
     * </p>
     * </li>
     * <li>
     * <p>
     * GIRPP: Provides summaries based on the patients progress toward goals. Sections include Goal, Intervention,
     * Response, Progress, and Plan.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #noteTemplate} will
     * return {@link MedicalScribeNoteTemplate#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #noteTemplateAsString}.
     * </p>
     * 
     * @return Specify one of the following templates to use for the clinical note summary. The default is
     *         <code>HISTORY_AND_PHYSICAL</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         HISTORY_AND_PHYSICAL: Provides summaries for key sections of the clinical documentation. Sections include
     *         Chief Complaint, History of Present Illness, Review of Systems, Past Medical History, Assessment, and
     *         Plan.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GIRPP: Provides summaries based on the patients progress toward goals. Sections include Goal,
     *         Intervention, Response, Progress, and Plan.
     *         </p>
     *         </li>
     * @see MedicalScribeNoteTemplate
     */
    public final String noteTemplateAsString() {
        return noteTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(noteTemplateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClinicalNoteGenerationSettings)) {
            return false;
        }
        ClinicalNoteGenerationSettings other = (ClinicalNoteGenerationSettings) obj;
        return Objects.equals(outputBucketName(), other.outputBucketName())
                && Objects.equals(noteTemplateAsString(), other.noteTemplateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClinicalNoteGenerationSettings").add("OutputBucketName", outputBucketName())
                .add("NoteTemplate", noteTemplateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputBucketName":
            return Optional.ofNullable(clazz.cast(outputBucketName()));
        case "NoteTemplate":
            return Optional.ofNullable(clazz.cast(noteTemplateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OutputBucketName", OUTPUT_BUCKET_NAME_FIELD);
        map.put("NoteTemplate", NOTE_TEMPLATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClinicalNoteGenerationSettings, T> g) {
        return obj -> g.apply((ClinicalNoteGenerationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClinicalNoteGenerationSettings> {
        /**
         * <p>
         * The name of the Amazon S3 bucket where you want the output of Amazon Web Services HealthScribe post-stream
         * analytics stored. Don't include the <code>S3://</code> prefix of the specified bucket.
         * </p>
         * <p>
         * HealthScribe outputs transcript and clinical note files under the prefix:
         * <code>S3://$output-bucket-name/healthscribe-streaming/session-id/post-stream-analytics/clinical-notes</code>
         * </p>
         * <p>
         * The role <code>ResourceAccessRoleArn</code> specified in the <code>MedicalScribeConfigurationEvent</code>
         * must have permission to use the specified location. You can change Amazon S3 permissions using the <a
         * href="https://console.aws.amazon.com/s3"> Amazon Web Services Management Console </a>. See also <a href=
         * "https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user"
         * >Permissions Required for IAM User Roles </a> .
         * </p>
         * 
         * @param outputBucketName
         *        The name of the Amazon S3 bucket where you want the output of Amazon Web Services HealthScribe
         *        post-stream analytics stored. Don't include the <code>S3://</code> prefix of the specified bucket.
         *        </p>
         *        <p>
         *        HealthScribe outputs transcript and clinical note files under the prefix:
         *        <code>S3://$output-bucket-name/healthscribe-streaming/session-id/post-stream-analytics/clinical-notes</code>
         *        </p>
         *        <p>
         *        The role <code>ResourceAccessRoleArn</code> specified in the
         *        <code>MedicalScribeConfigurationEvent</code> must have permission to use the specified location. You
         *        can change Amazon S3 permissions using the <a href="https://console.aws.amazon.com/s3"> Amazon Web
         *        Services Management Console </a>. See also <a href=
         *        "https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user"
         *        >Permissions Required for IAM User Roles </a> .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputBucketName(String outputBucketName);

        /**
         * <p>
         * Specify one of the following templates to use for the clinical note summary. The default is
         * <code>HISTORY_AND_PHYSICAL</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * HISTORY_AND_PHYSICAL: Provides summaries for key sections of the clinical documentation. Sections include
         * Chief Complaint, History of Present Illness, Review of Systems, Past Medical History, Assessment, and Plan.
         * </p>
         * </li>
         * <li>
         * <p>
         * GIRPP: Provides summaries based on the patients progress toward goals. Sections include Goal, Intervention,
         * Response, Progress, and Plan.
         * </p>
         * </li>
         * </ul>
         * 
         * @param noteTemplate
         *        Specify one of the following templates to use for the clinical note summary. The default is
         *        <code>HISTORY_AND_PHYSICAL</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        HISTORY_AND_PHYSICAL: Provides summaries for key sections of the clinical documentation. Sections
         *        include Chief Complaint, History of Present Illness, Review of Systems, Past Medical History,
         *        Assessment, and Plan.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GIRPP: Provides summaries based on the patients progress toward goals. Sections include Goal,
         *        Intervention, Response, Progress, and Plan.
         *        </p>
         *        </li>
         * @see MedicalScribeNoteTemplate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeNoteTemplate
         */
        Builder noteTemplate(String noteTemplate);

        /**
         * <p>
         * Specify one of the following templates to use for the clinical note summary. The default is
         * <code>HISTORY_AND_PHYSICAL</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * HISTORY_AND_PHYSICAL: Provides summaries for key sections of the clinical documentation. Sections include
         * Chief Complaint, History of Present Illness, Review of Systems, Past Medical History, Assessment, and Plan.
         * </p>
         * </li>
         * <li>
         * <p>
         * GIRPP: Provides summaries based on the patients progress toward goals. Sections include Goal, Intervention,
         * Response, Progress, and Plan.
         * </p>
         * </li>
         * </ul>
         * 
         * @param noteTemplate
         *        Specify one of the following templates to use for the clinical note summary. The default is
         *        <code>HISTORY_AND_PHYSICAL</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        HISTORY_AND_PHYSICAL: Provides summaries for key sections of the clinical documentation. Sections
         *        include Chief Complaint, History of Present Illness, Review of Systems, Past Medical History,
         *        Assessment, and Plan.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GIRPP: Provides summaries based on the patients progress toward goals. Sections include Goal,
         *        Intervention, Response, Progress, and Plan.
         *        </p>
         *        </li>
         * @see MedicalScribeNoteTemplate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeNoteTemplate
         */
        Builder noteTemplate(MedicalScribeNoteTemplate noteTemplate);
    }

    static final class BuilderImpl implements Builder {
        private String outputBucketName;

        private String noteTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(ClinicalNoteGenerationSettings model) {
            outputBucketName(model.outputBucketName);
            noteTemplate(model.noteTemplate);
        }

        public final String getOutputBucketName() {
            return outputBucketName;
        }

        public final void setOutputBucketName(String outputBucketName) {
            this.outputBucketName = outputBucketName;
        }

        @Override
        public final Builder outputBucketName(String outputBucketName) {
            this.outputBucketName = outputBucketName;
            return this;
        }

        public final String getNoteTemplate() {
            return noteTemplate;
        }

        public final void setNoteTemplate(String noteTemplate) {
            this.noteTemplate = noteTemplate;
        }

        @Override
        public final Builder noteTemplate(String noteTemplate) {
            this.noteTemplate = noteTemplate;
            return this;
        }

        @Override
        public final Builder noteTemplate(MedicalScribeNoteTemplate noteTemplate) {
            this.noteTemplate(noteTemplate == null ? null : noteTemplate.toString());
            return this;
        }

        @Override
        public ClinicalNoteGenerationSettings build() {
            return new ClinicalNoteGenerationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
