/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartStreamTranscriptionResponse extends TranscribeStreamingResponse implements
        ToCopyableBuilder<StartStreamTranscriptionResponse.Builder, StartStreamTranscriptionResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(StartStreamTranscriptionResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-request-id").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode")
            .getter(getter(StartStreamTranscriptionResponse::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-language-code")
                    .build()).build();

    private static final SdkField<Integer> MEDIA_SAMPLE_RATE_HERTZ_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MediaSampleRateHertz")
            .getter(getter(StartStreamTranscriptionResponse::mediaSampleRateHertz))
            .setter(setter(Builder::mediaSampleRateHertz))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-sample-rate")
                    .build()).build();

    private static final SdkField<String> MEDIA_ENCODING_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MediaEncoding")
            .getter(getter(StartStreamTranscriptionResponse::mediaEncodingAsString))
            .setter(setter(Builder::mediaEncoding))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-media-encoding")
                    .build()).build();

    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VocabularyName")
            .getter(getter(StartStreamTranscriptionResponse::vocabularyName))
            .setter(setter(Builder::vocabularyName))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-vocabulary-name")
                    .build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SessionId")
            .getter(getter(StartStreamTranscriptionResponse::sessionId))
            .setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-session-id")
                    .build()).build();

    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterName")
            .getter(getter(StartStreamTranscriptionResponse::vocabularyFilterName))
            .setter(setter(Builder::vocabularyFilterName))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-vocabulary-filter-name").build()).build();

    private static final SdkField<String> VOCABULARY_FILTER_METHOD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterMethod")
            .getter(getter(StartStreamTranscriptionResponse::vocabularyFilterMethodAsString))
            .setter(setter(Builder::vocabularyFilterMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-vocabulary-filter-method").build()).build();

    private static final SdkField<Boolean> SHOW_SPEAKER_LABEL_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ShowSpeakerLabel")
            .getter(getter(StartStreamTranscriptionResponse::showSpeakerLabel))
            .setter(setter(Builder::showSpeakerLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-show-speaker-label").build()).build();

    private static final SdkField<Boolean> ENABLE_CHANNEL_IDENTIFICATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableChannelIdentification")
            .getter(getter(StartStreamTranscriptionResponse::enableChannelIdentification))
            .setter(setter(Builder::enableChannelIdentification))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-enable-channel-identification").build()).build();

    private static final SdkField<Integer> NUMBER_OF_CHANNELS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfChannels")
            .getter(getter(StartStreamTranscriptionResponse::numberOfChannels))
            .setter(setter(Builder::numberOfChannels))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-number-of-channels").build()).build();

    private static final SdkField<Boolean> ENABLE_PARTIAL_RESULTS_STABILIZATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnablePartialResultsStabilization")
            .getter(getter(StartStreamTranscriptionResponse::enablePartialResultsStabilization))
            .setter(setter(Builder::enablePartialResultsStabilization))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-enable-partial-results-stabilization").build()).build();

    private static final SdkField<String> PARTIAL_RESULTS_STABILITY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PartialResultsStability")
            .getter(getter(StartStreamTranscriptionResponse::partialResultsStabilityAsString))
            .setter(setter(Builder::partialResultsStability))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-partial-results-stability").build()).build();

    private static final SdkField<String> CONTENT_IDENTIFICATION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ContentIdentificationType")
            .getter(getter(StartStreamTranscriptionResponse::contentIdentificationTypeAsString))
            .setter(setter(Builder::contentIdentificationType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-content-identification-type").build()).build();

    private static final SdkField<String> CONTENT_REDACTION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ContentRedactionType")
            .getter(getter(StartStreamTranscriptionResponse::contentRedactionTypeAsString))
            .setter(setter(Builder::contentRedactionType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-content-redaction-type").build()).build();

    private static final SdkField<String> PII_ENTITY_TYPES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PiiEntityTypes")
            .getter(getter(StartStreamTranscriptionResponse::piiEntityTypes))
            .setter(setter(Builder::piiEntityTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-pii-entity-types")
                    .build()).build();

    private static final SdkField<String> LANGUAGE_MODEL_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LanguageModelName")
            .getter(getter(StartStreamTranscriptionResponse::languageModelName))
            .setter(setter(Builder::languageModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-language-model-name").build()).build();

    private static final SdkField<Boolean> IDENTIFY_LANGUAGE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IdentifyLanguage")
            .getter(getter(StartStreamTranscriptionResponse::identifyLanguage))
            .setter(setter(Builder::identifyLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-identify-language")
                    .build()).build();

    private static final SdkField<String> LANGUAGE_OPTIONS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LanguageOptions")
            .getter(getter(StartStreamTranscriptionResponse::languageOptions))
            .setter(setter(Builder::languageOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-language-options")
                    .build()).build();

    private static final SdkField<String> PREFERRED_LANGUAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredLanguage")
            .getter(getter(StartStreamTranscriptionResponse::preferredLanguageAsString))
            .setter(setter(Builder::preferredLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-preferred-language").build()).build();

    private static final SdkField<Boolean> IDENTIFY_MULTIPLE_LANGUAGES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IdentifyMultipleLanguages")
            .getter(getter(StartStreamTranscriptionResponse::identifyMultipleLanguages))
            .setter(setter(Builder::identifyMultipleLanguages))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-identify-multiple-languages").build()).build();

    private static final SdkField<String> VOCABULARY_NAMES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VocabularyNames")
            .getter(getter(StartStreamTranscriptionResponse::vocabularyNames))
            .setter(setter(Builder::vocabularyNames))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-vocabulary-names")
                    .build()).build();

    private static final SdkField<String> VOCABULARY_FILTER_NAMES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterNames")
            .getter(getter(StartStreamTranscriptionResponse::vocabularyFilterNames))
            .setter(setter(Builder::vocabularyFilterNames))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amzn-transcribe-vocabulary-filter-names").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            LANGUAGE_CODE_FIELD, MEDIA_SAMPLE_RATE_HERTZ_FIELD, MEDIA_ENCODING_FIELD, VOCABULARY_NAME_FIELD, SESSION_ID_FIELD,
            VOCABULARY_FILTER_NAME_FIELD, VOCABULARY_FILTER_METHOD_FIELD, SHOW_SPEAKER_LABEL_FIELD,
            ENABLE_CHANNEL_IDENTIFICATION_FIELD, NUMBER_OF_CHANNELS_FIELD, ENABLE_PARTIAL_RESULTS_STABILIZATION_FIELD,
            PARTIAL_RESULTS_STABILITY_FIELD, CONTENT_IDENTIFICATION_TYPE_FIELD, CONTENT_REDACTION_TYPE_FIELD,
            PII_ENTITY_TYPES_FIELD, LANGUAGE_MODEL_NAME_FIELD, IDENTIFY_LANGUAGE_FIELD, LANGUAGE_OPTIONS_FIELD,
            PREFERRED_LANGUAGE_FIELD, IDENTIFY_MULTIPLE_LANGUAGES_FIELD, VOCABULARY_NAMES_FIELD, VOCABULARY_FILTER_NAMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String requestId;

    private final String languageCode;

    private final Integer mediaSampleRateHertz;

    private final String mediaEncoding;

    private final String vocabularyName;

    private final String sessionId;

    private final String vocabularyFilterName;

    private final String vocabularyFilterMethod;

    private final Boolean showSpeakerLabel;

    private final Boolean enableChannelIdentification;

    private final Integer numberOfChannels;

    private final Boolean enablePartialResultsStabilization;

    private final String partialResultsStability;

    private final String contentIdentificationType;

    private final String contentRedactionType;

    private final String piiEntityTypes;

    private final String languageModelName;

    private final Boolean identifyLanguage;

    private final String languageOptions;

    private final String preferredLanguage;

    private final Boolean identifyMultipleLanguages;

    private final String vocabularyNames;

    private final String vocabularyFilterNames;

    private StartStreamTranscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.requestId = builder.requestId;
        this.languageCode = builder.languageCode;
        this.mediaSampleRateHertz = builder.mediaSampleRateHertz;
        this.mediaEncoding = builder.mediaEncoding;
        this.vocabularyName = builder.vocabularyName;
        this.sessionId = builder.sessionId;
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.vocabularyFilterMethod = builder.vocabularyFilterMethod;
        this.showSpeakerLabel = builder.showSpeakerLabel;
        this.enableChannelIdentification = builder.enableChannelIdentification;
        this.numberOfChannels = builder.numberOfChannels;
        this.enablePartialResultsStabilization = builder.enablePartialResultsStabilization;
        this.partialResultsStability = builder.partialResultsStability;
        this.contentIdentificationType = builder.contentIdentificationType;
        this.contentRedactionType = builder.contentRedactionType;
        this.piiEntityTypes = builder.piiEntityTypes;
        this.languageModelName = builder.languageModelName;
        this.identifyLanguage = builder.identifyLanguage;
        this.languageOptions = builder.languageOptions;
        this.preferredLanguage = builder.preferredLanguage;
        this.identifyMultipleLanguages = builder.identifyMultipleLanguages;
        this.vocabularyNames = builder.vocabularyNames;
        this.vocabularyFilterNames = builder.vocabularyFilterNames;
    }

    /**
     * <p>
     * Provides the identifier for your streaming request.
     * </p>
     * 
     * @return Provides the identifier for your streaming request.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * Provides the language code that you specified in your request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Provides the language code that you specified in your request.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * Provides the language code that you specified in your request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Provides the language code that you specified in your request.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * Provides the sample rate that you specified in your request.
     * </p>
     * 
     * @return Provides the sample rate that you specified in your request.
     */
    public final Integer mediaSampleRateHertz() {
        return mediaSampleRateHertz;
    }

    /**
     * <p>
     * Provides the media encoding you specified in your request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaEncoding}
     * will return {@link MediaEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mediaEncodingAsString}.
     * </p>
     * 
     * @return Provides the media encoding you specified in your request.
     * @see MediaEncoding
     */
    public final MediaEncoding mediaEncoding() {
        return MediaEncoding.fromValue(mediaEncoding);
    }

    /**
     * <p>
     * Provides the media encoding you specified in your request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaEncoding}
     * will return {@link MediaEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mediaEncodingAsString}.
     * </p>
     * 
     * @return Provides the media encoding you specified in your request.
     * @see MediaEncoding
     */
    public final String mediaEncodingAsString() {
        return mediaEncoding;
    }

    /**
     * <p>
     * Provides the name of the custom vocabulary that you specified in your request.
     * </p>
     * 
     * @return Provides the name of the custom vocabulary that you specified in your request.
     */
    public final String vocabularyName() {
        return vocabularyName;
    }

    /**
     * <p>
     * Provides the identifier for your transcription session.
     * </p>
     * 
     * @return Provides the identifier for your transcription session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * Provides the name of the custom vocabulary filter that you specified in your request.
     * </p>
     * 
     * @return Provides the name of the custom vocabulary filter that you specified in your request.
     */
    public final String vocabularyFilterName() {
        return vocabularyFilterName;
    }

    /**
     * <p>
     * Provides the vocabulary filtering method used in your transcription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vocabularyFilterMethod} will return {@link VocabularyFilterMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #vocabularyFilterMethodAsString}.
     * </p>
     * 
     * @return Provides the vocabulary filtering method used in your transcription.
     * @see VocabularyFilterMethod
     */
    public final VocabularyFilterMethod vocabularyFilterMethod() {
        return VocabularyFilterMethod.fromValue(vocabularyFilterMethod);
    }

    /**
     * <p>
     * Provides the vocabulary filtering method used in your transcription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vocabularyFilterMethod} will return {@link VocabularyFilterMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #vocabularyFilterMethodAsString}.
     * </p>
     * 
     * @return Provides the vocabulary filtering method used in your transcription.
     * @see VocabularyFilterMethod
     */
    public final String vocabularyFilterMethodAsString() {
        return vocabularyFilterMethod;
    }

    /**
     * <p>
     * Shows whether speaker partitioning was enabled for your transcription.
     * </p>
     * 
     * @return Shows whether speaker partitioning was enabled for your transcription.
     */
    public final Boolean showSpeakerLabel() {
        return showSpeakerLabel;
    }

    /**
     * <p>
     * Shows whether channel identification was enabled for your transcription.
     * </p>
     * 
     * @return Shows whether channel identification was enabled for your transcription.
     */
    public final Boolean enableChannelIdentification() {
        return enableChannelIdentification;
    }

    /**
     * <p>
     * Provides the number of channels that you specified in your request.
     * </p>
     * 
     * @return Provides the number of channels that you specified in your request.
     */
    public final Integer numberOfChannels() {
        return numberOfChannels;
    }

    /**
     * <p>
     * Shows whether partial results stabilization was enabled for your transcription.
     * </p>
     * 
     * @return Shows whether partial results stabilization was enabled for your transcription.
     */
    public final Boolean enablePartialResultsStabilization() {
        return enablePartialResultsStabilization;
    }

    /**
     * <p>
     * Provides the stabilization level used for your transcription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #partialResultsStability} will return {@link PartialResultsStability#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #partialResultsStabilityAsString}.
     * </p>
     * 
     * @return Provides the stabilization level used for your transcription.
     * @see PartialResultsStability
     */
    public final PartialResultsStability partialResultsStability() {
        return PartialResultsStability.fromValue(partialResultsStability);
    }

    /**
     * <p>
     * Provides the stabilization level used for your transcription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #partialResultsStability} will return {@link PartialResultsStability#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #partialResultsStabilityAsString}.
     * </p>
     * 
     * @return Provides the stabilization level used for your transcription.
     * @see PartialResultsStability
     */
    public final String partialResultsStabilityAsString() {
        return partialResultsStability;
    }

    /**
     * <p>
     * Shows whether content identification was enabled for your transcription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentIdentificationType} will return {@link ContentIdentificationType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contentIdentificationTypeAsString}.
     * </p>
     * 
     * @return Shows whether content identification was enabled for your transcription.
     * @see ContentIdentificationType
     */
    public final ContentIdentificationType contentIdentificationType() {
        return ContentIdentificationType.fromValue(contentIdentificationType);
    }

    /**
     * <p>
     * Shows whether content identification was enabled for your transcription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentIdentificationType} will return {@link ContentIdentificationType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contentIdentificationTypeAsString}.
     * </p>
     * 
     * @return Shows whether content identification was enabled for your transcription.
     * @see ContentIdentificationType
     */
    public final String contentIdentificationTypeAsString() {
        return contentIdentificationType;
    }

    /**
     * <p>
     * Shows whether content redaction was enabled for your transcription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentRedactionType} will return {@link ContentRedactionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #contentRedactionTypeAsString}.
     * </p>
     * 
     * @return Shows whether content redaction was enabled for your transcription.
     * @see ContentRedactionType
     */
    public final ContentRedactionType contentRedactionType() {
        return ContentRedactionType.fromValue(contentRedactionType);
    }

    /**
     * <p>
     * Shows whether content redaction was enabled for your transcription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentRedactionType} will return {@link ContentRedactionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #contentRedactionTypeAsString}.
     * </p>
     * 
     * @return Shows whether content redaction was enabled for your transcription.
     * @see ContentRedactionType
     */
    public final String contentRedactionTypeAsString() {
        return contentRedactionType;
    }

    /**
     * <p>
     * Lists the PII entity types you specified in your request.
     * </p>
     * 
     * @return Lists the PII entity types you specified in your request.
     */
    public final String piiEntityTypes() {
        return piiEntityTypes;
    }

    /**
     * <p>
     * Provides the name of the custom language model that you specified in your request.
     * </p>
     * 
     * @return Provides the name of the custom language model that you specified in your request.
     */
    public final String languageModelName() {
        return languageModelName;
    }

    /**
     * <p>
     * Shows whether automatic language identification was enabled for your transcription.
     * </p>
     * 
     * @return Shows whether automatic language identification was enabled for your transcription.
     */
    public final Boolean identifyLanguage() {
        return identifyLanguage;
    }

    /**
     * <p>
     * Provides the language codes that you specified in your request.
     * </p>
     * 
     * @return Provides the language codes that you specified in your request.
     */
    public final String languageOptions() {
        return languageOptions;
    }

    /**
     * <p>
     * Provides the preferred language that you specified in your request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #preferredLanguage}
     * will return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #preferredLanguageAsString}.
     * </p>
     * 
     * @return Provides the preferred language that you specified in your request.
     * @see LanguageCode
     */
    public final LanguageCode preferredLanguage() {
        return LanguageCode.fromValue(preferredLanguage);
    }

    /**
     * <p>
     * Provides the preferred language that you specified in your request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #preferredLanguage}
     * will return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #preferredLanguageAsString}.
     * </p>
     * 
     * @return Provides the preferred language that you specified in your request.
     * @see LanguageCode
     */
    public final String preferredLanguageAsString() {
        return preferredLanguage;
    }

    /**
     * <p>
     * Shows whether automatic multi-language identification was enabled for your transcription.
     * </p>
     * 
     * @return Shows whether automatic multi-language identification was enabled for your transcription.
     */
    public final Boolean identifyMultipleLanguages() {
        return identifyMultipleLanguages;
    }

    /**
     * <p>
     * Provides the names of the custom vocabularies that you specified in your request.
     * </p>
     * 
     * @return Provides the names of the custom vocabularies that you specified in your request.
     */
    public final String vocabularyNames() {
        return vocabularyNames;
    }

    /**
     * <p>
     * Provides the names of the custom vocabulary filters that you specified in your request.
     * </p>
     * 
     * @return Provides the names of the custom vocabulary filters that you specified in your request.
     */
    public final String vocabularyFilterNames() {
        return vocabularyFilterNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mediaSampleRateHertz());
        hashCode = 31 * hashCode + Objects.hashCode(mediaEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(showSpeakerLabel());
        hashCode = 31 * hashCode + Objects.hashCode(enableChannelIdentification());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfChannels());
        hashCode = 31 * hashCode + Objects.hashCode(enablePartialResultsStabilization());
        hashCode = 31 * hashCode + Objects.hashCode(partialResultsStabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentIdentificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentRedactionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(piiEntityTypes());
        hashCode = 31 * hashCode + Objects.hashCode(languageModelName());
        hashCode = 31 * hashCode + Objects.hashCode(identifyLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(languageOptions());
        hashCode = 31 * hashCode + Objects.hashCode(preferredLanguageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identifyMultipleLanguages());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyNames());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterNames());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartStreamTranscriptionResponse)) {
            return false;
        }
        StartStreamTranscriptionResponse other = (StartStreamTranscriptionResponse) obj;
        return Objects.equals(requestId(), other.requestId())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(mediaSampleRateHertz(), other.mediaSampleRateHertz())
                && Objects.equals(mediaEncodingAsString(), other.mediaEncodingAsString())
                && Objects.equals(vocabularyName(), other.vocabularyName()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(vocabularyFilterName(), other.vocabularyFilterName())
                && Objects.equals(vocabularyFilterMethodAsString(), other.vocabularyFilterMethodAsString())
                && Objects.equals(showSpeakerLabel(), other.showSpeakerLabel())
                && Objects.equals(enableChannelIdentification(), other.enableChannelIdentification())
                && Objects.equals(numberOfChannels(), other.numberOfChannels())
                && Objects.equals(enablePartialResultsStabilization(), other.enablePartialResultsStabilization())
                && Objects.equals(partialResultsStabilityAsString(), other.partialResultsStabilityAsString())
                && Objects.equals(contentIdentificationTypeAsString(), other.contentIdentificationTypeAsString())
                && Objects.equals(contentRedactionTypeAsString(), other.contentRedactionTypeAsString())
                && Objects.equals(piiEntityTypes(), other.piiEntityTypes())
                && Objects.equals(languageModelName(), other.languageModelName())
                && Objects.equals(identifyLanguage(), other.identifyLanguage())
                && Objects.equals(languageOptions(), other.languageOptions())
                && Objects.equals(preferredLanguageAsString(), other.preferredLanguageAsString())
                && Objects.equals(identifyMultipleLanguages(), other.identifyMultipleLanguages())
                && Objects.equals(vocabularyNames(), other.vocabularyNames())
                && Objects.equals(vocabularyFilterNames(), other.vocabularyFilterNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartStreamTranscriptionResponse").add("RequestId", requestId())
                .add("LanguageCode", languageCodeAsString()).add("MediaSampleRateHertz", mediaSampleRateHertz())
                .add("MediaEncoding", mediaEncodingAsString()).add("VocabularyName", vocabularyName())
                .add("SessionId", sessionId()).add("VocabularyFilterName", vocabularyFilterName())
                .add("VocabularyFilterMethod", vocabularyFilterMethodAsString()).add("ShowSpeakerLabel", showSpeakerLabel())
                .add("EnableChannelIdentification", enableChannelIdentification()).add("NumberOfChannels", numberOfChannels())
                .add("EnablePartialResultsStabilization", enablePartialResultsStabilization())
                .add("PartialResultsStability", partialResultsStabilityAsString())
                .add("ContentIdentificationType", contentIdentificationTypeAsString())
                .add("ContentRedactionType", contentRedactionTypeAsString()).add("PiiEntityTypes", piiEntityTypes())
                .add("LanguageModelName", languageModelName()).add("IdentifyLanguage", identifyLanguage())
                .add("LanguageOptions", languageOptions()).add("PreferredLanguage", preferredLanguageAsString())
                .add("IdentifyMultipleLanguages", identifyMultipleLanguages()).add("VocabularyNames", vocabularyNames())
                .add("VocabularyFilterNames", vocabularyFilterNames()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "MediaSampleRateHertz":
            return Optional.ofNullable(clazz.cast(mediaSampleRateHertz()));
        case "MediaEncoding":
            return Optional.ofNullable(clazz.cast(mediaEncodingAsString()));
        case "VocabularyName":
            return Optional.ofNullable(clazz.cast(vocabularyName()));
        case "SessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "VocabularyFilterName":
            return Optional.ofNullable(clazz.cast(vocabularyFilterName()));
        case "VocabularyFilterMethod":
            return Optional.ofNullable(clazz.cast(vocabularyFilterMethodAsString()));
        case "ShowSpeakerLabel":
            return Optional.ofNullable(clazz.cast(showSpeakerLabel()));
        case "EnableChannelIdentification":
            return Optional.ofNullable(clazz.cast(enableChannelIdentification()));
        case "NumberOfChannels":
            return Optional.ofNullable(clazz.cast(numberOfChannels()));
        case "EnablePartialResultsStabilization":
            return Optional.ofNullable(clazz.cast(enablePartialResultsStabilization()));
        case "PartialResultsStability":
            return Optional.ofNullable(clazz.cast(partialResultsStabilityAsString()));
        case "ContentIdentificationType":
            return Optional.ofNullable(clazz.cast(contentIdentificationTypeAsString()));
        case "ContentRedactionType":
            return Optional.ofNullable(clazz.cast(contentRedactionTypeAsString()));
        case "PiiEntityTypes":
            return Optional.ofNullable(clazz.cast(piiEntityTypes()));
        case "LanguageModelName":
            return Optional.ofNullable(clazz.cast(languageModelName()));
        case "IdentifyLanguage":
            return Optional.ofNullable(clazz.cast(identifyLanguage()));
        case "LanguageOptions":
            return Optional.ofNullable(clazz.cast(languageOptions()));
        case "PreferredLanguage":
            return Optional.ofNullable(clazz.cast(preferredLanguageAsString()));
        case "IdentifyMultipleLanguages":
            return Optional.ofNullable(clazz.cast(identifyMultipleLanguages()));
        case "VocabularyNames":
            return Optional.ofNullable(clazz.cast(vocabularyNames()));
        case "VocabularyFilterNames":
            return Optional.ofNullable(clazz.cast(vocabularyFilterNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("x-amzn-request-id", REQUEST_ID_FIELD);
        map.put("x-amzn-transcribe-language-code", LANGUAGE_CODE_FIELD);
        map.put("x-amzn-transcribe-sample-rate", MEDIA_SAMPLE_RATE_HERTZ_FIELD);
        map.put("x-amzn-transcribe-media-encoding", MEDIA_ENCODING_FIELD);
        map.put("x-amzn-transcribe-vocabulary-name", VOCABULARY_NAME_FIELD);
        map.put("x-amzn-transcribe-session-id", SESSION_ID_FIELD);
        map.put("x-amzn-transcribe-vocabulary-filter-name", VOCABULARY_FILTER_NAME_FIELD);
        map.put("x-amzn-transcribe-vocabulary-filter-method", VOCABULARY_FILTER_METHOD_FIELD);
        map.put("x-amzn-transcribe-show-speaker-label", SHOW_SPEAKER_LABEL_FIELD);
        map.put("x-amzn-transcribe-enable-channel-identification", ENABLE_CHANNEL_IDENTIFICATION_FIELD);
        map.put("x-amzn-transcribe-number-of-channels", NUMBER_OF_CHANNELS_FIELD);
        map.put("x-amzn-transcribe-enable-partial-results-stabilization", ENABLE_PARTIAL_RESULTS_STABILIZATION_FIELD);
        map.put("x-amzn-transcribe-partial-results-stability", PARTIAL_RESULTS_STABILITY_FIELD);
        map.put("x-amzn-transcribe-content-identification-type", CONTENT_IDENTIFICATION_TYPE_FIELD);
        map.put("x-amzn-transcribe-content-redaction-type", CONTENT_REDACTION_TYPE_FIELD);
        map.put("x-amzn-transcribe-pii-entity-types", PII_ENTITY_TYPES_FIELD);
        map.put("x-amzn-transcribe-language-model-name", LANGUAGE_MODEL_NAME_FIELD);
        map.put("x-amzn-transcribe-identify-language", IDENTIFY_LANGUAGE_FIELD);
        map.put("x-amzn-transcribe-language-options", LANGUAGE_OPTIONS_FIELD);
        map.put("x-amzn-transcribe-preferred-language", PREFERRED_LANGUAGE_FIELD);
        map.put("x-amzn-transcribe-identify-multiple-languages", IDENTIFY_MULTIPLE_LANGUAGES_FIELD);
        map.put("x-amzn-transcribe-vocabulary-names", VOCABULARY_NAMES_FIELD);
        map.put("x-amzn-transcribe-vocabulary-filter-names", VOCABULARY_FILTER_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartStreamTranscriptionResponse, T> g) {
        return obj -> g.apply((StartStreamTranscriptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TranscribeStreamingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartStreamTranscriptionResponse> {
        /**
         * <p>
         * Provides the identifier for your streaming request.
         * </p>
         * 
         * @param requestId
         *        Provides the identifier for your streaming request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * Provides the language code that you specified in your request.
         * </p>
         * 
         * @param languageCode
         *        Provides the language code that you specified in your request.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * Provides the language code that you specified in your request.
         * </p>
         * 
         * @param languageCode
         *        Provides the language code that you specified in your request.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * Provides the sample rate that you specified in your request.
         * </p>
         * 
         * @param mediaSampleRateHertz
         *        Provides the sample rate that you specified in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaSampleRateHertz(Integer mediaSampleRateHertz);

        /**
         * <p>
         * Provides the media encoding you specified in your request.
         * </p>
         * 
         * @param mediaEncoding
         *        Provides the media encoding you specified in your request.
         * @see MediaEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaEncoding
         */
        Builder mediaEncoding(String mediaEncoding);

        /**
         * <p>
         * Provides the media encoding you specified in your request.
         * </p>
         * 
         * @param mediaEncoding
         *        Provides the media encoding you specified in your request.
         * @see MediaEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaEncoding
         */
        Builder mediaEncoding(MediaEncoding mediaEncoding);

        /**
         * <p>
         * Provides the name of the custom vocabulary that you specified in your request.
         * </p>
         * 
         * @param vocabularyName
         *        Provides the name of the custom vocabulary that you specified in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyName(String vocabularyName);

        /**
         * <p>
         * Provides the identifier for your transcription session.
         * </p>
         * 
         * @param sessionId
         *        Provides the identifier for your transcription session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * Provides the name of the custom vocabulary filter that you specified in your request.
         * </p>
         * 
         * @param vocabularyFilterName
         *        Provides the name of the custom vocabulary filter that you specified in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterName(String vocabularyFilterName);

        /**
         * <p>
         * Provides the vocabulary filtering method used in your transcription.
         * </p>
         * 
         * @param vocabularyFilterMethod
         *        Provides the vocabulary filtering method used in your transcription.
         * @see VocabularyFilterMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyFilterMethod
         */
        Builder vocabularyFilterMethod(String vocabularyFilterMethod);

        /**
         * <p>
         * Provides the vocabulary filtering method used in your transcription.
         * </p>
         * 
         * @param vocabularyFilterMethod
         *        Provides the vocabulary filtering method used in your transcription.
         * @see VocabularyFilterMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyFilterMethod
         */
        Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod);

        /**
         * <p>
         * Shows whether speaker partitioning was enabled for your transcription.
         * </p>
         * 
         * @param showSpeakerLabel
         *        Shows whether speaker partitioning was enabled for your transcription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder showSpeakerLabel(Boolean showSpeakerLabel);

        /**
         * <p>
         * Shows whether channel identification was enabled for your transcription.
         * </p>
         * 
         * @param enableChannelIdentification
         *        Shows whether channel identification was enabled for your transcription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableChannelIdentification(Boolean enableChannelIdentification);

        /**
         * <p>
         * Provides the number of channels that you specified in your request.
         * </p>
         * 
         * @param numberOfChannels
         *        Provides the number of channels that you specified in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfChannels(Integer numberOfChannels);

        /**
         * <p>
         * Shows whether partial results stabilization was enabled for your transcription.
         * </p>
         * 
         * @param enablePartialResultsStabilization
         *        Shows whether partial results stabilization was enabled for your transcription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePartialResultsStabilization(Boolean enablePartialResultsStabilization);

        /**
         * <p>
         * Provides the stabilization level used for your transcription.
         * </p>
         * 
         * @param partialResultsStability
         *        Provides the stabilization level used for your transcription.
         * @see PartialResultsStability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartialResultsStability
         */
        Builder partialResultsStability(String partialResultsStability);

        /**
         * <p>
         * Provides the stabilization level used for your transcription.
         * </p>
         * 
         * @param partialResultsStability
         *        Provides the stabilization level used for your transcription.
         * @see PartialResultsStability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartialResultsStability
         */
        Builder partialResultsStability(PartialResultsStability partialResultsStability);

        /**
         * <p>
         * Shows whether content identification was enabled for your transcription.
         * </p>
         * 
         * @param contentIdentificationType
         *        Shows whether content identification was enabled for your transcription.
         * @see ContentIdentificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentIdentificationType
         */
        Builder contentIdentificationType(String contentIdentificationType);

        /**
         * <p>
         * Shows whether content identification was enabled for your transcription.
         * </p>
         * 
         * @param contentIdentificationType
         *        Shows whether content identification was enabled for your transcription.
         * @see ContentIdentificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentIdentificationType
         */
        Builder contentIdentificationType(ContentIdentificationType contentIdentificationType);

        /**
         * <p>
         * Shows whether content redaction was enabled for your transcription.
         * </p>
         * 
         * @param contentRedactionType
         *        Shows whether content redaction was enabled for your transcription.
         * @see ContentRedactionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentRedactionType
         */
        Builder contentRedactionType(String contentRedactionType);

        /**
         * <p>
         * Shows whether content redaction was enabled for your transcription.
         * </p>
         * 
         * @param contentRedactionType
         *        Shows whether content redaction was enabled for your transcription.
         * @see ContentRedactionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentRedactionType
         */
        Builder contentRedactionType(ContentRedactionType contentRedactionType);

        /**
         * <p>
         * Lists the PII entity types you specified in your request.
         * </p>
         * 
         * @param piiEntityTypes
         *        Lists the PII entity types you specified in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder piiEntityTypes(String piiEntityTypes);

        /**
         * <p>
         * Provides the name of the custom language model that you specified in your request.
         * </p>
         * 
         * @param languageModelName
         *        Provides the name of the custom language model that you specified in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageModelName(String languageModelName);

        /**
         * <p>
         * Shows whether automatic language identification was enabled for your transcription.
         * </p>
         * 
         * @param identifyLanguage
         *        Shows whether automatic language identification was enabled for your transcription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifyLanguage(Boolean identifyLanguage);

        /**
         * <p>
         * Provides the language codes that you specified in your request.
         * </p>
         * 
         * @param languageOptions
         *        Provides the language codes that you specified in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageOptions(String languageOptions);

        /**
         * <p>
         * Provides the preferred language that you specified in your request.
         * </p>
         * 
         * @param preferredLanguage
         *        Provides the preferred language that you specified in your request.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder preferredLanguage(String preferredLanguage);

        /**
         * <p>
         * Provides the preferred language that you specified in your request.
         * </p>
         * 
         * @param preferredLanguage
         *        Provides the preferred language that you specified in your request.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder preferredLanguage(LanguageCode preferredLanguage);

        /**
         * <p>
         * Shows whether automatic multi-language identification was enabled for your transcription.
         * </p>
         * 
         * @param identifyMultipleLanguages
         *        Shows whether automatic multi-language identification was enabled for your transcription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifyMultipleLanguages(Boolean identifyMultipleLanguages);

        /**
         * <p>
         * Provides the names of the custom vocabularies that you specified in your request.
         * </p>
         * 
         * @param vocabularyNames
         *        Provides the names of the custom vocabularies that you specified in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyNames(String vocabularyNames);

        /**
         * <p>
         * Provides the names of the custom vocabulary filters that you specified in your request.
         * </p>
         * 
         * @param vocabularyFilterNames
         *        Provides the names of the custom vocabulary filters that you specified in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterNames(String vocabularyFilterNames);
    }

    static final class BuilderImpl extends TranscribeStreamingResponse.BuilderImpl implements Builder {
        private String requestId;

        private String languageCode;

        private Integer mediaSampleRateHertz;

        private String mediaEncoding;

        private String vocabularyName;

        private String sessionId;

        private String vocabularyFilterName;

        private String vocabularyFilterMethod;

        private Boolean showSpeakerLabel;

        private Boolean enableChannelIdentification;

        private Integer numberOfChannels;

        private Boolean enablePartialResultsStabilization;

        private String partialResultsStability;

        private String contentIdentificationType;

        private String contentRedactionType;

        private String piiEntityTypes;

        private String languageModelName;

        private Boolean identifyLanguage;

        private String languageOptions;

        private String preferredLanguage;

        private Boolean identifyMultipleLanguages;

        private String vocabularyNames;

        private String vocabularyFilterNames;

        private BuilderImpl() {
        }

        private BuilderImpl(StartStreamTranscriptionResponse model) {
            super(model);
            requestId(model.requestId);
            languageCode(model.languageCode);
            mediaSampleRateHertz(model.mediaSampleRateHertz);
            mediaEncoding(model.mediaEncoding);
            vocabularyName(model.vocabularyName);
            sessionId(model.sessionId);
            vocabularyFilterName(model.vocabularyFilterName);
            vocabularyFilterMethod(model.vocabularyFilterMethod);
            showSpeakerLabel(model.showSpeakerLabel);
            enableChannelIdentification(model.enableChannelIdentification);
            numberOfChannels(model.numberOfChannels);
            enablePartialResultsStabilization(model.enablePartialResultsStabilization);
            partialResultsStability(model.partialResultsStability);
            contentIdentificationType(model.contentIdentificationType);
            contentRedactionType(model.contentRedactionType);
            piiEntityTypes(model.piiEntityTypes);
            languageModelName(model.languageModelName);
            identifyLanguage(model.identifyLanguage);
            languageOptions(model.languageOptions);
            preferredLanguage(model.preferredLanguage);
            identifyMultipleLanguages(model.identifyMultipleLanguages);
            vocabularyNames(model.vocabularyNames);
            vocabularyFilterNames(model.vocabularyFilterNames);
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Integer getMediaSampleRateHertz() {
            return mediaSampleRateHertz;
        }

        public final void setMediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
        }

        @Override
        public final Builder mediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
            return this;
        }

        public final String getMediaEncoding() {
            return mediaEncoding;
        }

        public final void setMediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
        }

        @Override
        public final Builder mediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
            return this;
        }

        @Override
        public final Builder mediaEncoding(MediaEncoding mediaEncoding) {
            this.mediaEncoding(mediaEncoding == null ? null : mediaEncoding.toString());
            return this;
        }

        public final String getVocabularyName() {
            return vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getVocabularyFilterName() {
            return vocabularyFilterName;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final String getVocabularyFilterMethod() {
            return vocabularyFilterMethod;
        }

        public final void setVocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
        }

        @Override
        public final Builder vocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
            return this;
        }

        @Override
        public final Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod) {
            this.vocabularyFilterMethod(vocabularyFilterMethod == null ? null : vocabularyFilterMethod.toString());
            return this;
        }

        public final Boolean getShowSpeakerLabel() {
            return showSpeakerLabel;
        }

        public final void setShowSpeakerLabel(Boolean showSpeakerLabel) {
            this.showSpeakerLabel = showSpeakerLabel;
        }

        @Override
        public final Builder showSpeakerLabel(Boolean showSpeakerLabel) {
            this.showSpeakerLabel = showSpeakerLabel;
            return this;
        }

        public final Boolean getEnableChannelIdentification() {
            return enableChannelIdentification;
        }

        public final void setEnableChannelIdentification(Boolean enableChannelIdentification) {
            this.enableChannelIdentification = enableChannelIdentification;
        }

        @Override
        public final Builder enableChannelIdentification(Boolean enableChannelIdentification) {
            this.enableChannelIdentification = enableChannelIdentification;
            return this;
        }

        public final Integer getNumberOfChannels() {
            return numberOfChannels;
        }

        public final void setNumberOfChannels(Integer numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
        }

        @Override
        public final Builder numberOfChannels(Integer numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
            return this;
        }

        public final Boolean getEnablePartialResultsStabilization() {
            return enablePartialResultsStabilization;
        }

        public final void setEnablePartialResultsStabilization(Boolean enablePartialResultsStabilization) {
            this.enablePartialResultsStabilization = enablePartialResultsStabilization;
        }

        @Override
        public final Builder enablePartialResultsStabilization(Boolean enablePartialResultsStabilization) {
            this.enablePartialResultsStabilization = enablePartialResultsStabilization;
            return this;
        }

        public final String getPartialResultsStability() {
            return partialResultsStability;
        }

        public final void setPartialResultsStability(String partialResultsStability) {
            this.partialResultsStability = partialResultsStability;
        }

        @Override
        public final Builder partialResultsStability(String partialResultsStability) {
            this.partialResultsStability = partialResultsStability;
            return this;
        }

        @Override
        public final Builder partialResultsStability(PartialResultsStability partialResultsStability) {
            this.partialResultsStability(partialResultsStability == null ? null : partialResultsStability.toString());
            return this;
        }

        public final String getContentIdentificationType() {
            return contentIdentificationType;
        }

        public final void setContentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
        }

        @Override
        public final Builder contentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
            return this;
        }

        @Override
        public final Builder contentIdentificationType(ContentIdentificationType contentIdentificationType) {
            this.contentIdentificationType(contentIdentificationType == null ? null : contentIdentificationType.toString());
            return this;
        }

        public final String getContentRedactionType() {
            return contentRedactionType;
        }

        public final void setContentRedactionType(String contentRedactionType) {
            this.contentRedactionType = contentRedactionType;
        }

        @Override
        public final Builder contentRedactionType(String contentRedactionType) {
            this.contentRedactionType = contentRedactionType;
            return this;
        }

        @Override
        public final Builder contentRedactionType(ContentRedactionType contentRedactionType) {
            this.contentRedactionType(contentRedactionType == null ? null : contentRedactionType.toString());
            return this;
        }

        public final String getPiiEntityTypes() {
            return piiEntityTypes;
        }

        public final void setPiiEntityTypes(String piiEntityTypes) {
            this.piiEntityTypes = piiEntityTypes;
        }

        @Override
        public final Builder piiEntityTypes(String piiEntityTypes) {
            this.piiEntityTypes = piiEntityTypes;
            return this;
        }

        public final String getLanguageModelName() {
            return languageModelName;
        }

        public final void setLanguageModelName(String languageModelName) {
            this.languageModelName = languageModelName;
        }

        @Override
        public final Builder languageModelName(String languageModelName) {
            this.languageModelName = languageModelName;
            return this;
        }

        public final Boolean getIdentifyLanguage() {
            return identifyLanguage;
        }

        public final void setIdentifyLanguage(Boolean identifyLanguage) {
            this.identifyLanguage = identifyLanguage;
        }

        @Override
        public final Builder identifyLanguage(Boolean identifyLanguage) {
            this.identifyLanguage = identifyLanguage;
            return this;
        }

        public final String getLanguageOptions() {
            return languageOptions;
        }

        public final void setLanguageOptions(String languageOptions) {
            this.languageOptions = languageOptions;
        }

        @Override
        public final Builder languageOptions(String languageOptions) {
            this.languageOptions = languageOptions;
            return this;
        }

        public final String getPreferredLanguage() {
            return preferredLanguage;
        }

        public final void setPreferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
        }

        @Override
        public final Builder preferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
            return this;
        }

        @Override
        public final Builder preferredLanguage(LanguageCode preferredLanguage) {
            this.preferredLanguage(preferredLanguage == null ? null : preferredLanguage.toString());
            return this;
        }

        public final Boolean getIdentifyMultipleLanguages() {
            return identifyMultipleLanguages;
        }

        public final void setIdentifyMultipleLanguages(Boolean identifyMultipleLanguages) {
            this.identifyMultipleLanguages = identifyMultipleLanguages;
        }

        @Override
        public final Builder identifyMultipleLanguages(Boolean identifyMultipleLanguages) {
            this.identifyMultipleLanguages = identifyMultipleLanguages;
            return this;
        }

        public final String getVocabularyNames() {
            return vocabularyNames;
        }

        public final void setVocabularyNames(String vocabularyNames) {
            this.vocabularyNames = vocabularyNames;
        }

        @Override
        public final Builder vocabularyNames(String vocabularyNames) {
            this.vocabularyNames = vocabularyNames;
            return this;
        }

        public final String getVocabularyFilterNames() {
            return vocabularyFilterNames;
        }

        public final void setVocabularyFilterNames(String vocabularyFilterNames) {
            this.vocabularyFilterNames = vocabularyFilterNames;
        }

        @Override
        public final Builder vocabularyFilterNames(String vocabularyFilterNames) {
            this.vocabularyFilterNames = vocabularyFilterNames;
            return this;
        }

        @Override
        public StartStreamTranscriptionResponse build() {
            return new StartStreamTranscriptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
