/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specify the lifecycle of your streaming session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MedicalScribeSessionControlEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<MedicalScribeSessionControlEvent.Builder, MedicalScribeSessionControlEvent>, MedicalScribeInputStream {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(MedicalScribeSessionControlEvent::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    protected MedicalScribeSessionControlEvent(BuilderImpl builder) {
        this.type = builder.type;
    }

    /**
     * <p>
     * The type of <code>MedicalScribeSessionControlEvent</code>.
     * </p>
     * <p>
     * Possible Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>END_OF_SESSION</code> - Indicates the audio streaming is complete. After you send an END_OF_SESSION event,
     * Amazon Web Services HealthScribe starts the post-stream analytics. The session can't be resumed after this event
     * is sent. After Amazon Web Services HealthScribe processes the event, the real-time <code>StreamStatus</code> is
     * <code>COMPLETED</code>. You get the <code>StreamStatus</code> and other stream details with the <a
     * href="https://docs.aws.amazon.com/transcribe/latest/APIReference/API_streaming_GetMedicalScribeStream.html"
     * >GetMedicalScribeStream</a> API operation. For more information about different streaming statuses, see the
     * <code>StreamStatus</code> description in the <a
     * href="https://docs.aws.amazon.com/transcribe/latest/APIReference/API_streaming_MedicalScribeStreamDetails.html"
     * >MedicalScribeStreamDetails</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MedicalScribeSessionControlEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of <code>MedicalScribeSessionControlEvent</code>. </p>
     *         <p>
     *         Possible Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>END_OF_SESSION</code> - Indicates the audio streaming is complete. After you send an END_OF_SESSION
     *         event, Amazon Web Services HealthScribe starts the post-stream analytics. The session can't be resumed
     *         after this event is sent. After Amazon Web Services HealthScribe processes the event, the real-time
     *         <code>StreamStatus</code> is <code>COMPLETED</code>. You get the <code>StreamStatus</code> and other
     *         stream details with the <a href=
     *         "https://docs.aws.amazon.com/transcribe/latest/APIReference/API_streaming_GetMedicalScribeStream.html"
     *         >GetMedicalScribeStream</a> API operation. For more information about different streaming statuses, see
     *         the <code>StreamStatus</code> description in the <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/APIReference/API_streaming_MedicalScribeStreamDetails.html"
     *         >MedicalScribeStreamDetails</a>.
     *         </p>
     *         </li>
     * @see MedicalScribeSessionControlEventType
     */
    public final MedicalScribeSessionControlEventType type() {
        return MedicalScribeSessionControlEventType.fromValue(type);
    }

    /**
     * <p>
     * The type of <code>MedicalScribeSessionControlEvent</code>.
     * </p>
     * <p>
     * Possible Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>END_OF_SESSION</code> - Indicates the audio streaming is complete. After you send an END_OF_SESSION event,
     * Amazon Web Services HealthScribe starts the post-stream analytics. The session can't be resumed after this event
     * is sent. After Amazon Web Services HealthScribe processes the event, the real-time <code>StreamStatus</code> is
     * <code>COMPLETED</code>. You get the <code>StreamStatus</code> and other stream details with the <a
     * href="https://docs.aws.amazon.com/transcribe/latest/APIReference/API_streaming_GetMedicalScribeStream.html"
     * >GetMedicalScribeStream</a> API operation. For more information about different streaming statuses, see the
     * <code>StreamStatus</code> description in the <a
     * href="https://docs.aws.amazon.com/transcribe/latest/APIReference/API_streaming_MedicalScribeStreamDetails.html"
     * >MedicalScribeStreamDetails</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MedicalScribeSessionControlEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of <code>MedicalScribeSessionControlEvent</code>. </p>
     *         <p>
     *         Possible Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>END_OF_SESSION</code> - Indicates the audio streaming is complete. After you send an END_OF_SESSION
     *         event, Amazon Web Services HealthScribe starts the post-stream analytics. The session can't be resumed
     *         after this event is sent. After Amazon Web Services HealthScribe processes the event, the real-time
     *         <code>StreamStatus</code> is <code>COMPLETED</code>. You get the <code>StreamStatus</code> and other
     *         stream details with the <a href=
     *         "https://docs.aws.amazon.com/transcribe/latest/APIReference/API_streaming_GetMedicalScribeStream.html"
     *         >GetMedicalScribeStream</a> API operation. For more information about different streaming statuses, see
     *         the <code>StreamStatus</code> description in the <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/APIReference/API_streaming_MedicalScribeStreamDetails.html"
     *         >MedicalScribeStreamDetails</a>.
     *         </p>
     *         </li>
     * @see MedicalScribeSessionControlEventType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalScribeSessionControlEvent)) {
            return false;
        }
        MedicalScribeSessionControlEvent other = (MedicalScribeSessionControlEvent) obj;
        return Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MedicalScribeSessionControlEvent").add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final MedicalScribeSessionControlEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MedicalScribeSessionControlEvent, T> g) {
        return obj -> g.apply((MedicalScribeSessionControlEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MedicalScribeSessionControlEvent> {
        /**
         * <p>
         * The type of <code>MedicalScribeSessionControlEvent</code>.
         * </p>
         * <p>
         * Possible Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>END_OF_SESSION</code> - Indicates the audio streaming is complete. After you send an END_OF_SESSION
         * event, Amazon Web Services HealthScribe starts the post-stream analytics. The session can't be resumed after
         * this event is sent. After Amazon Web Services HealthScribe processes the event, the real-time
         * <code>StreamStatus</code> is <code>COMPLETED</code>. You get the <code>StreamStatus</code> and other stream
         * details with the <a
         * href="https://docs.aws.amazon.com/transcribe/latest/APIReference/API_streaming_GetMedicalScribeStream.html"
         * >GetMedicalScribeStream</a> API operation. For more information about different streaming statuses, see the
         * <code>StreamStatus</code> description in the <a href=
         * "https://docs.aws.amazon.com/transcribe/latest/APIReference/API_streaming_MedicalScribeStreamDetails.html"
         * >MedicalScribeStreamDetails</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of <code>MedicalScribeSessionControlEvent</code>. </p>
         *        <p>
         *        Possible Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>END_OF_SESSION</code> - Indicates the audio streaming is complete. After you send an
         *        END_OF_SESSION event, Amazon Web Services HealthScribe starts the post-stream analytics. The session
         *        can't be resumed after this event is sent. After Amazon Web Services HealthScribe processes the event,
         *        the real-time <code>StreamStatus</code> is <code>COMPLETED</code>. You get the
         *        <code>StreamStatus</code> and other stream details with the <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/APIReference/API_streaming_GetMedicalScribeStream.html"
         *        >GetMedicalScribeStream</a> API operation. For more information about different streaming statuses,
         *        see the <code>StreamStatus</code> description in the <a href=
         *        "https://docs.aws.amazon.com/transcribe/latest/APIReference/API_streaming_MedicalScribeStreamDetails.html"
         *        >MedicalScribeStreamDetails</a>.
         *        </p>
         *        </li>
         * @see MedicalScribeSessionControlEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeSessionControlEventType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of <code>MedicalScribeSessionControlEvent</code>.
         * </p>
         * <p>
         * Possible Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>END_OF_SESSION</code> - Indicates the audio streaming is complete. After you send an END_OF_SESSION
         * event, Amazon Web Services HealthScribe starts the post-stream analytics. The session can't be resumed after
         * this event is sent. After Amazon Web Services HealthScribe processes the event, the real-time
         * <code>StreamStatus</code> is <code>COMPLETED</code>. You get the <code>StreamStatus</code> and other stream
         * details with the <a
         * href="https://docs.aws.amazon.com/transcribe/latest/APIReference/API_streaming_GetMedicalScribeStream.html"
         * >GetMedicalScribeStream</a> API operation. For more information about different streaming statuses, see the
         * <code>StreamStatus</code> description in the <a href=
         * "https://docs.aws.amazon.com/transcribe/latest/APIReference/API_streaming_MedicalScribeStreamDetails.html"
         * >MedicalScribeStreamDetails</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of <code>MedicalScribeSessionControlEvent</code>. </p>
         *        <p>
         *        Possible Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>END_OF_SESSION</code> - Indicates the audio streaming is complete. After you send an
         *        END_OF_SESSION event, Amazon Web Services HealthScribe starts the post-stream analytics. The session
         *        can't be resumed after this event is sent. After Amazon Web Services HealthScribe processes the event,
         *        the real-time <code>StreamStatus</code> is <code>COMPLETED</code>. You get the
         *        <code>StreamStatus</code> and other stream details with the <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/APIReference/API_streaming_GetMedicalScribeStream.html"
         *        >GetMedicalScribeStream</a> API operation. For more information about different streaming statuses,
         *        see the <code>StreamStatus</code> description in the <a href=
         *        "https://docs.aws.amazon.com/transcribe/latest/APIReference/API_streaming_MedicalScribeStreamDetails.html"
         *        >MedicalScribeStreamDetails</a>.
         *        </p>
         *        </li>
         * @see MedicalScribeSessionControlEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeSessionControlEventType
         */
        Builder type(MedicalScribeSessionControlEventType type);
    }

    protected static class BuilderImpl implements Builder {
        private String type;

        protected BuilderImpl() {
        }

        protected BuilderImpl(MedicalScribeSessionControlEvent model) {
            type(model.type);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MedicalScribeSessionControlEventType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public MedicalScribeSessionControlEvent build() {
            return new MedicalScribeSessionControlEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
