/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a Amazon Web Services HealthScribe streaming session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MedicalScribeStreamDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<MedicalScribeStreamDetails.Builder, MedicalScribeStreamDetails> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionId").getter(getter(MedicalScribeStreamDetails::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()).build();

    private static final SdkField<Instant> STREAM_CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StreamCreatedAt").getter(getter(MedicalScribeStreamDetails::streamCreatedAt))
            .setter(setter(Builder::streamCreatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamCreatedAt").build()).build();

    private static final SdkField<Instant> STREAM_ENDED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StreamEndedAt").getter(getter(MedicalScribeStreamDetails::streamEndedAt))
            .setter(setter(Builder::streamEndedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamEndedAt").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(MedicalScribeStreamDetails::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<Integer> MEDIA_SAMPLE_RATE_HERTZ_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MediaSampleRateHertz").getter(getter(MedicalScribeStreamDetails::mediaSampleRateHertz))
            .setter(setter(Builder::mediaSampleRateHertz))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaSampleRateHertz").build())
            .build();

    private static final SdkField<String> MEDIA_ENCODING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaEncoding").getter(getter(MedicalScribeStreamDetails::mediaEncodingAsString))
            .setter(setter(Builder::mediaEncoding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaEncoding").build()).build();

    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyName").getter(getter(MedicalScribeStreamDetails::vocabularyName))
            .setter(setter(Builder::vocabularyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()).build();

    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterName").getter(getter(MedicalScribeStreamDetails::vocabularyFilterName))
            .setter(setter(Builder::vocabularyFilterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build())
            .build();

    private static final SdkField<String> VOCABULARY_FILTER_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterMethod").getter(getter(MedicalScribeStreamDetails::vocabularyFilterMethodAsString))
            .setter(setter(Builder::vocabularyFilterMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterMethod").build())
            .build();

    private static final SdkField<String> RESOURCE_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceAccessRoleArn").getter(getter(MedicalScribeStreamDetails::resourceAccessRoleArn))
            .setter(setter(Builder::resourceAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAccessRoleArn").build())
            .build();

    private static final SdkField<List<MedicalScribeChannelDefinition>> CHANNEL_DEFINITIONS_FIELD = SdkField
            .<List<MedicalScribeChannelDefinition>> builder(MarshallingType.LIST)
            .memberName("ChannelDefinitions")
            .getter(getter(MedicalScribeStreamDetails::channelDefinitions))
            .setter(setter(Builder::channelDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MedicalScribeChannelDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(MedicalScribeChannelDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MedicalScribeEncryptionSettings> ENCRYPTION_SETTINGS_FIELD = SdkField
            .<MedicalScribeEncryptionSettings> builder(MarshallingType.SDK_POJO).memberName("EncryptionSettings")
            .getter(getter(MedicalScribeStreamDetails::encryptionSettings)).setter(setter(Builder::encryptionSettings))
            .constructor(MedicalScribeEncryptionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionSettings").build())
            .build();

    private static final SdkField<String> STREAM_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamStatus").getter(getter(MedicalScribeStreamDetails::streamStatusAsString))
            .setter(setter(Builder::streamStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamStatus").build()).build();

    private static final SdkField<MedicalScribePostStreamAnalyticsSettings> POST_STREAM_ANALYTICS_SETTINGS_FIELD = SdkField
            .<MedicalScribePostStreamAnalyticsSettings> builder(MarshallingType.SDK_POJO)
            .memberName("PostStreamAnalyticsSettings")
            .getter(getter(MedicalScribeStreamDetails::postStreamAnalyticsSettings))
            .setter(setter(Builder::postStreamAnalyticsSettings))
            .constructor(MedicalScribePostStreamAnalyticsSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostStreamAnalyticsSettings")
                    .build()).build();

    private static final SdkField<MedicalScribePostStreamAnalyticsResult> POST_STREAM_ANALYTICS_RESULT_FIELD = SdkField
            .<MedicalScribePostStreamAnalyticsResult> builder(MarshallingType.SDK_POJO).memberName("PostStreamAnalyticsResult")
            .getter(getter(MedicalScribeStreamDetails::postStreamAnalyticsResult))
            .setter(setter(Builder::postStreamAnalyticsResult)).constructor(MedicalScribePostStreamAnalyticsResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostStreamAnalyticsResult").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD,
            STREAM_CREATED_AT_FIELD, STREAM_ENDED_AT_FIELD, LANGUAGE_CODE_FIELD, MEDIA_SAMPLE_RATE_HERTZ_FIELD,
            MEDIA_ENCODING_FIELD, VOCABULARY_NAME_FIELD, VOCABULARY_FILTER_NAME_FIELD, VOCABULARY_FILTER_METHOD_FIELD,
            RESOURCE_ACCESS_ROLE_ARN_FIELD, CHANNEL_DEFINITIONS_FIELD, ENCRYPTION_SETTINGS_FIELD, STREAM_STATUS_FIELD,
            POST_STREAM_ANALYTICS_SETTINGS_FIELD, POST_STREAM_ANALYTICS_RESULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sessionId;

    private final Instant streamCreatedAt;

    private final Instant streamEndedAt;

    private final String languageCode;

    private final Integer mediaSampleRateHertz;

    private final String mediaEncoding;

    private final String vocabularyName;

    private final String vocabularyFilterName;

    private final String vocabularyFilterMethod;

    private final String resourceAccessRoleArn;

    private final List<MedicalScribeChannelDefinition> channelDefinitions;

    private final MedicalScribeEncryptionSettings encryptionSettings;

    private final String streamStatus;

    private final MedicalScribePostStreamAnalyticsSettings postStreamAnalyticsSettings;

    private final MedicalScribePostStreamAnalyticsResult postStreamAnalyticsResult;

    private MedicalScribeStreamDetails(BuilderImpl builder) {
        this.sessionId = builder.sessionId;
        this.streamCreatedAt = builder.streamCreatedAt;
        this.streamEndedAt = builder.streamEndedAt;
        this.languageCode = builder.languageCode;
        this.mediaSampleRateHertz = builder.mediaSampleRateHertz;
        this.mediaEncoding = builder.mediaEncoding;
        this.vocabularyName = builder.vocabularyName;
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.vocabularyFilterMethod = builder.vocabularyFilterMethod;
        this.resourceAccessRoleArn = builder.resourceAccessRoleArn;
        this.channelDefinitions = builder.channelDefinitions;
        this.encryptionSettings = builder.encryptionSettings;
        this.streamStatus = builder.streamStatus;
        this.postStreamAnalyticsSettings = builder.postStreamAnalyticsSettings;
        this.postStreamAnalyticsResult = builder.postStreamAnalyticsResult;
    }

    /**
     * <p>
     * The identifier of the HealthScribe streaming session.
     * </p>
     * 
     * @return The identifier of the HealthScribe streaming session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The date and time when the HealthScribe streaming session was created.
     * </p>
     * 
     * @return The date and time when the HealthScribe streaming session was created.
     */
    public final Instant streamCreatedAt() {
        return streamCreatedAt;
    }

    /**
     * <p>
     * The date and time when the HealthScribe streaming session was ended.
     * </p>
     * 
     * @return The date and time when the HealthScribe streaming session was ended.
     */
    public final Instant streamEndedAt() {
        return streamEndedAt;
    }

    /**
     * <p>
     * The Language Code of the HealthScribe streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link MedicalScribeLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The Language Code of the HealthScribe streaming session.
     * @see MedicalScribeLanguageCode
     */
    public final MedicalScribeLanguageCode languageCode() {
        return MedicalScribeLanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The Language Code of the HealthScribe streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link MedicalScribeLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The Language Code of the HealthScribe streaming session.
     * @see MedicalScribeLanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The sample rate (in hertz) of the HealthScribe streaming session.
     * </p>
     * 
     * @return The sample rate (in hertz) of the HealthScribe streaming session.
     */
    public final Integer mediaSampleRateHertz() {
        return mediaSampleRateHertz;
    }

    /**
     * <p>
     * The Media Encoding of the HealthScribe streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaEncoding}
     * will return {@link MedicalScribeMediaEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #mediaEncodingAsString}.
     * </p>
     * 
     * @return The Media Encoding of the HealthScribe streaming session.
     * @see MedicalScribeMediaEncoding
     */
    public final MedicalScribeMediaEncoding mediaEncoding() {
        return MedicalScribeMediaEncoding.fromValue(mediaEncoding);
    }

    /**
     * <p>
     * The Media Encoding of the HealthScribe streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaEncoding}
     * will return {@link MedicalScribeMediaEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #mediaEncodingAsString}.
     * </p>
     * 
     * @return The Media Encoding of the HealthScribe streaming session.
     * @see MedicalScribeMediaEncoding
     */
    public final String mediaEncodingAsString() {
        return mediaEncoding;
    }

    /**
     * <p>
     * The vocabulary name of the HealthScribe streaming session.
     * </p>
     * 
     * @return The vocabulary name of the HealthScribe streaming session.
     */
    public final String vocabularyName() {
        return vocabularyName;
    }

    /**
     * <p>
     * The name of the vocabulary filter used for the HealthScribe streaming session .
     * </p>
     * 
     * @return The name of the vocabulary filter used for the HealthScribe streaming session .
     */
    public final String vocabularyFilterName() {
        return vocabularyFilterName;
    }

    /**
     * <p>
     * The method of the vocabulary filter for the HealthScribe streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vocabularyFilterMethod} will return {@link MedicalScribeVocabularyFilterMethod#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #vocabularyFilterMethodAsString}.
     * </p>
     * 
     * @return The method of the vocabulary filter for the HealthScribe streaming session.
     * @see MedicalScribeVocabularyFilterMethod
     */
    public final MedicalScribeVocabularyFilterMethod vocabularyFilterMethod() {
        return MedicalScribeVocabularyFilterMethod.fromValue(vocabularyFilterMethod);
    }

    /**
     * <p>
     * The method of the vocabulary filter for the HealthScribe streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vocabularyFilterMethod} will return {@link MedicalScribeVocabularyFilterMethod#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #vocabularyFilterMethodAsString}.
     * </p>
     * 
     * @return The method of the vocabulary filter for the HealthScribe streaming session.
     * @see MedicalScribeVocabularyFilterMethod
     */
    public final String vocabularyFilterMethodAsString() {
        return vocabularyFilterMethod;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role used in the HealthScribe streaming session.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role used in the HealthScribe streaming session.
     */
    public final String resourceAccessRoleArn() {
        return resourceAccessRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChannelDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChannelDefinitions() {
        return channelDefinitions != null && !(channelDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Channel Definitions of the HealthScribe streaming session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannelDefinitions} method.
     * </p>
     * 
     * @return The Channel Definitions of the HealthScribe streaming session.
     */
    public final List<MedicalScribeChannelDefinition> channelDefinitions() {
        return channelDefinitions;
    }

    /**
     * <p>
     * The Encryption Settings of the HealthScribe streaming session.
     * </p>
     * 
     * @return The Encryption Settings of the HealthScribe streaming session.
     */
    public final MedicalScribeEncryptionSettings encryptionSettings() {
        return encryptionSettings;
    }

    /**
     * <p>
     * The streaming status of the HealthScribe streaming session.
     * </p>
     * <p>
     * Possible Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PAUSED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * This status is specific to real-time streaming. A <code>COMPLETED</code> status doesn't mean that the post-stream
     * analytics is complete. To get status of an analytics result, check the <code>Status</code> field for the
     * analytics result within the <code>MedicalScribePostStreamAnalyticsResult</code>. For example, you can view the
     * status of the <code>ClinicalNoteGenerationResult</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamStatus} will
     * return {@link MedicalScribeStreamStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #streamStatusAsString}.
     * </p>
     * 
     * @return The streaming status of the HealthScribe streaming session.</p>
     *         <p>
     *         Possible Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PAUSED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         This status is specific to real-time streaming. A <code>COMPLETED</code> status doesn't mean that the
     *         post-stream analytics is complete. To get status of an analytics result, check the <code>Status</code>
     *         field for the analytics result within the <code>MedicalScribePostStreamAnalyticsResult</code>. For
     *         example, you can view the status of the <code>ClinicalNoteGenerationResult</code>.
     *         </p>
     * @see MedicalScribeStreamStatus
     */
    public final MedicalScribeStreamStatus streamStatus() {
        return MedicalScribeStreamStatus.fromValue(streamStatus);
    }

    /**
     * <p>
     * The streaming status of the HealthScribe streaming session.
     * </p>
     * <p>
     * Possible Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PAUSED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * This status is specific to real-time streaming. A <code>COMPLETED</code> status doesn't mean that the post-stream
     * analytics is complete. To get status of an analytics result, check the <code>Status</code> field for the
     * analytics result within the <code>MedicalScribePostStreamAnalyticsResult</code>. For example, you can view the
     * status of the <code>ClinicalNoteGenerationResult</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamStatus} will
     * return {@link MedicalScribeStreamStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #streamStatusAsString}.
     * </p>
     * 
     * @return The streaming status of the HealthScribe streaming session.</p>
     *         <p>
     *         Possible Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PAUSED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         This status is specific to real-time streaming. A <code>COMPLETED</code> status doesn't mean that the
     *         post-stream analytics is complete. To get status of an analytics result, check the <code>Status</code>
     *         field for the analytics result within the <code>MedicalScribePostStreamAnalyticsResult</code>. For
     *         example, you can view the status of the <code>ClinicalNoteGenerationResult</code>.
     *         </p>
     * @see MedicalScribeStreamStatus
     */
    public final String streamStatusAsString() {
        return streamStatus;
    }

    /**
     * <p>
     * The post-stream analytics settings of the HealthScribe streaming session.
     * </p>
     * 
     * @return The post-stream analytics settings of the HealthScribe streaming session.
     */
    public final MedicalScribePostStreamAnalyticsSettings postStreamAnalyticsSettings() {
        return postStreamAnalyticsSettings;
    }

    /**
     * <p>
     * The result of post-stream analytics for the HealthScribe streaming session.
     * </p>
     * 
     * @return The result of post-stream analytics for the HealthScribe streaming session.
     */
    public final MedicalScribePostStreamAnalyticsResult postStreamAnalyticsResult() {
        return postStreamAnalyticsResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(streamCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(streamEndedAt());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mediaSampleRateHertz());
        hashCode = 31 * hashCode + Objects.hashCode(mediaEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasChannelDefinitions() ? channelDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(encryptionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(streamStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(postStreamAnalyticsSettings());
        hashCode = 31 * hashCode + Objects.hashCode(postStreamAnalyticsResult());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalScribeStreamDetails)) {
            return false;
        }
        MedicalScribeStreamDetails other = (MedicalScribeStreamDetails) obj;
        return Objects.equals(sessionId(), other.sessionId()) && Objects.equals(streamCreatedAt(), other.streamCreatedAt())
                && Objects.equals(streamEndedAt(), other.streamEndedAt())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(mediaSampleRateHertz(), other.mediaSampleRateHertz())
                && Objects.equals(mediaEncodingAsString(), other.mediaEncodingAsString())
                && Objects.equals(vocabularyName(), other.vocabularyName())
                && Objects.equals(vocabularyFilterName(), other.vocabularyFilterName())
                && Objects.equals(vocabularyFilterMethodAsString(), other.vocabularyFilterMethodAsString())
                && Objects.equals(resourceAccessRoleArn(), other.resourceAccessRoleArn())
                && hasChannelDefinitions() == other.hasChannelDefinitions()
                && Objects.equals(channelDefinitions(), other.channelDefinitions())
                && Objects.equals(encryptionSettings(), other.encryptionSettings())
                && Objects.equals(streamStatusAsString(), other.streamStatusAsString())
                && Objects.equals(postStreamAnalyticsSettings(), other.postStreamAnalyticsSettings())
                && Objects.equals(postStreamAnalyticsResult(), other.postStreamAnalyticsResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MedicalScribeStreamDetails").add("SessionId", sessionId())
                .add("StreamCreatedAt", streamCreatedAt()).add("StreamEndedAt", streamEndedAt())
                .add("LanguageCode", languageCodeAsString()).add("MediaSampleRateHertz", mediaSampleRateHertz())
                .add("MediaEncoding", mediaEncodingAsString()).add("VocabularyName", vocabularyName())
                .add("VocabularyFilterName", vocabularyFilterName())
                .add("VocabularyFilterMethod", vocabularyFilterMethodAsString())
                .add("ResourceAccessRoleArn", resourceAccessRoleArn())
                .add("ChannelDefinitions", hasChannelDefinitions() ? channelDefinitions() : null)
                .add("EncryptionSettings", encryptionSettings()).add("StreamStatus", streamStatusAsString())
                .add("PostStreamAnalyticsSettings", postStreamAnalyticsSettings())
                .add("PostStreamAnalyticsResult", postStreamAnalyticsResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "StreamCreatedAt":
            return Optional.ofNullable(clazz.cast(streamCreatedAt()));
        case "StreamEndedAt":
            return Optional.ofNullable(clazz.cast(streamEndedAt()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "MediaSampleRateHertz":
            return Optional.ofNullable(clazz.cast(mediaSampleRateHertz()));
        case "MediaEncoding":
            return Optional.ofNullable(clazz.cast(mediaEncodingAsString()));
        case "VocabularyName":
            return Optional.ofNullable(clazz.cast(vocabularyName()));
        case "VocabularyFilterName":
            return Optional.ofNullable(clazz.cast(vocabularyFilterName()));
        case "VocabularyFilterMethod":
            return Optional.ofNullable(clazz.cast(vocabularyFilterMethodAsString()));
        case "ResourceAccessRoleArn":
            return Optional.ofNullable(clazz.cast(resourceAccessRoleArn()));
        case "ChannelDefinitions":
            return Optional.ofNullable(clazz.cast(channelDefinitions()));
        case "EncryptionSettings":
            return Optional.ofNullable(clazz.cast(encryptionSettings()));
        case "StreamStatus":
            return Optional.ofNullable(clazz.cast(streamStatusAsString()));
        case "PostStreamAnalyticsSettings":
            return Optional.ofNullable(clazz.cast(postStreamAnalyticsSettings()));
        case "PostStreamAnalyticsResult":
            return Optional.ofNullable(clazz.cast(postStreamAnalyticsResult()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SessionId", SESSION_ID_FIELD);
        map.put("StreamCreatedAt", STREAM_CREATED_AT_FIELD);
        map.put("StreamEndedAt", STREAM_ENDED_AT_FIELD);
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        map.put("MediaSampleRateHertz", MEDIA_SAMPLE_RATE_HERTZ_FIELD);
        map.put("MediaEncoding", MEDIA_ENCODING_FIELD);
        map.put("VocabularyName", VOCABULARY_NAME_FIELD);
        map.put("VocabularyFilterName", VOCABULARY_FILTER_NAME_FIELD);
        map.put("VocabularyFilterMethod", VOCABULARY_FILTER_METHOD_FIELD);
        map.put("ResourceAccessRoleArn", RESOURCE_ACCESS_ROLE_ARN_FIELD);
        map.put("ChannelDefinitions", CHANNEL_DEFINITIONS_FIELD);
        map.put("EncryptionSettings", ENCRYPTION_SETTINGS_FIELD);
        map.put("StreamStatus", STREAM_STATUS_FIELD);
        map.put("PostStreamAnalyticsSettings", POST_STREAM_ANALYTICS_SETTINGS_FIELD);
        map.put("PostStreamAnalyticsResult", POST_STREAM_ANALYTICS_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MedicalScribeStreamDetails, T> g) {
        return obj -> g.apply((MedicalScribeStreamDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MedicalScribeStreamDetails> {
        /**
         * <p>
         * The identifier of the HealthScribe streaming session.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the HealthScribe streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The date and time when the HealthScribe streaming session was created.
         * </p>
         * 
         * @param streamCreatedAt
         *        The date and time when the HealthScribe streaming session was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamCreatedAt(Instant streamCreatedAt);

        /**
         * <p>
         * The date and time when the HealthScribe streaming session was ended.
         * </p>
         * 
         * @param streamEndedAt
         *        The date and time when the HealthScribe streaming session was ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamEndedAt(Instant streamEndedAt);

        /**
         * <p>
         * The Language Code of the HealthScribe streaming session.
         * </p>
         * 
         * @param languageCode
         *        The Language Code of the HealthScribe streaming session.
         * @see MedicalScribeLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeLanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The Language Code of the HealthScribe streaming session.
         * </p>
         * 
         * @param languageCode
         *        The Language Code of the HealthScribe streaming session.
         * @see MedicalScribeLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeLanguageCode
         */
        Builder languageCode(MedicalScribeLanguageCode languageCode);

        /**
         * <p>
         * The sample rate (in hertz) of the HealthScribe streaming session.
         * </p>
         * 
         * @param mediaSampleRateHertz
         *        The sample rate (in hertz) of the HealthScribe streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaSampleRateHertz(Integer mediaSampleRateHertz);

        /**
         * <p>
         * The Media Encoding of the HealthScribe streaming session.
         * </p>
         * 
         * @param mediaEncoding
         *        The Media Encoding of the HealthScribe streaming session.
         * @see MedicalScribeMediaEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeMediaEncoding
         */
        Builder mediaEncoding(String mediaEncoding);

        /**
         * <p>
         * The Media Encoding of the HealthScribe streaming session.
         * </p>
         * 
         * @param mediaEncoding
         *        The Media Encoding of the HealthScribe streaming session.
         * @see MedicalScribeMediaEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeMediaEncoding
         */
        Builder mediaEncoding(MedicalScribeMediaEncoding mediaEncoding);

        /**
         * <p>
         * The vocabulary name of the HealthScribe streaming session.
         * </p>
         * 
         * @param vocabularyName
         *        The vocabulary name of the HealthScribe streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyName(String vocabularyName);

        /**
         * <p>
         * The name of the vocabulary filter used for the HealthScribe streaming session .
         * </p>
         * 
         * @param vocabularyFilterName
         *        The name of the vocabulary filter used for the HealthScribe streaming session .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterName(String vocabularyFilterName);

        /**
         * <p>
         * The method of the vocabulary filter for the HealthScribe streaming session.
         * </p>
         * 
         * @param vocabularyFilterMethod
         *        The method of the vocabulary filter for the HealthScribe streaming session.
         * @see MedicalScribeVocabularyFilterMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeVocabularyFilterMethod
         */
        Builder vocabularyFilterMethod(String vocabularyFilterMethod);

        /**
         * <p>
         * The method of the vocabulary filter for the HealthScribe streaming session.
         * </p>
         * 
         * @param vocabularyFilterMethod
         *        The method of the vocabulary filter for the HealthScribe streaming session.
         * @see MedicalScribeVocabularyFilterMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeVocabularyFilterMethod
         */
        Builder vocabularyFilterMethod(MedicalScribeVocabularyFilterMethod vocabularyFilterMethod);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role used in the HealthScribe streaming session.
         * </p>
         * 
         * @param resourceAccessRoleArn
         *        The Amazon Resource Name (ARN) of the role used in the HealthScribe streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAccessRoleArn(String resourceAccessRoleArn);

        /**
         * <p>
         * The Channel Definitions of the HealthScribe streaming session.
         * </p>
         * 
         * @param channelDefinitions
         *        The Channel Definitions of the HealthScribe streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelDefinitions(Collection<MedicalScribeChannelDefinition> channelDefinitions);

        /**
         * <p>
         * The Channel Definitions of the HealthScribe streaming session.
         * </p>
         * 
         * @param channelDefinitions
         *        The Channel Definitions of the HealthScribe streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelDefinitions(MedicalScribeChannelDefinition... channelDefinitions);

        /**
         * <p>
         * The Channel Definitions of the HealthScribe streaming session.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeChannelDefinition.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeChannelDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeChannelDefinition.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #channelDefinitions(List<MedicalScribeChannelDefinition>)}.
         * 
         * @param channelDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeChannelDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelDefinitions(java.util.Collection<MedicalScribeChannelDefinition>)
         */
        Builder channelDefinitions(Consumer<MedicalScribeChannelDefinition.Builder>... channelDefinitions);

        /**
         * <p>
         * The Encryption Settings of the HealthScribe streaming session.
         * </p>
         * 
         * @param encryptionSettings
         *        The Encryption Settings of the HealthScribe streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionSettings(MedicalScribeEncryptionSettings encryptionSettings);

        /**
         * <p>
         * The Encryption Settings of the HealthScribe streaming session.
         * </p>
         * This is a convenience method that creates an instance of the {@link MedicalScribeEncryptionSettings.Builder}
         * avoiding the need to create one manually via {@link MedicalScribeEncryptionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MedicalScribeEncryptionSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #encryptionSettings(MedicalScribeEncryptionSettings)}.
         * 
         * @param encryptionSettings
         *        a consumer that will call methods on {@link MedicalScribeEncryptionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionSettings(MedicalScribeEncryptionSettings)
         */
        default Builder encryptionSettings(Consumer<MedicalScribeEncryptionSettings.Builder> encryptionSettings) {
            return encryptionSettings(MedicalScribeEncryptionSettings.builder().applyMutation(encryptionSettings).build());
        }

        /**
         * <p>
         * The streaming status of the HealthScribe streaming session.
         * </p>
         * <p>
         * Possible Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PAUSED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * This status is specific to real-time streaming. A <code>COMPLETED</code> status doesn't mean that the
         * post-stream analytics is complete. To get status of an analytics result, check the <code>Status</code> field
         * for the analytics result within the <code>MedicalScribePostStreamAnalyticsResult</code>. For example, you can
         * view the status of the <code>ClinicalNoteGenerationResult</code>.
         * </p>
         * </note>
         * 
         * @param streamStatus
         *        The streaming status of the HealthScribe streaming session.</p>
         *        <p>
         *        Possible Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PAUSED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        This status is specific to real-time streaming. A <code>COMPLETED</code> status doesn't mean that the
         *        post-stream analytics is complete. To get status of an analytics result, check the <code>Status</code>
         *        field for the analytics result within the <code>MedicalScribePostStreamAnalyticsResult</code>. For
         *        example, you can view the status of the <code>ClinicalNoteGenerationResult</code>.
         *        </p>
         * @see MedicalScribeStreamStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeStreamStatus
         */
        Builder streamStatus(String streamStatus);

        /**
         * <p>
         * The streaming status of the HealthScribe streaming session.
         * </p>
         * <p>
         * Possible Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PAUSED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * This status is specific to real-time streaming. A <code>COMPLETED</code> status doesn't mean that the
         * post-stream analytics is complete. To get status of an analytics result, check the <code>Status</code> field
         * for the analytics result within the <code>MedicalScribePostStreamAnalyticsResult</code>. For example, you can
         * view the status of the <code>ClinicalNoteGenerationResult</code>.
         * </p>
         * </note>
         * 
         * @param streamStatus
         *        The streaming status of the HealthScribe streaming session.</p>
         *        <p>
         *        Possible Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PAUSED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        This status is specific to real-time streaming. A <code>COMPLETED</code> status doesn't mean that the
         *        post-stream analytics is complete. To get status of an analytics result, check the <code>Status</code>
         *        field for the analytics result within the <code>MedicalScribePostStreamAnalyticsResult</code>. For
         *        example, you can view the status of the <code>ClinicalNoteGenerationResult</code>.
         *        </p>
         * @see MedicalScribeStreamStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeStreamStatus
         */
        Builder streamStatus(MedicalScribeStreamStatus streamStatus);

        /**
         * <p>
         * The post-stream analytics settings of the HealthScribe streaming session.
         * </p>
         * 
         * @param postStreamAnalyticsSettings
         *        The post-stream analytics settings of the HealthScribe streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postStreamAnalyticsSettings(MedicalScribePostStreamAnalyticsSettings postStreamAnalyticsSettings);

        /**
         * <p>
         * The post-stream analytics settings of the HealthScribe streaming session.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MedicalScribePostStreamAnalyticsSettings.Builder} avoiding the need to create one manually via
         * {@link MedicalScribePostStreamAnalyticsSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MedicalScribePostStreamAnalyticsSettings.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #postStreamAnalyticsSettings(MedicalScribePostStreamAnalyticsSettings)}.
         * 
         * @param postStreamAnalyticsSettings
         *        a consumer that will call methods on {@link MedicalScribePostStreamAnalyticsSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postStreamAnalyticsSettings(MedicalScribePostStreamAnalyticsSettings)
         */
        default Builder postStreamAnalyticsSettings(
                Consumer<MedicalScribePostStreamAnalyticsSettings.Builder> postStreamAnalyticsSettings) {
            return postStreamAnalyticsSettings(MedicalScribePostStreamAnalyticsSettings.builder()
                    .applyMutation(postStreamAnalyticsSettings).build());
        }

        /**
         * <p>
         * The result of post-stream analytics for the HealthScribe streaming session.
         * </p>
         * 
         * @param postStreamAnalyticsResult
         *        The result of post-stream analytics for the HealthScribe streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postStreamAnalyticsResult(MedicalScribePostStreamAnalyticsResult postStreamAnalyticsResult);

        /**
         * <p>
         * The result of post-stream analytics for the HealthScribe streaming session.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MedicalScribePostStreamAnalyticsResult.Builder} avoiding the need to create one manually via
         * {@link MedicalScribePostStreamAnalyticsResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MedicalScribePostStreamAnalyticsResult.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #postStreamAnalyticsResult(MedicalScribePostStreamAnalyticsResult)}.
         * 
         * @param postStreamAnalyticsResult
         *        a consumer that will call methods on {@link MedicalScribePostStreamAnalyticsResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postStreamAnalyticsResult(MedicalScribePostStreamAnalyticsResult)
         */
        default Builder postStreamAnalyticsResult(
                Consumer<MedicalScribePostStreamAnalyticsResult.Builder> postStreamAnalyticsResult) {
            return postStreamAnalyticsResult(MedicalScribePostStreamAnalyticsResult.builder()
                    .applyMutation(postStreamAnalyticsResult).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sessionId;

        private Instant streamCreatedAt;

        private Instant streamEndedAt;

        private String languageCode;

        private Integer mediaSampleRateHertz;

        private String mediaEncoding;

        private String vocabularyName;

        private String vocabularyFilterName;

        private String vocabularyFilterMethod;

        private String resourceAccessRoleArn;

        private List<MedicalScribeChannelDefinition> channelDefinitions = DefaultSdkAutoConstructList.getInstance();

        private MedicalScribeEncryptionSettings encryptionSettings;

        private String streamStatus;

        private MedicalScribePostStreamAnalyticsSettings postStreamAnalyticsSettings;

        private MedicalScribePostStreamAnalyticsResult postStreamAnalyticsResult;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalScribeStreamDetails model) {
            sessionId(model.sessionId);
            streamCreatedAt(model.streamCreatedAt);
            streamEndedAt(model.streamEndedAt);
            languageCode(model.languageCode);
            mediaSampleRateHertz(model.mediaSampleRateHertz);
            mediaEncoding(model.mediaEncoding);
            vocabularyName(model.vocabularyName);
            vocabularyFilterName(model.vocabularyFilterName);
            vocabularyFilterMethod(model.vocabularyFilterMethod);
            resourceAccessRoleArn(model.resourceAccessRoleArn);
            channelDefinitions(model.channelDefinitions);
            encryptionSettings(model.encryptionSettings);
            streamStatus(model.streamStatus);
            postStreamAnalyticsSettings(model.postStreamAnalyticsSettings);
            postStreamAnalyticsResult(model.postStreamAnalyticsResult);
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Instant getStreamCreatedAt() {
            return streamCreatedAt;
        }

        public final void setStreamCreatedAt(Instant streamCreatedAt) {
            this.streamCreatedAt = streamCreatedAt;
        }

        @Override
        public final Builder streamCreatedAt(Instant streamCreatedAt) {
            this.streamCreatedAt = streamCreatedAt;
            return this;
        }

        public final Instant getStreamEndedAt() {
            return streamEndedAt;
        }

        public final void setStreamEndedAt(Instant streamEndedAt) {
            this.streamEndedAt = streamEndedAt;
        }

        @Override
        public final Builder streamEndedAt(Instant streamEndedAt) {
            this.streamEndedAt = streamEndedAt;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(MedicalScribeLanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Integer getMediaSampleRateHertz() {
            return mediaSampleRateHertz;
        }

        public final void setMediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
        }

        @Override
        public final Builder mediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
            return this;
        }

        public final String getMediaEncoding() {
            return mediaEncoding;
        }

        public final void setMediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
        }

        @Override
        public final Builder mediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
            return this;
        }

        @Override
        public final Builder mediaEncoding(MedicalScribeMediaEncoding mediaEncoding) {
            this.mediaEncoding(mediaEncoding == null ? null : mediaEncoding.toString());
            return this;
        }

        public final String getVocabularyName() {
            return vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getVocabularyFilterName() {
            return vocabularyFilterName;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final String getVocabularyFilterMethod() {
            return vocabularyFilterMethod;
        }

        public final void setVocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
        }

        @Override
        public final Builder vocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
            return this;
        }

        @Override
        public final Builder vocabularyFilterMethod(MedicalScribeVocabularyFilterMethod vocabularyFilterMethod) {
            this.vocabularyFilterMethod(vocabularyFilterMethod == null ? null : vocabularyFilterMethod.toString());
            return this;
        }

        public final String getResourceAccessRoleArn() {
            return resourceAccessRoleArn;
        }

        public final void setResourceAccessRoleArn(String resourceAccessRoleArn) {
            this.resourceAccessRoleArn = resourceAccessRoleArn;
        }

        @Override
        public final Builder resourceAccessRoleArn(String resourceAccessRoleArn) {
            this.resourceAccessRoleArn = resourceAccessRoleArn;
            return this;
        }

        public final List<MedicalScribeChannelDefinition.Builder> getChannelDefinitions() {
            List<MedicalScribeChannelDefinition.Builder> result = MedicalScribeChannelDefinitionsCopier
                    .copyToBuilder(this.channelDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelDefinitions(Collection<MedicalScribeChannelDefinition.BuilderImpl> channelDefinitions) {
            this.channelDefinitions = MedicalScribeChannelDefinitionsCopier.copyFromBuilder(channelDefinitions);
        }

        @Override
        public final Builder channelDefinitions(Collection<MedicalScribeChannelDefinition> channelDefinitions) {
            this.channelDefinitions = MedicalScribeChannelDefinitionsCopier.copy(channelDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(MedicalScribeChannelDefinition... channelDefinitions) {
            channelDefinitions(Arrays.asList(channelDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(Consumer<MedicalScribeChannelDefinition.Builder>... channelDefinitions) {
            channelDefinitions(Stream.of(channelDefinitions)
                    .map(c -> MedicalScribeChannelDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final MedicalScribeEncryptionSettings.Builder getEncryptionSettings() {
            return encryptionSettings != null ? encryptionSettings.toBuilder() : null;
        }

        public final void setEncryptionSettings(MedicalScribeEncryptionSettings.BuilderImpl encryptionSettings) {
            this.encryptionSettings = encryptionSettings != null ? encryptionSettings.build() : null;
        }

        @Override
        public final Builder encryptionSettings(MedicalScribeEncryptionSettings encryptionSettings) {
            this.encryptionSettings = encryptionSettings;
            return this;
        }

        public final String getStreamStatus() {
            return streamStatus;
        }

        public final void setStreamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
        }

        @Override
        public final Builder streamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
            return this;
        }

        @Override
        public final Builder streamStatus(MedicalScribeStreamStatus streamStatus) {
            this.streamStatus(streamStatus == null ? null : streamStatus.toString());
            return this;
        }

        public final MedicalScribePostStreamAnalyticsSettings.Builder getPostStreamAnalyticsSettings() {
            return postStreamAnalyticsSettings != null ? postStreamAnalyticsSettings.toBuilder() : null;
        }

        public final void setPostStreamAnalyticsSettings(
                MedicalScribePostStreamAnalyticsSettings.BuilderImpl postStreamAnalyticsSettings) {
            this.postStreamAnalyticsSettings = postStreamAnalyticsSettings != null ? postStreamAnalyticsSettings.build() : null;
        }

        @Override
        public final Builder postStreamAnalyticsSettings(MedicalScribePostStreamAnalyticsSettings postStreamAnalyticsSettings) {
            this.postStreamAnalyticsSettings = postStreamAnalyticsSettings;
            return this;
        }

        public final MedicalScribePostStreamAnalyticsResult.Builder getPostStreamAnalyticsResult() {
            return postStreamAnalyticsResult != null ? postStreamAnalyticsResult.toBuilder() : null;
        }

        public final void setPostStreamAnalyticsResult(
                MedicalScribePostStreamAnalyticsResult.BuilderImpl postStreamAnalyticsResult) {
            this.postStreamAnalyticsResult = postStreamAnalyticsResult != null ? postStreamAnalyticsResult.build() : null;
        }

        @Override
        public final Builder postStreamAnalyticsResult(MedicalScribePostStreamAnalyticsResult postStreamAnalyticsResult) {
            this.postStreamAnalyticsResult = postStreamAnalyticsResult;
            return this;
        }

        @Override
        public MedicalScribeStreamDetails build() {
            return new MedicalScribeStreamDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
