/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details for clinical note generation, including status, and output locations for clinical note and aggregated
 * transcript if the analytics completed, or failure reason if the analytics failed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClinicalNoteGenerationResult implements SdkPojo, Serializable,
        ToCopyableBuilder<ClinicalNoteGenerationResult.Builder, ClinicalNoteGenerationResult> {
    private static final SdkField<String> CLINICAL_NOTE_OUTPUT_LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClinicalNoteOutputLocation")
            .getter(getter(ClinicalNoteGenerationResult::clinicalNoteOutputLocation))
            .setter(setter(Builder::clinicalNoteOutputLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClinicalNoteOutputLocation").build())
            .build();

    private static final SdkField<String> TRANSCRIPT_OUTPUT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TranscriptOutputLocation").getter(getter(ClinicalNoteGenerationResult::transcriptOutputLocation))
            .setter(setter(Builder::transcriptOutputLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptOutputLocation").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ClinicalNoteGenerationResult::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(ClinicalNoteGenerationResult::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLINICAL_NOTE_OUTPUT_LOCATION_FIELD, TRANSCRIPT_OUTPUT_LOCATION_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clinicalNoteOutputLocation;

    private final String transcriptOutputLocation;

    private final String status;

    private final String failureReason;

    private ClinicalNoteGenerationResult(BuilderImpl builder) {
        this.clinicalNoteOutputLocation = builder.clinicalNoteOutputLocation;
        this.transcriptOutputLocation = builder.transcriptOutputLocation;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * Holds the Amazon S3 URI for the output Clinical Note.
     * </p>
     * 
     * @return Holds the Amazon S3 URI for the output Clinical Note.
     */
    public final String clinicalNoteOutputLocation() {
        return clinicalNoteOutputLocation;
    }

    /**
     * <p>
     * Holds the Amazon S3 URI for the output Transcript.
     * </p>
     * 
     * @return Holds the Amazon S3 URI for the output Transcript.
     */
    public final String transcriptOutputLocation() {
        return transcriptOutputLocation;
    }

    /**
     * <p>
     * The status of the clinical note generation.
     * </p>
     * <p>
     * Possible Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * After audio streaming finishes, and you send a <code>MedicalScribeSessionControlEvent</code> event (with
     * END_OF_SESSION as the Type), the status is set to <code>IN_PROGRESS</code>. If the status is
     * <code>COMPLETED</code>, the analytics completed successfully, and you can find the results at the locations
     * specified in <code>ClinicalNoteOutputLocation</code> and <code>TranscriptOutputLocation</code>. If the status is
     * <code>FAILED</code>, <code>FailureReason</code> provides details about the failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ClinicalNoteGenerationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the clinical note generation.</p>
     *         <p>
     *         Possible Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         After audio streaming finishes, and you send a <code>MedicalScribeSessionControlEvent</code> event (with
     *         END_OF_SESSION as the Type), the status is set to <code>IN_PROGRESS</code>. If the status is
     *         <code>COMPLETED</code>, the analytics completed successfully, and you can find the results at the
     *         locations specified in <code>ClinicalNoteOutputLocation</code> and <code>TranscriptOutputLocation</code>.
     *         If the status is <code>FAILED</code>, <code>FailureReason</code> provides details about the failure.
     * @see ClinicalNoteGenerationStatus
     */
    public final ClinicalNoteGenerationStatus status() {
        return ClinicalNoteGenerationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the clinical note generation.
     * </p>
     * <p>
     * Possible Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * After audio streaming finishes, and you send a <code>MedicalScribeSessionControlEvent</code> event (with
     * END_OF_SESSION as the Type), the status is set to <code>IN_PROGRESS</code>. If the status is
     * <code>COMPLETED</code>, the analytics completed successfully, and you can find the results at the locations
     * specified in <code>ClinicalNoteOutputLocation</code> and <code>TranscriptOutputLocation</code>. If the status is
     * <code>FAILED</code>, <code>FailureReason</code> provides details about the failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ClinicalNoteGenerationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the clinical note generation.</p>
     *         <p>
     *         Possible Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         After audio streaming finishes, and you send a <code>MedicalScribeSessionControlEvent</code> event (with
     *         END_OF_SESSION as the Type), the status is set to <code>IN_PROGRESS</code>. If the status is
     *         <code>COMPLETED</code>, the analytics completed successfully, and you can find the results at the
     *         locations specified in <code>ClinicalNoteOutputLocation</code> and <code>TranscriptOutputLocation</code>.
     *         If the status is <code>FAILED</code>, <code>FailureReason</code> provides details about the failure.
     * @see ClinicalNoteGenerationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * If <code>ClinicalNoteGenerationResult</code> is <code>FAILED</code>, information about why it failed.
     * </p>
     * 
     * @return If <code>ClinicalNoteGenerationResult</code> is <code>FAILED</code>, information about why it failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clinicalNoteOutputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(transcriptOutputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClinicalNoteGenerationResult)) {
            return false;
        }
        ClinicalNoteGenerationResult other = (ClinicalNoteGenerationResult) obj;
        return Objects.equals(clinicalNoteOutputLocation(), other.clinicalNoteOutputLocation())
                && Objects.equals(transcriptOutputLocation(), other.transcriptOutputLocation())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClinicalNoteGenerationResult").add("ClinicalNoteOutputLocation", clinicalNoteOutputLocation())
                .add("TranscriptOutputLocation", transcriptOutputLocation()).add("Status", statusAsString())
                .add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClinicalNoteOutputLocation":
            return Optional.ofNullable(clazz.cast(clinicalNoteOutputLocation()));
        case "TranscriptOutputLocation":
            return Optional.ofNullable(clazz.cast(transcriptOutputLocation()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClinicalNoteOutputLocation", CLINICAL_NOTE_OUTPUT_LOCATION_FIELD);
        map.put("TranscriptOutputLocation", TRANSCRIPT_OUTPUT_LOCATION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClinicalNoteGenerationResult, T> g) {
        return obj -> g.apply((ClinicalNoteGenerationResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClinicalNoteGenerationResult> {
        /**
         * <p>
         * Holds the Amazon S3 URI for the output Clinical Note.
         * </p>
         * 
         * @param clinicalNoteOutputLocation
         *        Holds the Amazon S3 URI for the output Clinical Note.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clinicalNoteOutputLocation(String clinicalNoteOutputLocation);

        /**
         * <p>
         * Holds the Amazon S3 URI for the output Transcript.
         * </p>
         * 
         * @param transcriptOutputLocation
         *        Holds the Amazon S3 URI for the output Transcript.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcriptOutputLocation(String transcriptOutputLocation);

        /**
         * <p>
         * The status of the clinical note generation.
         * </p>
         * <p>
         * Possible Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * After audio streaming finishes, and you send a <code>MedicalScribeSessionControlEvent</code> event (with
         * END_OF_SESSION as the Type), the status is set to <code>IN_PROGRESS</code>. If the status is
         * <code>COMPLETED</code>, the analytics completed successfully, and you can find the results at the locations
         * specified in <code>ClinicalNoteOutputLocation</code> and <code>TranscriptOutputLocation</code>. If the status
         * is <code>FAILED</code>, <code>FailureReason</code> provides details about the failure.
         * </p>
         * 
         * @param status
         *        The status of the clinical note generation.</p>
         *        <p>
         *        Possible Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        After audio streaming finishes, and you send a <code>MedicalScribeSessionControlEvent</code> event
         *        (with END_OF_SESSION as the Type), the status is set to <code>IN_PROGRESS</code>. If the status is
         *        <code>COMPLETED</code>, the analytics completed successfully, and you can find the results at the
         *        locations specified in <code>ClinicalNoteOutputLocation</code> and
         *        <code>TranscriptOutputLocation</code>. If the status is <code>FAILED</code>,
         *        <code>FailureReason</code> provides details about the failure.
         * @see ClinicalNoteGenerationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClinicalNoteGenerationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the clinical note generation.
         * </p>
         * <p>
         * Possible Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * After audio streaming finishes, and you send a <code>MedicalScribeSessionControlEvent</code> event (with
         * END_OF_SESSION as the Type), the status is set to <code>IN_PROGRESS</code>. If the status is
         * <code>COMPLETED</code>, the analytics completed successfully, and you can find the results at the locations
         * specified in <code>ClinicalNoteOutputLocation</code> and <code>TranscriptOutputLocation</code>. If the status
         * is <code>FAILED</code>, <code>FailureReason</code> provides details about the failure.
         * </p>
         * 
         * @param status
         *        The status of the clinical note generation.</p>
         *        <p>
         *        Possible Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        After audio streaming finishes, and you send a <code>MedicalScribeSessionControlEvent</code> event
         *        (with END_OF_SESSION as the Type), the status is set to <code>IN_PROGRESS</code>. If the status is
         *        <code>COMPLETED</code>, the analytics completed successfully, and you can find the results at the
         *        locations specified in <code>ClinicalNoteOutputLocation</code> and
         *        <code>TranscriptOutputLocation</code>. If the status is <code>FAILED</code>,
         *        <code>FailureReason</code> provides details about the failure.
         * @see ClinicalNoteGenerationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClinicalNoteGenerationStatus
         */
        Builder status(ClinicalNoteGenerationStatus status);

        /**
         * <p>
         * If <code>ClinicalNoteGenerationResult</code> is <code>FAILED</code>, information about why it failed.
         * </p>
         * 
         * @param failureReason
         *        If <code>ClinicalNoteGenerationResult</code> is <code>FAILED</code>, information about why it failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private String clinicalNoteOutputLocation;

        private String transcriptOutputLocation;

        private String status;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ClinicalNoteGenerationResult model) {
            clinicalNoteOutputLocation(model.clinicalNoteOutputLocation);
            transcriptOutputLocation(model.transcriptOutputLocation);
            status(model.status);
            failureReason(model.failureReason);
        }

        public final String getClinicalNoteOutputLocation() {
            return clinicalNoteOutputLocation;
        }

        public final void setClinicalNoteOutputLocation(String clinicalNoteOutputLocation) {
            this.clinicalNoteOutputLocation = clinicalNoteOutputLocation;
        }

        @Override
        public final Builder clinicalNoteOutputLocation(String clinicalNoteOutputLocation) {
            this.clinicalNoteOutputLocation = clinicalNoteOutputLocation;
            return this;
        }

        public final String getTranscriptOutputLocation() {
            return transcriptOutputLocation;
        }

        public final void setTranscriptOutputLocation(String transcriptOutputLocation) {
            this.transcriptOutputLocation = transcriptOutputLocation;
        }

        @Override
        public final Builder transcriptOutputLocation(String transcriptOutputLocation) {
            this.transcriptOutputLocation = transcriptOutputLocation;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ClinicalNoteGenerationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public ClinicalNoteGenerationResult build() {
            return new ClinicalNoteGenerationResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
