/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The event associated with <code>MedicalScribeResultStream</code>.
 * </p>
 * <p>
 * Contains <code>MedicalScribeTranscriptSegment</code>, which contains segment related information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MedicalScribeTranscriptEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<MedicalScribeTranscriptEvent.Builder, MedicalScribeTranscriptEvent>, MedicalScribeResultStream {
    private static final SdkField<MedicalScribeTranscriptSegment> TRANSCRIPT_SEGMENT_FIELD = SdkField
            .<MedicalScribeTranscriptSegment> builder(MarshallingType.SDK_POJO).memberName("TranscriptSegment")
            .getter(getter(MedicalScribeTranscriptEvent::transcriptSegment)).setter(setter(Builder::transcriptSegment))
            .constructor(MedicalScribeTranscriptSegment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptSegment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPT_SEGMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MedicalScribeTranscriptSegment transcriptSegment;

    protected MedicalScribeTranscriptEvent(BuilderImpl builder) {
        this.transcriptSegment = builder.transcriptSegment;
    }

    /**
     * <p>
     * The <code>TranscriptSegment</code> associated with a <code>MedicalScribeTranscriptEvent</code>.
     * </p>
     * 
     * @return The <code>TranscriptSegment</code> associated with a <code>MedicalScribeTranscriptEvent</code>.
     */
    public final MedicalScribeTranscriptSegment transcriptSegment() {
        return transcriptSegment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transcriptSegment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalScribeTranscriptEvent)) {
            return false;
        }
        MedicalScribeTranscriptEvent other = (MedicalScribeTranscriptEvent) obj;
        return Objects.equals(transcriptSegment(), other.transcriptSegment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MedicalScribeTranscriptEvent").add("TranscriptSegment", transcriptSegment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TranscriptSegment":
            return Optional.ofNullable(clazz.cast(transcriptSegment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final MedicalScribeTranscriptEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TranscriptSegment", TRANSCRIPT_SEGMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MedicalScribeTranscriptEvent, T> g) {
        return obj -> g.apply((MedicalScribeTranscriptEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link MedicalScribeTranscriptEvent}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(StartMedicalScribeStreamResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MedicalScribeTranscriptEvent> {
        /**
         * <p>
         * The <code>TranscriptSegment</code> associated with a <code>MedicalScribeTranscriptEvent</code>.
         * </p>
         * 
         * @param transcriptSegment
         *        The <code>TranscriptSegment</code> associated with a <code>MedicalScribeTranscriptEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcriptSegment(MedicalScribeTranscriptSegment transcriptSegment);

        /**
         * <p>
         * The <code>TranscriptSegment</code> associated with a <code>MedicalScribeTranscriptEvent</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link MedicalScribeTranscriptSegment.Builder}
         * avoiding the need to create one manually via {@link MedicalScribeTranscriptSegment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MedicalScribeTranscriptSegment.Builder#build()} is called
         * immediately and its result is passed to {@link #transcriptSegment(MedicalScribeTranscriptSegment)}.
         * 
         * @param transcriptSegment
         *        a consumer that will call methods on {@link MedicalScribeTranscriptSegment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transcriptSegment(MedicalScribeTranscriptSegment)
         */
        default Builder transcriptSegment(Consumer<MedicalScribeTranscriptSegment.Builder> transcriptSegment) {
            return transcriptSegment(MedicalScribeTranscriptSegment.builder().applyMutation(transcriptSegment).build());
        }
    }

    protected static class BuilderImpl implements Builder {
        private MedicalScribeTranscriptSegment transcriptSegment;

        protected BuilderImpl() {
        }

        protected BuilderImpl(MedicalScribeTranscriptEvent model) {
            transcriptSegment(model.transcriptSegment);
        }

        public final MedicalScribeTranscriptSegment.Builder getTranscriptSegment() {
            return transcriptSegment != null ? transcriptSegment.toBuilder() : null;
        }

        public final void setTranscriptSegment(MedicalScribeTranscriptSegment.BuilderImpl transcriptSegment) {
            this.transcriptSegment = transcriptSegment != null ? transcriptSegment.build() : null;
        }

        @Override
        public final Builder transcriptSegment(MedicalScribeTranscriptSegment transcriptSegment) {
            this.transcriptSegment = transcriptSegment;
            return this;
        }

        @Override
        public MedicalScribeTranscriptEvent build() {
            return new MedicalScribeTranscriptEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
