/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribestreaming.model.ContentRedactionOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PostCallAnalyticsSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PostCallAnalyticsSettings> {
    private static final SdkField<String> OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputLocation").getter(PostCallAnalyticsSettings.getter(PostCallAnalyticsSettings::outputLocation)).setter(PostCallAnalyticsSettings.setter(Builder::outputLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataAccessRoleArn").getter(PostCallAnalyticsSettings.getter(PostCallAnalyticsSettings::dataAccessRoleArn)).setter(PostCallAnalyticsSettings.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final SdkField<String> CONTENT_REDACTION_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentRedactionOutput").getter(PostCallAnalyticsSettings.getter(PostCallAnalyticsSettings::contentRedactionOutputAsString)).setter(PostCallAnalyticsSettings.setter(Builder::contentRedactionOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentRedactionOutput").build()}).build();
    private static final SdkField<String> OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputEncryptionKMSKeyId").getter(PostCallAnalyticsSettings.getter(PostCallAnalyticsSettings::outputEncryptionKMSKeyId)).setter(PostCallAnalyticsSettings.setter(Builder::outputEncryptionKMSKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputEncryptionKMSKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_LOCATION_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, CONTENT_REDACTION_OUTPUT_FIELD, OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PostCallAnalyticsSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String outputLocation;
    private final String dataAccessRoleArn;
    private final String contentRedactionOutput;
    private final String outputEncryptionKMSKeyId;

    private PostCallAnalyticsSettings(BuilderImpl builder) {
        this.outputLocation = builder.outputLocation;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.contentRedactionOutput = builder.contentRedactionOutput;
        this.outputEncryptionKMSKeyId = builder.outputEncryptionKMSKeyId;
    }

    public final String outputLocation() {
        return this.outputLocation;
    }

    public final String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public final ContentRedactionOutput contentRedactionOutput() {
        return ContentRedactionOutput.fromValue(this.contentRedactionOutput);
    }

    public final String contentRedactionOutputAsString() {
        return this.contentRedactionOutput;
    }

    public final String outputEncryptionKMSKeyId() {
        return this.outputEncryptionKMSKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentRedactionOutputAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputEncryptionKMSKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostCallAnalyticsSettings)) {
            return false;
        }
        PostCallAnalyticsSettings other = (PostCallAnalyticsSettings)obj;
        return Objects.equals(this.outputLocation(), other.outputLocation()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(this.contentRedactionOutputAsString(), other.contentRedactionOutputAsString()) && Objects.equals(this.outputEncryptionKMSKeyId(), other.outputEncryptionKMSKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"PostCallAnalyticsSettings").add("OutputLocation", (Object)this.outputLocation()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).add("ContentRedactionOutput", (Object)this.contentRedactionOutputAsString()).add("OutputEncryptionKMSKeyId", (Object)this.outputEncryptionKMSKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
            case "ContentRedactionOutput": {
                return Optional.ofNullable(clazz.cast(this.contentRedactionOutputAsString()));
            }
            case "OutputEncryptionKMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.outputEncryptionKMSKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("OutputLocation", OUTPUT_LOCATION_FIELD);
        map.put("DataAccessRoleArn", DATA_ACCESS_ROLE_ARN_FIELD);
        map.put("ContentRedactionOutput", CONTENT_REDACTION_OUTPUT_FIELD);
        map.put("OutputEncryptionKMSKeyId", OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PostCallAnalyticsSettings, T> g) {
        return obj -> g.apply((PostCallAnalyticsSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outputLocation;
        private String dataAccessRoleArn;
        private String contentRedactionOutput;
        private String outputEncryptionKMSKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(PostCallAnalyticsSettings model) {
            this.outputLocation(model.outputLocation);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
            this.contentRedactionOutput(model.contentRedactionOutput);
            this.outputEncryptionKMSKeyId(model.outputEncryptionKMSKeyId);
        }

        public final String getOutputLocation() {
            return this.outputLocation;
        }

        public final void setOutputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
        }

        @Override
        public final Builder outputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final String getContentRedactionOutput() {
            return this.contentRedactionOutput;
        }

        public final void setContentRedactionOutput(String contentRedactionOutput) {
            this.contentRedactionOutput = contentRedactionOutput;
        }

        @Override
        public final Builder contentRedactionOutput(String contentRedactionOutput) {
            this.contentRedactionOutput = contentRedactionOutput;
            return this;
        }

        @Override
        public final Builder contentRedactionOutput(ContentRedactionOutput contentRedactionOutput) {
            this.contentRedactionOutput(contentRedactionOutput == null ? null : contentRedactionOutput.toString());
            return this;
        }

        public final String getOutputEncryptionKMSKeyId() {
            return this.outputEncryptionKMSKeyId;
        }

        public final void setOutputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
        }

        @Override
        public final Builder outputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
            return this;
        }

        public PostCallAnalyticsSettings build() {
            return new PostCallAnalyticsSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PostCallAnalyticsSettings> {
        public Builder outputLocation(String var1);

        public Builder dataAccessRoleArn(String var1);

        public Builder contentRedactionOutput(String var1);

        public Builder contentRedactionOutput(ContentRedactionOutput var1);

        public Builder outputEncryptionKMSKeyId(String var1);
    }
}

