/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information on any <code>TranscriptFilterType</code> categories that matched your transcription output.
 * Matches are identified for each segment upon completion of that segment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CategoryEvent implements SdkPojo, Serializable, ToCopyableBuilder<CategoryEvent.Builder, CategoryEvent>,
        CallAnalyticsTranscriptResultStream {
    private static final SdkField<List<String>> MATCHED_CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MatchedCategories")
            .getter(getter(CategoryEvent::matchedCategories))
            .setter(setter(Builder::matchedCategories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchedCategories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, PointsOfInterest>> MATCHED_DETAILS_FIELD = SdkField
            .<Map<String, PointsOfInterest>> builder(MarshallingType.MAP)
            .memberName("MatchedDetails")
            .getter(getter(CategoryEvent::matchedDetails))
            .setter(setter(Builder::matchedDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchedDetails").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<PointsOfInterest> builder(MarshallingType.SDK_POJO)
                                            .constructor(PointsOfInterest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCHED_CATEGORIES_FIELD,
            MATCHED_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> matchedCategories;

    private final Map<String, PointsOfInterest> matchedDetails;

    protected CategoryEvent(BuilderImpl builder) {
        this.matchedCategories = builder.matchedCategories;
        this.matchedDetails = builder.matchedDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the MatchedCategories property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMatchedCategories() {
        return matchedCategories != null && !(matchedCategories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the categories that were matched in your audio segment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchedCategories} method.
     * </p>
     * 
     * @return Lists the categories that were matched in your audio segment.
     */
    public final List<String> matchedCategories() {
        return matchedCategories;
    }

    /**
     * For responses, this returns true if the service returned a value for the MatchedDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMatchedDetails() {
        return matchedDetails != null && !(matchedDetails instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Contains information about the matched categories, including category names and timestamps.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchedDetails} method.
     * </p>
     * 
     * @return Contains information about the matched categories, including category names and timestamps.
     */
    public final Map<String, PointsOfInterest> matchedDetails() {
        return matchedDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchedCategories() ? matchedCategories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchedDetails() ? matchedDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CategoryEvent)) {
            return false;
        }
        CategoryEvent other = (CategoryEvent) obj;
        return hasMatchedCategories() == other.hasMatchedCategories()
                && Objects.equals(matchedCategories(), other.matchedCategories())
                && hasMatchedDetails() == other.hasMatchedDetails() && Objects.equals(matchedDetails(), other.matchedDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CategoryEvent").add("MatchedCategories", hasMatchedCategories() ? matchedCategories() : null)
                .add("MatchedDetails", hasMatchedDetails() ? matchedDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MatchedCategories":
            return Optional.ofNullable(clazz.cast(matchedCategories()));
        case "MatchedDetails":
            return Optional.ofNullable(clazz.cast(matchedDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final CategoryEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MatchedCategories", MATCHED_CATEGORIES_FIELD);
        map.put("MatchedDetails", MATCHED_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CategoryEvent, T> g) {
        return obj -> g.apply((CategoryEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link CategoryEvent}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(StartCallAnalyticsStreamTranscriptionResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CategoryEvent> {
        /**
         * <p>
         * Lists the categories that were matched in your audio segment.
         * </p>
         * 
         * @param matchedCategories
         *        Lists the categories that were matched in your audio segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchedCategories(Collection<String> matchedCategories);

        /**
         * <p>
         * Lists the categories that were matched in your audio segment.
         * </p>
         * 
         * @param matchedCategories
         *        Lists the categories that were matched in your audio segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchedCategories(String... matchedCategories);

        /**
         * <p>
         * Contains information about the matched categories, including category names and timestamps.
         * </p>
         * 
         * @param matchedDetails
         *        Contains information about the matched categories, including category names and timestamps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchedDetails(Map<String, PointsOfInterest> matchedDetails);
    }

    protected static class BuilderImpl implements Builder {
        private List<String> matchedCategories = DefaultSdkAutoConstructList.getInstance();

        private Map<String, PointsOfInterest> matchedDetails = DefaultSdkAutoConstructMap.getInstance();

        protected BuilderImpl() {
        }

        protected BuilderImpl(CategoryEvent model) {
            matchedCategories(model.matchedCategories);
            matchedDetails(model.matchedDetails);
        }

        public final Collection<String> getMatchedCategories() {
            if (matchedCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return matchedCategories;
        }

        public final void setMatchedCategories(Collection<String> matchedCategories) {
            this.matchedCategories = StringListCopier.copy(matchedCategories);
        }

        @Override
        public final Builder matchedCategories(Collection<String> matchedCategories) {
            this.matchedCategories = StringListCopier.copy(matchedCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedCategories(String... matchedCategories) {
            matchedCategories(Arrays.asList(matchedCategories));
            return this;
        }

        public final Map<String, PointsOfInterest.Builder> getMatchedDetails() {
            Map<String, PointsOfInterest.Builder> result = MatchedCategoryDetailsCopier.copyToBuilder(this.matchedDetails);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMatchedDetails(Map<String, PointsOfInterest.BuilderImpl> matchedDetails) {
            this.matchedDetails = MatchedCategoryDetailsCopier.copyFromBuilder(matchedDetails);
        }

        @Override
        public final Builder matchedDetails(Map<String, PointsOfInterest> matchedDetails) {
            this.matchedDetails = MatchedCategoryDetailsCopier.copy(matchedDetails);
            return this;
        }

        @Override
        public CategoryEvent build() {
            return new CategoryEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
