/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Allows you to specify additional settings for your Call Analytics post-call request, including output locations for
 * your redacted transcript, which IAM role to use, and which encryption key to use.
 * </p>
 * <p>
 * <code>DataAccessRoleArn</code> and <code>OutputLocation</code> are required fields.
 * </p>
 * <p>
 * <code>PostCallAnalyticsSettings</code> provides you with the same insights as a Call Analytics post-call
 * transcription. Refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-post-call.html">Post-call
 * analytics</a> for more information on this feature.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PostCallAnalyticsSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<PostCallAnalyticsSettings.Builder, PostCallAnalyticsSettings> {
    private static final SdkField<String> OUTPUT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputLocation").getter(getter(PostCallAnalyticsSettings::outputLocation))
            .setter(setter(Builder::outputLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessRoleArn").getter(getter(PostCallAnalyticsSettings::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final SdkField<String> CONTENT_REDACTION_OUTPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentRedactionOutput").getter(getter(PostCallAnalyticsSettings::contentRedactionOutputAsString))
            .setter(setter(Builder::contentRedactionOutput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentRedactionOutput").build())
            .build();

    private static final SdkField<String> OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputEncryptionKMSKeyId").getter(getter(PostCallAnalyticsSettings::outputEncryptionKMSKeyId))
            .setter(setter(Builder::outputEncryptionKMSKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputEncryptionKMSKeyId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_LOCATION_FIELD,
            DATA_ACCESS_ROLE_ARN_FIELD, CONTENT_REDACTION_OUTPUT_FIELD, OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String outputLocation;

    private final String dataAccessRoleArn;

    private final String contentRedactionOutput;

    private final String outputEncryptionKMSKeyId;

    private PostCallAnalyticsSettings(BuilderImpl builder) {
        this.outputLocation = builder.outputLocation;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.contentRedactionOutput = builder.contentRedactionOutput;
        this.outputEncryptionKMSKeyId = builder.outputEncryptionKMSKeyId;
    }

    /**
     * <p>
     * The Amazon S3 location where you want your Call Analytics post-call transcription output stored. You can use any
     * of the following formats to specify the output location:
     * </p>
     * <ol>
     * <li>
     * <p>
     * s3://DOC-EXAMPLE-BUCKET
     * </p>
     * </li>
     * <li>
     * <p>
     * s3://DOC-EXAMPLE-BUCKET/my-output-folder/
     * </p>
     * </li>
     * <li>
     * <p>
     * s3://DOC-EXAMPLE-BUCKET/my-output-folder/my-call-analytics-job.json
     * </p>
     * </li>
     * </ol>
     * 
     * @return The Amazon S3 location where you want your Call Analytics post-call transcription output stored. You can
     *         use any of the following formats to specify the output location:</p>
     *         <ol>
     *         <li>
     *         <p>
     *         s3://DOC-EXAMPLE-BUCKET
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         s3://DOC-EXAMPLE-BUCKET/my-output-folder/
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         s3://DOC-EXAMPLE-BUCKET/my-output-folder/my-call-analytics-job.json
     *         </p>
     *         </li>
     */
    public final String outputLocation() {
        return outputLocation;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains
     * your input files. If the role that you specify doesn’t have the appropriate permissions to access the specified
     * Amazon S3 location, your request fails.
     * </p>
     * <p>
     * IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example:
     * <code>arn:aws:iam::111122223333:role/Admin</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM ARNs</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that
     *         contains your input files. If the role that you specify doesn’t have the appropriate permissions to
     *         access the specified Amazon S3 location, your request fails.</p>
     *         <p>
     *         IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For
     *         example: <code>arn:aws:iam::111122223333:role/Admin</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM
     *         ARNs</a>.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    /**
     * <p>
     * Specify whether you want only a redacted transcript or both a redacted and an unredacted transcript. If you
     * choose redacted and unredacted, two JSON files are generated and stored in the Amazon S3 output location you
     * specify.
     * </p>
     * <p>
     * Note that to include <code>ContentRedactionOutput</code> in your request, you must enable content redaction (
     * <code>ContentRedactionType</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentRedactionOutput} will return {@link ContentRedactionOutput#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #contentRedactionOutputAsString}.
     * </p>
     * 
     * @return Specify whether you want only a redacted transcript or both a redacted and an unredacted transcript. If
     *         you choose redacted and unredacted, two JSON files are generated and stored in the Amazon S3 output
     *         location you specify.</p>
     *         <p>
     *         Note that to include <code>ContentRedactionOutput</code> in your request, you must enable content
     *         redaction (<code>ContentRedactionType</code>).
     * @see ContentRedactionOutput
     */
    public final ContentRedactionOutput contentRedactionOutput() {
        return ContentRedactionOutput.fromValue(contentRedactionOutput);
    }

    /**
     * <p>
     * Specify whether you want only a redacted transcript or both a redacted and an unredacted transcript. If you
     * choose redacted and unredacted, two JSON files are generated and stored in the Amazon S3 output location you
     * specify.
     * </p>
     * <p>
     * Note that to include <code>ContentRedactionOutput</code> in your request, you must enable content redaction (
     * <code>ContentRedactionType</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentRedactionOutput} will return {@link ContentRedactionOutput#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #contentRedactionOutputAsString}.
     * </p>
     * 
     * @return Specify whether you want only a redacted transcript or both a redacted and an unredacted transcript. If
     *         you choose redacted and unredacted, two JSON files are generated and stored in the Amazon S3 output
     *         location you specify.</p>
     *         <p>
     *         Note that to include <code>ContentRedactionOutput</code> in your request, you must enable content
     *         redaction (<code>ContentRedactionType</code>).
     * @see ContentRedactionOutput
     */
    public final String contentRedactionOutputAsString() {
        return contentRedactionOutput;
    }

    /**
     * <p>
     * The KMS key you want to use to encrypt your Call Analytics post-call output.
     * </p>
     * <p>
     * If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key in one of
     * four ways:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the Amazon Resource Name (ARN) for the KMS key ID. For example,
     * <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
     * </p>
     * </li>
     * </ol>
     * <p>
     * If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web Services
     * account, you can specify your KMS key in one of two ways:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use the ARN for the KMS key ID. For example,
     * <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
     * </p>
     * </li>
     * </ol>
     * <p>
     * Note that the role making the request must have permission to use the specified KMS key.
     * </p>
     * 
     * @return The KMS key you want to use to encrypt your Call Analytics post-call output.</p>
     *         <p>
     *         If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key in
     *         one of four ways:
     *         </p>
     *         <ol>
     *         <li>
     *         <p>
     *         Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use the Amazon Resource Name (ARN) for the KMS key ID. For example,
     *         <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use the ARN for the KMS key alias. For example,
     *         <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
     *         </p>
     *         </li>
     *         </ol>
     *         <p>
     *         If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web
     *         Services account, you can specify your KMS key in one of two ways:
     *         </p>
     *         <ol>
     *         <li>
     *         <p>
     *         Use the ARN for the KMS key ID. For example,
     *         <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use the ARN for the KMS key alias. For example,
     *         <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
     *         </p>
     *         </li>
     *         </ol>
     *         <p>
     *         Note that the role making the request must have permission to use the specified KMS key.
     */
    public final String outputEncryptionKMSKeyId() {
        return outputEncryptionKMSKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(contentRedactionOutputAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputEncryptionKMSKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostCallAnalyticsSettings)) {
            return false;
        }
        PostCallAnalyticsSettings other = (PostCallAnalyticsSettings) obj;
        return Objects.equals(outputLocation(), other.outputLocation())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn())
                && Objects.equals(contentRedactionOutputAsString(), other.contentRedactionOutputAsString())
                && Objects.equals(outputEncryptionKMSKeyId(), other.outputEncryptionKMSKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PostCallAnalyticsSettings").add("OutputLocation", outputLocation())
                .add("DataAccessRoleArn", dataAccessRoleArn()).add("ContentRedactionOutput", contentRedactionOutputAsString())
                .add("OutputEncryptionKMSKeyId", outputEncryptionKMSKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputLocation":
            return Optional.ofNullable(clazz.cast(outputLocation()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        case "ContentRedactionOutput":
            return Optional.ofNullable(clazz.cast(contentRedactionOutputAsString()));
        case "OutputEncryptionKMSKeyId":
            return Optional.ofNullable(clazz.cast(outputEncryptionKMSKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OutputLocation", OUTPUT_LOCATION_FIELD);
        map.put("DataAccessRoleArn", DATA_ACCESS_ROLE_ARN_FIELD);
        map.put("ContentRedactionOutput", CONTENT_REDACTION_OUTPUT_FIELD);
        map.put("OutputEncryptionKMSKeyId", OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PostCallAnalyticsSettings, T> g) {
        return obj -> g.apply((PostCallAnalyticsSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PostCallAnalyticsSettings> {
        /**
         * <p>
         * The Amazon S3 location where you want your Call Analytics post-call transcription output stored. You can use
         * any of the following formats to specify the output location:
         * </p>
         * <ol>
         * <li>
         * <p>
         * s3://DOC-EXAMPLE-BUCKET
         * </p>
         * </li>
         * <li>
         * <p>
         * s3://DOC-EXAMPLE-BUCKET/my-output-folder/
         * </p>
         * </li>
         * <li>
         * <p>
         * s3://DOC-EXAMPLE-BUCKET/my-output-folder/my-call-analytics-job.json
         * </p>
         * </li>
         * </ol>
         * 
         * @param outputLocation
         *        The Amazon S3 location where you want your Call Analytics post-call transcription output stored. You
         *        can use any of the following formats to specify the output location:</p>
         *        <ol>
         *        <li>
         *        <p>
         *        s3://DOC-EXAMPLE-BUCKET
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        s3://DOC-EXAMPLE-BUCKET/my-output-folder/
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        s3://DOC-EXAMPLE-BUCKET/my-output-folder/my-call-analytics-job.json
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(String outputLocation);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that
         * contains your input files. If the role that you specify doesn’t have the appropriate permissions to access
         * the specified Amazon S3 location, your request fails.
         * </p>
         * <p>
         * IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example:
         * <code>arn:aws:iam::111122223333:role/Admin</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM
         * ARNs</a>.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that
         *        contains your input files. If the role that you specify doesn’t have the appropriate permissions to
         *        access the specified Amazon S3 location, your request fails.</p>
         *        <p>
         *        IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For
         *        example: <code>arn:aws:iam::111122223333:role/Admin</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns"
         *        >IAM ARNs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);

        /**
         * <p>
         * Specify whether you want only a redacted transcript or both a redacted and an unredacted transcript. If you
         * choose redacted and unredacted, two JSON files are generated and stored in the Amazon S3 output location you
         * specify.
         * </p>
         * <p>
         * Note that to include <code>ContentRedactionOutput</code> in your request, you must enable content redaction (
         * <code>ContentRedactionType</code>).
         * </p>
         * 
         * @param contentRedactionOutput
         *        Specify whether you want only a redacted transcript or both a redacted and an unredacted transcript.
         *        If you choose redacted and unredacted, two JSON files are generated and stored in the Amazon S3 output
         *        location you specify.</p>
         *        <p>
         *        Note that to include <code>ContentRedactionOutput</code> in your request, you must enable content
         *        redaction (<code>ContentRedactionType</code>).
         * @see ContentRedactionOutput
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentRedactionOutput
         */
        Builder contentRedactionOutput(String contentRedactionOutput);

        /**
         * <p>
         * Specify whether you want only a redacted transcript or both a redacted and an unredacted transcript. If you
         * choose redacted and unredacted, two JSON files are generated and stored in the Amazon S3 output location you
         * specify.
         * </p>
         * <p>
         * Note that to include <code>ContentRedactionOutput</code> in your request, you must enable content redaction (
         * <code>ContentRedactionType</code>).
         * </p>
         * 
         * @param contentRedactionOutput
         *        Specify whether you want only a redacted transcript or both a redacted and an unredacted transcript.
         *        If you choose redacted and unredacted, two JSON files are generated and stored in the Amazon S3 output
         *        location you specify.</p>
         *        <p>
         *        Note that to include <code>ContentRedactionOutput</code> in your request, you must enable content
         *        redaction (<code>ContentRedactionType</code>).
         * @see ContentRedactionOutput
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentRedactionOutput
         */
        Builder contentRedactionOutput(ContentRedactionOutput contentRedactionOutput);

        /**
         * <p>
         * The KMS key you want to use to encrypt your Call Analytics post-call output.
         * </p>
         * <p>
         * If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key in one
         * of four ways:
         * </p>
         * <ol>
         * <li>
         * <p>
         * Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use the Amazon Resource Name (ARN) for the KMS key ID. For example,
         * <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>
         * .
         * </p>
         * </li>
         * </ol>
         * <p>
         * If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web Services
         * account, you can specify your KMS key in one of two ways:
         * </p>
         * <ol>
         * <li>
         * <p>
         * Use the ARN for the KMS key ID. For example,
         * <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>
         * .
         * </p>
         * </li>
         * </ol>
         * <p>
         * Note that the role making the request must have permission to use the specified KMS key.
         * </p>
         * 
         * @param outputEncryptionKMSKeyId
         *        The KMS key you want to use to encrypt your Call Analytics post-call output.</p>
         *        <p>
         *        If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key
         *        in one of four ways:
         *        </p>
         *        <ol>
         *        <li>
         *        <p>
         *        Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use the Amazon Resource Name (ARN) for the KMS key ID. For example,
         *        <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use the ARN for the KMS key alias. For example,
         *        <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
         *        </p>
         *        </li>
         *        </ol>
         *        <p>
         *        If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web
         *        Services account, you can specify your KMS key in one of two ways:
         *        </p>
         *        <ol>
         *        <li>
         *        <p>
         *        Use the ARN for the KMS key ID. For example,
         *        <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use the ARN for the KMS key alias. For example,
         *        <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
         *        </p>
         *        </li>
         *        </ol>
         *        <p>
         *        Note that the role making the request must have permission to use the specified KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputEncryptionKMSKeyId(String outputEncryptionKMSKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String outputLocation;

        private String dataAccessRoleArn;

        private String contentRedactionOutput;

        private String outputEncryptionKMSKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(PostCallAnalyticsSettings model) {
            outputLocation(model.outputLocation);
            dataAccessRoleArn(model.dataAccessRoleArn);
            contentRedactionOutput(model.contentRedactionOutput);
            outputEncryptionKMSKeyId(model.outputEncryptionKMSKeyId);
        }

        public final String getOutputLocation() {
            return outputLocation;
        }

        public final void setOutputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
        }

        @Override
        public final Builder outputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final String getContentRedactionOutput() {
            return contentRedactionOutput;
        }

        public final void setContentRedactionOutput(String contentRedactionOutput) {
            this.contentRedactionOutput = contentRedactionOutput;
        }

        @Override
        public final Builder contentRedactionOutput(String contentRedactionOutput) {
            this.contentRedactionOutput = contentRedactionOutput;
            return this;
        }

        @Override
        public final Builder contentRedactionOutput(ContentRedactionOutput contentRedactionOutput) {
            this.contentRedactionOutput(contentRedactionOutput == null ? null : contentRedactionOutput.toString());
            return this;
        }

        public final String getOutputEncryptionKMSKeyId() {
            return outputEncryptionKMSKeyId;
        }

        public final void setOutputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
        }

        @Override
        public final Builder outputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
            return this;
        }

        @Override
        public PostCallAnalyticsSettings build() {
            return new PostCallAnalyticsSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
